/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscWriteOffBankFileApprovalAbilityService;
import com.tydic.fsc.common.ability.api.FscWriteOffEntityAccountAuditAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscWriteOffBankFileApprovalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscWriteOffBankFileApprovalAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscWriteOffEntityAccountAuditAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscWriteOffEntityAccountAuditAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscWriteOffEntityAccountAuditBusiService;
import com.tydic.fsc.common.busi.api.FscWriteOffEntityAccountQryInfoBusiService;
import com.tydic.fsc.common.busi.bo.FscWriteOffEntityAccountAuditBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscWriteOffEntityAccountAuditBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscWriteOffEntityAccountQryInfoBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscWriteOffEntityAccountQryInfoBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscWriteOffEntityAccountAuditAbilityService"})
public class FscWriteOffEntityAccountAuditAbilityServiceImpl
implements FscWriteOffEntityAccountAuditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscWriteOffEntityAccountAuditAbilityServiceImpl.class);
    @Autowired
    private FscWriteOffEntityAccountAuditBusiService fscWriteOffEntityAccountAuditBusiService;
    @Autowired
    private FscWriteOffEntityAccountQryInfoBusiService fscWriteOffEntityAccountQryInfoBusiService;
    @Autowired
    private FscWriteOffBankFileApprovalAbilityService fscWriteOffBankFileApprovalAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @PostMapping(value={"writeOffEntityAccountAudit"})
    public FscWriteOffEntityAccountAuditAbilityRspBO writeOffEntityAccountAudit(@RequestBody FscWriteOffEntityAccountAuditAbilityReqBO reqBO) {
        this.validateWriteOffEntityAccountAudit(reqBO);
        ArrayList<Long> applyIdList = new ArrayList<Long>();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getApplyIdList())) {
            applyIdList.addAll(reqBO.getApplyIdList());
        }
        if (null != reqBO.getApplyId()) {
            applyIdList.add(reqBO.getApplyId());
        }
        for (Long applyId : applyIdList) {
            reqBO.setApplyId(applyId);
            this.editWriteOffBankFileApproval(reqBO);
            FscWriteOffEntityAccountAuditBusiRspBO fscWriteOffEntityAccountAuditBusiRspBO = this.editWriteOffEntityAccountAudit(reqBO);
            this.syncFscOrder(fscWriteOffEntityAccountAuditBusiRspBO.getFscOrderId(), reqBO);
        }
        return new FscWriteOffEntityAccountAuditAbilityRspBO();
    }

    private void validateWriteOffEntityAccountAudit(FscWriteOffEntityAccountAuditAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAuditType())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[\u5ba1\u6838\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!FscConstants.WriteOffEntityAccountAuditType.REJECT.equals(reqBO.getAuditType()) && !FscConstants.WriteOffEntityAccountAuditType.PASS.equals(reqBO.getAuditType())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[\u5ba1\u6838\u7c7b\u578b]\u4e0d\u5408\u6cd5");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getApplyId()) && ObjectUtil.isEmpty((Object)reqBO.getApplyIdList())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[\u7533\u8bf7ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private FscWriteOffEntityAccountQryInfoBusiRspBO qryWriteOffEntityAccountInfo(FscWriteOffEntityAccountAuditAbilityReqBO reqBO) {
        FscWriteOffEntityAccountQryInfoBusiReqBO fscWriteOffEntityAccountQryInfoBusiReqBO = new FscWriteOffEntityAccountQryInfoBusiReqBO();
        fscWriteOffEntityAccountQryInfoBusiReqBO.setApplyId(reqBO.getApplyId());
        fscWriteOffEntityAccountQryInfoBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscWriteOffEntityAccountQryInfoBusiRspBO fscWriteOffEntityAccountQryInfoBusiRspBO = this.fscWriteOffEntityAccountQryInfoBusiService.qryWriteOffEntityAccountInfo(fscWriteOffEntityAccountQryInfoBusiReqBO);
        if (!"0000".equals(fscWriteOffEntityAccountQryInfoBusiRspBO.getRespCode())) {
            throw new ZTBusinessException(fscWriteOffEntityAccountQryInfoBusiRspBO.getRespDesc());
        }
        if (!FscConstants.FscPayOrderState.ENTITY_ACCOUNT_PAY_APPLY.equals(fscWriteOffEntityAccountQryInfoBusiRspBO.getOrderState())) {
            throw new ZTBusinessException("\u975e\u5b9e\u4f53\u6237\u4ed8\u6b3e\u7533\u8bf7\u7684\u4ed8\u6b3e\u5355\u4e0d\u80fd\u6838\u9500");
        }
        return fscWriteOffEntityAccountQryInfoBusiRspBO;
    }

    private void editWriteOffBankFileApproval(FscWriteOffEntityAccountAuditAbilityReqBO reqBO) {
        if (FscConstants.WriteOffEntityAccountAuditType.PASS.equals(reqBO.getAuditType())) {
            FscWriteOffEntityAccountQryInfoBusiRspBO fscWriteOffEntityAccountQryInfoBusiRspBO = this.qryWriteOffEntityAccountInfo(reqBO);
            FscWriteOffBankFileApprovalAbilityReqBO fscWriteOffBankFileApprovalAbilityReqBO = new FscWriteOffBankFileApprovalAbilityReqBO();
            fscWriteOffBankFileApprovalAbilityReqBO.setFscOrderIds((List)CollectionUtil.newArrayList((Object[])new Long[]{fscWriteOffEntityAccountQryInfoBusiRspBO.getFscOrderId()}));
            fscWriteOffBankFileApprovalAbilityReqBO.setMemo(fscWriteOffEntityAccountQryInfoBusiRspBO.getWriteOffRemark());
            fscWriteOffBankFileApprovalAbilityReqBO.setPayUrl(fscWriteOffEntityAccountQryInfoBusiRspBO.getAttachmentUrl());
            fscWriteOffBankFileApprovalAbilityReqBO.setPayFileName(fscWriteOffEntityAccountQryInfoBusiRspBO.getAttachmentName());
            fscWriteOffBankFileApprovalAbilityReqBO.setAllToPay(FscConstants.WRITE_OFF_ALL_TO_PAY.NO);
            fscWriteOffBankFileApprovalAbilityReqBO.setWriteOffType(FscConstants.WRITE_OFF_APPROVAL_TYPE.PAY_ORDER);
            fscWriteOffBankFileApprovalAbilityReqBO.setIsWriteOffEntityAccount(Boolean.valueOf(true));
            fscWriteOffBankFileApprovalAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
            fscWriteOffBankFileApprovalAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
            FscWriteOffBankFileApprovalAbilityRspBO fscWriteOffBankFileApprovalAbilityRspBO = this.fscWriteOffBankFileApprovalAbilityService.writeOffBankFileApproval(fscWriteOffBankFileApprovalAbilityReqBO);
            if (!"0000".equals(fscWriteOffBankFileApprovalAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException(fscWriteOffBankFileApprovalAbilityRspBO.getRespDesc());
            }
        }
    }

    private FscWriteOffEntityAccountAuditBusiRspBO editWriteOffEntityAccountAudit(FscWriteOffEntityAccountAuditAbilityReqBO reqBO) {
        FscWriteOffEntityAccountAuditBusiReqBO fscWriteOffEntityAccountAuditBusiReqBO = (FscWriteOffEntityAccountAuditBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscWriteOffEntityAccountAuditBusiReqBO.class));
        FscWriteOffEntityAccountAuditBusiRspBO fscWriteOffEntityAccountAuditBusiRspBO = this.fscWriteOffEntityAccountAuditBusiService.writeOffEntityAccountAudit(fscWriteOffEntityAccountAuditBusiReqBO);
        if (!"0000".equals(fscWriteOffEntityAccountAuditBusiRspBO.getRespCode())) {
            throw new ZTBusinessException(fscWriteOffEntityAccountAuditBusiRspBO.getRespDesc());
        }
        return fscWriteOffEntityAccountAuditBusiRspBO;
    }

    private void syncFscOrder(Long fscOrderId, FscWriteOffEntityAccountAuditAbilityReqBO reqBO) {
        try {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
            fscComOrderListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        catch (Exception e) {
            log.error("\u5b9e\u4f53\u6237\u6838\u9500\u7533\u8bf7\u5ba1\u6838|\u7ed3\u7b97\u5355ES\u540c\u6b65\u5f02\u5e38|\u5931\u8d25\u539f\u56e0: {}", (Object)e.getMessage());
        }
    }
}

