/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.atom.impl;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.fsc.busibase.atom.api.FscOrderCancelAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscSyncSendTodoApprovalInvoicingService;
import com.tydic.fsc.common.ability.bo.FscSyncSendTodoAbilityReqBO;
import com.tydic.fsc.common.atom.api.FscComOrderApprovalAtomService;
import com.tydic.fsc.common.atom.bo.FscComOrderApprovalAtomReqBO;
import com.tydic.fsc.common.atom.bo.FscComOrderApprovalAtomRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscComOrderApprovalAtomServiceImpl
implements FscComOrderApprovalAtomService {
    public static final String BUSI_NAME = "\u4e3b\u5355\u5ba1\u6279";
    public static final String BUSI_CODE = "1009";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderCancelAtomService fscOrderCancelAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscSyncSendTodoApprovalInvoicingService fscSyncSendTodoApprovalInvoicingService;
    public static final Integer PASS = 1;

    @Override
    public FscComOrderApprovalAtomRspBO dealOrderApproval(FscComOrderApprovalAtomReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setSysTenantId(reqBO.getSysTenantId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (!FscBillStatus.TO_BE_APPROVAL.getCode().equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("191124", "\u5f53\u524d\u7ed3\u7b97\u5355\u4e0d\u4e3a\u5f85\u5ba1\u6279\u72b6\u6001");
        }
        reqBO.setOrderFlow(fscOrder.getOrderFlow());
        reqBO.setOrderState(fscOrder.getOrderState());
        reqBO.setActualAmount(fscOrder.getActualAmount());
        reqBO.setFscOrder(fscOrder);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        if (PASS.equals(reqBO.getAuditResult())) {
            if (null != reqBO.getActualAmount() && BigDecimal.ZERO.compareTo(reqBO.getActualAmount()) == 0) {
                paramMap.put("orderFinish", "1");
            }
            paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
        } else {
            paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
        }
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getOrderId());
        flowAtomReqBO.setCurStatus(reqBO.getOrderState());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        flowAtomReqBO.setParamMap(paramMap);
        flowAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
        }
        if (!PASS.equals(reqBO.getAuditResult())) {
            reqBO.setOrderState(FscBillStatus.MAIN_ORDER_CANCELLATION.getCode());
            this.dismissalProcess(reqBO);
        } else {
            this.updateMaxConfirmTime(reqBO);
        }
        return new FscComOrderApprovalAtomRspBO();
    }

    private void updateMaxConfirmTime(FscComOrderApprovalAtomReqBO reqBO) {
        if (!(FscConstants.OrderFlow.INVOICE.equals(reqBO.getFscOrder().getOrderFlow()) || FscConstants.OrderFlow.PAY.equals(reqBO.getFscOrder().getOrderFlow()) || FscConstants.OrderFlow.INVOICE_APPROVAL.equals(reqBO.getFscOrder().getOrderFlow()))) {
            FscOrderPO fscOrder = new FscOrderPO();
            fscOrder.setFscOrderId(reqBO.getFscOrder().getFscOrderId());
            fscOrder.setCreditConfirmDueDate(DateUtils.getDate((Date)new Date(), (Integer)Convert.toInt((Object)reqBO.getFscOrder().getCreditConfirmDueDay(), (Integer)1)));
            fscOrder.setSysTenantId(reqBO.getSysTenantId());
            this.fscOrderMapper.updateById(fscOrder);
        } else if (FscConstants.OrderFlow.INVOICE_APPROVAL.equals(reqBO.getFscOrder().getOrderFlow())) {
            FscSyncSendTodoAbilityReqBO fscSendTodoBusiReqBO = new FscSyncSendTodoAbilityReqBO();
            fscSendTodoBusiReqBO.setAuditOrderStatus(FscConstants.AuditStatus.AUDIT_PASS.toString());
            fscSendTodoBusiReqBO.setFscOrderId(reqBO.getFscOrder().getFscOrderId());
            fscSendTodoBusiReqBO.setSourceType(FscConstants.SOURCE_TYPE.APPROVAL_SERVICE_FEE);
            fscSendTodoBusiReqBO.setObjType(FscConstants.TODO_OBJ_TYPE.APPROVAL);
            fscSendTodoBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
            this.fscSyncSendTodoApprovalInvoicingService.syncSendToApprovalInvoicing(fscSendTodoBusiReqBO);
        }
    }

    private void dismissalProcess(FscComOrderApprovalAtomReqBO reqBO) {
        if (FscConstants.OrderFlow.PAY.equals(reqBO.getOrderFlow())) {
            this.paymentRejectionProcess(reqBO);
        } else if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            FscOrderCancelAtomReqBO cancelAtomReqBO = new FscOrderCancelAtomReqBO();
            cancelAtomReqBO.setOrderFlow(reqBO.getOrderFlow());
            cancelAtomReqBO.setOrderId(reqBO.getOrderId());
            cancelAtomReqBO.setOrderState(reqBO.getOrderState());
        }
    }

    private void serviceFeeRejectionProcess(FscComOrderApprovalAtomReqBO reqBO) {
        FscOrderPO set = new FscOrderPO();
        set.setCreditAmount(BigDecimal.ZERO);
        set.setFscOrderId(reqBO.getOrderId());
        set.setSysTenantId(reqBO.getSysTenantId());
        int i = this.fscOrderMapper.updateByOrderId(set);
        if (i != 1) {
            throw new FscBusinessException("193108", "\u66f4\u65b0\u6570\u636e\u5e93\u51fa\u9519");
        }
    }

    private void paymentRejectionProcess(FscComOrderApprovalAtomReqBO reqBO) {
        FscOrderPayItemPO fscOrderPayItemPo = new FscOrderPayItemPO();
        fscOrderPayItemPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPayItemPo.setSysTenantId(reqBO.getSysTenantId());
        List fscOrderPayItemPos = this.fscOrderPayItemMapper.getList(fscOrderPayItemPo);
        for (FscOrderPayItemPO orderPayItemPo : fscOrderPayItemPos) {
            int i = this.fscShouldPayMapper.updatePayingAmt(orderPayItemPo.getShouldPayId(), orderPayItemPo.getPayAmount(), reqBO.getSysTenantId());
            if (i == 1) continue;
            throw new FscBusinessException("193108", "\u66f4\u65b0\u6570\u636e\u5e93\u51fa\u9519");
        }
    }
}

