/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscAuditOfflineWriteOffBankFileBusiService;
import com.tydic.fsc.common.busi.bo.FscAuditOfflineWriteOffBankFileBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAuditOfflineWriteOffBankFileBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOutPayRecordMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOutPayRecordPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAuditOfflineWriteOffBankFileBusiServiceImpl
implements FscAuditOfflineWriteOffBankFileBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAuditOfflineWriteOffBankFileBusiServiceImpl.class);
    @Value(value="${task.max.pageSize}")
    private Integer masPageSize;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOutPayRecordMapper fscOutPayRecordMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Value(value="${task.cancelReason}")
    private String cancelReason;

    @Override
    public FscAuditOfflineWriteOffBankFileBusiRspBO auditOfflineWriteOffBankFile(FscAuditOfflineWriteOffBankFileBusiReqBO reqBO) {
        FscBankCheckFileItemPO fscBankCheckFileItemPO1;
        FscAuditOfflineWriteOffBankFileBusiRspBO rspBO = new FscAuditOfflineWriteOffBankFileBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<Long> bankCheckIdList = new ArrayList<Long>();
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(this.masPageSize.intValue());
        FscOutPayRecordPO fscOutPayRecordPO = new FscOutPayRecordPO();
        fscOutPayRecordPO.setWriteOffFlag(Integer.valueOf(Integer.parseInt("0")));
        fscOutPayRecordPO.setPayMode("offline");
        fscOutPayRecordPO.setTaskExecuteTime(new Date());
        fscOutPayRecordPO.setSysTenantId(reqBO.getSysTenantId());
        log.info("\u7f6e\u5730\u4ed8\u6b3e\u8bb0\u5f55\u6838\u9500\u94f6\u884c\u6d41\u6c34\u67e5\u8be2\u5165\u53c2:{},page-----{}", (Object)JSON.toJSONString((Object)fscOutPayRecordPO), (Object)JSON.toJSONString((Object)page));
        List fscOutPayRecordPOList = this.fscOutPayRecordMapper.getunWriteOffList(fscOutPayRecordPO, page);
        if (!ObjectUtil.isEmpty((Object)fscOutPayRecordPOList)) {
            ArrayList<Long> bankCheckItemIds = new ArrayList<Long>();
            ArrayList<FscWriteOffItemPO> fscWriteOffItemPOList = new ArrayList<FscWriteOffItemPO>();
            ArrayList<Long> outPayRecordIds = new ArrayList<Long>();
            ArrayList<String> containsList = new ArrayList<String>();
            for (FscOutPayRecordPO item : fscOutPayRecordPOList) {
                FscOutPayRecordPO setTaskTimePO = new FscOutPayRecordPO();
                FscOutPayRecordPO whereTaskTimePO = new FscOutPayRecordPO();
                setTaskTimePO.setTaskExecuteTime(new Date());
                whereTaskTimePO.setOutPayRecordId(item.getOutPayRecordId());
                whereTaskTimePO.setSysTenantId(reqBO.getSysTenantId());
                this.fscOutPayRecordMapper.updateBy(setTaskTimePO, whereTaskTimePO);
                FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
                fscBankCheckFileItemPO.setTradeAmt(item.getPayAmount());
                fscBankCheckFileItemPO.setPayerBankAccount(item.getPayerAccount());
                fscBankCheckFileItemPO.setPayeeId(item.getPayeeId());
                fscBankCheckFileItemPO.setPayeeAccountNo(item.getPayeeAccount());
                fscBankCheckFileItemPO.setWriteOffFlag("0");
                fscBankCheckFileItemPO.setSysTenantId(reqBO.getSysTenantId());
                log.info("\u67e5\u8be2\u5165\u53c2\u94f6\u884c\u6d41\u6c34\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscBankCheckFileItemPO));
                List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPO);
                if (ObjectUtil.isEmpty((Object)fscBankCheckFileItemPOList)) {
                    fscBankCheckFileItemPO1 = this.insertBankFileItem(item);
                    fscBankCheckFileItemPOList.add(fscBankCheckFileItemPO1);
                }
                log.info("\u67e5\u8be2\u5165\u53c2\u94f6\u884c\u6d41\u6c34\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscBankCheckFileItemPOList));
                FscBankCheckFileItemPO fileItemPO = (FscBankCheckFileItemPO)fscBankCheckFileItemPOList.get(0);
                log.info("\u4ed8\u6b3e\u5355\u6570\u636e:{}", (Object)JSON.toJSONString((Object)item));
                if (bankCheckItemIds.contains(fileItemPO.getBankCheckId())) {
                    log.info("\u91cd\u590d\u6838\u9500\u94f6\u884cid:{}-------\u4ed8\u6b3e\u5355\u4fe1\u606f:{}", (Object)fileItemPO.getBankCheckId(), (Object)JSON.toJSONString((Object)fscBankCheckFileItemPO));
                    continue;
                }
                outPayRecordIds.add(item.getOutPayRecordId());
                bankCheckItemIds.add(fileItemPO.getBankCheckId());
                Long outPayOrderId = item.getOutPayOrderId();
                FscOrderPO outPayOrderParams = new FscOrderPO();
                outPayOrderParams.setOutPayOrderId(outPayOrderId);
                outPayOrderParams.setPayeeId(item.getPayeeId());
                outPayOrderParams.setPayerId(item.getPayerId());
                outPayOrderParams.setOrderState(FscConstants.FscPayOrderState.PAIED);
                outPayOrderParams.setSysTenantId(reqBO.getSysTenantId());
                List fscPayOrderPOList = this.fscOrderMapper.getPayOrderListByOutPayOrderId(outPayOrderParams);
                if (ObjectUtil.isEmpty((Object)fscPayOrderPOList)) continue;
                FscWriteOffItemPO fscWriteOffItemParmsPO = new FscWriteOffItemPO();
                fscWriteOffItemParmsPO.setBankCheckId(fileItemPO.getBankCheckId());
                fscWriteOffItemParmsPO.setSysTenantId(reqBO.getSysTenantId());
                List writeOffItemPOS = this.fscWriteOffItemMapper.getListByFscOrderId(fscWriteOffItemParmsPO);
                ArrayList fscWriteOffPayOrderIds = new ArrayList();
                if (!ObjectUtil.isEmpty((Object)writeOffItemPOS)) {
                    fscWriteOffPayOrderIds.addAll(writeOffItemPOS.stream().map(FscWriteOffItemPO::getFscOrderId).collect(Collectors.toList()));
                }
                for (FscOrderPO fscPayOrderPO : fscPayOrderPOList) {
                    if (fscWriteOffPayOrderIds.contains(fscPayOrderPO.getFscOrderId())) continue;
                    FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
                    fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscWriteOffItemPO.setFscOrderId(fscPayOrderPO.getFscOrderId());
                    fscWriteOffItemPO.setBankCheckId(fileItemPO.getBankCheckId());
                    fscWriteOffItemPO.setWriteOffType(FscConstants.FSC_WRITE_OFF_TYPE.OUT_PAY_RECORD);
                    fscWriteOffItemPO.setCreateTime(new Date());
                    fscWriteOffItemPO.setCreateOperUserId(Long.valueOf(0L));
                    fscWriteOffItemPO.setCreateOperUserName("admin");
                    fscWriteOffItemPO.setMemo("\u7f6e\u5730\u7ebf\u4e0b\u4ed8\u6b3e\u6838\u9500\u5173\u8054-\u4ed8\u6b3e\u8bb0\u5f55");
                    fscWriteOffItemPO.setSysTenantId(reqBO.getSysTenantId());
                    fscWriteOffItemPO.setSysTenantName(reqBO.getSysTenantName());
                    String key = fscPayOrderPO.getFscOrderId() + "-" + fileItemPO.getBankCheckId();
                    if (containsList.contains(key)) continue;
                    fscWriteOffItemPOList.add(fscWriteOffItemPO);
                    bankCheckIdList.add(fscWriteOffItemPO.getBankCheckId());
                    containsList.add(key);
                }
            }
            if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
                log.info("\u53d1\u7968\u6838\u9500\u94f6\u884c\u6d41\u6c34\u65b0\u589e\u5173\u7cfb\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString(fscWriteOffItemPOList));
                this.fscWriteOffItemMapper.insertBatch(fscWriteOffItemPOList);
            }
            if (!CollectionUtils.isEmpty(outPayRecordIds)) {
                FscOutPayRecordPO updateFscOutPayRecordPO = new FscOutPayRecordPO();
                updateFscOutPayRecordPO.setUpdateTime(new Date());
                updateFscOutPayRecordPO.setOutPayRecordIds(outPayRecordIds);
                updateFscOutPayRecordPO.setUpdateTime(new Date());
                updateFscOutPayRecordPO.setUpdateOperUserName("admin");
                updateFscOutPayRecordPO.setUpdateOperUserId(Long.valueOf(0L));
                updateFscOutPayRecordPO.setWriteOffFlag(Integer.valueOf(Integer.parseInt("1")));
                updateFscOutPayRecordPO.setSysTenantId(reqBO.getSysTenantId());
                this.fscOutPayRecordMapper.updateByRecordIds(updateFscOutPayRecordPO);
            }
        }
        Page pageOrder = new Page();
        pageOrder.setPageNo(1);
        pageOrder.setPageSize(this.masPageSize.intValue());
        FscOrderPO selectPO = new FscOrderPO();
        selectPO.setCancelReason(this.cancelReason);
        selectPO.setOrderFlow(Integer.valueOf(1));
        selectPO.setNotCancelDesc("\u7ebf\u4e0b\u4ed8\u6b3e\u5df2\u6838\u9500\u5904\u7406");
        selectPO.setTaskExecuteTime(new Date());
        selectPO.setOrderState(FscConstants.FscPayOrderState.PAIED);
        selectPO.setSysTenantId(reqBO.getSysTenantId());
        List fscOrderPOList = this.fscOrderMapper.getListPage(selectPO, pageOrder);
        if (!ObjectUtil.isEmpty((Object)fscOrderPOList)) {
            ArrayList<FscWriteOffItemPO> fscWriteOffItemPOList = new ArrayList<FscWriteOffItemPO>();
            ArrayList updateOrderIds = new ArrayList();
            ArrayList<String> containsList = new ArrayList<String>();
            for (FscOrderPO fscOrderPO : fscOrderPOList) {
                fscOrderPO.setTaskExecuteTime(new Date());
                this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
                FscWriteOffItemPO record = new FscWriteOffItemPO();
                record.setFscOrderIds(Arrays.asList(fscOrderPO.getFscOrderId()));
                record.setSysTenantId(reqBO.getSysTenantId());
                List fscWriteOffItemPOS = this.fscWriteOffItemMapper.getListByFscOrderId(record);
                if (!ObjectUtil.isEmpty((Object)fscWriteOffItemPOS)) continue;
                fscBankCheckFileItemPO1 = this.insertBankFileItem(fscOrderPO);
                FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
                fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                fscWriteOffItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
                fscWriteOffItemPO.setBankCheckId(fscBankCheckFileItemPO1.getBankCheckId());
                fscWriteOffItemPO.setWriteOffType(FscConstants.FSC_WRITE_OFF_TYPE.OUT_PAY_RECORD);
                fscWriteOffItemPO.setCreateTime(new Date());
                fscWriteOffItemPO.setCreateOperUserId(Long.valueOf(0L));
                fscWriteOffItemPO.setCreateOperUserName("admin");
                fscWriteOffItemPO.setMemo("\u4ed8\u6b3e\u5355\u7ebf\u4e0b\u4ed8\u6b3e\u6838\u9500-\u81ea\u52a8\u5173\u8054");
                fscWriteOffItemPO.setSysTenantId(reqBO.getSysTenantId());
                fscWriteOffItemPO.setSysTenantName(reqBO.getSysTenantName());
                String key = fscOrderPO.getFscOrderId() + "-" + fscBankCheckFileItemPO1.getBankCheckId();
                if (containsList.contains(key)) continue;
                fscWriteOffItemPOList.add(fscWriteOffItemPO);
                bankCheckIdList.add(fscWriteOffItemPO.getBankCheckId());
                containsList.add(key);
            }
            if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
                this.fscWriteOffItemMapper.insertBatch(fscWriteOffItemPOList);
            }
            if (!ObjectUtil.isEmpty(updateOrderIds)) {
                FscOrderPO setPO = new FscOrderPO();
                setPO.setCancelDesc("\u7ebf\u4e0b\u4ed8\u6b3e\u5df2\u6838\u9500\u5904\u7406");
                setPO.setCancelTime(new Date());
                FscOrderPO wherePO = new FscOrderPO();
                wherePO.setFscOrderIds(updateOrderIds);
                wherePO.setSysTenantId(reqBO.getSysTenantId());
                this.fscOrderMapper.updateBy(setPO, wherePO);
            }
        }
        rspBO.setBankCheckIdList(bankCheckIdList);
        return rspBO;
    }

    private FscBankCheckFileItemPO insertBankFileItem(FscOutPayRecordPO item) {
        FscLegalCompanyPO fscLegalCompanyPO;
        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPO.setBankCheckId(Long.valueOf(Sequence.getInstance().nextId()));
        fscBankCheckFileItemPO.setPayeeOraCode(item.getPayeeId().toString());
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setStatus(Integer.valueOf(1));
        fscAccountPO.setOrgIdS(Arrays.asList(item.getPayerId(), item.getPayeeId()));
        fscAccountPO.setSysTenantId(item.getSysTenantId());
        List fscAccountPOList = this.fscAccountMapper.getList(fscAccountPO);
        if (!ObjectUtil.isEmpty((Object)fscAccountPOList)) {
            Map<Long, List<FscAccountPO>> fscAccountMapList = fscAccountPOList.stream().collect(Collectors.groupingBy(FscAccountPO::getOrgId));
            fscBankCheckFileItemPO.setPayerAccountName(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayerId())) ? "" : fscAccountMapList.get(item.getPayerId()).get(0).getAccountName());
            fscBankCheckFileItemPO.setPayerBankAccount(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayerId())) ? "" : fscAccountMapList.get(item.getPayerId()).get(0).getAccountNo());
            fscBankCheckFileItemPO.setPayerBankName(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayerId())) ? "" : fscAccountMapList.get(item.getPayerId()).get(0).getDepositBankName());
            fscBankCheckFileItemPO.setPayeeAccountNo(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayeeId())) ? "" : fscAccountMapList.get(item.getPayeeId()).get(0).getRecvSubLedgerAcctNo());
            fscBankCheckFileItemPO.setPayeeAccountName(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayeeId())) ? "" : fscAccountMapList.get(item.getPayeeId()).get(0).getAccountName());
            fscBankCheckFileItemPO.setPayeeBankName(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayeeId())) ? "" : fscAccountMapList.get(item.getPayeeId()).get(0).getRecvSubLedgerBankName());
        }
        fscBankCheckFileItemPO.setPayeeSubAccountNo(ObjectUtil.isEmpty((Object)(fscLegalCompanyPO = this.fscLegalCompanyMapper.getByOrgId(item.getPayeeId(), item.getSysTenantId()))) ? "" : fscLegalCompanyPO.getSubAccountNo());
        fscBankCheckFileItemPO.setTradeAmt(item.getPayAmount());
        fscBankCheckFileItemPO.setPayerId(item.getPayerId());
        fscBankCheckFileItemPO.setPayerName(item.getPayerName());
        fscBankCheckFileItemPO.setPayeeId(item.getPayeeId());
        fscBankCheckFileItemPO.setPayeeName(item.getPayeeName());
        fscBankCheckFileItemPO.setWriteOffFlag("1");
        fscBankCheckFileItemPO.setStatus(Integer.valueOf(1));
        fscBankCheckFileItemPO.setShouldPayNo("\u7f6e\u5730\u6838\u9500\u624b\u52a8\u751f\u6210\u6d41\u6c34-\u7f6e\u5730\u4ed8\u6b3e\u8bb0\u5f55id:" + item.getOutPayRecordId());
        fscBankCheckFileItemPO.setMemo("\u7f6e\u5730\u6838\u9500\u624b\u52a8\u751f\u6210\u6d41\u6c34");
        fscBankCheckFileItemPO.setSysTenantId(item.getSysTenantId());
        fscBankCheckFileItemPO.setSysTenantName(item.getSysTenantName());
        int result = this.fscBankCheckFileItemMapper.insert(fscBankCheckFileItemPO);
        if (result < 1) {
            throw new FscBusinessException("198888", "\u65b0\u589e\u94f6\u884c\u6d41\u6c34\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        return fscBankCheckFileItemPO;
    }

    private FscBankCheckFileItemPO insertBankFileItem(FscOrderPO item) {
        FscLegalCompanyPO fscLegalCompanyPO;
        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPO.setBankCheckId(Long.valueOf(Sequence.getInstance().nextId()));
        fscBankCheckFileItemPO.setPayeeOraCode(item.getPayeeId().toString());
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setStatus(Integer.valueOf(1));
        fscAccountPO.setOrgIdS(Arrays.asList(item.getPayerId(), item.getPayeeId()));
        fscAccountPO.setSysTenantId(item.getSysTenantId());
        List fscAccountPOList = this.fscAccountMapper.getList(fscAccountPO);
        if (!ObjectUtil.isEmpty((Object)fscAccountPOList)) {
            Map<Long, List<FscAccountPO>> fscAccountMapList = fscAccountPOList.stream().collect(Collectors.groupingBy(FscAccountPO::getOrgId));
            fscBankCheckFileItemPO.setPayerAccountName(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayerId())) ? "" : fscAccountMapList.get(item.getPayerId()).get(0).getAccountName());
            fscBankCheckFileItemPO.setPayerBankAccount(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayerId())) ? "" : fscAccountMapList.get(item.getPayerId()).get(0).getAccountNo());
            fscBankCheckFileItemPO.setPayerBankName(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayerId())) ? "" : fscAccountMapList.get(item.getPayerId()).get(0).getDepositBankName());
            fscBankCheckFileItemPO.setPayeeAccountNo(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayeeId())) ? "" : fscAccountMapList.get(item.getPayeeId()).get(0).getRecvSubLedgerAcctNo());
            fscBankCheckFileItemPO.setPayeeAccountName(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayeeId())) ? "" : fscAccountMapList.get(item.getPayeeId()).get(0).getAccountName());
            fscBankCheckFileItemPO.setPayeeBankName(ObjectUtil.isEmpty(fscAccountMapList.get(item.getPayeeId())) ? "" : fscAccountMapList.get(item.getPayeeId()).get(0).getRecvSubLedgerBankName());
        }
        fscBankCheckFileItemPO.setPayeeSubAccountNo(ObjectUtil.isEmpty((Object)(fscLegalCompanyPO = this.fscLegalCompanyMapper.getByOrgId(item.getPayeeId(), item.getSysTenantId()))) ? "" : fscLegalCompanyPO.getSubAccountNo());
        fscBankCheckFileItemPO.setTradeAmt(item.getTotalCharge());
        fscBankCheckFileItemPO.setPayerId(item.getPayerId());
        fscBankCheckFileItemPO.setPayerName(item.getPayerName());
        fscBankCheckFileItemPO.setPayeeId(item.getPayeeId());
        fscBankCheckFileItemPO.setPayeeName(item.getPayeeName());
        fscBankCheckFileItemPO.setWriteOffFlag("1");
        fscBankCheckFileItemPO.setStatus(Integer.valueOf(1));
        fscBankCheckFileItemPO.setShouldPayNo("\u7f6e\u5730\u6838\u9500\u624b\u52a8\u751f\u6210\u6d41\u6c34-\u4ed8\u6b3e\u5355id:" + item.getFscOrderId());
        fscBankCheckFileItemPO.setMemo("\u4ed8\u6b3e\u5355\u7ebf\u4e0b\u4ed8\u6b3e\u6838\u9500\u624b\u52a8\u751f\u6210\u6d41\u6c34");
        fscBankCheckFileItemPO.setSysTenantId(item.getSysTenantId());
        fscBankCheckFileItemPO.setSysTenantName(item.getSysTenantName());
        int result = this.fscBankCheckFileItemMapper.insert(fscBankCheckFileItemPO);
        if (result < 1) {
            throw new FscBusinessException("198888", "\u65b0\u589e\u94f6\u884c\u6d41\u6c34\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        return fscBankCheckFileItemPO;
    }
}

