/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.cfc.ability.api.CrcQryPaymentBehalfAbilityService;
import com.tydic.cfc.ability.bo.CfcPaymentBehalfBO;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfAbilityReqBO;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfAbilityRspBO;
import com.tydic.fsc.bo.FscBalanceBO;
import com.tydic.fsc.bo.FscCreateFscBalanceBusiReqBO;
import com.tydic.fsc.busibase.busi.api.FscOrderStatusFlowBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscAutoWriteOffBusiService;
import com.tydic.fsc.common.busi.bo.FscAutoWriteOffBusiServiceReqBO;
import com.tydic.fsc.common.busi.bo.FscAutoWriteOffBusiServiceRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAutoWriteOffBusiServiceImpl
implements FscAutoWriteOffBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAutoWriteOffBusiServiceImpl.class);
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscOrderStatusFlowBusiService fscOrderStatusFlowBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private CrcQryPaymentBehalfAbilityService crcQryPaymentBehalfAbilityService;
    @Resource(name="createFscBalanceProducer")
    private ProxyMessageProducer createFscBalanceProducer;
    @Value(value="${CREATE_FSC_BALANCE_TOPIC:CREATE_FSC_BALANCE_TOPIC}")
    private String CREATE_FSC_BALANCE_TOPIC;
    @Value(value="${CREATE_FSC_BALANCE_TAG:*}")
    private String CREATE_FSC_BALANCE_TAG;

    @Override
    public FscAutoWriteOffBusiServiceRspBO autoWriteOffOrder(FscAutoWriteOffBusiServiceReqBO reqBO) {
        FscAutoWriteOffBusiServiceRspBO rspBO = new FscAutoWriteOffBusiServiceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<FscOrderPO> fscOrderPOList = reqBO.getFscOrderPOList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<FscWriteOffItemPO> fscWriteOffItemPOList = new ArrayList<FscWriteOffItemPO>();
        ArrayList<FscBalancePO> fscBalancePOList = new ArrayList<FscBalancePO>();
        ArrayList<Long> dealStatusOrderIds = new ArrayList<Long>();
        ArrayList<Long> bankCheckIdList = new ArrayList<Long>();
        Calendar now = Calendar.getInstance();
        now.add(5, Math.negateExact(reqBO.getOverdueDay()));
        List fscOrderIds = fscOrderPOList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        FscWriteOffItemPO record = new FscWriteOffItemPO();
        record.setFscOrderIds(fscOrderIds);
        record.setSysTenantId(reqBO.getSysTenantId());
        List writeOffItemPOS = this.fscWriteOffItemMapper.getListByFscOrderId(record);
        ArrayList writeOffFscOrderIds = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)writeOffItemPOS)) {
            writeOffFscOrderIds.addAll(writeOffItemPOS.stream().map(FscWriteOffItemPO::getFscOrderId).collect(Collectors.toList()));
        }
        for (FscOrderPO fscOrderPO : fscOrderPOList) {
            Date syncDate = fscOrderPO.getSyncTime();
            Date configDate = DateUtil.strToDate((String)sdf.format(now.getTime()), (String)"yyyy-MM-dd");
            Date payOrderDate = DateUtil.strToDate((String)sdf.format(syncDate.getTime()), (String)"yyyy-MM-dd");
            log.info("\u6838\u9500\u65f6\u95f4\uff1a{}----{}", (Object)configDate, (Object)payOrderDate);
            if (payOrderDate.after(configDate)) {
                log.info("\u4ed8\u6b3e\u5355:{}\u72b6\u6001\u672a\u4fee\u6539\u65f6\u95f4\u4e0e\u914d\u7f6e\u4e0d\u4e00\u81f4", (Object)fscOrderPO.getFscOrderId());
                continue;
            }
            if (writeOffFscOrderIds.contains(fscOrderPO.getFscOrderId())) {
                log.info("\u4ed8\u6b3e\u5355:{}\u5df2\u6838\u9500,\u8bf7\u52ff\u91cd\u590d\u6838\u9500", (Object)fscOrderPO.getFscOrderId());
                continue;
            }
            Long payerId = fscOrderPO.getPayerId();
            List<Long> toPayerIds = this.getPaymentBehalf(fscOrderPO.getPayerId(), fscOrderPO.getSecondOrgId());
            Long payeeId = fscOrderPO.getPayeeId();
            String payeeAccountNo = fscOrderPO.getPayeeBankAccount();
            BigDecimal payAmount = fscOrderPO.getTotalCharge();
            FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
            toPayerIds.add(payerId);
            fscBankCheckFileItemPO.setPayerIds(toPayerIds);
            fscBankCheckFileItemPO.setPayeeId(payeeId);
            fscBankCheckFileItemPO.setPayeeAccountNo(payeeAccountNo);
            fscBankCheckFileItemPO.setTradeAmt(payAmount);
            fscBankCheckFileItemPO.setTradeDate(sdf.format(syncDate));
            fscBankCheckFileItemPO.setWriteOffFlag("0");
            fscBankCheckFileItemPO.setSysTenantId(reqBO.getSysTenantId());
            List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.autoWriteOffPayOrder(fscBankCheckFileItemPO);
            if (ObjectUtils.isEmpty((Object)fscBankCheckFileItemPOList)) {
                log.info("\u672a\u67e5\u8be2\u5230\u94f6\u884c\u6d41\u6c34\u6587\u4ef6");
                continue;
            }
            FscBankCheckFileItemPO unWriteOffBankFileItem = (FscBankCheckFileItemPO)fscBankCheckFileItemPOList.get(0);
            FscOrderPO updatePayOrder = new FscOrderPO();
            updatePayOrder.setFscOrderId(fscOrderPO.getFscOrderId());
            if (null != reqBO.getUserId()) {
                fscOrderPO.setPayOperId(reqBO.getUserId().toString());
            }
            updatePayOrder.setPayOperName("\u7cfb\u7edf\u81ea\u52a8\u6838\u9500");
            updatePayOrder.setPayTime(new Date());
            updatePayOrder.setPayState(FscConstants.PayOrderPayStatus.PAIED);
            updatePayOrder.setActualAmount(fscOrderPO.getTotalCharge());
            updatePayOrder.setOrderState(FscConstants.FscPayOrderState.PAIED);
            updatePayOrder.setSysTenantId(reqBO.getSysTenantId());
            int row = this.fscOrderMapper.updateById(updatePayOrder);
            if (row < 1) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            unWriteOffBankFileItem.setWriteOffFlag("1");
            unWriteOffBankFileItem.setStatus(FscConstants.BANK_CHECK_STATUS.YES);
            int rows = this.fscBankCheckFileItemMapper.updateByBankCheckId(unWriteOffBankFileItem);
            if (rows < 1) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u6838\u9500\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
            fscWriteOffItemPO.setMemo("\u62a5\u8d26\u7cfb\u7edf\u4ed8\u6b3e\u6210\u529f");
            fscWriteOffItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscWriteOffItemPO.setBankCheckId(unWriteOffBankFileItem.getBankCheckId());
            fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
            fscWriteOffItemPO.setCreateTime(new Date());
            fscWriteOffItemPO.setCreateOperUserId(Long.valueOf(0L));
            fscWriteOffItemPO.setCreateOperUserName("admin");
            fscWriteOffItemPO.setWriteOffType(Integer.valueOf(1));
            fscWriteOffItemPO.setSysTenantId(reqBO.getSysTenantId());
            fscWriteOffItemPO.setSysTenantName(reqBO.getSysTenantName());
            if (fscOrderPO.getPayerId().equals(unWriteOffBankFileItem.getPayerId())) {
                fscWriteOffItemPO.setMemo("\u81ea\u52a8\u6838\u9500\uff08\u652f\u4ed8\u53cd\u9988\u53ca\u8d85\u671f\uff09");
            } else {
                fscWriteOffItemPO.setMemo("\u81ea\u52a8\u6838\u9500\uff08\u652f\u4ed8\u53cd\u9988\u53ca\u8d85\u671f\uff09\uff0c\u4ee3\u4ed8\u6b3e");
            }
            fscWriteOffItemPOList.add(fscWriteOffItemPO);
            bankCheckIdList.add(fscWriteOffItemPO.getBankCheckId());
            FscBalancePO fscBalancePO = new FscBalancePO();
            fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
            fscBalancePO.setBankCheckId(unWriteOffBankFileItem.getBankCheckId());
            fscBalancePO.setOrgId(fscOrderPO.getPayeeId());
            fscBalancePO.setOrgCode("");
            fscBalancePO.setOrgName(fscOrderPO.getPayeeName());
            fscBalancePO.setSubAccountNo(unWriteOffBankFileItem.getPayeeAccountNo());
            fscBalancePO.setPayerOrgId(fscOrderPO.getPayerId());
            fscBalancePO.setPayerOrgName(fscOrderPO.getPayerName());
            fscBalancePO.setPayerOrgCode(null);
            fscBalancePO.setPayerSubAccountNo(null);
            fscBalancePO.setFrozenEndTime(this.getConfiguration(fscOrderPO.getPayeeId().toString(), reqBO.getSysTenantId()));
            fscBalancePO.setPayAmount(unWriteOffBankFileItem.getTradeAmt());
            fscBalancePO.setCreateTime(new Date());
            if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                fscBalancePO.setFrozenAmount(new BigDecimal(0));
                fscBalancePO.setUsableAmount(unWriteOffBankFileItem.getTradeAmt());
                fscBalancePO.setThawOperTime(new Date());
            } else {
                fscBalancePO.setFrozenAmount(unWriteOffBankFileItem.getTradeAmt());
                fscBalancePO.setUsableAmount(new BigDecimal(0));
            }
            fscBalancePO.setUsedAmount(new BigDecimal(0));
            fscBalancePO.setCreateTime(new Date());
            fscBalancePO.setSysTenantId(unWriteOffBankFileItem.getSysTenantId());
            fscBalancePOList.add(fscBalancePO);
            dealStatusOrderIds.add(fscOrderPO.getFscOrderId());
        }
        if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
            this.fscWriteOffItemMapper.insertBatch(fscWriteOffItemPOList);
        }
        if (!CollectionUtils.isEmpty(fscBalancePOList)) {
            FscCreateFscBalanceBusiReqBO fscBalanceBusiReqBO = new FscCreateFscBalanceBusiReqBO();
            fscBalanceBusiReqBO.setFscBalanceList(JSON.parseArray((String)JSON.toJSONString(fscBalancePOList), FscBalanceBO.class));
            ProxyMessage message = new ProxyMessage(this.CREATE_FSC_BALANCE_TOPIC, this.CREATE_FSC_BALANCE_TAG, JSON.toJSONString((Object)fscBalanceBusiReqBO));
            this.createFscBalanceProducer.send(message);
        }
        if (!CollectionUtils.isEmpty(dealStatusOrderIds)) {
            Date curSysDate = new Date();
            for (Long id : dealStatusOrderIds) {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(id);
                fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
                fscComOrderListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                this.syncOrderStatus1(id, curSysDate, reqBO.getSysTenantId());
            }
        }
        rspBO.setBankCheckIdList(bankCheckIdList);
        return rspBO;
    }

    private Date getConfiguration(String relId, Long sysTenantId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        fscCfcUniteParamQryListDetailExternalReqBO.setSysTenantId(sysTenantId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }

    private void syncOrderStatus1(Long fscPayOrderId, Date curSysDate, Long sysTenantId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId, sysTenantId);
        Map<Long, FscShouldPayPO> fscShouldPayPOMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getObjectId, FscShouldPayPO2 -> FscShouldPayPO2));
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            return;
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(fscShouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        fscOrderPo.setSysTenantId(sysTenantId);
        List orderList = this.fscOrderMapper.getList(fscOrderPo);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(orderList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList()));
        fscOrderRelationPo.setSysTenantId(sysTenantId);
        List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
            fscUocProOrderPaymentCallbackAbilityReqBO.setUocPaymentCallbackBOS(fscOrderRelationPOs.stream().map(fscPaySuccessCallBackOrderBO -> {
                FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBO = new FscUocProOrderPaymentCallbackAbilityBO();
                fscUocProOrderPaymentCallbackAbilityBO.setSaleOrderId(fscPaySuccessCallBackOrderBO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayMod(Integer.valueOf(30));
                fscUocProOrderPaymentCallbackAbilityBO.setObjectId(fscPaySuccessCallBackOrderBO.getAcceptOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayerType(FscConstants.FscOrderReceiveType.PURCHASE.equals(((FscOrderPO)orderList.get(0)).getReceiveType()) ? "pur" : "pro");
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(Boolean.valueOf(true));
                fscUocProOrderPaymentCallbackAbilityBO.setPayTime(curSysDate);
                fscUocProOrderPaymentCallbackAbilityBO.setShouldPayMoney(fscPaySuccessCallBackOrderBO.getOrderTotalCharge());
                fscUocProOrderPaymentCallbackAbilityBO.setFscShouldPayId(((FscShouldPayPO)fscShouldPayPOMap.get(fscPaySuccessCallBackOrderBO.getFscOrderId())).getShouldPayId());
                return fscUocProOrderPaymentCallbackAbilityBO;
            }).collect(Collectors.toList()));
            fscUocProOrderPaymentCallbackAbilityReqBO.setSysTenantId(sysTenantId);
            this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
        }
    }

    private List<Long> getPaymentBehalf(Long purId, Long subId) {
        ArrayList<Long> toPayPayerIds = new ArrayList<Long>();
        CrcQryPaymentBehalfAbilityReqBO crcQryPaymentBehalfAbilityReqBO = new CrcQryPaymentBehalfAbilityReqBO();
        crcQryPaymentBehalfAbilityReqBO.setCorporationId(purId);
        crcQryPaymentBehalfAbilityReqBO.setOrgIdWeb(subId);
        log.info("\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfAbilityReqBO));
        CrcQryPaymentBehalfAbilityRspBO crcQryPaymentBehalfAbilityRspBO = this.crcQryPaymentBehalfAbilityService.qryPaymentBehalf(crcQryPaymentBehalfAbilityReqBO);
        log.info("\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfAbilityRspBO));
        if (!"0000".equals(crcQryPaymentBehalfAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("193203", "\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u9519\u8bef");
        }
        if (!ObjectUtil.isEmpty((Object)crcQryPaymentBehalfAbilityRspBO.getCfcPaymentBehalfBOS())) {
            List cfcPaymentBehalfBOS = crcQryPaymentBehalfAbilityRspBO.getCfcPaymentBehalfBOS().stream().filter(o -> o.getFreezeFlag().equals(FscConstants.CONFIG_STATUS_TO_PAY.NO)).collect(Collectors.toList());
            List paymentIds = cfcPaymentBehalfBOS.stream().map(CfcPaymentBehalfBO::getPaymentId).collect(Collectors.toList());
            toPayPayerIds.addAll(paymentIds);
        }
        return toPayPayerIds;
    }
}

