/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.fsc.common.busi.api.FscBankCheckFileItemInsertBusiService;
import com.tydic.fsc.common.busi.bo.FscBankCheckFileItemInsertBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBankCheckFileItemInsertBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscBankCheckFileItemTenantBO;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscBankCheckFileItemInsertBusiServiceImpl
implements FscBankCheckFileItemInsertBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBankCheckFileItemInsertBusiServiceImpl.class);
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Value(value="${crc.sys.tenant.id:305775845729763327}")
    private Long crcSysTenantId;
    @Value(value="${TRADE_SUB_ACCOUNT_NO:30012817000000}")
    private String tradeSubAccountNo;
    @Value(value="${opertionSmartAccountNo:15467777777705}")
    private String opertionSmartAccountNo;

    @Override
    public FscBankCheckFileItemInsertBusiRspBO BankCheckFileItemInsert(FscBankCheckFileItemInsertBusiReqBO reqBO) {
        FscBankCheckFileItemInsertBusiRspBO rspBO = new FscBankCheckFileItemInsertBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (ObjectUtil.isNotEmpty(reqBO.getBankCheckFileItemTenantBOList())) {
            FscBankCheckFileItemPO fscBankCheckFileItemPo = new FscBankCheckFileItemPO();
            fscBankCheckFileItemPo.setBankWitnessSeqList(reqBO.getBankCheckFileItemTenantBOList().stream().map(FscBankCheckFileItemTenantBO::getBankWitnessSeq).collect(Collectors.toList()));
            List bankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPo);
            List bankWithnessSeqList = bankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getBankWitnessSeq).collect(Collectors.toList());
            ArrayList fscBankCheckFileItemPOList = new ArrayList();
            reqBO.getBankCheckFileItemTenantBOList().forEach(bo -> {
                if (!bankWithnessSeqList.contains(bo.getBankWitnessSeq())) {
                    FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
                    BeanUtils.copyProperties((Object)bo, (Object)fscBankCheckFileItemPO);
                    if (this.crcSysTenantId != reqBO.getSysTenantId() && this.opertionSmartAccountNo.equals(fscBankCheckFileItemPO.getPayeeAccountNo())) {
                        fscBankCheckFileItemPO.setPayeeSubAccountNo(this.tradeSubAccountNo);
                    }
                    fscBankCheckFileItemPOList.add(fscBankCheckFileItemPO);
                }
            });
            if (ObjectUtil.isNotEmpty(fscBankCheckFileItemPOList)) {
                this.fscBankCheckFileItemMapper.insertBatch(fscBankCheckFileItemPOList);
            }
        }
        return rspBO;
    }
}

