/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankWithCorpService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankBindBankAccountRspBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankWithCorpReqBO;
import com.tydic.fsc.common.busi.api.FscBindBankAccountAuthBusiService;
import com.tydic.fsc.common.busi.bo.FscBindBankAccountAuthBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBindBankAccountAuthBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBindBankAccountAuthBusiServiceImpl
implements FscBindBankAccountAuthBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBindBankAccountAuthBusiServiceImpl.class);
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscBToBPingAnBankWithCorpService fscBToBPingAnBankWithCorpService;

    @Override
    public FscBindBankAccountAuthBusiRspBO bindBankAccountAuth(FscBindBankAccountAuthBusiReqBO reqBO) {
        FscBToBPingAnBankWithCorpReqBO corpReqBO = new FscBToBPingAnBankWithCorpReqBO();
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setAccountNo(reqBO.getAccountNo() + "");
        fscAccountPO.setSysTenantId(reqBO.getSysTenantId());
        log.info("\u8d26\u6237accountNo\u4e3a:{}", (Object)reqBO.getAccountNo());
        FscAccountPO modelById = this.fscAccountMapper.getModelBy(fscAccountPO);
        log.debug("\u67e5\u8be2\u5230\u7684\u8d26\u6237\u4fe1\u606f\u4e3a:{}", (Object)modelById);
        if (modelById == null) {
            throw new FscBusinessException("198888", "\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u4e3anull");
        }
        corpReqBO.setTranNetMemberCode(modelById.getOrgId() + "");
        Long orgId = modelById.getOrgId();
        FscLegalCompanyPO fscLegalCompanyPO = this.fscLegalCompanyMapper.getById(orgId, reqBO.getSysTenantId());
        if (fscLegalCompanyPO == null) {
            throw new FscBusinessException("198888", "\u8bf7\u6c42\u8d26\u53f7\u4e0d\u5b58\u5728\u5b50\u8d26\u6237\u8d26\u53f7");
        }
        corpReqBO.setSubAcctNo(fscLegalCompanyPO.getSubAccountNo());
        corpReqBO.setTakeCashAcctNo(modelById.getAccountNo());
        if (reqBO.getAuthAmt() == null) {
            throw new FscBusinessException("198888", "\u9274\u6743\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        corpReqBO.setAuthAmt(reqBO.getAuthAmt().toString());
        corpReqBO.setOrderNo(reqBO.getInstNumber());
        corpReqBO.setCcy("RMB");
        corpReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscBToBPingAnBankBindBankAccountRspBO fscBToBPingAnBankBindBankAccountRspBO = this.fscBToBPingAnBankWithCorpService.checkAmountWithCorp(corpReqBO);
        log.debug("\u6b64\u5904\u8c03\u7528\u94f6\u884c\u63a5\u53e3\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a:{}", (Object)fscBToBPingAnBankBindBankAccountRspBO.getRespDesc());
        if (!"0000".equals(fscBToBPingAnBankBindBankAccountRspBO.getRespCode())) {
            throw new FscBusinessException("198888", fscBToBPingAnBankBindBankAccountRspBO.getRespDesc());
        }
        String frontSeqNo = fscBToBPingAnBankBindBankAccountRspBO.getFrontSeqNo();
        FscAccountPO updateAccountPO = new FscAccountPO();
        updateAccountPO.setStatus(FscConstants.AccountStatus.VALID);
        updateAccountPO.setFrontSeqNo(frontSeqNo);
        updateAccountPO.setB2bStatus(FscConstants.AccountBtoBStatus.OPEN);
        int updateRows = this.fscAccountMapper.updateBy(updateAccountPO, fscAccountPO);
        if (updateRows != 1) {
            throw new FscBusinessException("198888", "\u9274\u6743\u72b6\u6001\u4fee\u6539\u5f02\u5e38!");
        }
        FscBindBankAccountAuthBusiRspBO rspBO = new FscBindBankAccountAuthBusiRspBO();
        return rspBO;
    }
}

