/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.common.busi.api.FscCheckWriteOffDateBusiService;
import com.tydic.fsc.common.busi.bo.FscCheckWriteOffDateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscCheckWriteOffDateBusiRspBO;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscCheckWriteOffDateBusiServiceImpl
implements FscCheckWriteOffDateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCheckWriteOffDateBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;

    @Override
    public FscCheckWriteOffDateBusiRspBO checkWriteOffDate(FscCheckWriteOffDateBusiReqBO reqBO) {
        FscCheckWriteOffDateBusiRspBO rspBO = new FscCheckWriteOffDateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(reqBO.getFscOrderPayIds());
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
        if (ObjectUtil.isEmpty((Object)fscOrderPOList)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5173\u8054\u7ed3\u7b97\u5355");
        }
        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPO.setBankCheckIdS(reqBO.getBankCheckIds());
        fscBankCheckFileItemPO.setSysTenantId(reqBO.getSysTenantId());
        List bankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPO);
        if (ObjectUtil.isEmpty((Object)bankCheckFileItemPOList)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u94f6\u884c\u6d41\u6c34");
        }
        List orderCreateTimeList = fscOrderPOList.stream().filter(o -> !ObjectUtil.isEmpty((Object)o.getCreateTime())).map(FscOrderPO::getCreateTime).collect(Collectors.toList());
        log.info("\u4e0b\u5355\u65e5\u671f:{}", (Object)JSON.toJSONString(orderCreateTimeList));
        Date maxDate = orderCreateTimeList.stream().max(Date::compareTo).orElse(null);
        ArrayList<Date> bankDateList = new ArrayList<Date>();
        for (FscBankCheckFileItemPO bankCheckFileItemPO : bankCheckFileItemPOList) {
            String tradDate = DateUtil.dateToStrLong((Date)DateUtil.strToDateyyyyMMddHHmmss((String)(bankCheckFileItemPO.getTradeDate() + bankCheckFileItemPO.getTradeTime())));
            Date tempDate = DateUtil.strToDate((String)tradDate, (String)"yyyy-MM-dd HH:mm:ss");
            bankDateList.add(tempDate);
        }
        Date minDate = bankDateList.stream().min(Date::compareTo).orElse(null);
        int result = maxDate.compareTo(minDate);
        if (result > 0) {
            rspBO.setIsAfter(true);
        } else if (result < 0) {
            rspBO.setIsAfter(false);
        } else {
            rspBO.setIsAfter(false);
        }
        return rspBO;
    }
}

