/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.cfc.ability.api.CrcQryPaymentBehalfAbilityService;
import com.tydic.cfc.ability.bo.CfcPaymentBehalfBO;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfAbilityReqBO;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfAbilityRspBO;
import com.tydic.fsc.bo.FscBalanceBO;
import com.tydic.fsc.bo.FscCreateFscBalanceBusiReqBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.busi.api.FscCheckWriteOffDateBusiService;
import com.tydic.fsc.common.busi.api.FscWriteOffBankFileApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscPayBillCreateBusiBO;
import com.tydic.fsc.common.busi.bo.FscPayBillCreateBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscWriteOffBankFileApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscWriteOffBankFileApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscWriteOffApprovalOrderMapper;
import com.tydic.fsc.dao.FscWriteOffApprovalRelationMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcDycEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscWriteOffBankFileApprovalBusiServiceImpl
implements FscWriteOffBankFileApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscWriteOffBankFileApprovalBusiServiceImpl.class);
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private UmcDycEnterpriseOrgQryDetailAbilityService umcDycEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscWriteOffApprovalOrderMapper fscWriteOffApprovalOrderMapper;
    @Autowired
    private FscWriteOffApprovalRelationMapper fscWriteOffApprovalRelationMapper;
    @Autowired
    private CrcQryPaymentBehalfAbilityService crcQryPaymentBehalfAbilityService;
    @Autowired
    private FscCheckWriteOffDateBusiService fscCheckWriteOffDateBusiService;
    @Value(value="${enabled.pingAn.account:true}")
    private Boolean enabledPingAnAccount;
    @Resource(name="createFscBalanceProducer")
    private ProxyMessageProducer createFscBalanceProducer;
    @Value(value="${CREATE_FSC_BALANCE_TOPIC:CREATE_FSC_BALANCE_TOPIC}")
    private String CREATE_FSC_BALANCE_TOPIC;
    @Value(value="${CREATE_FSC_BALANCE_TAG:*}")
    private String CREATE_FSC_BALANCE_TAG;

    @Override
    public FscWriteOffBankFileApprovalBusiRspBO writeOffBankFileApproval(FscWriteOffBankFileApprovalBusiReqBO reqBO) {
        FscWriteOffBankFileApprovalBusiRspBO fscWriteOffBankFileApprovalBusiRspBO = new FscWriteOffBankFileApprovalBusiRspBO();
        fscWriteOffBankFileApprovalBusiRspBO.setRespCode("0000");
        fscWriteOffBankFileApprovalBusiRspBO.setRespDesc("\u6210\u529f");
        FscBankCheckFileItemPO queryFscPaidBankCheckFileItem = new FscBankCheckFileItemPO();
        queryFscPaidBankCheckFileItem.setFscOrderIds(reqBO.getFscOrderIds());
        queryFscPaidBankCheckFileItem.setSysTenantId(reqBO.getSysTenantId());
        List fscPaidBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.queryPaidBankCheckFileItemList(queryFscPaidBankCheckFileItem);
        this.validateWriteOffBankAndPayOrder(reqBO, fscPaidBankCheckFileItemPOList);
        ArrayList<Long> syncFscOrderIds = new ArrayList<Long>();
        List fscBankCheckFileItemPOList = new ArrayList();
        if (!ObjectUtil.isEmpty(reqBO.getBankCheckIds())) {
            FscBankCheckFileItemPO fscBankCheckFileItemPOQry = new FscBankCheckFileItemPO();
            fscBankCheckFileItemPOQry.setBankCheckIdS(reqBO.getBankCheckIds());
            fscBankCheckFileItemPOQry.setSysTenantId(reqBO.getSysTenantId());
            fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPOQry);
            if (CollectionUtils.isEmpty(fscBankCheckFileItemPOList) || reqBO.getBankCheckIds().size() != fscBankCheckFileItemPOList.size()) {
                throw new FscBusinessException("198888", "\u672a\u6838\u9500\u72b6\u6001\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u540e\u518d\u8bd5");
            }
        }
        List<Object> fscOrderPOList = new ArrayList();
        if (reqBO.getIsShoulPayWrite().booleanValue() && !ObjectUtil.isEmpty((Object)reqBO.getFscPayBillCreateBO())) {
            FscPayBillCreateBusiRspBO fscPayBillCreateBusiRspBO = this.insertPayOrder(reqBO.getFscPayBillCreateBO(), reqBO);
            fscOrderPOList = fscPayBillCreateBusiRspBO.getFscOrderPOList();
            syncFscOrderIds.addAll(fscOrderPOList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList()));
        } else if (!ObjectUtil.isEmpty(reqBO.getFscOrderIds())) {
            FscOrderPO fscOrderPOQry = new FscOrderPO();
            fscOrderPOQry.setFscOrderIds(reqBO.getFscOrderIds());
            fscOrderPOQry.setSysTenantId(reqBO.getSysTenantId());
            fscOrderPOList = this.fscOrderMapper.getList(fscOrderPOQry);
            if (ObjectUtil.isEmpty(fscOrderPOList)) {
                throw new FscBusinessException("198888", "\u4ed8\u6b3e\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u540e\u518d\u8bd5");
            }
            Set orderStateS = fscOrderPOList.stream().map(FscOrderPO::getOrderState).collect(Collectors.toSet());
            syncFscOrderIds.addAll(reqBO.getFscOrderIds());
        }
        if (FscConstants.WRITE_OFF_APPROVAL_TYPE.BANK_AND_PAY_ORDER.equals(reqBO.getWriteOffType())) {
            BigDecimal bigDecimal;
            Object bankAmount;
            FscWriteOffItemPO writeOffItemPO = new FscWriteOffItemPO();
            writeOffItemPO.setBankCheckIds(reqBO.getBankCheckIds());
            List fscWriteOffItemPOList = this.fscWriteOffItemMapper.getList(writeOffItemPO);
            Set payeeIds = fscBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getPayeeName).collect(Collectors.toSet());
            Set bankPayerIds = fscBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getPayerId).collect(Collectors.toSet());
            Set bankPayerNames = fscBankCheckFileItemPOList.stream().map(bo -> bo.getPayerName().replace("(", "\uff08").replace(")", "\uff09")).collect(Collectors.toSet());
            Set supplierIds = fscOrderPOList.stream().map(FscOrderPO::getPayeeName).collect(Collectors.toSet());
            Set payerIds = fscOrderPOList.stream().map(FscOrderPO::getPayerId).collect(Collectors.toSet());
            Set set = fscOrderPOList.stream().map(bo -> bo.getPayerName().replace("(", "\uff08").replace(")", "\uff09")).collect(Collectors.toSet());
            if (payeeIds.size() != supplierIds.size()) {
                throw new FscBusinessException("198888", "\u6536\u6b3e\u5355\u4f4d\u5fc5\u987b\u76f8\u540c");
            }
            Collection disjunctionList = CollectionUtil.disjunction(payeeIds, supplierIds);
            if (!ObjectUtils.isEmpty((Object)disjunctionList) && disjunctionList.size() > 0) {
                throw new FscBusinessException("198888", "\u6536\u6b3e\u5355\u4f4d\u5fc5\u987b\u76f8\u540c");
            }
            ArrayList<Long> toPayerIds = new ArrayList<Long>();
            ArrayList<String> toPayerNames = new ArrayList<String>();
            for (FscOrderPO fscOrderPO : fscOrderPOList) {
                List<Long> tempToPayerIds = this.getPaymentBehalf(fscOrderPO.getPayerId(), fscOrderPO.getSecondOrgId(), toPayerNames);
                toPayerIds.addAll(tempToPayerIds);
            }
            toPayerIds.addAll(payerIds);
            toPayerNames.addAll(set);
            if (!toPayerIds.containsAll(bankPayerIds) && !toPayerNames.containsAll(bankPayerNames)) {
                throw new FscBusinessException("198888", "\u4ed8\u6b3e\u5355\u4f4d\u4e0e\u6240\u9009\u6d41\u6c34\u4e0d\u4e00\u81f4");
            }
            if (FscConstants.WRITE_OFF_ALL_TO_PAY.YES.equals(reqBO.getAllToPay()) && ((BigDecimal)(bankAmount = fscBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getTradeAmt).reduce(BigDecimal.ZERO, BigDecimal::add))).compareTo(bigDecimal = fscOrderPOList.stream().map(FscOrderPO::getTotalCharge).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                throw new FscBusinessException("198888", "\u4ed8\u6b3e\u5355\u7684\u603b\u4ed8\u6b3e\u91d1\u989d\u4e0e\u9009\u4e2d\u6838\u9500\u7684\u94f6\u884c\u6d41\u6c34\u603b\u91d1\u989d\u4e0d\u76f8\u7b49");
            }
            bankAmount = fscOrderPOList.stream().map(FscOrderPO::getOrderState).collect(Collectors.toSet());
        }
        ArrayList<FscBankCheckFileItemPO> payBankCheckFileItemList = new ArrayList<FscBankCheckFileItemPO>();
        if (FscConstants.WRITE_OFF_APPROVAL_TYPE.PAY_ORDER.equals(reqBO.getWriteOffType())) {
            FscBankCheckFileItemPO fscBankCheckFileItemPO = this.insertBankFileItem((FscOrderPO)fscOrderPOList.get(0));
            payBankCheckFileItemList.add(fscBankCheckFileItemPO);
        }
        ArrayList<FscOrderPO> fscPayOrderPOList = new ArrayList<FscOrderPO>();
        ArrayList<Long> bankCheckIdList = new ArrayList<Long>();
        if (FscConstants.WRITE_OFF_APPROVAL_TYPE.BANK.equals(reqBO.getWriteOffType())) {
            FscOrderPO fscPayOrderPO = this.insertFscOrder((FscBankCheckFileItemPO)fscBankCheckFileItemPOList.get(0), reqBO.getSysTenantId());
            fscPayOrderPOList.add(fscPayOrderPO);
            syncFscOrderIds.add(fscPayOrderPO.getFscOrderId());
        }
        ArrayList<FscWriteOffItemPO> fscWriteOffItemPOList = new ArrayList<FscWriteOffItemPO>();
        Map<Object, Object> fscPaidBankCheckFileItemPOListMap = new HashMap();
        if (FscConstants.WRITE_OFF_APPROVAL_TYPE.BANK_AND_PAY_ORDER.equals(reqBO.getWriteOffType()) || FscConstants.WRITE_OFF_APPROVAL_TYPE.PAY_ORDER.equals(reqBO.getWriteOffType())) {
            if (ObjectUtil.isNotEmpty((Object)fscPaidBankCheckFileItemPOList)) {
                fscPaidBankCheckFileItemPOListMap = fscPaidBankCheckFileItemPOList.stream().collect(Collectors.groupingBy(FscBankCheckFileItemPO::getFscOrderId));
            }
            ArrayList writeOffBankId = new ArrayList();
            for (FscOrderPO fscOrderPO : fscOrderPOList) {
                if (!reqBO.getIsShoulPayWrite().booleanValue()) {
                    FscOrderPO fscOrderPO2 = new FscOrderPO();
                    fscOrderPO2.setFscOrderId(fscOrderPO.getFscOrderId());
                    if (null != reqBO.getUserId()) {
                        fscOrderPO2.setPayOperId(reqBO.getUserId().toString());
                    }
                    fscOrderPO2.setPayOperName(reqBO.getName());
                    fscOrderPO2.setPayTime(new Date());
                    fscOrderPO2.setPayState(FscConstants.PayOrderPayStatus.PAIED);
                    fscOrderPO2.setOrderState(FscConstants.FscPayOrderState.PAIED);
                    fscOrderPO2.setActualAmount(fscOrderPO.getTotalCharge());
                    fscOrderPO2.setSysTenantId(reqBO.getSysTenantId());
                    int row = this.fscOrderMapper.updateById(fscOrderPO2);
                    if (row < 1) {
                        throw new FscBusinessException("198888", "\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
                    }
                }
                Boolean writeOffFkd = false;
                BigDecimal writeOffTradeAmt = BigDecimal.ZERO;
                if (ObjectUtil.isNotEmpty(fscPaidBankCheckFileItemPOListMap) && ObjectUtil.isNotEmpty((Object)fscPaidBankCheckFileItemPOListMap.get(fscOrderPO.getFscOrderId()))) {
                    writeOffTradeAmt = ((List)fscPaidBankCheckFileItemPOListMap.get(fscOrderPO.getFscOrderId())).stream().map(FscBankCheckFileItemPO::getTradeAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                List tempFscBankCheckFileItemPOList = FscConstants.WRITE_OFF_APPROVAL_TYPE.PAY_ORDER.equals(reqBO.getWriteOffType()) ? payBankCheckFileItemList : fscBankCheckFileItemPOList;
                for (FscBankCheckFileItemPO fscBankCheckFileItemPOFor : tempFscBankCheckFileItemPOList) {
                    if (writeOffBankId.contains(fscBankCheckFileItemPOFor.getBankCheckId()) || writeOffFkd.booleanValue() || ObjectUtil.isNotEmpty(fscWriteOffItemPOList) && fscWriteOffItemPOList.stream().anyMatch(bo -> fscBankCheckFileItemPOFor.getBankCheckId().equals(bo.getBankCheckId()) && fscOrderPOFor.getFscOrderId().equals(bo.getFscOrderId()))) continue;
                    if (fscOrderPO.getTotalCharge().subtract(writeOffTradeAmt).compareTo(fscBankCheckFileItemPOFor.getTradeAmt()) == 0) {
                        if (ObjectUtil.isNotEmpty(fscWriteOffItemPOList)) {
                            fscWriteOffItemPOList.removeAll(fscWriteOffItemPOList.stream().filter(bo -> bo.getBankCheckId().equals(fscBankCheckFileItemPOFor.getBankCheckId()) || bo.getFscOrderId().equals(fscOrderPOFor.getFscOrderId())).collect(Collectors.toList()));
                        }
                        writeOffBankId.add(fscBankCheckFileItemPOFor.getBankCheckId());
                        writeOffFkd = true;
                    }
                    FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
                    fscBankCheckFileItemPO.setWriteOffFlag("2".toString());
                    fscBankCheckFileItemPO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
                    fscBankCheckFileItemPO.setSysTenantId(reqBO.getSysTenantId());
                    int rows = this.fscBankCheckFileItemMapper.updateByBankCheckId(fscBankCheckFileItemPO);
                    if (rows < 1) {
                        throw new FscBusinessException("198888", "\u66f4\u65b0\u6838\u9500\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
                    }
                    FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
                    String memo = "";
                    FscBankCheckFileItemPO fscBankCheckFileItemEntityPO = new FscBankCheckFileItemPO();
                    if (FscConstants.WRITE_OFF_APPROVAL_TYPE.BANK_AND_PAY_ORDER.equals(reqBO.getWriteOffType())) {
                        if (FscConstants.WRITE_OFF_ALL_TO_PAY.YES.equals(reqBO.getAllToPay())) {
                            memo = ObjectUtil.isEmpty((Object)reqBO.getMemo()) ? "" : reqBO.getMemo();
                        } else {
                            memo = fscOrderPOList.size() == 1 && fscBankCheckFileItemPOList.size() == 1 ? "\u90e8\u5206\u4ef7\u6b3e\u4ed8\u81f3\u5b9e\u4f53\u6237\uff0c\u91d1\u989d\uff1a" + fscOrderPO.getTotalCharge().subtract(fscBankCheckFileItemPOFor.getTradeAmt()).setScale(2, RoundingMode.HALF_UP) + "\u5143" : "\u4ef7\u6b3e\u4ed8\u81f3\u5b9e\u4f53\u6237";
                            fscBankCheckFileItemEntityPO = this.insertBankFileItem((FscOrderPO)fscOrderPOList.get(0));
                        }
                    } else {
                        memo = FscConstants.WRITE_OFF_APPROVAL_TYPE.BANK.equals(reqBO.getWriteOffType()) ? (ObjectUtil.isEmpty((Object)reqBO.getMemo()) ? "" : reqBO.getMemo()) : (FscConstants.WRITE_OFF_APPROVAL_TYPE.PAY_ORDER.equals(reqBO.getWriteOffType()) && FscConstants.FscPayOrderState.PAIED.equals(fscOrderPO.getOrderState()) ? "\u90e8\u5206\u4ef7\u6b3e\u4ed8\u81f3\u5b9e\u4f53\u6237" : "\u4ef7\u6b3e\u4ed8\u81f3\u5b9e\u4f53\u6237\uff0c\u91d1\u989d\uff1a" + fscOrderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5143");
                    }
                    fscWriteOffItemPO.setMemo(memo);
                    fscWriteOffItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
                    fscWriteOffItemPO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
                    fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscWriteOffItemPO.setWriteOffType(Integer.valueOf(Integer.parseInt("2")));
                    fscWriteOffItemPO.setCreateTime(new Date());
                    fscWriteOffItemPO.setCreateOperUserId(reqBO.getUserId());
                    fscWriteOffItemPO.setCreateOperUserName(reqBO.getUserName());
                    fscWriteOffItemPO.setSysTenantId(reqBO.getSysTenantId());
                    fscWriteOffItemPO.setSysTenantName(reqBO.getSysTenantName());
                    fscWriteOffItemPOList.add(fscWriteOffItemPO);
                    if (null != fscBankCheckFileItemEntityPO.getBankCheckId()) {
                        FscWriteOffItemPO fscWriteOffItemEntityPO = new FscWriteOffItemPO();
                        BeanUtils.copyProperties((Object)fscWriteOffItemPO, (Object)fscWriteOffItemEntityPO);
                        fscWriteOffItemEntityPO.setBankCheckId(fscBankCheckFileItemEntityPO.getBankCheckId());
                        fscWriteOffItemEntityPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                        fscWriteOffItemPOList.add(fscWriteOffItemEntityPO);
                    }
                    bankCheckIdList.add(fscWriteOffItemPO.getBankCheckId());
                }
            }
        } else {
            for (Object fscBankCheckFileItemPOFor : fscBankCheckFileItemPOList) {
                FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
                fscBankCheckFileItemPO.setWriteOffFlag("2".toString());
                fscBankCheckFileItemPO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
                fscBankCheckFileItemPO.setSysTenantId(reqBO.getSysTenantId());
                int rows = this.fscBankCheckFileItemMapper.updateByBankCheckId(fscBankCheckFileItemPO);
                if (rows < 1) {
                    throw new FscBusinessException("198888", "\u66f4\u65b0\u6838\u9500\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
                }
                FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
                String memo = ObjectUtil.isEmpty((Object)reqBO.getMemo()) ? "" : reqBO.getMemo();
                fscWriteOffItemPO.setMemo("\u8fd0\u7ef4\u6838\u9500[" + memo + "]");
                fscWriteOffItemPO.setFscOrderId(((FscOrderPO)fscPayOrderPOList.get(0)).getFscOrderId());
                fscWriteOffItemPO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
                fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                fscWriteOffItemPO.setCreateTime(new Date());
                fscWriteOffItemPO.setCreateOperUserId(reqBO.getUserId());
                fscWriteOffItemPO.setCreateOperUserName(reqBO.getUserName());
                fscWriteOffItemPO.setSysTenantId(reqBO.getSysTenantId());
                fscWriteOffItemPO.setSysTenantName(reqBO.getSysTenantName());
                fscWriteOffItemPOList.add(fscWriteOffItemPO);
                bankCheckIdList.add(fscWriteOffItemPO.getBankCheckId());
            }
        }
        if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
            this.fscWriteOffItemMapper.insertBatch(fscWriteOffItemPOList);
        }
        if (!ObjectUtil.isEmpty(fscBankCheckFileItemPOList) && !FscConstants.WRITE_OFF_APPROVAL_TYPE.PAY_ORDER.equals(reqBO.getWriteOffType())) {
            ArrayList<FscBalancePO> fscBalancePOList = new ArrayList<FscBalancePO>();
            for (FscBankCheckFileItemPO fscBankCheckFileItemPO : fscBankCheckFileItemPOList) {
                UmcDycEnterpriseOrgQryDetailAbilityReqBO umcDycEnterpriseOrgQryDetailAbilityReqBO = new UmcDycEnterpriseOrgQryDetailAbilityReqBO();
                umcDycEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscBankCheckFileItemPO.getPayeeId());
                log.info("\u67e5\u8be2\u6536\u6b3e\u5355\u4f4d\u662f\u5426\u662f\u8fd0\u8425\u5165\u53c2:{}", (Object)umcDycEnterpriseOrgQryDetailAbilityReqBO);
                UmcDycEnterpriseOrgQryDetailAbilityRspBO rspBO = this.umcDycEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcDycEnterpriseOrgQryDetailAbilityReqBO);
                log.info("\u67e5\u8be2\u6536\u6b3e\u5355\u4f4d\u662f\u5426\u662f\u8fd0\u8425\u51fa\u53c2:{}", (Object)rspBO);
                if (!ObjectUtils.isEmpty((Object)rspBO.getEnterpriseOrgBO()) && rspBO.getEnterpriseOrgBO().getIsProfessionalOrg().equals("0")) continue;
                FscBalancePO fscBalancePO = new FscBalancePO();
                fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
                fscBalancePO.setBankCheckId(fscBankCheckFileItemPO.getBankCheckId());
                fscBalancePO.setOrgId(fscBankCheckFileItemPO.getPayeeId());
                fscBalancePO.setOrgCode("");
                fscBalancePO.setOrgName(fscBankCheckFileItemPO.getPayeeName());
                fscBalancePO.setSubAccountNo(fscBankCheckFileItemPO.getPayeeAccountNo());
                fscBalancePO.setPayerOrgId(ObjectUtil.isEmpty(fscOrderPOList) ? ((FscOrderPO)fscPayOrderPOList.get(0)).getPayerId() : ((FscOrderPO)fscOrderPOList.get(0)).getPayerId());
                fscBalancePO.setPayerOrgName(ObjectUtil.isEmpty(fscOrderPOList) ? ((FscOrderPO)fscPayOrderPOList.get(0)).getPayerName() : ((FscOrderPO)fscOrderPOList.get(0)).getPayerName());
                fscBalancePO.setPayerOrgCode(null);
                fscBalancePO.setPayerSubAccountNo(null);
                fscBalancePO.setFrozenEndTime(this.getConfiguration(ObjectUtil.isEmpty(fscOrderPOList) ? ((FscOrderPO)fscPayOrderPOList.get(0)).getPayeeId().toString() : ((FscOrderPO)fscOrderPOList.get(0)).getPayeeId().toString(), reqBO.getSysTenantId()));
                fscBalancePO.setPayAmount(fscBankCheckFileItemPO.getTradeAmt());
                fscBalancePO.setCreateTime(new Date());
                if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                    fscBalancePO.setFrozenAmount(new BigDecimal(0));
                    fscBalancePO.setUsableAmount(fscBankCheckFileItemPO.getTradeAmt());
                    fscBalancePO.setThawOperTime(new Date());
                } else {
                    fscBalancePO.setFrozenAmount(fscBankCheckFileItemPO.getTradeAmt());
                    fscBalancePO.setUsableAmount(new BigDecimal(0));
                }
                fscBalancePO.setUsedAmount(new BigDecimal(0));
                fscBalancePO.setCreateTime(new Date());
                fscBalancePO.setSysTenantId(fscBankCheckFileItemPO.getSysTenantId());
                fscBalancePOList.add(fscBalancePO);
            }
            if (!CollectionUtils.isEmpty(fscBalancePOList)) {
                FscCreateFscBalanceBusiReqBO fscBalanceBusiReqBO = new FscCreateFscBalanceBusiReqBO();
                fscBalanceBusiReqBO.setFscBalanceList(JSON.parseArray((String)JSON.toJSONString(fscBalancePOList), FscBalanceBO.class));
                ProxyMessage proxyMessage = new ProxyMessage(this.CREATE_FSC_BALANCE_TOPIC, this.CREATE_FSC_BALANCE_TAG, JSON.toJSONString((Object)fscBalanceBusiReqBO));
                this.createFscBalanceProducer.send(proxyMessage);
            }
        }
        fscWriteOffBankFileApprovalBusiRspBO.setFscOrderId(syncFscOrderIds);
        fscWriteOffBankFileApprovalBusiRspBO.setBankCheckIdList(bankCheckIdList);
        return fscWriteOffBankFileApprovalBusiRspBO;
    }

    private Date getConfiguration(String relId, Long sysTenantId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        fscCfcUniteParamQryListDetailExternalReqBO.setSysTenantId(sysTenantId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }

    private FscBankCheckFileItemPO insertBankFileItem(FscOrderPO fscOrder) {
        FscLegalCompanyPO fscLegalCompanyPO;
        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPO.setBankCheckId(Long.valueOf(Sequence.getInstance().nextId()));
        fscBankCheckFileItemPO.setPayeeOraCode(fscOrder.getPayeeId().toString());
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setOrgIdS(Arrays.asList(fscOrder.getPayerId(), fscOrder.getPayeeId()));
        fscAccountPO.setSysTenantId(fscOrder.getSysTenantId());
        List fscAccountPOList = this.fscAccountMapper.getList(fscAccountPO);
        if (!ObjectUtil.isEmpty((Object)fscAccountPOList)) {
            Map<Long, List<FscAccountPO>> fscAccountMapList = fscAccountPOList.stream().collect(Collectors.groupingBy(FscAccountPO::getOrgId));
            fscBankCheckFileItemPO.setPayerAccountName(ObjectUtil.isEmpty(fscAccountMapList.get(fscOrder.getPayerId())) ? "" : fscAccountMapList.get(fscOrder.getPayerId()).get(0).getAccountName());
            fscBankCheckFileItemPO.setPayerBankAccount(ObjectUtil.isEmpty(fscAccountMapList.get(fscOrder.getPayerId())) ? "" : fscAccountMapList.get(fscOrder.getPayerId()).get(0).getAccountNo());
            fscBankCheckFileItemPO.setPayerBankName(ObjectUtil.isEmpty(fscAccountMapList.get(fscOrder.getPayerId())) ? "" : fscAccountMapList.get(fscOrder.getPayerId()).get(0).getDepositBankName());
            fscBankCheckFileItemPO.setPayeeAccountNo(ObjectUtil.isEmpty(fscAccountMapList.get(fscOrder.getPayeeId())) ? "" : fscAccountMapList.get(fscOrder.getPayeeId()).get(0).getRecvSubLedgerAcctNo());
            fscBankCheckFileItemPO.setPayeeAccountName(ObjectUtil.isEmpty(fscAccountMapList.get(fscOrder.getPayeeId())) ? "" : fscAccountMapList.get(fscOrder.getPayeeId()).get(0).getAccountName());
            fscBankCheckFileItemPO.setPayeeBankName(ObjectUtil.isEmpty(fscAccountMapList.get(fscOrder.getPayeeId())) ? "" : fscAccountMapList.get(fscOrder.getPayeeId()).get(0).getRecvSubLedgerBankName());
        }
        fscBankCheckFileItemPO.setPayeeSubAccountNo(ObjectUtil.isEmpty((Object)(fscLegalCompanyPO = this.fscLegalCompanyMapper.getByOrgId(fscOrder.getPayeeId(), fscOrder.getSysTenantId()))) ? "" : fscLegalCompanyPO.getSubAccountNo());
        fscBankCheckFileItemPO.setTradeAmt(BigDecimal.ZERO);
        fscBankCheckFileItemPO.setPayerId(fscOrder.getPayerId());
        fscBankCheckFileItemPO.setPayerName(fscOrder.getPayerName());
        fscBankCheckFileItemPO.setPayeeId(fscOrder.getPayeeId());
        fscBankCheckFileItemPO.setPayeeName(fscOrder.getPayeeName());
        fscBankCheckFileItemPO.setWriteOffFlag("1");
        fscBankCheckFileItemPO.setStatus(Integer.valueOf(1));
        fscBankCheckFileItemPO.setShouldPayNo(fscOrder.getOrderNo());
        fscBankCheckFileItemPO.setMemo(fscOrder.getOrderNo());
        fscBankCheckFileItemPO.setSysTenantId(fscOrder.getSysTenantId());
        fscBankCheckFileItemPO.setSysTenantName(fscOrder.getSysTenantName());
        int result = this.fscBankCheckFileItemMapper.insert(fscBankCheckFileItemPO);
        if (result < 1) {
            throw new FscBusinessException("198888", "\u65b0\u589e\u94f6\u884c\u6d41\u6c34\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        return fscBankCheckFileItemPO;
    }

    private FscOrderPO insertFscOrder(FscBankCheckFileItemPO fscBankCheckFileItemPO, Long sysTenantId) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderPO.setOrderFlowKey("pay_flow_key");
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_ORDER_CODE");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setSysTenantId(sysTenantId);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscOrderPO.setPayerId(fscBankCheckFileItemPO.getPayerId());
        fscOrderPO.setPayerName(fscBankCheckFileItemPO.getPayerName());
        fscOrderPO.setPayeeId(fscBankCheckFileItemPO.getPayeeId());
        fscOrderPO.setPayeeName(fscBankCheckFileItemPO.getPayeeAccountName());
        fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAIED);
        fscOrderPO.setPayState(FscConstants.PayOrderPayStatus.PAIED);
        fscOrderPO.setPayeeBankAccount(fscBankCheckFileItemPO.getPayeeAccountNo());
        fscOrderPO.setPayType(Integer.valueOf(2));
        fscOrderPO.setShouldPayType(Integer.valueOf(1));
        fscOrderPO.setCreateOperId(Long.valueOf(1L));
        fscOrderPO.setSwapUserId(Long.valueOf(1L));
        fscOrderPO.setSwapOrgId(Long.valueOf(1L));
        fscOrderPO.setSwapOrgName("admin");
        fscOrderPO.setCreateOperName("admin");
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(Long.valueOf(1L));
        fscOrderPO.setCreateCompanyName("admin");
        fscOrderPO.setCreateOrgId(Long.valueOf(1L));
        fscOrderPO.setCreateOrgName("admin");
        fscOrderPO.setTotalCharge(BigDecimal.ZERO);
        fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.PAY_SUCCESS);
        fscOrderPO.setPurchaserId(fscBankCheckFileItemPO.getPayerId());
        fscOrderPO.setPurchaserName(fscBankCheckFileItemPO.getPayerName());
        fscOrderPO.setSysTenantId(fscBankCheckFileItemPO.getSysTenantId());
        fscOrderPO.setSysTenantName(fscBankCheckFileItemPO.getSysTenantName());
        log.info("\u4ed8\u6b3e\u5355\u4fdd\u5b58\u5165\u53c2\uff1a{}", (Object)fscOrderPO);
        int result = this.fscOrderMapper.insert(fscOrderPO);
        if (result < 1) {
            throw new FscBusinessException("198888", "\u65b0\u589e\u4ed8\u6b3e\u5355\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderPayItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrderPayItemPO.setShouldPayId(Long.valueOf(907973741663322112L));
        fscOrderPayItemPO.setSysTenantId(fscBankCheckFileItemPO.getSysTenantId());
        fscOrderPayItemPO.setSysTenantName(fscBankCheckFileItemPO.getSysTenantName());
        this.fscOrderPayItemMapper.insert(fscOrderPayItemPO);
        return fscOrderPO;
    }

    private FscPayBillCreateBusiRspBO insertPayOrder(FscPayBillCreateBusiBO busiReqBO, FscWriteOffBankFileApprovalBusiReqBO reqBO) {
        busiReqBO.setQueryAuditFlag(false);
        log.info("\u4ed8\u6b3e\u5355\u5408\u5e76\u524d\u53c2\u6570:{}", (Object)busiReqBO);
        List<FscPayBillCreateBusiBO> fscPayBillCreateAtomReqBOList = this.groupFscPayBillCreateAtomReqBO(busiReqBO);
        log.info("\u4ed8\u6b3e\u5355\u5408\u5e76\u540e\u53c2\u6570:{}", fscPayBillCreateAtomReqBOList);
        FscPayBillCreateBusiRspBO atomRspBO = new FscPayBillCreateBusiRspBO();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        ArrayList<FscOrderPO> fscOrderPOList = new ArrayList<FscOrderPO>();
        for (FscPayBillCreateBusiBO atom : fscPayBillCreateAtomReqBOList) {
            Long fscOrderId = Sequence.getInstance().nextId();
            List<FscOrderPayItemPO> fscOrderPayItemPOs = null;
            if (!CollectionUtils.isEmpty(atom.getFscOrderPayItemBOS())) {
                fscOrderPayItemPOs = this.updateShouldPay(atom, fscOrderId, atomRspBO, reqBO);
                if (atom.getPayFscOrderId() != null) {
                    atomRspBO.setFscOrderId(atom.getPayFscOrderId());
                    return atomRspBO;
                }
            } else {
                fscOrderPayItemPOs = this.insertShouldPay(atom, fscOrderId, reqBO);
            }
            this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
            FscOrderPO fscOrderPO = this.insertOrder(atom, fscOrderId, reqBO);
            atomRspBO.setFscOrderId(fscOrderId);
            fscOrderPOList.add(fscOrderPO);
            fscOrderIds.add(fscOrderId);
        }
        atomRspBO.setFscOrderIds(fscOrderIds);
        atomRspBO.setFscOrderPOList(fscOrderPOList);
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return atomRspBO;
    }

    private List<FscPayBillCreateBusiBO> groupFscPayBillCreateAtomReqBO(FscPayBillCreateBusiBO atomReqBO) {
        ArrayList<FscPayBillCreateBusiBO> fscPayBillCreateAtomReqBOList = new ArrayList<FscPayBillCreateBusiBO>();
        Map<String, List<FscOrderPayItemBO>> fscOrderPayItemMapList = atomReqBO.getFscOrderPayItemBOS().stream().collect(Collectors.groupingBy(FscOrderPayItemBO::getFscBusiType));
        String atomReqBOStr = JSON.toJSONString((Object)atomReqBO);
        fscOrderPayItemMapList.forEach((key, value) -> {
            FscPayBillCreateBusiBO copyAtomReqBO = (FscPayBillCreateBusiBO)JSONObject.parseObject((String)atomReqBOStr, FscPayBillCreateBusiBO.class);
            copyAtomReqBO.setFscOrderPayItemBOS((List<FscOrderPayItemBO>)value);
            fscPayBillCreateAtomReqBOList.add(copyAtomReqBO);
        });
        return fscPayBillCreateAtomReqBOList;
    }

    private List<FscOrderPayItemPO> updateShouldPay(FscPayBillCreateBusiBO busiReqBO, Long fscOrderId, FscPayBillCreateBusiRspBO atomRspBO, FscWriteOffBankFileApprovalBusiReqBO reqBO) {
        FscShouldPayPO fscShouldPayPO1 = new FscShouldPayPO();
        ArrayList shouldPayIds = new ArrayList();
        busiReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> shouldPayIds.add(fscOrderPayItemBO.getShouldPayId()));
        fscShouldPayPO1.setShouldPayIds(shouldPayIds);
        fscShouldPayPO1.setSysTenantId(reqBO.getSysTenantId());
        List poResult = this.fscShouldPayMapper.getList(fscShouldPayPO1);
        if (CollectionUtils.isEmpty((Collection)poResult)) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        HashSet shouldPayType = new HashSet();
        HashSet payerIds = new HashSet();
        HashSet payeeIds = new HashSet();
        HashSet contractNos = new HashSet();
        HashSet payType = new HashSet();
        poResult.forEach(fscShouldPayPO -> {
            if (null != fscShouldPayPO.getShouldPayType()) {
                shouldPayType.add(fscShouldPayPO.getShouldPayType());
                busiReqBO.setShouldPayType(fscShouldPayPO.getShouldPayType());
            }
            if (null != fscShouldPayPO.getPayerId()) {
                payerIds.add(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerId(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerName(fscShouldPayPO.getPayerName());
            }
            if (null != fscShouldPayPO.getPayeeId()) {
                payeeIds.add(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeId(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeName(fscShouldPayPO.getPayeeName());
            }
            if (null != fscShouldPayPO.getPayType()) {
                payType.add(fscShouldPayPO.getPayType());
                busiReqBO.setPayType(fscShouldPayPO.getPayType());
            }
            if (StringUtils.hasText((String)fscShouldPayPO.getContractNo())) {
                contractNos.add(fscShouldPayPO.getContractNo());
                busiReqBO.setContractNo(fscShouldPayPO.getContractNo());
            }
            if (fscShouldPayPO.getContractId() != null) {
                busiReqBO.setContractId(fscShouldPayPO.getContractId());
            }
        });
        if (shouldPayType.size() > 1) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payerIds.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payType.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5f0f\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (contractNos.size() > 1) {
            throw new FscBusinessException("194203", "\u5408\u540c\u7f16\u53f7\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (!(FscConstants.ShouldPayType.PAYMENT_DAY_PAY.equals(busiReqBO.getShouldPayType()) || StringUtils.isEmpty((Object)busiReqBO.getPayMethod()) || StringUtils.isEmpty((Object)busiReqBO.getPayMethod()))) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setShouldPayIds(shouldPayIds);
            List itemPOS = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)itemPOS) && itemPOS.size() == shouldPayIds.size()) {
                HashSet payFscOrderIds = new HashSet();
                itemPOS.forEach(fscOrderPayItemPO1 -> payFscOrderIds.add(fscOrderPayItemPO1.getFscOrderId()));
                if (payFscOrderIds.size() == 1) {
                    FscOrderPO fscOrderPO = new FscOrderPO();
                    fscOrderPO.setFscOrderId((Long)payFscOrderIds.iterator().next());
                    fscOrderPO.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
                    fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
                    FscOrderPO po = this.fscOrderMapper.getModelBy(fscOrderPO);
                    if (po != null) {
                        busiReqBO.setPayFscOrderId(po.getFscOrderId());
                        FscOrderPO set = new FscOrderPO();
                        FscOrderPO where = new FscOrderPO();
                        set.setPayChannel(busiReqBO.getPayChannel());
                        set.setPayMethod(busiReqBO.getPayMethod());
                        where.setFscOrderId(po.getFscOrderId());
                        where.setSysTenantId(reqBO.getSysTenantId());
                        this.fscOrderMapper.updateBy(set, where);
                        return null;
                    }
                    throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5df2\u5b58\u5728\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4e14\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001\uff01");
                }
                throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5b58\u5728\u591a\u4e2a\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u8bf7\u5230\u4ed8\u6b3e\u7533\u8bf7\u9875\u9762\u8fdb\u884c\u652f\u4ed8\uff01");
            }
        }
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        for (FscOrderPayItemBO fscOrderPayItemBO2 : busiReqBO.getFscOrderPayItemBOS()) {
            FscShouldPayPO fscShouldPayPO2 = new FscShouldPayPO();
            fscShouldPayPO2.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            fscShouldPayPO2.setPayAmount(fscOrderPayItemBO2.getPayAmount());
            fscShouldPayPO2.setSysTenantId(reqBO.getSysTenantId());
            int count = this.fscShouldPayMapper.updateAmount(fscShouldPayPO2);
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            po.setPayAmount(fscOrderPayItemBO2.getPayAmount());
            po.setSysTenantId(reqBO.getSysTenantId());
            po.setSysTenantName(reqBO.getSysTenantName());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO2.getPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        atomRspBO.setPayeeId((Long)payeeIds.iterator().next());
        atomRspBO.setPayerId((Long)payerIds.iterator().next());
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(poResult.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        fscOrderPo.setOrderBy("last_pay_date");
        fscOrderPo.setSysTenantId(reqBO.getSysTenantId());
        List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPo);
        if (!CollectionUtils.isEmpty((Collection)fscOrderPOList)) {
            busiReqBO.setLastPayDate(((FscOrderPO)fscOrderPOList.get(0)).getLastPayDate());
        }
        return fscOrderPayItemPOs;
    }

    private List<FscOrderPayItemPO> insertShouldPay(FscPayBillCreateBusiBO busiReqBO, Long fscOrderId, FscWriteOffBankFileApprovalBusiReqBO reqBO) {
        List fscShouldPayPOS = JSON.parseArray((String)JSON.toJSONString(busiReqBO.getFscShouldPayBOS()), FscShouldPayPO.class);
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        List serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()) == null) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(fscShouldPayPOS.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()).getDescr());
        encodedSerialGetServiceReqBO.setSysTenantId(reqBO.getSysTenantId());
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        for (int i = 0; i < fscShouldPayPOS.size(); ++i) {
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayPOS.get(i);
            Long shouldPayId = Sequence.getInstance().nextId();
            fscShouldPayPO.setShouldPayId(shouldPayId);
            fscShouldPayPO.setCreateId(busiReqBO.getUserId());
            fscShouldPayPO.setCreateName(busiReqBO.getName());
            fscShouldPayPO.setCreateAccount(busiReqBO.getUserName());
            fscShouldPayPO.setCreateTime(new Date());
            fscShouldPayPO.setCreateCompanyId(busiReqBO.getCompanyId());
            fscShouldPayPO.setCreateCompanyName(busiReqBO.getCompanyName());
            fscShouldPayPO.setCreateOrgId(busiReqBO.getOrgId());
            fscShouldPayPO.setCreateOrgName(busiReqBO.getOrgName());
            fscShouldPayPO.setPayingAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setPaidAmount(new BigDecimal(0));
            fscShouldPayPO.setToPayAmount(new BigDecimal(0));
            fscShouldPayPO.setShouldPayNo((String)serialNoList.get(i));
            fscShouldPayPO.setPenalty(new BigDecimal(0));
            fscShouldPayPO.setOriginalAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
            fscShouldPayPO.setSysTenantId(reqBO.getSysTenantId());
            fscShouldPayPO.setSysTenantName(reqBO.getSysTenantName());
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(shouldPayId);
            po.setPayAmount(fscShouldPayPO.getShouldPayAmount());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscShouldPayPO.getShouldPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        this.fscShouldPayMapper.insertBatch(fscShouldPayPOS);
        return fscOrderPayItemPOs;
    }

    private FscOrderPO insertOrder(FscPayBillCreateBusiBO busiReqBO, Long fscOrderId, FscWriteOffBankFileApprovalBusiReqBO reqBO) {
        FscMerchantPayeePO fscMerchantPayeePo = new FscMerchantPayeePO();
        fscMerchantPayeePo.setOrgId(busiReqBO.getPayeeId());
        if (this.enabledPingAnAccount.booleanValue()) {
            fscMerchantPayeePo.setAccountNoTypeList(Arrays.asList("2", "3"));
        } else {
            fscMerchantPayeePo.setAccountNoTypeList(Arrays.asList("1"));
        }
        FscMerchantPayeePO fscMerchantPayeePoQry = this.fscMerchantPayeeMapper.getModelByOrgId(fscMerchantPayeePo);
        if (null == fscMerchantPayeePoQry) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u5355\u4f4d[" + busiReqBO.getPayeeId() + "]\u7684\u6536\u6b3e\u8d26\u6237");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_ORDER_CODE");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setSysTenantId(reqBO.getSysTenantId());
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscOrderPO.setPayerId(busiReqBO.getPayerId());
        fscOrderPO.setPayerName(busiReqBO.getPayerName());
        fscOrderPO.setPayeeId(busiReqBO.getPayeeId());
        fscOrderPO.setPayeeName(fscMerchantPayeePoQry.getPayeeAccountName());
        fscOrderPO.setPayeeBankAccount(fscMerchantPayeePoQry.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName("\u5e73\u5b89\u94f6\u884c");
        fscOrderPO.setPayMethod(busiReqBO.getPayMethod());
        fscOrderPO.setPayType(busiReqBO.getPayType());
        fscOrderPO.setShouldPayType(busiReqBO.getShouldPayType());
        fscOrderPO.setPayChannel(busiReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setSwapUserId(busiReqBO.getUserId());
        fscOrderPO.setSwapOrgId(busiReqBO.getOrgId());
        fscOrderPO.setSwapOrgName(busiReqBO.getOrgName());
        fscOrderPO.setSwapOrgPath(busiReqBO.getPurOrgPath());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(busiReqBO.getTotalAmount());
        fscOrderPO.setContractNo(busiReqBO.getContractNo());
        fscOrderPO.setContractId(busiReqBO.getContractId());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        fscOrderPO.setPayOperName(busiReqBO.getName());
        fscOrderPO.setPayTime(new Date());
        fscOrderPO.setPayState(FscConstants.PayOrderPayStatus.PAIED);
        fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAIED);
        fscOrderPO.setActualAmount(busiReqBO.getTotalAmount());
        if ("3".equals(busiReqBO.getPayChannel())) {
            if (null != busiReqBO.getUserId()) {
                fscOrderPO.setPayOperId(busiReqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(busiReqBO.getName());
        }
        fscOrderPO.setLastPayDate(busiReqBO.getLastPayDate());
        if (null != busiReqBO.getFscOrderPayItemBOS()) {
            fscOrderPO.setFscBusiType(busiReqBO.getFscOrderPayItemBOS().get(0).getFscBusiType());
            fscOrderPO.setFscBusiTypeName(busiReqBO.getFscOrderPayItemBOS().get(0).getFscBusiTypeName());
        }
        fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.PAY_SUCCESS);
        if (!ObjectUtil.isEmpty((Object)busiReqBO.getSecondOrgId())) {
            fscOrderPO.setSecondOrgName(busiReqBO.getSecondOrgName());
            fscOrderPO.setSecondOrgId(busiReqBO.getSecondOrgId());
        }
        if (!ObjectUtil.isEmpty((Object)busiReqBO.getAppSubId())) {
            fscOrderPO.setAppSubId(busiReqBO.getAppSubId());
        }
        if (!ObjectUtil.isEmpty((Object)busiReqBO.getPurOrgPath())) {
            fscOrderPO.setPurOrgPath(busiReqBO.getPurOrgPath());
        }
        if (!ObjectUtil.isEmpty((Object)busiReqBO.getPurchaserId())) {
            fscOrderPO.setPurchaserId(busiReqBO.getPurchaserId());
            fscOrderPO.setPurchaserName(busiReqBO.getPurchaserName());
        }
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderPO.setSysTenantName(reqBO.getSysTenantName());
        log.info("\u4ed8\u6b3e\u5355\u4fdd\u5b58\u5165\u53c2\uff1a{}", (Object)fscOrderPO);
        this.fscOrderMapper.insert(fscOrderPO);
        return fscOrderPO;
    }

    private void invokeUacNoTask(FscPayBillCreateBusiBO busiReqBO, Long fscOrderId) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO), FscOrderStatusStartAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        if (busiReqBO.getQueryAuditFlag().booleanValue()) {
            UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
            uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
            uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
            uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
            uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
            uacNoTaskAuditCreateReqBO.setMenuId("fscPayApplyOrder");
            uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
            ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
            UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
            uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
            uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
            uacNoTaskAuditCreateInfoReqBO.setOrderId(fscOrderId);
            createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
            ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
            ApprovalObjBO approvalObjBO = new ApprovalObjBO();
            approvalObjBO.setObjId(fscOrderId.toString());
            approvalObjBO.setObjName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
            approvalObjBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
            approvalObjInfo.add(approvalObjBO);
            uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
            uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
            UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
            log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
            if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
                throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
            }
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
                paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
            }
            if (uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
                paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
            }
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserName());
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194203", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private List<Long> getPaymentBehalf(Long purId, Long subId, List<String> toPayerNames) {
        ArrayList<Long> toPayPayerIds = new ArrayList<Long>();
        CrcQryPaymentBehalfAbilityReqBO crcQryPaymentBehalfAbilityReqBO = new CrcQryPaymentBehalfAbilityReqBO();
        crcQryPaymentBehalfAbilityReqBO.setCorporationId(purId);
        crcQryPaymentBehalfAbilityReqBO.setOrgIdWeb(subId);
        log.info("\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfAbilityReqBO));
        CrcQryPaymentBehalfAbilityRspBO crcQryPaymentBehalfAbilityRspBO = this.crcQryPaymentBehalfAbilityService.qryPaymentBehalf(crcQryPaymentBehalfAbilityReqBO);
        log.info("\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfAbilityRspBO));
        if (!"0000".equals(crcQryPaymentBehalfAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("193203", "\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u9519\u8bef");
        }
        if (!ObjectUtil.isEmpty((Object)crcQryPaymentBehalfAbilityRspBO.getCfcPaymentBehalfBOS())) {
            List cfcPaymentBehalfBOS = crcQryPaymentBehalfAbilityRspBO.getCfcPaymentBehalfBOS().stream().filter(o -> o.getFreezeFlag().equals(FscConstants.CONFIG_STATUS_TO_PAY.NO)).collect(Collectors.toList());
            List paymentIds = cfcPaymentBehalfBOS.stream().map(CfcPaymentBehalfBO::getPaymentId).collect(Collectors.toList());
            toPayerNames.addAll(cfcPaymentBehalfBOS.stream().map(bo -> bo.getPaymentName().replace("(", "\uff08").replace(")", "\uff09")).collect(Collectors.toList()));
            toPayPayerIds.addAll(paymentIds);
        }
        return toPayPayerIds;
    }

    private void validateWriteOffPayOrder(FscWriteOffBankFileApprovalBusiReqBO reqBO) {
        if (FscConstants.WRITE_OFF_APPROVAL_TYPE.PAY_ORDER.equals(reqBO.getWriteOffType()) && !reqBO.getIsWriteOffEntityAccount().booleanValue() && FscConstants.WRITE_OFF_DATA_FLAG.PAY.equals(reqBO.getWriteOffDataFlag())) {
            FscOrderPO queryFscOrderPO = new FscOrderPO();
            queryFscOrderPO.setFscOrderIds(reqBO.getFscOrderIds());
            List fscOrderPOList = this.fscOrderMapper.getList(queryFscOrderPO);
            if (ObjectUtil.isEmpty((Object)fscOrderPOList)) {
                throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
            }
            long payCount = fscOrderPOList.stream().filter(po -> FscConstants.FscPayOrderState.PAIED.equals(po.getOrderState())).count();
            if (payCount > 0L) {
                throw new FscBusinessException("198888", "\u5df2\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u5355\u4e0d\u80fd\u6838\u9500");
            }
        }
    }

    private void validateWriteOffBankAndPayOrder(FscWriteOffBankFileApprovalBusiReqBO reqBO, List<FscBankCheckFileItemPO> fscPaidBankCheckFileItemPOList) {
        if (FscConstants.WRITE_OFF_APPROVAL_TYPE.BANK_AND_PAY_ORDER.equals(reqBO.getWriteOffType()) && ObjectUtil.isNotEmpty(reqBO.getFscOrderIds())) {
            FscOrderPO queryFscOrderPO = new FscOrderPO();
            queryFscOrderPO.setFscOrderIds(reqBO.getFscOrderIds());
            List fscOrderPOList = this.fscOrderMapper.getList(queryFscOrderPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderPOList)) {
                throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
            }
            Map<Integer, Long> orderStateCountMap = fscOrderPOList.stream().collect(Collectors.groupingBy(FscOrderPO::getOrderState, Collectors.counting()));
            if (FscConstants.WRITE_OFF_DATA_FLAG.PAY.equals(reqBO.getWriteOffDataFlag())) {
                if (orderStateCountMap.size() != 1 || orderStateCountMap.values().iterator().next() != (long)fscOrderPOList.size()) {
                    throw new FscBusinessException("198888", "\u5df2\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u5355\u4e0d\u80fd\u6838\u9500");
                }
                return;
            }
            if (FscConstants.WRITE_OFF_DATA_FLAG.NO_PAY_AND_PAY.equals(reqBO.getWriteOffDataFlag()) && ObjectUtil.isNotEmpty((Object)orderStateCountMap.get(FscConstants.FscPayOrderState.PAIED))) {
                List paidFscOrderIdList = fscOrderPOList.stream().filter(po -> FscConstants.FscPayOrderState.PAIED.equals(po.getOrderState())).map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
                BigDecimal paidTotalCharge = fscOrderPOList.stream().filter(po -> FscConstants.FscPayOrderState.PAIED.equals(po.getOrderState())).map(FscOrderPO::getTotalCharge).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal writeOffAmount = new BigDecimal("0");
                if (!CollectionUtils.isEmpty(fscPaidBankCheckFileItemPOList)) {
                    writeOffAmount = fscPaidBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getTradeAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                BigDecimal unWriteOffAmount = paidTotalCharge.subtract(writeOffAmount);
                FscBankCheckFileItemPO queryFscBankCheckFileItem = new FscBankCheckFileItemPO();
                queryFscBankCheckFileItem.setBankCheckIdS(reqBO.getBankCheckIds());
                queryFscBankCheckFileItem.setSysTenantId(reqBO.getSysTenantId());
                List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(queryFscBankCheckFileItem);
                BigDecimal tradeAmtSum = new BigDecimal("0");
                if (!CollectionUtils.isEmpty((Collection)fscBankCheckFileItemPOList)) {
                    tradeAmtSum = fscBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getTradeAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
            }
        }
    }
}

