/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscWriteOffEntityAccountSubmitBusiService;
import com.tydic.fsc.common.busi.bo.FscWriteOffEntityAccountSubmitBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscWriteOffEntityAccountSubmitBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffEntityAccountHistoryMapper;
import com.tydic.fsc.dao.FscWriteOffEntityAccountMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffEntityAccountHistoryPO;
import com.tydic.fsc.po.FscWriteOffEntityAccountPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscWriteOffEntityAccountSubmitBusiServiceImpl
implements FscWriteOffEntityAccountSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscWriteOffEntityAccountSubmitBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscWriteOffEntityAccountMapper fscWriteOffEntityAccountMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscWriteOffEntityAccountHistoryMapper fscWriteOffEntityAccountHistoryMapper;
    @Autowired
    private CfcEncodedSerialGetService cfcEncodedSerialGetService;
    private static final String SUPPLIER_VERIFICATION_APPLICATION_CODE = "SUPPLIER_VERIFICATION_APPLICATION_CODE";

    @Override
    public FscWriteOffEntityAccountSubmitBusiRspBO writeOffEntityAccountSubmit(FscWriteOffEntityAccountSubmitBusiReqBO reqBO) {
        FscWriteOffEntityAccountSubmitBusiRspBO rspBO = new FscWriteOffEntityAccountSubmitBusiRspBO();
        this.validateWriteOffEntityAccountSubmit(reqBO);
        this.validateWriteOffEntityAccountInfo(reqBO);
        this.updateFscOrderInfo(reqBO);
        List<FscWriteOffEntityAccountPO> fscWriteOffEntityAccountPOList = this.addFscWriteOffEntityAccountInfo(reqBO);
        this.addFscAttachmentInfo(reqBO, fscWriteOffEntityAccountPOList);
        this.addWriteOffEntityAccountHistoryInfo(fscWriteOffEntityAccountPOList, reqBO);
        rspBO.setApplyNo(fscWriteOffEntityAccountPOList.get(0).getApplyNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateWriteOffEntityAccountSubmit(FscWriteOffEntityAccountSubmitBusiReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBO))) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getFscOrderIds())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[\u7ed3\u7b97\u5355ID\u96c6\u5408]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getWriteOffRemark())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[\u6838\u9500\u8bf4\u660e]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getWriteOffFileUrl())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[\u6838\u9500\u51ed\u8bc1RUL]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getWriteOffFileName())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[\u6838\u9500\u51ed\u8bc1\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateFscOrderInfo(FscWriteOffEntityAccountSubmitBusiReqBO reqBO) {
        FscOrderPO queryFscOrder = new FscOrderPO();
        queryFscOrder.setFscOrderIds(reqBO.getFscOrderIds());
        List fscOrderList = this.fscOrderMapper.getList(queryFscOrder);
        if (CollectionUtils.isEmpty((Collection)fscOrderList)) {
            throw new FscBusinessException("190000", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        long unPayCount = fscOrderList.stream().filter(po -> FscConstants.FscPayOrderState.TO_PAY.equals(po.getOrderState())).count();
        if (unPayCount != (long)reqBO.getFscOrderIds().size()) {
            throw new FscBusinessException("198888", "\u975e\u672a\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u5355\u4e0d\u80fd\u6838\u9500");
        }
    }

    private void validateWriteOffEntityAccountInfo(FscWriteOffEntityAccountSubmitBusiReqBO reqBO) {
        FscWriteOffEntityAccountPO queryFscWriteOffEntityAccount = new FscWriteOffEntityAccountPO();
        queryFscWriteOffEntityAccount.setFscOrderIdList(reqBO.getFscOrderIds());
        queryFscWriteOffEntityAccount.setApplyStatus(FscConstants.WriteOffEntityAccountApplyStatus.APPLY);
        queryFscWriteOffEntityAccount.setSysTenantId(reqBO.getSysTenantId());
        int checkCount = this.fscWriteOffEntityAccountMapper.getCheckBy(queryFscWriteOffEntityAccount);
        if (checkCount > 0) {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u5355\u5df2\u5b58\u5728\u5b9e\u4f53\u6237\u6838\u9500\u7533\u8bf7");
        }
    }

    private void updateFscOrderInfo(FscWriteOffEntityAccountSubmitBusiReqBO reqBO) {
        FscOrderPO fscOrderSet = new FscOrderPO();
        fscOrderSet.setOrderState(FscConstants.FscPayOrderState.ENTITY_ACCOUNT_PAY_APPLY);
        FscOrderPO fscOrderWhere = new FscOrderPO();
        fscOrderWhere.setFscOrderIds(reqBO.getFscOrderIds());
        fscOrderWhere.setSysTenantId(reqBO.getSysTenantId());
        this.fscOrderMapper.updateBy(fscOrderSet, fscOrderWhere);
    }

    private List<FscWriteOffEntityAccountPO> addFscWriteOffEntityAccountInfo(FscWriteOffEntityAccountSubmitBusiReqBO reqBO) {
        FscWriteOffEntityAccountPO deleteFscWriteOffEntityAccount = new FscWriteOffEntityAccountPO();
        deleteFscWriteOffEntityAccount.setFscOrderIdList(reqBO.getFscOrderIds());
        deleteFscWriteOffEntityAccount.setSysTenantId(reqBO.getSysTenantId());
        this.fscWriteOffEntityAccountMapper.deleteBy(deleteFscWriteOffEntityAccount);
        String applyNo = this.getEncodedSerial(reqBO.getSysTenantId());
        ArrayList<FscWriteOffEntityAccountPO> fscWriteOffEntityAccountList = new ArrayList<FscWriteOffEntityAccountPO>(10);
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscWriteOffEntityAccountPO fscWriteOffEntityAccountPO = new FscWriteOffEntityAccountPO();
            fscWriteOffEntityAccountPO.setApplyId(Long.valueOf(Sequence.getInstance().nextId()));
            fscWriteOffEntityAccountPO.setApplyNo(applyNo);
            fscWriteOffEntityAccountPO.setFscOrderId(fscOrderId);
            fscWriteOffEntityAccountPO.setWriteOffRemark(reqBO.getWriteOffRemark());
            fscWriteOffEntityAccountPO.setApplyStatus(FscConstants.WriteOffEntityAccountApplyStatus.APPLY);
            fscWriteOffEntityAccountPO.setCreateUserId(reqBO.getUserId());
            fscWriteOffEntityAccountPO.setCreateUserName(reqBO.getName());
            fscWriteOffEntityAccountPO.setCreateTime(new Date());
            fscWriteOffEntityAccountPO.setSysTenantId(reqBO.getSysTenantId());
            fscWriteOffEntityAccountPO.setSysTenantName(reqBO.getSysTenantName());
            fscWriteOffEntityAccountList.add(fscWriteOffEntityAccountPO);
        }
        this.fscWriteOffEntityAccountMapper.insertBatch(fscWriteOffEntityAccountList);
        return fscWriteOffEntityAccountList;
    }

    private void addFscAttachmentInfo(FscWriteOffEntityAccountSubmitBusiReqBO reqBO, List<FscWriteOffEntityAccountPO> fscWriteOffEntityAccountPOList) {
        ArrayList<FscAttachmentPO> fscAttachmentPOList = new ArrayList<FscAttachmentPO>(10);
        for (FscWriteOffEntityAccountPO fscWriteOffEntityAccountPO : fscWriteOffEntityAccountPOList) {
            FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
            fscAttachmentPO.setFscOrderId(fscWriteOffEntityAccountPO.getFscOrderId());
            fscAttachmentPO.setObjId(fscWriteOffEntityAccountPO.getApplyId());
            fscAttachmentPO.setObjType(FscConstants.FscAttachmentObjType.ORDER);
            fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.WRITE_OFF_ENTITY_ACCOUNT_FILE);
            fscAttachmentPO.setAttachmentName(reqBO.getWriteOffFileName());
            fscAttachmentPO.setAttachmentUrl(reqBO.getWriteOffFileUrl());
            fscAttachmentPO.setAttachmentUrlSource("0");
            fscAttachmentPO.setSysTenantId(reqBO.getSysTenantId());
            fscAttachmentPO.setSysTenantName(reqBO.getSysTenantName());
            fscAttachmentPOList.add(fscAttachmentPO);
        }
        this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
    }

    private void addWriteOffEntityAccountHistoryInfo(List<FscWriteOffEntityAccountPO> fscWriteOffEntityAccountList, FscWriteOffEntityAccountSubmitBusiReqBO reqBO) {
        ArrayList<FscWriteOffEntityAccountHistoryPO> fscWriteOffEntityAccountHistoryList = new ArrayList<FscWriteOffEntityAccountHistoryPO>(10);
        for (FscWriteOffEntityAccountPO fscWriteOffEntityAccountPO : fscWriteOffEntityAccountList) {
            FscWriteOffEntityAccountHistoryPO fscWriteOffEntityAccountHistoryPO = new FscWriteOffEntityAccountHistoryPO();
            BeanUtils.copyProperties((Object)fscWriteOffEntityAccountPO, (Object)fscWriteOffEntityAccountHistoryPO);
            fscWriteOffEntityAccountHistoryPO.setHistoryId(Long.valueOf(Sequence.getInstance().nextId()));
            fscWriteOffEntityAccountHistoryPO.setObjId(fscWriteOffEntityAccountPO.getApplyId());
            fscWriteOffEntityAccountHistoryPO.setSysTenantId(reqBO.getSysTenantId());
            fscWriteOffEntityAccountHistoryPO.setSysTenantName(reqBO.getSysTenantName());
            fscWriteOffEntityAccountHistoryList.add(fscWriteOffEntityAccountHistoryPO);
        }
        this.fscWriteOffEntityAccountHistoryMapper.insertBatch(fscWriteOffEntityAccountHistoryList);
    }

    private String getEncodedSerial(Long sysTenantId) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(SUPPLIER_VERIFICATION_APPLICATION_CODE);
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setSysTenantId(sysTenantId);
        CfcEncodedSerialGetServiceRspBO cfcEncodedSerialGetServiceRspBO = this.cfcEncodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        return (String)cfcEncodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }
}

