/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.busi.api.FscComBankItemDetailQryBusiService;
import com.tydic.fsc.common.busi.api.FscEsSyncBankCheckItemBusiService;
import com.tydic.fsc.common.busi.bo.FscComBankItemListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComBankItemSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscEsSyncBankCheckItemRspBO;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.po.FscBalancePO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class FscEsSyncBankItemServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscEsSyncBankItemServiceConsumer.class);
    @Autowired
    private FscComBankItemDetailQryBusiService fscComBankItemDetailQryBusiService;
    @Autowired
    private FscEsSyncBankCheckItemBusiService fscEsSyncBankCheckItemBusiService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Value(value="${crc.sys.tenant.id:305775845729763327}")
    private Long crcSysTenantId;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        try {
            FscComBankItemSyncRspBO fscComBankItemSyncRspBO;
            log.debug("---------------ES\u540c\u6b65\u7d22\u5f15\u6d88\u8d39\u8005\u5f00\u59cb---------------");
            FscSyncReqBO fscSyncReqBO = (FscSyncReqBO)JSON.parseObject((String)proxyMessage.getContent(), (TypeReference)new TypeReference<FscSyncReqBO>(){}, (Feature[])new Feature[0]);
            log.debug("ES\u7ed3\u7b97\u5355\u4fe1\u606f\u7d22\u5f15\u540c\u6b65\u8f6c\u6362\u540e\u5f97\u5230\u7684\u6d88\u8d39\u8005\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)fscSyncReqBO));
            if (fscSyncReqBO.getBankCheckId() == null) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if (fscSyncReqBO.getBankCheckId() == 0L) {
                log.error("ES\u7ed3\u7b97\u5355\u4fe1\u606f\u7d22\u5f15\u540c\u6b65\u5931\u8d25\uff01fscOrderId\u4e3a\u96f6,\u53c2\u6570\u4e3a\uff1a{}", (Object)fscSyncReqBO.getFscOrderId());
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            try {
                FscComBankItemListQueryBusiReqBO fscComBankItemListQueryBusiReqBO = (FscComBankItemListQueryBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)fscSyncReqBO), FscComBankItemListQueryBusiReqBO.class);
                fscComBankItemSyncRspBO = this.fscComBankItemDetailQryBusiService.bankCheckItemDetailQry(fscComBankItemListQueryBusiReqBO);
                FscBalancePO selectBalancPO = new FscBalancePO();
                selectBalancPO.setOrgId(fscComBankItemSyncRspBO.getPayeeId());
                selectBalancPO.setBankCheckId(fscComBankItemSyncRspBO.getBankCheckId());
                selectBalancPO.setSysTenantId(this.crcSysTenantId);
                List fscBalancePOS = this.fscBalanceMapper.getByOrgIdAndBankCheckId(selectBalancPO);
                if (!ObjectUtil.isEmpty((Object)fscBalancePOS)) {
                    fscComBankItemSyncRspBO.setUsableAmount(((FscBalancePO)fscBalancePOS.get(0)).getUsableAmount().setScale(2, RoundingMode.HALF_UP));
                    fscComBankItemSyncRspBO.setUsedAmount(((FscBalancePO)fscBalancePOS.get(0)).getUsedAmount().setScale(2, RoundingMode.HALF_UP));
                    fscComBankItemSyncRspBO.setBalanceCreateDate(((FscBalancePO)fscBalancePOS.get(0)).getCreateTime());
                } else {
                    fscComBankItemSyncRspBO.setUsableAmount(fscComBankItemSyncRspBO.getTradeAmt());
                    fscComBankItemSyncRspBO.setUsedAmount(BigDecimal.ZERO);
                }
                if (fscComBankItemSyncRspBO.getUsableAmount().compareTo(BigDecimal.ZERO) != 0) {
                    fscComBankItemSyncRspBO.setWithdrawableStatus("1");
                } else {
                    fscComBankItemSyncRspBO.setWithdrawableStatus("0");
                }
            }
            catch (Exception e) {
                log.error("ES\u540c\u6b65\u67e5\u8be2\u5931\u8d25\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscSyncReqBO));
                this.writeFailLog(fscSyncReqBO.getBankCheckId(), null, fscSyncReqBO);
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if ("0000".equals(fscComBankItemSyncRspBO.getRespCode())) {
                FscEsSyncBankCheckItemRspBO fscEsSyncBankCheckItemRspBO = this.fscEsSyncBankCheckItemBusiService.esSyncBankCheckItem(fscComBankItemSyncRspBO);
                if (!"0000".equals(fscEsSyncBankCheckItemRspBO.getRespCode())) {
                    log.error("ES\u540c\u6b65\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)fscEsSyncBankCheckItemRspBO.getRespDesc());
                    this.writeFailLog(fscSyncReqBO.getBankCheckId(), fscEsSyncBankCheckItemRspBO, fscSyncReqBO);
                    return ProxyConsumerStatus.RECONSUME_LATER;
                }
                log.debug("---------------ES\u540c\u6b65\u7d22\u5f15\u6d88\u8d39\u8005\u7ed3\u675f---------------");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private void writeFailLog(Long bankCheckId, FscRspBaseBO rspBO, FscSyncReqBO reqBO) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(bankCheckId);
        if (null != rspBO) {
            fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(rspBO.getRespDesc());
        }
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        fscOrderFailLogUpdateBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderFailLogUpdateBusiReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

