/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscAuditOrderCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscGeneralBusiRuleExecAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralBusiRuleExecAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralBusiRuleExecAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPayServiceBillCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillCreateBusiRspBO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayServiceBillCreateBusiServiceImpl
implements FscPayServiceBillCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayServiceBillCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    private static final String BUSI_NAME = "\u670d\u52a1\u8d39\u4e3b\u5355\u521b\u5efa";
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscGeneralBusiRuleExecAtomService fscGeneralBusiRuleExecAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Value(value="${no.need.audit.key :noNeedAudit}")
    private String noNeedAudit;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Autowired
    private FscAuditOrderCreateAtomService fscAuditOrderCreateAtomService;

    @Override
    public FscPayServiceBillCreateBusiRspBO dealPayServiceOrdCreate(FscPayServiceBillCreateBusiReqBO reqBO) {
        Long fscOrderId = Sequence.getInstance().nextId();
        this.insertOrder(reqBO, fscOrderId);
        if (!FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            this.insertOrderInvoice(reqBO, fscOrderId);
            if (!reqBO.getTaskFlag().booleanValue() || FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
                this.insertOrderRelation(reqBO, fscOrderId);
            }
        }
        this.invokeUacNoTaskAndStatusStart(reqBO, fscOrderId);
        FscPayServiceBillCreateBusiRspBO fscPayServiceBillCreateBusiRspBO = new FscPayServiceBillCreateBusiRspBO();
        fscPayServiceBillCreateBusiRspBO.setFscOrderId(fscOrderId);
        return fscPayServiceBillCreateBusiRspBO;
    }

    private void insertOrder(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderPO.class);
        fscOrderPO.setFscOrderId(fscOrderId);
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PL_SERVICE_FEE);
        }
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.MONTH_SERVICE_FEE);
        }
        if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE);
        }
        if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE);
        }
        fscOrderPO.setPayerId(busiReqBO.getSupplierId());
        fscOrderPO.setPayeeId(busiReqBO.getProOrgId());
        fscOrderPO.setPayeeBankAccount(busiReqBO.getAccount());
        fscOrderPO.setShouldPayType(FscConstants.ShouldPayType.DEAL_PAY);
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscOrderPO.setCreateOperName(busiReqBO.getLinkMan());
        } else {
            fscOrderPO.setCreateOperId(busiReqBO.getUserId());
            fscOrderPO.setCreateOperName(busiReqBO.getName());
        }
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(busiReqBO.getTotalCharge());
        fscOrderPO.setServiceFeeCycle(busiReqBO.getServiceFeeCycle());
        fscOrderPO.setServiceFeeRate(busiReqBO.getServiceFeeRate());
        if (FscConstants.AllowCreditEnable.NO.equals(busiReqBO.getAllowCreditEnable())) {
            busiReqBO.setCreditAmount(null);
        }
        fscOrderPO.setCreditAmount(busiReqBO.getCreditAmount());
        if (busiReqBO.getCreditAmount() != null) {
            fscOrderPO.setActualAmount(busiReqBO.getTotalCharge().subtract(busiReqBO.getCreditAmount()));
            CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
            encodedSerialGetServiceReqBO.setCenter("FSC");
            encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
            encodedSerialGetServiceReqBO.setOrgType("-1");
            if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
                encodedSerialGetServiceReqBO.setEncodedRuleCode("MONTH_DEAL_SERVICE_FEE_CREDIT_ORDER_NO");
            }
            if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(busiReqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
                encodedSerialGetServiceReqBO.setEncodedRuleCode("YEAR_DEAL_SERVICE_FEE_CREDIT_ORDER_NO");
            }
            if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
                encodedSerialGetServiceReqBO.setEncodedRuleCode("PLATFORM_SERVICE_FEE_CREDIT_ORDER_NO");
            }
            CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
            fscOrderPO.setCreditNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
            fscOrderPO.setDiscountOperId(busiReqBO.getUserName());
            fscOrderPO.setDiscountOperName(busiReqBO.getName());
            fscOrderPO.setDiscountOperTime(new Date());
        } else {
            fscOrderPO.setActualAmount(busiReqBO.getTotalCharge());
        }
        fscOrderPO.setOrderNum(Integer.valueOf(busiReqBO.getRelOrderBOList().size()));
        int insert = this.fscOrderMapper.insert(fscOrderPO);
        if (insert != 1) {
            throw new FscBusinessException("193207", "\u670d\u52a1\u8d39\u4e3b\u5355\u521b\u5efa----\u751f\u6210\u4ed8\u6b3e\u4e3b\u5355\u5931\u8d25");
        }
    }

    private void insertOrderInvoice(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        FscOrderInvoicePO fscOrderInvoicePO = (FscOrderInvoicePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderInvoicePO.class);
        fscOrderInvoicePO.setFscOrderId(fscOrderId);
        if (null != busiReqBO.getUserId()) {
            fscOrderInvoicePO.setBillOperId(busiReqBO.getUserId().toString());
        }
        fscOrderInvoicePO.setAccountSetId(busiReqBO.getAccountSetId());
        fscOrderInvoicePO.setAccountSetName(busiReqBO.getAccountSetName());
        fscOrderInvoicePO.setBillOperName(busiReqBO.getUserName());
        fscOrderInvoicePO.setBillTime(new Date());
        int insert = this.fscOrderInvoiceMapper.insert(fscOrderInvoicePO);
        if (insert != 1) {
            throw new FscBusinessException("193207", "\u670d\u52a1\u8d39\u4e3b\u5355\u521b\u5efa----\u751f\u6210\u53d1\u7968\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void insertOrderRelation(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        List fscOrderRelationPOS = JSON.parseArray((String)JSON.toJSONString(busiReqBO.getRelOrderBOList()), FscOrderRelationPO.class);
        for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPOS) {
            Long id = Sequence.getInstance().nextId();
            fscOrderRelationPO.setId(id);
            fscOrderRelationPO.setFscOrderId(fscOrderId);
            fscOrderRelationPO.setOrderNo(busiReqBO.getOrderNo());
        }
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOS)) {
            this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        }
    }

    private void invokeUacNoTaskAndStatusStart(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>(4);
        String createEvaProcessKey = "";
        if (FscConstants.AllowCreditEnable.NO.equals(busiReqBO.getAllowCreditEnable())) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag0);
        } else if ("0".equals(busiReqBO.getIsProfessionalOrgExt())) {
            if (busiReqBO.getCreditAmount() != null && BigDecimal.ZERO.compareTo(busiReqBO.getCreditAmount()) == -1) {
                FscGeneralBusiRuleExecAtomReqBO fscGeneralBusiRuleExecAtomReqBO = new FscGeneralBusiRuleExecAtomReqBO();
                fscGeneralBusiRuleExecAtomReqBO.setServiceCode("FSC001");
                fscGeneralBusiRuleExecAtomReqBO.setParamJsonStr(JSON.toJSONString((Object)((Object)busiReqBO)));
                FscGeneralBusiRuleExecAtomRspBO fscGeneralBusiRuleExecAtomRspBO = this.fscGeneralBusiRuleExecAtomService.dealGeneralBusiRuleExec(fscGeneralBusiRuleExecAtomReqBO);
                if (!StringUtils.hasText((String)fscGeneralBusiRuleExecAtomRspBO.getBusiRuleExecResult())) {
                    throw new FscBusinessException("193208", "\u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u51cf\u514d\u5ba1\u6279\u6d41\u89c4\u5219");
                }
                JSONObject callRuleRspJsonObj = JSON.parseObject((String)fscGeneralBusiRuleExecAtomRspBO.getBusiRuleExecResult());
                createEvaProcessKey = callRuleRspJsonObj.getString("processKey");
                if (this.noNeedAudit.equals(createEvaProcessKey)) {
                    if (busiReqBO.getTotalCharge().compareTo(null == busiReqBO.getCreditAmount() ? BigDecimal.ZERO : busiReqBO.getCreditAmount()) == 0) {
                        paramMap.put("orderFinish", FscConstants.ProcessParam.orderFinish);
                    } else {
                        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag0);
                    }
                } else {
                    paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
                }
            } else {
                paramMap.put("auditFlag", FscConstants.ServiceFeeProcessFlag.UNDO);
            }
        } else {
            paramMap.put("processFlag", FscConstants.ServiceFeeProcessFlag.UNDO);
        }
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.MONTH_SERVICE_FEE);
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        if (!FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getOrderFlow()) && !busiReqBO.getTaskFlag().booleanValue()) {
            fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserId().toString());
        }
        paramMap.put("auditStartflag", 1);
        paramMap.put("auditCompleteflag", 1);
        paramMap.put("auditObjId", fscOrderId);
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193207", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        if (paramMap.get("auditFlag") != null && FscConstants.ProcessParam.auditFlag.equals(paramMap.get("auditFlag"))) {
            FscAuditOrderCreateAtomReqBO fscAuditOrderCreateAtomReqBO = new FscAuditOrderCreateAtomReqBO();
            fscAuditOrderCreateAtomReqBO.setOrderId(fscOrderId);
            fscAuditOrderCreateAtomReqBO.setObjId(fscOrderId);
            fscAuditOrderCreateAtomReqBO.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
            if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
            }
            if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
            }
            if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
            }
            if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
            }
            fscAuditOrderCreateAtomReqBO.setUserId(busiReqBO.getUserId());
            fscAuditOrderCreateAtomReqBO.setUserName(busiReqBO.getName());
            FscAuditOrderCreateAtomRspBO atomRspBO = this.fscAuditOrderCreateAtomService.dealAuditOrderCreate(fscAuditOrderCreateAtomReqBO);
            EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = (EacStartProjectAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), EacStartProjectAbilityReqBO.class);
            eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
            eacStartProjectAbilityReqBO.setProcDefKey(createEvaProcessKey);
            eacStartProjectAbilityReqBO.setPartitionKey(fscOrderId.toString());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("auditId", atomRspBO.getAuditOrderId());
            variables.put("todoOrderNo", busiReqBO.getOrderNo());
            eacStartProjectAbilityReqBO.setVariables(variables);
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(fscOrderId.toString());
            eacStartProjectAbilityReqBO.setBusinessIdList(strings);
            log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
            EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
            log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
            if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
            }
        }
    }
}

