/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscPaySuccessCallBackOrderBO;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscPayConfirmBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayConfirmBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayConfirmBusiRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfirmBusiServiceImpl
implements FscPayConfirmBusiService {
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @Override
    public FscPayConfirmBusiRspBO dealPayConfirm(FscPayConfirmBusiReqBO busiReqBO) {
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>();
        ArrayList<FscPaySuccessCallBackOrderBO> fscPaySuccessCallBackOrderBOList = new ArrayList<FscPaySuccessCallBackOrderBO>();
        FscOrderPO set = new FscOrderPO();
        set.setPayConfirmId(busiReqBO.getUserName());
        set.setPayConfirmName(busiReqBO.getName());
        set.setPayConfirmTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(busiReqBO.getFscOrderIds());
        this.fscOrderMapper.updateBy(set, where);
        Map<String, Object> paramMap = this.invokeFscOrderStatusFlow(busiReqBO);
        if (busiReqBO.getPayFlag().booleanValue()) {
            FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
            fscDealPaySuccessAtomReqBO.setPayFscOrderId(busiReqBO.getFscOrderIds());
            fscDealPaySuccessAtomReqBO.setParamMap(paramMap);
            FscDealPaySuccessAtomRspBO atomRspBO = this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty(atomRspBO.getResultFscOrderIds())) {
                resultFscOrderIds.addAll(atomRspBO.getResultFscOrderIds());
            }
            if (!CollectionUtils.isEmpty(atomRspBO.getFscPaySuccessCallBackOrderBOList())) {
                fscPaySuccessCallBackOrderBOList.addAll(atomRspBO.getFscPaySuccessCallBackOrderBOList());
            }
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getFscAttachmentBOS())) {
            this.insertFscAttachment(busiReqBO);
        }
        resultFscOrderIds.addAll(busiReqBO.getFscOrderIds());
        FscPayConfirmBusiRspBO busiRspBO = new FscPayConfirmBusiRspBO();
        busiRspBO.setResultFscOrderIds(resultFscOrderIds);
        busiRspBO.setFscPaySuccessCallBackOrderBOList(fscPaySuccessCallBackOrderBOList);
        return busiRspBO;
    }

    private Map<String, Object> invokeFscOrderStatusFlow(FscPayConfirmBusiReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(fscOrderId);
            FscOrderPO fscOrderPOS = this.fscOrderMapper.getModelBy(fscOrderPO);
            if (busiReqBO.getPayFlag().booleanValue()) {
                if (fscOrderPOS != null && FscConstants.FscPayOrderState.TO_PAY.equals(fscOrderPOS.getOrderState())) {
                    paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
                } else {
                    paramMap.put("payFlag", FscConstants.ProcessParam.payFlag1);
                }
            } else {
                paramMap.put("payFlag", FscConstants.ProcessParam.payFlag0);
            }
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.PAIED_TO_COMFIR);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
        });
        return paramMap;
    }

    private void insertFscAttachment(FscPayConfirmBusiReqBO busiReqBO) {
        ArrayList<Long> fscOrderIds = this.fscOrderMapper.getPayOrderRelationFscOrder(busiReqBO.getFscOrderIds());
        if (CollectionUtils.isEmpty((Collection)fscOrderIds)) {
            fscOrderIds = new ArrayList<Long>();
        }
        fscOrderIds.addAll(busiReqBO.getFscOrderIds());
        ArrayList fscAttachmentPOS = new ArrayList();
        fscOrderIds.forEach(fscOrderId -> busiReqBO.getFscAttachmentBOS().forEach(fscAttachmentBO -> {
            FscAttachmentPO po = new FscAttachmentPO();
            po.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setAttachmentName(fscAttachmentBO.getAttachmentName());
            po.setAttachmentType(fscAttachmentBO.getAttachmentType());
            po.setAttachmentUrl(fscAttachmentBO.getAttachmentUrl());
            po.setObjType(FscConstants.FscAttachmentObjType.ORDER);
            po.setObjId(fscOrderId);
            po.setFscOrderId(fscOrderId);
            fscAttachmentPOS.add(po);
        }));
        this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
    }
}

