/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.busi.api.FscOrderStatusFlowBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderStatusFlowBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscOrderStatusFlowBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayBillCreateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiRspBO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillCreateAbilityService"})
public class FscPayBillCreateAbilityServiceImpl
implements FscPayBillCreateAbilityService {
    @Autowired
    private FscPayBillCreateBusiService fscPayBillCreateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderStatusFlowBusiService fscOrderStatusFlowBusiService;

    @BigDecimalConvert
    @PostMapping(value={"dealPayBillCreate"})
    public FscPayBillCreateAbilityRspBO dealPayBillCreate(@RequestBody FscPayBillCreateAbilityReqBO abilityReqBO) {
        this.validParam(abilityReqBO);
        FscPayBillCreateBusiReqBO fscPayBillCreateBusiReqBO = (FscPayBillCreateBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscPayBillCreateBusiReqBO.class));
        FscPayBillCreateBusiRspBO busiRspBO = this.fscPayBillCreateBusiService.dealPayBillCreate(fscPayBillCreateBusiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS())) {
                FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
                fscShouldPayPo.setShouldPayIds(abilityReqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getShouldPayId).collect(Collectors.toList()));
                fscShouldPayPo.setShouldPayType(FscConstants.ShouldPayType.DEAL_PAY);
                List fscShouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPo);
                if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
                    FscOrderStatusFlowBusiReqBO fscOrderStatusFlowBusiReqBO = (FscOrderStatusFlowBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)abilityReqBO), FscOrderStatusFlowBusiReqBO.class);
                    fscOrderStatusFlowBusiReqBO.setOrderIds(fscShouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
                    fscOrderStatusFlowBusiReqBO.setCurStatus(FscConstants.FscServiceOrderState.TO_PAY);
                    FscOrderStatusFlowBusiRspBO busiRspBO1 = this.fscOrderStatusFlowBusiService.dealStatusFlow(fscOrderStatusFlowBusiReqBO);
                    fscShouldPayPOList.forEach(fscShouldPayId -> {
                        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO1 = new FscComOrderListSyncAbilityReqBO();
                        fscComOrderListSyncAbilityReqBO1.setFscOrderId(fscShouldPayId.getObjectId());
                        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO1);
                    });
                }
            }
        }
        FscPayBillCreateAbilityRspBO abilityRspBO = new FscPayBillCreateAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        return abilityRspBO;
    }

    private void validParam(FscPayBillCreateAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS()) && CollectionUtils.isEmpty((Collection)abilityReqBO.getFscShouldPayBOS())) {
            throw new FscBusinessException("191000", "\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u548c\u5e94\u4ed8\u8bb0\u5f55\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS())) {
            abilityReqBO.setFscShouldPayBOS(null);
            abilityReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
                if (fscOrderPayItemBO.getPayAmount() == null) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u4e3a\u7a7a");
                }
                if (fscOrderPayItemBO.getShouldPayId() == null) {
                    throw new FscBusinessException("191000", "\u5e94\u4ed8ID\u4e3a\u7a7a");
                }
                if (BigDecimal.ZERO.compareTo(fscOrderPayItemBO.getPayAmount()) >= 0) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8eO!");
                }
            });
            return;
        }
        abilityReqBO.getFscShouldPayBOS().forEach(fscShouldPayBO -> {
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getObjectNo())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7f16\u7801\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getShouldPayAmount())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5e94\u4ed8\u91d1\u989d\u4e3a\u7a7a\uff01");
            }
            if (null == fscShouldPayBO.getObjectId()) {
                throw new FscBusinessException("191000", "\u5355\u636eID\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getObjectType())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\uff01");
            }
            fscShouldPayBO.setPayeeId(abilityReqBO.getPayeeId());
            fscShouldPayBO.setPayeeName(abilityReqBO.getPayeeName());
            fscShouldPayBO.setPayerId(abilityReqBO.getPayerId());
            fscShouldPayBO.setPayerName(abilityReqBO.getPayerName());
            fscShouldPayBO.setContractNo(abilityReqBO.getContractNo());
            fscShouldPayBO.setPayType(abilityReqBO.getPayType());
            fscShouldPayBO.setShouldPayType(abilityReqBO.getShouldPayType());
        });
    }
}

