/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayQueryPayDateByOrderAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayDateByOrderAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscPayQueryPayDateByOrderAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayQueryPayDateByOrderAbilityRspBO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayQueryPayDateByOrderAbilityService"})
public class FscPayQueryPayDateByOrderAbilityServiceImpl
implements FscPayQueryPayDateByOrderAbilityService {
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @PostMapping(value={"qryPayDateLast"})
    public FscPayQueryPayDateByOrderAbilityRspBO qryPayDateLast(@RequestBody FscPayQueryPayDateByOrderAbilityReqBO reqBO) {
        ArrayList<FscPayDateByOrderAbilityRspBO> fscPayDateByOrderAbilityRsps = new ArrayList<FscPayDateByOrderAbilityRspBO>(10);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setOrderIds(reqBO.getOrderIds());
            List fscOrderRelationPos = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
            ArrayList<Long> notSelectedOrderId = new ArrayList<Long>(10);
            if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPos)) {
                this.getSelectedPayDate(reqBO, fscPayDateByOrderAbilityRsps, fscOrderRelationPos, notSelectedOrderId);
            } else {
                notSelectedOrderId.addAll(reqBO.getOrderIds());
            }
            if (!CollectionUtils.isEmpty(notSelectedOrderId)) {
                this.getNotSelectedPayDate(fscPayDateByOrderAbilityRsps, notSelectedOrderId);
            }
        } else {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscPayQueryPayDateByOrderAbilityRspBO rspBO = new FscPayQueryPayDateByOrderAbilityRspBO();
        rspBO.setFscPayDateByOrderAbilityRspBOS(fscPayDateByOrderAbilityRsps);
        return rspBO;
    }

    private void getNotSelectedPayDate(List<FscPayDateByOrderAbilityRspBO> fscPayDateByOrderAbilityRsps, List<Long> notSelectedOrderId) {
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setOrderIds(notSelectedOrderId);
        List fscShouldPayPos = this.fscShouldPayMapper.getList(fscShouldPayPo);
        for (Long orderId : notSelectedOrderId) {
            List shouldPayPOS = fscShouldPayPos.stream().filter(fscShouldPayPO -> orderId.equals(fscShouldPayPO.getOrderId())).collect(Collectors.toList());
            List fscShouldPayPoList = shouldPayPOS.stream().filter(fscShouldPay -> ObjectUtil.isNotNull((Object)fscShouldPay.getShouldPayDate())).sorted(Comparator.comparing(FscShouldPayPO::getShouldPayDate)).collect(Collectors.toList());
            FscPayDateByOrderAbilityRspBO fscPayDateByOrderAbilityRspBO = new FscPayDateByOrderAbilityRspBO();
            if (!CollectionUtils.isEmpty(fscShouldPayPoList)) {
                FscShouldPayPO fscShouldPayPO2 = (FscShouldPayPO)fscShouldPayPoList.get(0);
                fscPayDateByOrderAbilityRspBO.setPayDate(fscShouldPayPO2.getShouldPayDate());
            } else {
                fscPayDateByOrderAbilityRspBO.setPayDate(null);
            }
            fscPayDateByOrderAbilityRspBO.setOrderId(orderId);
            fscPayDateByOrderAbilityRsps.add(fscPayDateByOrderAbilityRspBO);
        }
    }

    private void getSelectedPayDate(FscPayQueryPayDateByOrderAbilityReqBO reqBO, List<FscPayDateByOrderAbilityRspBO> fscPayDateByOrderAbilityRsps, List<FscOrderRelationPO> fscOrderRelationPos, List<Long> notSelectedOrderId) {
        List selectedOrderId = fscOrderRelationPos.stream().map(FscOrderRelationPO::getOrderId).distinct().collect(Collectors.toList());
        notSelectedOrderId.addAll(reqBO.getOrderIds().stream().filter(orderId -> !selectedOrderId.contains(orderId)).collect(Collectors.toList()));
        List selectedFscOrderIdList = fscOrderRelationPos.stream().map(FscOrderRelationPO::getFscOrderId).collect(Collectors.toList());
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setObjectIds(selectedFscOrderIdList);
        List fscShouldPayPos = this.fscShouldPayMapper.getList(fscShouldPayPo);
        for (Long orderId2 : selectedOrderId) {
            List fscOrderIds = fscOrderRelationPos.stream().filter(fscOrderRelation -> orderId2.equals(fscOrderRelation.getOrderId())).map(FscOrderRelationPO::getFscOrderId).collect(Collectors.toList());
            List shouldPayPOS = fscShouldPayPos.stream().filter(fscShouldPayPO -> fscOrderIds.contains(fscShouldPayPO.getObjectId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(shouldPayPOS)) {
                List fscShouldPayPoList = shouldPayPOS.stream().filter(fscShouldPay -> ObjectUtil.isNotNull((Object)fscShouldPay.getShouldPayDate())).sorted(Comparator.comparing(FscShouldPayPO::getShouldPayDate)).collect(Collectors.toList());
                FscPayDateByOrderAbilityRspBO fscPayDateByOrderAbilityRspBO = new FscPayDateByOrderAbilityRspBO();
                if (!CollectionUtils.isEmpty(fscShouldPayPoList)) {
                    FscShouldPayPO fscShouldPay2 = (FscShouldPayPO)fscShouldPayPoList.get(0);
                    fscPayDateByOrderAbilityRspBO.setPayDate(fscShouldPay2.getShouldPayDate());
                } else {
                    fscPayDateByOrderAbilityRspBO.setPayDate(null);
                }
                fscPayDateByOrderAbilityRspBO.setOrderId(orderId2);
                fscPayDateByOrderAbilityRsps.add(fscPayDateByOrderAbilityRspBO);
                continue;
            }
            notSelectedOrderId.add(orderId2);
        }
    }
}

