/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.org.apache.commons.codec.binary.Base64;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.fsc.busibase.busi.api.FscBillOrderCreatePdfBusiService;
import com.tydic.fsc.busibase.busi.bo.FscBillReCreateFscOrderPdfReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.pay.atom.api.FscSendPaymentOrderAtomService;
import com.tydic.fsc.pay.atom.bo.FscSendPaymentOrderAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendPaymentOrderAtomRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcQryOrgAccountCodeByOrgIdAbilityService;
import com.tydic.umc.general.ability.api.UmcZhMemDetailQueryAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcZhMemDetailQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcZhMemDetailQueryAbilityRspBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscSendPaymentOrderAtomServiceImpl
implements FscSendPaymentOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSendPaymentOrderAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UmcZhMemDetailQueryAbilityService umcZhMemDetailQueryAbilityService;
    @Autowired
    private UmcQryOrgAccountCodeByOrgIdAbilityService umcQryOrgAccountCodeByOrgIdAbilityService;
    @Value(value="${ESB_SEND_PAYMENT_ORDER_URL}")
    private String ESB_SEND_PAYMENT_ORDER_URL;
    @Value(value="${FINANCIAL_SHARED_SEND_PAYER_ID}")
    private String financialSharedSendPayerIdS;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private FscBillOrderCreatePdfBusiService fscBillOrderCreatePdfBusiService;

    @Override
    public FscSendPaymentOrderAtomRspBO dealPaySuccess(FscSendPaymentOrderAtomReqBO atomReqBO) {
        FscSendPaymentOrderAtomRspBO rspBO = new FscSendPaymentOrderAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderPO temp = new FscOrderPO();
        temp.setOrderFlow(Integer.valueOf(1));
        temp.setFscOrderId(atomReqBO.getFscOrderId());
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(temp);
        if (fscOrderPO == null) {
            throw new BaseBusinessException("8888", "\u6ca1\u6709id\u4e3a\uff1a" + atomReqBO.getFscOrderId() + "\u7684\u4ed8\u6b3e\u5355");
        }
        Boolean payerIdFlag = Arrays.asList(this.financialSharedSendPayerIdS.split(",")).contains(fscOrderPO.getPayerId().toString());
        if (null == fscOrderPO.getPayerId() || !payerIdFlag.booleanValue()) {
            return rspBO;
        }
        String reqStr = this.initPostStr(atomReqBO, fscOrderPO);
        log.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_SEND_PAYMENT_ORDER_URL);
        log.info("\u8bf7\u6c42\u53c2\u6570:{}", (Object)reqStr);
        String returnString = SSLClient.doPost((String)this.ESB_SEND_PAYMENT_ORDER_URL, (String)reqStr);
        log.info("\u8c03\u7528ESB\u63a5\u53e3\u4ed8\u6b3e\u5355\u63a8\u9001\u81f3\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587:{}", (Object)returnString);
        if (ObjectUtil.isEmpty((Object)returnString)) {
            throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u4ed8\u6b3e\u5355\u63a8\u9001\u81f3\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        this.resolveRsp(returnString, atomReqBO);
        return rspBO;
    }

    private String initPostStr(FscSendPaymentOrderAtomReqBO atomReqBO, FscOrderPO fscOrderPO) {
        UmcZhMemDetailQueryAbilityReqBO umcZhMemDetailQueryAbilityReqBO = new UmcZhMemDetailQueryAbilityReqBO();
        umcZhMemDetailQueryAbilityReqBO.setMemId(fscOrderPO.getCreateOperId());
        log.info("\u67e5\u8be2\u4f1a\u5458Ldap\u8d26\u53f7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcZhMemDetailQueryAbilityReqBO));
        UmcZhMemDetailQueryAbilityRspBO umcZhMemDetailQueryAbilityRspBO = this.umcZhMemDetailQueryAbilityService.memDetailQuery(umcZhMemDetailQueryAbilityReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458Ldap\u8d26\u53f7\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcZhMemDetailQueryAbilityRspBO));
        String creatorLdap = umcZhMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO().getRegAccount();
        List jsdList = this.fscOrderMapper.getJSDbyFKDid(fscOrderPO.getFscOrderId());
        JSONObject reqJson = new JSONObject();
        reqJson.put("sysCode", (Object)"EGSC");
        reqJson.put("appyId", (Object)fscOrderPO.getFscOrderId().toString());
        reqJson.put("payNo", (Object)fscOrderPO.getOrderNo());
        reqJson.put("paytypeCode", (Object)fscOrderPO.getFscBusiType());
        reqJson.put("paytypeName", (Object)fscOrderPO.getFscBusiTypeName());
        reqJson.put("creatorLdap", (Object)creatorLdap);
        reqJson.put("payAmount", (Object)fscOrderPO.getTotalCharge().setScale(2, 4));
        reqJson.put("currency", (Object)"CNY");
        UmcQryOrgAccountCodeByOrgIdAbilityReqBO umcQryOrgAccountCodeByOrgIdAbilityReqBO = new UmcQryOrgAccountCodeByOrgIdAbilityReqBO();
        umcQryOrgAccountCodeByOrgIdAbilityReqBO.setOrgId(fscOrderPO.getPayerId());
        log.info("\u67e5\u8be2\u4f1a\u5458\u4ed8\u6b3e\u5355\u4f4d\u7f16\u7801\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityReqBO));
        UmcQryOrgAccountCodeByOrgIdAbilityRspBO umcQryOrgAccountCodeByOrgIdAbilityRspBO = this.umcQryOrgAccountCodeByOrgIdAbilityService.qryOrgAccountCodeByOrgId(umcQryOrgAccountCodeByOrgIdAbilityReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458\u4ed8\u6b3e\u5355\u4f4d\u7f16\u7801\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityRspBO));
        reqJson.put("payerCode", (Object)umcQryOrgAccountCodeByOrgIdAbilityRspBO.getOrgAccountCode());
        reqJson.put("payerName", (Object)fscOrderPO.getPayerName());
        UmcQryOrgAccountCodeByOrgIdAbilityReqBO umcQryOrgAccountCodeByOrgIdAbilityReqBO2 = new UmcQryOrgAccountCodeByOrgIdAbilityReqBO();
        umcQryOrgAccountCodeByOrgIdAbilityReqBO2.setOrgId(fscOrderPO.getPayeeId());
        log.info("\u67e5\u8be2\u4f1a\u5458\u6536\u6b3e\u5355\u4f4d\u7f16\u7801\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityReqBO2));
        UmcQryOrgAccountCodeByOrgIdAbilityRspBO umcQryOrgAccountCodeByOrgIdAbilityRspBO2 = this.umcQryOrgAccountCodeByOrgIdAbilityService.qryOrgAccountCodeByOrgId(umcQryOrgAccountCodeByOrgIdAbilityReqBO2);
        log.info("\u67e5\u8be2\u4f1a\u5458\u6536\u6b3e\u5355\u4f4d\u7f16\u7801\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityRspBO2));
        reqJson.put("payeeCode", (Object)umcQryOrgAccountCodeByOrgIdAbilityRspBO2.getOrgAccountCode());
        reqJson.put("payeeName", (Object)fscOrderPO.getPayeeName());
        reqJson.put("payeeBankAccount", (Object)fscOrderPO.getPayeeBankAccount());
        reqJson.put("remark", (Object)fscOrderPO.getOrderNo());
        JSONArray payDetail = new JSONArray();
        for (FscOrderPO each : jsdList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("fscOrderNo", (Object)each.getOrderNo());
            jsonObject.put("shouldPayAmount", (Object)each.getTotalCharge().setScale(2, 4));
            jsonObject.put("payCreateTime", (Object)DateUtil.dateToStrLong((Date)each.getCreateTime()));
            jsonObject.put("lastPayDate", (Object)DateUtil.dateToStrLong((Date)each.getLastPayDate()));
            Map<String, String> pdfInfo = this.getPdfBase64(each.getFscOrderId());
            jsonObject.put("annex", (Object)(ObjectUtil.isEmpty((Object)pdfInfo.get("pdfBase64")) ? "" : pdfInfo.get("pdfBase64")));
            jsonObject.put("fileName", (Object)(ObjectUtil.isEmpty((Object)pdfInfo.get("fileName")) ? "" : pdfInfo.get("fileName")));
            payDetail.add((Object)jsonObject);
        }
        log.info("\u63a8\u9001\u51fa\u53c2:{}", (Object)payDetail);
        reqJson.put("payDetail", (Object)payDetail);
        return reqJson.toString();
    }

    private void resolveRsp(String returnString, FscSendPaymentOrderAtomReqBO atomReqBO) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(atomReqBO.getFscOrderId());
        fscOrderPO.setSyncTime(new Date(System.currentTimeMillis()));
        if (null == rspJsonObject.getJSONObject("RESPONSE") || null == rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA")) {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setSyncFailReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            return;
        }
        if (rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"status").equals("SUCC")) {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.APPLYING);
            fscOrderPO.setSyncFailReason("");
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
        } else {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setSyncFailReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
        }
    }

    private Map<String, String> getPdfBase64(Long fscOrderId) {
        log.info("pdf\u67e5\u8be2\u5165\u53c2\u7ed3\u7b97id:{}", (Object)fscOrderId);
        HashMap<String, String> pdfInfo = new HashMap<String, String>(2);
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderId(fscOrderId);
        FscAttachmentPO fscAttachmentPOS = this.fscAttachmentMapper.getModelBy(fscAttachmentPo);
        if (ObjectUtil.isEmpty((Object)fscAttachmentPOS)) {
            log.info("\u7ed3\u7b97\u5355id:{}", (Object)fscOrderId);
            try {
                FscBillReCreateFscOrderPdfReqBO fscBillReCreateFscOrderPdfReqBO = new FscBillReCreateFscOrderPdfReqBO();
                fscBillReCreateFscOrderPdfReqBO.setFscOrderId(fscOrderId);
                fscBillReCreateFscOrderPdfReqBO.setIsShowMark(Boolean.valueOf(false));
                List fscAttachmentPOList = this.fscBillOrderCreatePdfBusiService.recreateFscOrderPdf(fscBillReCreateFscOrderPdfReqBO);
                if (!ObjectUtil.isEmpty((Object)fscAttachmentPOList)) {
                    fscAttachmentPOS = (FscAttachmentPO)fscAttachmentPOList.get(0);
                }
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u7ed3\u7b97pdf\u751f\u6210\u5931\u8d25");
            }
        }
        log.info("\u7ed3\u7b97pdf\u9644\u4ef6\u67e5\u8be2\u53c2\u6570:{}", (Object)fscAttachmentPOS);
        String pdfBase64 = "";
        try {
            String[] pad = fscAttachmentPOS.getAttachmentUrl().split("group1");
            String filePath = "group1" + pad[1].replaceFirst("/", ",");
            File pdfFile = this.fileClient.downloadToFile(filePath);
            FileInputStream inputFile = new FileInputStream(pdfFile);
            byte[] buffer = new byte[(int)pdfFile.length()];
            inputFile.read(buffer);
            inputFile.close();
            pdfBase64 = Base64.encodeBase64String((byte[])buffer);
            pdfInfo.put("pdfBase64", pdfBase64);
            pdfInfo.put("fileName", fscAttachmentPOS.getAttachmentName());
        }
        catch (IOException e) {
            log.info("\u7ed3\u7b97\u5355id:{}", (Object)fscOrderId);
            throw new RuntimeException("pdf\u8f6cbase64\u51fa\u9519\uff1a" + e.getMessage());
        }
        return pdfInfo;
    }
}

