/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendPaymentOrderAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendPaymentOrderAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscSendPaymentOrderBusiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscFinancialSharedSendConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscFinancialSharedSendConsumer.class);
    @Autowired
    private FscSendPaymentOrderBusiService fscSendPaymentOrderBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        String content = proxyMessage.getContent();
        log.info("\u7ed3\u7b97\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u72b6\u6001\u6d88\u8d39\u8005\u5165\u53c2:{}" + content);
        try {
            FscSendPaymentOrderAtomReqBO reqBO = (FscSendPaymentOrderAtomReqBO)((Object)JSON.parseObject((String)content, FscSendPaymentOrderAtomReqBO.class));
            log.info("\u8f6c\u6362\u540e\u53c2\u6570\u5982\u4e0b:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
            if (reqBO != null) {
                FscSendPaymentOrderAtomRspBO rspBO = this.fscSendPaymentOrderBusiService.dealPaySuccess(reqBO);
                if (!"0000".equals(rspBO.getRespCode())) {
                    log.error("\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u72b6\u6001Busi\u670d\u52a1\u62a5\u9519\uff1a" + rspBO.getRespDesc());
                    return ProxyConsumerStatus.CONSUME_SUCCESS;
                }
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            log.error("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }
}

