/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillCreateAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillCreateAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillCreateAtomRspBO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillCreateAtomServiceImpl
implements FscPayBillCreateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCreateAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FscPayBillCreateAtomRspBO dealPayBillCreate(FscPayBillCreateAtomReqBO atomReqBO) {
        log.info("\u4ed8\u6b3e\u5355\u5408\u5e76\u524d\u53c2\u6570:{}", (Object)atomReqBO);
        List<FscPayBillCreateAtomReqBO> fscPayBillCreateAtomReqBOList = this.groupFscPayBillCreateAtomReqBO(atomReqBO);
        log.info("\u4ed8\u6b3e\u5355\u5408\u5e76\u540e\u53c2\u6570:{}", fscPayBillCreateAtomReqBOList);
        FscPayBillCreateAtomRspBO atomRspBO = new FscPayBillCreateAtomRspBO();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        for (FscPayBillCreateAtomReqBO atom : fscPayBillCreateAtomReqBOList) {
            Long fscOrderId = Sequence.getInstance().nextId();
            List<FscOrderPayItemPO> fscOrderPayItemPOs = null;
            if (!CollectionUtils.isEmpty(atom.getFscOrderPayItemBOS())) {
                fscOrderPayItemPOs = this.updateShouldPay(atom, fscOrderId, atomRspBO);
                if (atom.getPayFscOrderId() != null) {
                    atomRspBO.setFscOrderId(atom.getPayFscOrderId());
                    return atomRspBO;
                }
            } else {
                fscOrderPayItemPOs = this.insertShouldPay(atom, fscOrderId);
            }
            this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
            this.insertOrder(atom, fscOrderId);
            this.invokeUacNoTask(atom, fscOrderId);
            atomRspBO.setFscOrderId(fscOrderId);
            fscOrderIds.add(fscOrderId);
        }
        atomRspBO.setFscOrderIds(fscOrderIds);
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return atomRspBO;
    }

    private List<FscPayBillCreateAtomReqBO> groupFscPayBillCreateAtomReqBO(FscPayBillCreateAtomReqBO atomReqBO) {
        ArrayList<FscPayBillCreateAtomReqBO> fscPayBillCreateAtomReqBOList = new ArrayList<FscPayBillCreateAtomReqBO>();
        Map<String, List<FscOrderPayItemBO>> fscOrderPayItemMapList = atomReqBO.getFscOrderPayItemBOS().stream().collect(Collectors.groupingBy(FscOrderPayItemBO::getFscBusiType));
        String atomReqBOStr = JSON.toJSONString((Object)((Object)atomReqBO));
        fscOrderPayItemMapList.forEach((key, value) -> {
            FscPayBillCreateAtomReqBO copyAtomReqBO = (FscPayBillCreateAtomReqBO)((Object)((Object)JSONObject.parseObject((String)atomReqBOStr, FscPayBillCreateAtomReqBO.class)));
            copyAtomReqBO.setFscOrderPayItemBOS((List<FscOrderPayItemBO>)value);
            fscPayBillCreateAtomReqBOList.add(copyAtomReqBO);
        });
        return fscPayBillCreateAtomReqBOList;
    }

    private void invokeUacNoTask(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusStartAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        if (busiReqBO.getQueryAuditFlag().booleanValue()) {
            UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
            uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
            uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
            uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
            uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
            uacNoTaskAuditCreateReqBO.setMenuId("fscPayApplyOrder");
            uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
            ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
            UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
            uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
            uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
            uacNoTaskAuditCreateInfoReqBO.setOrderId(fscOrderId);
            createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
            ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
            ApprovalObjBO approvalObjBO = new ApprovalObjBO();
            approvalObjBO.setObjId(fscOrderId.toString());
            approvalObjBO.setObjName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
            approvalObjBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
            approvalObjInfo.add(approvalObjBO);
            uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
            uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
            UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
            log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
            if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
                throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
            }
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
                paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
            }
            if (uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
                paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
            }
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserName());
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194203", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private void insertOrder(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId) {
        FscMerchantPayeePO fscMerchantPayeePo = new FscMerchantPayeePO();
        fscMerchantPayeePo.setOrgId(busiReqBO.getPayeeId());
        FscMerchantPayeePO fscMerchantPayeePoQry = this.fscMerchantPayeeMapper.getModelByOrgId(fscMerchantPayeePo);
        if (null == fscMerchantPayeePoQry) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u5355\u4f4d[" + busiReqBO.getPayeeId() + "]\u7684\u6536\u6b3e\u8d26\u6237");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_ORDER_CODE");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscOrderPO.setPayerId(busiReqBO.getPayerId());
        fscOrderPO.setPayerName(busiReqBO.getPayerName());
        fscOrderPO.setPayeeId(busiReqBO.getPayeeId());
        fscOrderPO.setPayeeName(fscMerchantPayeePoQry.getPayeeAccountName());
        fscOrderPO.setPayeeBankAccount(fscMerchantPayeePoQry.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName("\u5e73\u5b89\u94f6\u884c");
        fscOrderPO.setPayMethod(busiReqBO.getPayMethod());
        fscOrderPO.setPayType(busiReqBO.getPayType());
        fscOrderPO.setShouldPayType(busiReqBO.getShouldPayType());
        fscOrderPO.setPayChannel(busiReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(busiReqBO.getTotalAmount());
        fscOrderPO.setContractNo(busiReqBO.getContractNo());
        fscOrderPO.setContractId(busiReqBO.getContractId());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        if ("3".equals(busiReqBO.getPayChannel())) {
            if (null != busiReqBO.getUserId()) {
                fscOrderPO.setPayOperId(busiReqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(busiReqBO.getName());
        }
        fscOrderPO.setLastPayDate(busiReqBO.getLastPayDate());
        if (null != busiReqBO.getFscOrderPayItemBOS()) {
            fscOrderPO.setFscBusiType(busiReqBO.getFscOrderPayItemBOS().get(0).getFscBusiType());
            fscOrderPO.setFscBusiTypeName(busiReqBO.getFscOrderPayItemBOS().get(0).getFscBusiTypeName());
        }
        fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.PAY_SUCCESS);
        fscOrderPO.setSecondOrgName(busiReqBO.getSecondOrgName());
        fscOrderPO.setSecondOrgId(busiReqBO.getSecondOrgId());
        log.info("\u4ed8\u6b3e\u5355\u4fdd\u5b58\u5165\u53c2\uff1a{}", (Object)fscOrderPO);
        this.fscOrderMapper.insert(fscOrderPO);
    }

    private List<FscOrderPayItemPO> updateShouldPay(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId, FscPayBillCreateAtomRspBO atomRspBO) {
        FscShouldPayPO fscShouldPayPO1 = new FscShouldPayPO();
        ArrayList shouldPayIds = new ArrayList();
        busiReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> shouldPayIds.add(fscOrderPayItemBO.getShouldPayId()));
        fscShouldPayPO1.setShouldPayIds(shouldPayIds);
        List poResult = this.fscShouldPayMapper.getList(fscShouldPayPO1);
        if (CollectionUtils.isEmpty((Collection)poResult)) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        HashSet shouldPayType = new HashSet();
        HashSet payerIds = new HashSet();
        HashSet payeeIds = new HashSet();
        HashSet contractNos = new HashSet();
        HashSet payType = new HashSet();
        poResult.forEach(fscShouldPayPO -> {
            if (null != fscShouldPayPO.getShouldPayType()) {
                shouldPayType.add(fscShouldPayPO.getShouldPayType());
                busiReqBO.setShouldPayType(fscShouldPayPO.getShouldPayType());
            }
            if (null != fscShouldPayPO.getPayerId()) {
                payerIds.add(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerId(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerName(fscShouldPayPO.getPayerName());
            }
            if (null != fscShouldPayPO.getPayeeId()) {
                payeeIds.add(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeId(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeName(fscShouldPayPO.getPayeeName());
            }
            if (null != fscShouldPayPO.getPayType()) {
                payType.add(fscShouldPayPO.getPayType());
                busiReqBO.setPayType(fscShouldPayPO.getPayType());
            }
            if (StringUtils.hasText((String)fscShouldPayPO.getContractNo())) {
                contractNos.add(fscShouldPayPO.getContractNo());
                busiReqBO.setContractNo(fscShouldPayPO.getContractNo());
            }
            if (fscShouldPayPO.getContractId() != null) {
                busiReqBO.setContractId(fscShouldPayPO.getContractId());
            }
        });
        if (shouldPayType.size() > 1) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payerIds.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payType.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5f0f\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (contractNos.size() > 1) {
            throw new FscBusinessException("194203", "\u5408\u540c\u7f16\u53f7\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (!(FscConstants.ShouldPayType.PAYMENT_DAY_PAY.equals(busiReqBO.getShouldPayType()) || StringUtils.isEmpty((Object)busiReqBO.getPayMethod()) || StringUtils.isEmpty((Object)busiReqBO.getPayMethod()))) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setShouldPayIds(shouldPayIds);
            List itemPOS = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)itemPOS) && itemPOS.size() == shouldPayIds.size()) {
                HashSet payFscOrderIds = new HashSet();
                itemPOS.forEach(fscOrderPayItemPO1 -> payFscOrderIds.add(fscOrderPayItemPO1.getFscOrderId()));
                if (payFscOrderIds.size() == 1) {
                    FscOrderPO fscOrderPO = new FscOrderPO();
                    fscOrderPO.setFscOrderId((Long)payFscOrderIds.iterator().next());
                    fscOrderPO.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
                    FscOrderPO po = this.fscOrderMapper.getModelBy(fscOrderPO);
                    if (po != null) {
                        busiReqBO.setPayFscOrderId(po.getFscOrderId());
                        FscOrderPO set = new FscOrderPO();
                        FscOrderPO where = new FscOrderPO();
                        set.setPayChannel(busiReqBO.getPayChannel());
                        set.setPayMethod(busiReqBO.getPayMethod());
                        where.setFscOrderId(po.getFscOrderId());
                        this.fscOrderMapper.updateBy(set, where);
                        return null;
                    }
                    throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5df2\u5b58\u5728\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4e14\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001\uff01");
                }
                throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5b58\u5728\u591a\u4e2a\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u8bf7\u5230\u4ed8\u6b3e\u7533\u8bf7\u9875\u9762\u8fdb\u884c\u652f\u4ed8\uff01");
            }
        }
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        for (FscOrderPayItemBO fscOrderPayItemBO2 : busiReqBO.getFscOrderPayItemBOS()) {
            FscShouldPayPO fscShouldPayPO2 = new FscShouldPayPO();
            fscShouldPayPO2.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            fscShouldPayPO2.setPayAmount(fscOrderPayItemBO2.getPayAmount());
            int count = this.fscShouldPayMapper.updateAmount(fscShouldPayPO2);
            if (count != 1) {
                throw new FscBusinessException("194203", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
            }
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            po.setPayAmount(fscOrderPayItemBO2.getPayAmount());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO2.getPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        atomRspBO.setPayeeId((Long)payeeIds.iterator().next());
        atomRspBO.setPayerId((Long)payerIds.iterator().next());
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(poResult.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        fscOrderPo.setOrderBy("last_pay_date");
        List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPo);
        if (!CollectionUtils.isEmpty((Collection)fscOrderPOList)) {
            busiReqBO.setLastPayDate(((FscOrderPO)fscOrderPOList.get(0)).getLastPayDate());
        }
        return fscOrderPayItemPOs;
    }

    private List<FscOrderPayItemPO> insertShouldPay(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId) {
        List fscShouldPayPOS = JSON.parseArray((String)JSON.toJSONString(busiReqBO.getFscShouldPayBOS()), FscShouldPayPO.class);
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        List serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()) == null) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(fscShouldPayPOS.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()).getDescr());
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        for (int i = 0; i < fscShouldPayPOS.size(); ++i) {
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayPOS.get(i);
            Long shouldPayId = Sequence.getInstance().nextId();
            fscShouldPayPO.setShouldPayId(shouldPayId);
            fscShouldPayPO.setCreateId(busiReqBO.getUserId());
            fscShouldPayPO.setCreateName(busiReqBO.getName());
            fscShouldPayPO.setCreateAccount(busiReqBO.getUserName());
            fscShouldPayPO.setCreateTime(new Date());
            fscShouldPayPO.setCreateCompanyId(busiReqBO.getCompanyId());
            fscShouldPayPO.setCreateCompanyName(busiReqBO.getCompanyName());
            fscShouldPayPO.setCreateOrgId(busiReqBO.getOrgId());
            fscShouldPayPO.setCreateOrgName(busiReqBO.getOrgName());
            fscShouldPayPO.setPayingAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setPaidAmount(new BigDecimal(0));
            fscShouldPayPO.setToPayAmount(new BigDecimal(0));
            fscShouldPayPO.setShouldPayNo((String)serialNoList.get(i));
            fscShouldPayPO.setPenalty(new BigDecimal(0));
            fscShouldPayPO.setOriginalAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(shouldPayId);
            po.setPayAmount(fscShouldPayPO.getShouldPayAmount());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscShouldPayPO.getShouldPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        this.fscShouldPayMapper.insertBatch(fscShouldPayPOS);
        return fscOrderPayItemPOs;
    }
}

