/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.cfc.ability.api.CfcQryAutoPaymentRuleAbilityService;
import com.tydic.cfc.ability.bo.CfcQryAutoPaymentRuleAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryAutoPaymentRuleAbilityRspBO;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceSignInAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceSignBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceSignInAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceSignInAbilityRspBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscBillAutoCreatePayOrderAbilityService;
import com.tydic.fsc.pay.ability.api.FscSendEleInvoiceToXhSrmAbilityService;
import com.tydic.fsc.pay.ability.api.FscSendPayBillOrderToXhSrmAbilityService;
import com.tydic.fsc.pay.ability.bo.FscBillAutoCreatePayOrderAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscBillAutoCreatePayOrderAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscSendEleInvoiceToXhSrmAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscSendEleInvoiceToXhSrmAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscSendPayBillOrderToXhSrmAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscSendPayBillOrderToXhSrmAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiRspBO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscBillAutoCreatePayOrderAbilityService"})
public class FscBillAutoCreatePayOrderAbilityServiceImpl
implements FscBillAutoCreatePayOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillAutoCreatePayOrderAbilityServiceImpl.class);
    @Value(value="${secondOrgId.xh}")
    private Long SECONDORGID_XH;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBillInvoiceSignInAbilityService fscBillInvoiceSignInAbilityService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscPayBillCreateBusiService fscPayBillCreateBusiService;
    @Autowired
    private CfcQryAutoPaymentRuleAbilityService cfcQryAutoPaymentRuleAbilityService;
    @Autowired
    private FscSendPayBillOrderToXhSrmAbilityService fscSendPayBillOrderToXhSrmAbilityService;
    @Autowired
    private FscSendEleInvoiceToXhSrmAbilityService fscSendEleInvoiceToXhSrmAbilityService;

    @PostMapping(value={"createPayOrder"})
    public FscBillAutoCreatePayOrderAbilityRspBO createPayOrder(@RequestBody FscBillAutoCreatePayOrderAbilityReqBO reqBO) {
        List<Integer> modeList = Arrays.asList(1, 2);
        FscOrderPO fscPayOrderPO = new FscOrderPO();
        fscPayOrderPO.setSecondOrgId(this.SECONDORGID_XH);
        fscPayOrderPO.setOrderFlow(Integer.valueOf(1));
        List payOrderInfoList = this.fscOrderMapper.getList(fscPayOrderPO);
        List payOrderIds = payOrderInfoList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        List jsdList = null;
        if (!ObjectUtils.isEmpty(payOrderIds)) {
            jsdList = this.fscOrderMapper.getJSDbyFKDids(payOrderIds);
        }
        for (Integer type : modeList) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setSecondOrgId(this.SECONDORGID_XH);
            fscOrderPO.setOrderState(FscConstants.FscServiceOrderState.BILLED_INVOICE);
            if (type.equals(1)) {
                fscOrderPO.setMakeType(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE);
                fscOrderPO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
                fscOrderPO.setOrderSource(Integer.valueOf(Integer.parseInt("2")));
            } else if (type.equals(2)) {
                fscOrderPO.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
                fscOrderPO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
                fscOrderPO.setOrderSource(Integer.valueOf(Integer.parseInt("2")));
                fscOrderPO.setOrderState(FscConstants.FscServiceOrderState.BILLED_INVOICE);
            }
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
            List totalFscOrderList = this.fscOrderMapper.getFscOrderAndShouldPayId(fscOrderPO);
            Map<String, List<FscOrderPO>> totalFscOrderListMap = totalFscOrderList.stream().collect(Collectors.groupingBy(o -> o.getPurchaserId() + "-" + o.getSecondOrgId()));
            for (Map.Entry<String, List<FscOrderPO>> entry : totalFscOrderListMap.entrySet()) {
                String[] keyList = entry.getKey().toString().split("-");
                CfcQryAutoPaymentRuleAbilityReqBO cfcQryAutoPaymentRuleAbilityReqBO = new CfcQryAutoPaymentRuleAbilityReqBO();
                cfcQryAutoPaymentRuleAbilityReqBO.setCorporationId(Long.valueOf(Long.parseLong(keyList[0])));
                cfcQryAutoPaymentRuleAbilityReqBO.setOrgIdWeb(Long.valueOf(Long.parseLong(keyList[1])));
                log.info("\u81ea\u52a8\u751f\u6210\u7ed3\u7b97\u5355\u914d\u7f6e\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)cfcQryAutoPaymentRuleAbilityReqBO));
                CfcQryAutoPaymentRuleAbilityRspBO cfcQryAutoPaymentRuleAbilityRspBO = this.cfcQryAutoPaymentRuleAbilityService.qryAutoPaymentRule(cfcQryAutoPaymentRuleAbilityReqBO);
                log.info("\u81ea\u52a8\u751f\u6210\u7ed3\u7b97\u5355\u914d\u7f6e\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)cfcQryAutoPaymentRuleAbilityRspBO));
                if (!"0000".equals(cfcQryAutoPaymentRuleAbilityRspBO.getRespCode())) {
                    log.info("\u81ea\u52a8\u751f\u6210\u7ed3\u7b97\u5355\u914d\u7f6e\u67e5\u8be2\u9519\u8bef:{}", (Object)cfcQryAutoPaymentRuleAbilityRspBO.getRespDesc());
                    continue;
                }
                if ("0".equals(cfcQryAutoPaymentRuleAbilityRspBO.getStatus())) {
                    log.info("\u81ea\u52a8\u751f\u6210\u7ed3\u7b97\u5355\u914d\u7f6e\u672a\u542f\u7528");
                    continue;
                }
                List<FscOrderPO> createPayOrderList = entry.getValue();
                for (FscOrderPO item : createPayOrderList) {
                    Boolean result;
                    if (!ObjectUtils.isEmpty((Object)jsdList) && jsdList.contains(item.getFscOrderId()) || !(result = this.validBankAndOrder(item)).booleanValue()) continue;
                    FscPayBillCreateBusiReqBO fscPayBillCreateBusiReqBO = new FscPayBillCreateBusiReqBO();
                    FscOrderPayItemBO fscOrderPayItemBO = new FscOrderPayItemBO();
                    fscOrderPayItemBO.setFscBusiType(item.getFscBusiType());
                    fscOrderPayItemBO.setFscBusiTypeName(item.getFscBusiTypeName());
                    fscOrderPayItemBO.setPayAmount(item.getShouldPayAmount());
                    fscOrderPayItemBO.setShouldPayId(item.getShouldPayId());
                    fscPayBillCreateBusiReqBO.setFscOrderPayItemBOS(Arrays.asList(fscOrderPayItemBO));
                    fscPayBillCreateBusiReqBO.setOrgId(item.getCreateOrgId());
                    fscPayBillCreateBusiReqBO.setPurchaserId(item.getPurchaserId());
                    fscPayBillCreateBusiReqBO.setPurchaserName(item.getPurchaserName());
                    fscPayBillCreateBusiReqBO.setSecondOrgId(item.getSecondOrgId());
                    fscPayBillCreateBusiReqBO.setSecondOrgName(item.getSecondOrgName());
                    fscPayBillCreateBusiReqBO.setCompanyName(item.getCreateCompanyName());
                    if (type.equals(1)) {
                        fscPayBillCreateBusiReqBO.setIsprofess("1");
                    } else if (type.equals(2)) {
                        fscPayBillCreateBusiReqBO.setIsprofess("0");
                    }
                    fscPayBillCreateBusiReqBO.setName(item.getCreateOperName());
                    fscPayBillCreateBusiReqBO.setUserId(item.getCreateOperId());
                    fscPayBillCreateBusiReqBO.setPurOrgPath(item.getPurOrgPath());
                    log.info("\u81ea\u52a8\u521b\u5efa\u4ed8\u6b3e\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)fscPayBillCreateBusiReqBO)));
                    FscPayBillCreateBusiRspBO busiRspBO = this.fscPayBillCreateBusiService.dealPayBillCreate(fscPayBillCreateBusiReqBO);
                    log.info("\u521b\u5efa\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)((Object)busiRspBO)));
                    if (!"0000".equals(busiRspBO.getRespCode())) {
                        log.info("\u4ed8\u6b3e\u5355\u521b\u5efa\u5931\u8d25");
                        continue;
                    }
                    FscSendPayBillOrderToXhSrmAbilityReqBO fscSendPayBillOrderToXhSrmAbilityReqBO = new FscSendPayBillOrderToXhSrmAbilityReqBO();
                    fscSendPayBillOrderToXhSrmAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
                    FscSendPayBillOrderToXhSrmAbilityRspBO fscSendPayBillOrderToXhSrmAbilityRspBO = this.fscSendPayBillOrderToXhSrmAbilityService.sendPayBillOrderToXhSrm(fscSendPayBillOrderToXhSrmAbilityReqBO);
                    if (!"0000".equals(fscSendPayBillOrderToXhSrmAbilityRspBO.getRespCode())) {
                        log.info("\u4ed8\u6b3e\u5355\u540c\u6b65SRM\u7cfb\u7edf\u5931\u8d25");
                    }
                    FscSendEleInvoiceToXhSrmAbilityReqBO fscSendEleInvoiceToXhSrmAbilityReqBO = new FscSendEleInvoiceToXhSrmAbilityReqBO();
                    fscSendEleInvoiceToXhSrmAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
                    FscSendEleInvoiceToXhSrmAbilityRspBO fscSendEleInvoiceToXhSrmAbilityRspBO = this.fscSendEleInvoiceToXhSrmAbilityService.sendEleInvoiceToXhSrm(fscSendEleInvoiceToXhSrmAbilityReqBO);
                    if ("0000".equals(fscSendEleInvoiceToXhSrmAbilityRspBO.getRespCode())) continue;
                    log.info("\u4ed8\u6b3e\u5355\u7535\u5b50\u53d1\u7968\u540c\u6b65SRM\u7cfb\u7edf\u5931\u8d25");
                }
            }
        }
        return new FscBillAutoCreatePayOrderAbilityRspBO();
    }

    private void validParam(FscPayBillCreateAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS()) && CollectionUtils.isEmpty((Collection)abilityReqBO.getFscShouldPayBOS())) {
            throw new FscBusinessException("191000", "\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u548c\u5e94\u4ed8\u8bb0\u5f55\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS())) {
            abilityReqBO.setFscShouldPayBOS(null);
            abilityReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
                if (fscOrderPayItemBO.getPayAmount() == null) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u4e3a\u7a7a");
                }
                if (fscOrderPayItemBO.getShouldPayId() == null) {
                    throw new FscBusinessException("191000", "\u5e94\u4ed8ID\u4e3a\u7a7a");
                }
                if (BigDecimal.ZERO.compareTo(fscOrderPayItemBO.getPayAmount()) >= 0) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8eO!");
                }
            });
            return;
        }
        abilityReqBO.getFscShouldPayBOS().forEach(fscShouldPayBO -> {
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getObjectNo())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7f16\u7801\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getShouldPayAmount())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5e94\u4ed8\u91d1\u989d\u4e3a\u7a7a\uff01");
            }
            if (null == fscShouldPayBO.getObjectId()) {
                throw new FscBusinessException("191000", "\u5355\u636eID\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getObjectType())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\uff01");
            }
            fscShouldPayBO.setPayeeId(abilityReqBO.getPayeeId());
            fscShouldPayBO.setPayeeName(abilityReqBO.getPayeeName());
            fscShouldPayBO.setPayerId(abilityReqBO.getPayerId());
            fscShouldPayBO.setPayerName(abilityReqBO.getPayerName());
            fscShouldPayBO.setContractNo(abilityReqBO.getContractNo());
            fscShouldPayBO.setPayType(abilityReqBO.getPayType());
            fscShouldPayBO.setShouldPayType(abilityReqBO.getShouldPayType());
        });
    }

    private Boolean validBankAndOrder(FscOrderPO fscOrderPO) {
        if (!FscConstants.FscServiceOrderState.SIGNED_INVOICE.equals(fscOrderPO.getOrderState())) {
            FscAccountPO fscAccountPo = new FscAccountPO();
            fscAccountPo.setOrgId(fscOrderPO.getPurchaserId());
            fscAccountPo.setStatus(FscConstants.AccountStatus.VALID);
            fscAccountPo.setAccountCategory(Integer.valueOf(Integer.parseInt("1")));
            log.info("\u6821\u9a8c\u7ed1\u5b9a\u94f6\u884c\u5361\u5165\u53c2\uff1a{}", (Object)fscAccountPo);
            int checkResult = this.fscAccountMapper.getCheckBy(fscAccountPo);
            log.info("\u6821\u9a8c\u7ed1\u5b9a\u94f6\u884c\u5361\u7ed3\u679c\uff1a{}", (Object)checkResult);
            if (checkResult <= 0) {
                String resultMessage = "\u8d26\u53f7\u6ca1\u6709\u7ed1\u5b9a\u6709\u6548\u7684\u94f6\u884c\u5361\u4fe1\u606f\uff0c\u8bf7\u5b8c\u6210\u5b9e\u4f53\u8d26\u6237\u7ed1\u5b9a\uff0c\u518d\u53d1\u8d77\u4ed8\u6b3e\u3002";
                return false;
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType()) && (FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType()) && "3".equals(fscOrderPO.getOrderSource().toString()) || FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) && "2".equals(fscOrderPO.getOrderSource().toString()))) {
                FscBillInvoiceSignInAbilityReqBO fscBillInvoiceSignInAbilityReqBO = new FscBillInvoiceSignInAbilityReqBO();
                fscBillInvoiceSignInAbilityReqBO.setFscOrderIds(Arrays.asList(fscOrderPO.getFscOrderId()));
                FscBillInvoiceSignInAbilityRspBO fscBillInvoiceSignInAbilityRspBO = this.fscBillInvoiceSignInAbilityService.fscOrderInvoiceSignIn(fscBillInvoiceSignInAbilityReqBO);
                if (!((FscBillInvoiceSignBO)fscBillInvoiceSignInAbilityRspBO.getFscBillInvoiceSignBOList().get(0)).getSignIsSuccess().booleanValue()) {
                    return false;
                }
            }
        }
        return true;
    }
}

