/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.busibase.busi.bo.FscComInvoiceListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComInvoiceListPageQueryBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderMsgLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscSendEleInvoiceToXhSrmAtomService;
import com.tydic.fsc.pay.atom.bo.FscSendEleInvoiceToXhSrmAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendEleInvoiceToXhSrmAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscEsQryComInvoiceListToXhBusiService;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.fsc.po.FscOrderMsgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.umc.general.ability.api.UmcQryOrgAccountCodeByOrgIdAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityRspBO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscSendEleInvoiceToXhSrmAtomServiceImpl
implements FscSendEleInvoiceToXhSrmAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSendEleInvoiceToXhSrmAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderMsgLogMapper fscOrderMsgLogMapper;
    @Value(value="${ESB_SEND_ELE_INVOICE_XH_URL}")
    private String ESB_SEND_ELE_INVOICE_XH_URL;
    @Autowired
    private FscEsQryComInvoiceListToXhBusiService fscEsQryComInvoiceListToXhBusiService;
    @Autowired
    private UmcQryOrgAccountCodeByOrgIdAbilityService umcQryOrgAccountCodeByOrgIdAbilityService;

    @Override
    public FscSendEleInvoiceToXhSrmAtomRspBO sendEleInvoiceToXhSrm(FscSendEleInvoiceToXhSrmAtomReqBO reqBO) {
        FscSendEleInvoiceToXhSrmAtomRspBO rspBO = new FscSendEleInvoiceToXhSrmAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderPO payOrderPO = new FscOrderPO();
        payOrderPO.setFscOrderId(reqBO.getFscOrderId());
        log.info("\u67e5\u8be2\u4ed8\u6b3e\u5355\u5165\u53c2:{}", (Object)payOrderPO);
        FscOrderPO payOrderInfo = this.fscOrderMapper.getModelBy(payOrderPO);
        log.info("\u67e5\u8be2\u4ed8\u6b3e\u5355\u51fa\u53c2:{}", (Object)payOrderInfo);
        if (ObjectUtil.isEmpty((Object)payOrderInfo)) {
            throw new FscBusinessException("198888", "\u96ea\u82b1\u540c\u6b65\u7535\u5b50\u53d1\u7968-\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728");
        }
        List fscOrderPOList = this.fscOrderMapper.getJSDbyFKDid(reqBO.getFscOrderId());
        if (ObjectUtil.isEmpty((Object)fscOrderPOList)) {
            throw new FscBusinessException("198888", "\u96ea\u82b1\u540c\u6b65\u7535\u5b50\u53d1\u7968-\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
        }
        List fscOrderIds = fscOrderPOList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderIds(fscOrderIds);
        fscInvoicePO.setInvoiceCategory(FscConstants.InvoiceCategory.ELECTRON);
        List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        if (ObjectUtil.isEmpty((Object)fscInvoicePOList)) {
            return new FscSendEleInvoiceToXhSrmAtomRspBO();
        }
        String sendParams = this.initPostStr(fscInvoicePOList, (FscOrderPO)fscOrderPOList.get(0));
        log.info("\u96ea\u82b1\u7535\u5b50\u53d1\u7968\u63a8\u9001SRM\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_SEND_ELE_INVOICE_XH_URL);
        log.info("\u96ea\u82b1\u7535\u5b50\u53d1\u7968\u63a8\u9001SRM\u8bf7\u6c42\u53c2\u6570:{}", (Object)sendParams);
        String returnString = SSLClient.doPost((String)this.ESB_SEND_ELE_INVOICE_XH_URL, (String)sendParams);
        log.info("\u96ea\u82b1\u7535\u5b50\u53d1\u7968\u63a8\u9001SRM\u8bf7\u6c42\u54cd\u5e94:{}", (Object)returnString);
        FscOrderMsgLogPO fscOrderMsgLogPO = new FscOrderMsgLogPO();
        fscOrderMsgLogPO.setSendUrl(this.ESB_SEND_ELE_INVOICE_XH_URL);
        fscOrderMsgLogPO.setSendContent(sendParams);
        fscOrderMsgLogPO.setMsgContent(returnString);
        fscOrderMsgLogPO.setObjId(reqBO.getFscOrderId());
        fscOrderMsgLogPO.setPushTime(new Date());
        if (ObjectUtil.isEmpty((Object)returnString)) {
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8c03\u7528ESB\u63a5\u53e3\u96ea\u82b1\u7535\u5b50\u53d1\u7968\u63a8\u9001SRM\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            this.writeLog(fscOrderMsgLogPO);
            throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u96ea\u82b1\u7535\u5b50\u53d1\u7968\u63a8\u9001SRM\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        this.resolveRsp(returnString, fscOrderMsgLogPO);
        return rspBO;
    }

    private String initPostStr(List<FscInvoicePO> fscInvoicePOList, FscOrderPO fscOrderPO) {
        JSONObject postJson = new JSONObject();
        JSONObject reqJson = new JSONObject();
        reqJson.put("processNo", (Object)Sequence.getInstance().nextId());
        reqJson.put("requestTime", (Object)DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        JSONArray invoiceDetailList = new JSONArray();
        FscComInvoiceListPageQueryBusiReqBO fscComInvoiceListPageQueryBusiReqBO = new FscComInvoiceListPageQueryBusiReqBO();
        fscComInvoiceListPageQueryBusiReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
        log.info("\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscComInvoiceListPageQueryBusiReqBO));
        FscComInvoiceListPageQueryBusiRspBO fscComInvoiceListPageQueryBusiRspBO = this.fscEsQryComInvoiceListToXhBusiService.esQryComInvoiceList(fscComInvoiceListPageQueryBusiReqBO);
        log.info("\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)fscComInvoiceListPageQueryBusiRspBO));
        if (!"0000".equals(fscComInvoiceListPageQueryBusiRspBO.getRespCode())) {
            log.info("es\u67e5\u8be2\u53d1\u7968\u9519\u8bef");
            throw new BaseBusinessException("8888", "es\u67e5\u8be2\u53d1\u7968\u9519\u8bef");
        }
        List invoiceBOList = fscComInvoiceListPageQueryBusiRspBO.getRows();
        if (ObjectUtil.isEmpty((Object)invoiceBOList)) {
            log.info("es\u67e5\u8be2\u53d1\u7968\u4e3a\u7a7a");
            throw new BaseBusinessException("8888", "es\u67e5\u8be2\u53d1\u7968\u4e3a\u7a7a");
        }
        Map<Long, List<InvoiceBO>> invoiceBOListMap = invoiceBOList.stream().collect(Collectors.groupingBy(o -> o.getInvoiceId()));
        for (FscInvoicePO invoice : fscInvoicePOList) {
            log.info("\u53d1\u7968\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)invoice));
            JSONObject invoiceDetail = new JSONObject();
            invoiceDetail.put("statementNo", (Object)fscOrderPO.getOrderNo());
            UmcQryOrgAccountCodeByOrgIdAbilityReqBO umcQryOrgAccountCodeByOrgIdAbilityReqBO2 = new UmcQryOrgAccountCodeByOrgIdAbilityReqBO();
            umcQryOrgAccountCodeByOrgIdAbilityReqBO2.setOrgId(fscOrderPO.getPurchaserId());
            UmcQryOrgAccountCodeByOrgIdAbilityRspBO umcQryOrgAccountCodeByOrgIdAbilityRspBO2 = this.umcQryOrgAccountCodeByOrgIdAbilityService.qryOrgAccountCodeByOrgId(umcQryOrgAccountCodeByOrgIdAbilityReqBO2);
            if (!"0000".equals(umcQryOrgAccountCodeByOrgIdAbilityRspBO2.getRespCode())) {
                throw new FscBusinessException("198888", "\u96ea\u82b1\u540c\u6b65\u7535\u5b50\u53d1\u7968-\u91c7\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u5b58\u5728");
            }
            invoiceDetail.put("CompanySalerCode", (Object)"91441900765724131Y");
            FscLegalCompanyPO fscLegalCompanyPO = this.fscLegalCompanyMapper.getByOrgId(fscOrderPO.getSupplierId());
            if (ObjectUtil.isEmpty((Object)fscLegalCompanyPO)) {
                throw new FscBusinessException("198888", "\u96ea\u82b1\u540c\u6b65\u7535\u5b50\u53d1\u7968-\u4f9b\u5e94\u5546\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u5b58\u5728");
            }
            invoiceDetail.put("supplierSalerCode", (Object)fscLegalCompanyPO.getOrgCertificateCode());
            invoiceDetail.put("invoiceType", (Object)invoice.getInvoiceType());
            invoiceDetail.put("invoiceNum", (Object)invoice.getInvoiceNo());
            invoiceDetail.put("invoiceCode", (Object)invoice.getInvoiceCode());
            JSONArray invoicePdfUrlList = new JSONArray();
            List attachmentBOList = invoiceBOListMap.get(invoice.getInvoiceId()).get(0).getAttachmentList();
            for (AttachmentBO attachmentBO : attachmentBOList) {
                if (!attachmentBO.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE)) continue;
                JSONObject invoicePdfDetail = new JSONObject();
                invoicePdfDetail.put("fileName", (Object)"\u7535\u5b50\u53d1\u7968.pdf");
                invoicePdfDetail.put("fileUrl", (Object)attachmentBO.getAttachmentUrl());
                invoicePdfUrlList.add((Object)invoicePdfDetail);
            }
            invoiceDetail.put("invoiceFileList", (Object)invoicePdfUrlList);
            invoiceDetailList.add((Object)invoiceDetail);
        }
        reqJson.put("invoiceList", (Object)invoiceDetailList);
        postJson.put("payload", (Object)JSON.toJSONString((Object)reqJson));
        log.info("\u96ea\u82b1\u63a8\u9001SRM-\u51fa\u53c2:{}", (Object)postJson.toString());
        return postJson.toString();
    }

    private void resolveRsp(String returnString, FscOrderMsgLogPO fscOrderMsgLogPO) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519:" + e.getMessage());
            this.writeLog(fscOrderMsgLogPO);
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        if (null == rspJsonObject.getJSONObject("RESPONSE") || null == rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA")) {
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.writeLog(fscOrderMsgLogPO);
            return;
        }
        if (rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"status").equals("SUCC")) {
            fscOrderMsgLogPO.setResultString("1");
        } else {
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            this.writeLog(fscOrderMsgLogPO);
        }
        this.writeLog(fscOrderMsgLogPO);
    }

    private void writeLog(FscOrderMsgLogPO fscOrderMsgLogPO) {
        fscOrderMsgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderMsgLogPO.setMsgType(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_SALE_ORDER);
        fscOrderMsgLogPO.setObjType(FscConstants.FSC_ORDER_OUT_OBJ_TYPE.SALE_FSC_ORDER);
        fscOrderMsgLogPO.setCreateTime(new Date());
        this.fscOrderMsgLogMapper.insert(fscOrderMsgLogPO);
    }
}

