/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderMsgLogMapper;
import com.tydic.fsc.pay.atom.api.FscSendPayBillOrderToXhSrmAtomService;
import com.tydic.fsc.pay.atom.api.FscSendPaymentOrderAtomService;
import com.tydic.fsc.pay.atom.api.FscSendTradePayBillOrderAtomService;
import com.tydic.fsc.pay.atom.bo.FscSendEleInvoiceToXhSrmAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendEleInvoiceToXhSrmAtomRspBO;
import com.tydic.fsc.pay.atom.bo.FscSendPayBillOrderToXhSrmAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendPayBillOrderToXhSrmAtomRspBO;
import com.tydic.fsc.pay.atom.bo.FscSendPaymentOrderAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendPaymentOrderAtomRspBO;
import com.tydic.fsc.pay.atom.bo.FscSendTradePayBillOrderAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendTradePayBillOrderAtomRspBO;
import com.tydic.fsc.pay.atom.impl.FscSendEleInvoiceToXhSrmAtomServiceImpl;
import com.tydic.fsc.po.FscOrderMsgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;

public class FscFinancialSharedSendConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscFinancialSharedSendConsumer.class);
    @Autowired
    private FscSendTradePayBillOrderAtomService fscSendTradePayBillOrderAtomService;
    @Autowired
    private FscSendPaymentOrderAtomService fscSendPaymentOrderAtomService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscSendPayBillOrderToXhSrmAtomService fscSendPayBillOrderToXhSrmAtomService;
    @Autowired
    private FscSendEleInvoiceToXhSrmAtomServiceImpl fscSendEleInvoiceToXhSrmAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderMsgLogMapper fscOrderMsgLogMapper;
    @Value(value="${secondOrgId.xh}")
    private Long SECONDORGID_XH;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        String content = proxyMessage.getContent();
        log.info("\u7ed3\u7b97\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u72b6\u6001\u6d88\u8d39\u8005\u5165\u53c2:{}" + content);
        try {
            FscSendPaymentOrderAtomReqBO reqBO = (FscSendPaymentOrderAtomReqBO)((Object)JSON.parseObject((String)content, FscSendPaymentOrderAtomReqBO.class));
            log.info("\u8f6c\u6362\u540e\u53c2\u6570\u5982\u4e0b:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
            if (reqBO != null) {
                HashSet<Long> fscOrderIds = new HashSet<Long>();
                if (!ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
                    fscOrderIds.add(reqBO.getFscOrderId());
                }
                if (!ObjectUtils.isEmpty(reqBO.getFscOrderIds())) {
                    fscOrderIds.addAll(reqBO.getFscOrderIds());
                }
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderIds(new ArrayList(fscOrderIds));
                List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
                Set secondeOrgIds = fscOrderPOList.stream().map(FscOrderPO::getSecondOrgId).collect(Collectors.toSet());
                if (secondeOrgIds.size() == 1 && secondeOrgIds.contains(this.SECONDORGID_XH)) {
                    for (Long id : fscOrderIds) {
                        log.info("\u96ea\u82b1--\u63a8\u9001SRM\u7cfb\u7edf:{}", (Object)reqBO.getFscOrderId());
                        FscOrderMsgLogPO fscOrderMsgLogPO = new FscOrderMsgLogPO();
                        fscOrderMsgLogPO.setObjId(id);
                        fscOrderMsgLogPO.setResultString("1");
                        List fscOrderMsgLogPOS = this.fscOrderMsgLogMapper.getList(fscOrderMsgLogPO);
                        if (ObjectUtils.isEmpty((Object)fscOrderMsgLogPOS)) {
                            this.syncPayOrder(reqBO, id);
                            this.syncEleInvoice(reqBO, id);
                            continue;
                        }
                        List typeList = fscOrderMsgLogPOS.stream().map(FscOrderMsgLogPO::getMsgType).collect(Collectors.toList());
                        if (!typeList.contains(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_XH_INVOICE)) {
                            this.syncEleInvoice(reqBO, id);
                        }
                        if (typeList.contains(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_XH_SRM)) continue;
                        this.syncPayOrder(reqBO, id);
                    }
                } else if ("0".equals(reqBO.getIsprofess())) {
                    for (Long id : fscOrderIds) {
                        log.info("\u5b88\u6b63--\u63a8\u9001\u8d22\u52a1\u4e2d\u5fc3:{}", (Object)reqBO.getFscOrderId());
                        FscSendTradePayBillOrderAtomReqBO fscSendTradePayBillOrderAtomReqBO = new FscSendTradePayBillOrderAtomReqBO();
                        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)fscSendTradePayBillOrderAtomReqBO));
                        fscSendTradePayBillOrderAtomReqBO.setFscOrderId(id);
                        FscSendTradePayBillOrderAtomRspBO fscSendTradePayBillOrderAtomRspBO = null;
                        try {
                            fscSendTradePayBillOrderAtomRspBO = this.fscSendTradePayBillOrderAtomService.sendTradePayBillOrder(fscSendTradePayBillOrderAtomReqBO);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.updateOrderState(id, "\u540c\u6b65\u7a0b\u5e8f\u5f02\u5e38");
                        }
                        if ("0000".equals(fscSendTradePayBillOrderAtomRspBO.getRespCode())) continue;
                        this.updateOrderState(id, fscSendTradePayBillOrderAtomRspBO.getRespDesc());
                    }
                } else {
                    for (Long id : fscOrderIds) {
                        log.info("\u64ae\u5408--\u63a8\u9001\u8d22\u52a1\u4e2d\u5fc3:{}", (Object)id);
                        FscSendPaymentOrderAtomReqBO fscSendPaymentOrderAtomReqBO = new FscSendPaymentOrderAtomReqBO();
                        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)fscSendPaymentOrderAtomReqBO));
                        fscSendPaymentOrderAtomReqBO.setFscOrderId(id);
                        FscSendPaymentOrderAtomRspBO fscSendPaymentOrderAtomRspBO = null;
                        try {
                            fscSendPaymentOrderAtomRspBO = this.fscSendPaymentOrderAtomService.dealPaySuccess(fscSendPaymentOrderAtomReqBO);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.updateOrderState(id, "\u540c\u6b65\u7a0b\u5e8f\u5f02\u5e38");
                        }
                        if ("0000".equals(fscSendPaymentOrderAtomRspBO.getRespCode())) continue;
                        this.updateOrderState(id, fscSendPaymentOrderAtomRspBO.getRespDesc());
                    }
                }
                for (Long id : fscOrderIds) {
                    FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                    fscComOrderListSyncAbilityReqBO.setFscOrderId(id);
                    this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                }
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            log.error("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private void syncPayOrder(FscSendPaymentOrderAtomReqBO reqBO, Long id) {
        FscSendPayBillOrderToXhSrmAtomReqBO fscSendPayBillOrderToXhSrmAtomReqBO = new FscSendPayBillOrderToXhSrmAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)fscSendPayBillOrderToXhSrmAtomReqBO));
        fscSendPayBillOrderToXhSrmAtomReqBO.setFscOrderId(id);
        FscSendPayBillOrderToXhSrmAtomRspBO fscSendPayBillOrderToXhSrmAtomRspBO = null;
        try {
            fscSendPayBillOrderToXhSrmAtomRspBO = this.fscSendPayBillOrderToXhSrmAtomService.sendPayBillOrderToXhSrm(fscSendPayBillOrderToXhSrmAtomReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.updateOrderState(id, "\u96ea\u82b1\u4ed8\u6b3e\u5355:\u540c\u6b65\u7a0b\u5e8f\u5f02\u5e38");
        }
        if (!"0000".equals(fscSendPayBillOrderToXhSrmAtomRspBO.getRespCode())) {
            this.updateOrderState(id, "\u96ea\u82b1\u4ed8\u6b3e\u5355" + fscSendPayBillOrderToXhSrmAtomRspBO.getRespDesc());
        }
    }

    private void syncEleInvoice(FscSendPaymentOrderAtomReqBO reqBO, Long id) {
        FscSendEleInvoiceToXhSrmAtomReqBO fscSendEleInvoiceToXhSrmAtomReqBO = new FscSendEleInvoiceToXhSrmAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)fscSendEleInvoiceToXhSrmAtomReqBO));
        fscSendEleInvoiceToXhSrmAtomReqBO.setFscOrderId(id);
        FscSendEleInvoiceToXhSrmAtomRspBO fscSendEleInvoiceToXhSrmAtomRspBO = null;
        try {
            fscSendEleInvoiceToXhSrmAtomRspBO = this.fscSendEleInvoiceToXhSrmAtomService.sendEleInvoiceToXhSrm(fscSendEleInvoiceToXhSrmAtomReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.updateOrderState(id, "\u96ea\u82b1\u7535\u5b50\u53d1\u7968:\u540c\u6b65\u7a0b\u5e8f\u5f02\u5e38");
        }
        if (!"0000".equals(fscSendEleInvoiceToXhSrmAtomRspBO.getRespCode())) {
            this.updateOrderState(id, "\u96ea\u82b1\u7535\u5b50\u53d1\u7968:" + fscSendEleInvoiceToXhSrmAtomRspBO.getRespDesc());
        }
    }

    private void updateOrderState(Long fscOrderId, String errorMsg) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setSyncTime(new Date(System.currentTimeMillis()));
        fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
        fscOrderPO.setSyncFailReason(errorMsg);
        this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
    }
}

