/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPaymentStatusReturnAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPaymentStatusReturnAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPaymentStatusReturnAbilityRspBO;
import com.tydic.fsc.po.FscOrderPO;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPaymentStatusReturnAbilityService"})
public class FscPaymentStatusReturnAbilityServiceImpl
implements FscPaymentStatusReturnAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPaymentStatusReturnAbilityServiceImpl.class);
    @Value(value="${FSC_FINANCIAL_SHARED_CALL_BACK_TOPIC:FSC_FINANCIAL_SHARED_CALL_BACK_TOPIC}")
    private String FSC_FINANCIAL_SHARED_CALL_BACK_TOPIC;
    @Resource(name="fscFinancialSharedCallBackProducer")
    private ProxyMessageProducer fscFinancialSharedCallBackProducer;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @PostMapping(value={"paymentStatusReturn"})
    public FscPaymentStatusReturnAbilityRspBO paymentStatusReturn(@RequestBody FscPaymentStatusReturnAbilityReqBO reqBO) {
        FscPaymentStatusReturnAbilityRspBO abilityRspBO = new FscPaymentStatusReturnAbilityRspBO();
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setRespDesc("\u6210\u529f");
        this.validParam(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderNo(reqBO.getSourceNo());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtil.isEmpty((Object)fscOrderPO)) {
            abilityRspBO.setStatus("FAIL");
            abilityRspBO.setMessage("\u4ed8\u6b3e\u5355\uff08" + reqBO.getSourceNo() + "\uff09\u4e0d\u5b58\u5728");
            return abilityRspBO;
        }
        FscOrderPO temp = new FscOrderPO();
        temp.setFscOrderId(fscOrderPO.getFscOrderId());
        temp.setOrderFlow(Integer.valueOf(1));
        FscOrderPO modelBy = this.fscOrderMapper.getModelBy(temp);
        if (modelBy == null) {
            abilityRspBO.setStatus("FAIL");
            abilityRspBO.setMessage("\u4ed8\u6b3e\u5355id\uff08" + reqBO.getSourceNo() + "\uff09\u4e0d\u5b58\u5728");
            return abilityRspBO;
        }
        try {
            reqBO.setAppyId(modelBy.getFscOrderId());
            this.fscFinancialSharedCallBackProducer.send(new ProxyMessage(this.FSC_FINANCIAL_SHARED_CALL_BACK_TOPIC, "*", JSON.toJSONString((Object)reqBO)));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u5904\u7406\u8d22\u52a1\u5171\u4eab\u72b6\u6001mq\u5931\u8d25\uff1a" + e.getMessage());
            abilityRspBO.setStatus("FAIL");
            abilityRspBO.setMessage("\u53d1\u9001\u5904\u7406\u8d22\u52a1\u5171\u4eab\u72b6\u6001mq\u5931\u8d25\uff1a" + e.getMessage());
            return abilityRspBO;
        }
        abilityRspBO.setStatus("SUCCESS");
        abilityRspBO.setMessage("\u6210\u529f");
        return abilityRspBO;
    }

    private void validParam(FscPaymentStatusReturnAbilityReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getSourceNo())) {
            throw new FscBusinessException("191000", "\u6e90\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getClaimNo())) {
            throw new FscBusinessException("191000", "\u62a5\u8d26\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPayStatus())) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

