/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.oc.service.order.UocOrderRelUpdateExtService;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateExtReqBo;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateExtRspBo;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceSignInAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceSignBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceSignInAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceSignInAbilityRspBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.busi.bo.FscOrderRelationAndOrderBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.pay.ability.api.FscBatchCreatePayOrderBillAbilityService;
import com.tydic.fsc.pay.ability.bo.FscAutoPaymentRuleBO;
import com.tydic.fsc.pay.ability.bo.FscBatchCreatePayOrderAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscBatchCreatePayOrderAbilityRspBO;
import com.tydic.fsc.pay.atom.bo.FscSendPaymentOrderAtomReqBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiRspBO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscBatchCreatePayOrderBillAbilityService"})
public class FscBatchCreatePayOrderBillAbilityServiceImpl
implements FscBatchCreatePayOrderBillAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBatchCreatePayOrderBillAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPayBillCreateBusiService fscPayBillCreateBusiService;
    @Value(value="${FSC_FINANCIAL_SHARED_SEND_TOPIC:FSC_FINANCIAL_SHARED_SEND_TOPIC}")
    private String FSC_FINANCIAL_SHARED_SEND_TOPIC;
    @Resource(name="fscFinancialSharedSendProducer")
    private ProxyMessageProducer fscFinancialSharedSendProducer;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscBillInvoiceSignInAbilityService fscBillInvoiceSignInAbilityService;
    @Autowired
    private UocOrderRelUpdateExtService uocOrderRelUpdateExtService;

    @PostMapping(value={"batchCreatePayOrder"})
    public FscBatchCreatePayOrderAbilityRspBO batchCreatePayOrder(@RequestBody FscBatchCreatePayOrderAbilityReqBO reqBO) {
        Integer type = reqBO.getModelType();
        FscAutoPaymentRuleBO fscAutoPaymentRuleBO = reqBO.getFscAutoPaymentRuleBO();
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getFscOrderBO()), FscOrderPO.class);
        this.createPayOrder(type, fscAutoPaymentRuleBO, fscOrderPO);
        return new FscBatchCreatePayOrderAbilityRspBO();
    }

    private void createPayOrder(Integer type, FscAutoPaymentRuleBO autoPaymentRuleBO, FscOrderPO fscOrderPO) {
        Page page = new Page();
        page.setPageSize(50);
        page.setPageNo(1);
        List totalFscOrderList = this.fscOrderMapper.getFscOrderAndShouldPayIdPage(fscOrderPO, page);
        log.info("\u751f\u6210\u7ed3\u7b97\u5355\u4fe1\u606f\u67e5\u8be2\u5165\u53c2page:{}", (Object)JSON.toJSONString((Object)page));
        log.info("\u5f85\u751f\u6210\u4ed8\u6b3e\u5355\u7ed3\u7b97\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)totalFscOrderList));
        List filterList = totalFscOrderList.stream().filter(o -> !ObjectUtils.isEmpty((Object)o.getSecondOrgId())).collect(Collectors.toList());
        Map<String, List<FscOrderPO>> totalFscOrderListMap = filterList.stream().collect(Collectors.groupingBy(o -> o.getPurchaserId() + "-" + o.getSecondOrgId()));
        for (Map.Entry<String, List<FscOrderPO>> entry : totalFscOrderListMap.entrySet()) {
            String[] keyList = entry.getKey().toString().split("-");
            List<FscOrderPO> createPayOrderList = entry.getValue();
            for (FscOrderPO item : createPayOrderList) {
                try {
                    Boolean result = this.validBankAndOrder(item);
                    if (!result.booleanValue()) {
                        String failReason = "\u81ea\u52a8\u521b\u5efa\u4ed8\u6b3e\u5355\u5931\u8d25:\u672a\u7ed1\u5b9a\u94f6\u884c\u5361";
                        this.updateAutoOrderState(item.getFscOrderId(), failReason, 2);
                        continue;
                    }
                    FscPayBillCreateBusiReqBO fscPayBillCreateBusiReqBO = new FscPayBillCreateBusiReqBO();
                    FscOrderPayItemBO fscOrderPayItemBO = new FscOrderPayItemBO();
                    fscOrderPayItemBO.setFscBusiType(item.getFscBusiType());
                    fscOrderPayItemBO.setFscBusiTypeName(item.getFscBusiTypeName());
                    fscOrderPayItemBO.setPayAmount(item.getShouldPayAmount());
                    fscOrderPayItemBO.setShouldPayId(item.getShouldPayId());
                    fscPayBillCreateBusiReqBO.setFscOrderPayItemBOS(Arrays.asList(fscOrderPayItemBO));
                    fscPayBillCreateBusiReqBO.setOrgId(item.getCreateOrgId());
                    fscPayBillCreateBusiReqBO.setPurchaserId(item.getPurchaserId());
                    fscPayBillCreateBusiReqBO.setPurchaserName(item.getPurchaserName());
                    fscPayBillCreateBusiReqBO.setSecondOrgId(item.getSecondOrgId());
                    fscPayBillCreateBusiReqBO.setSecondOrgName(item.getSecondOrgName());
                    fscPayBillCreateBusiReqBO.setAppSubId(item.getAppSubId());
                    fscPayBillCreateBusiReqBO.setCompanyName(item.getCreateCompanyName());
                    if (type.equals(1) || type.equals(3)) {
                        fscPayBillCreateBusiReqBO.setIsprofess("1");
                    } else if (type.equals(2) || type.equals(4)) {
                        fscPayBillCreateBusiReqBO.setIsprofess("0");
                    }
                    fscPayBillCreateBusiReqBO.setName(item.getCreateOperName());
                    fscPayBillCreateBusiReqBO.setUserId(item.getCreateOperId());
                    fscPayBillCreateBusiReqBO.setPurOrgPath(item.getPurOrgPath());
                    log.info("\u81ea\u52a8\u521b\u5efa\u4ed8\u6b3e\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)fscPayBillCreateBusiReqBO)));
                    FscPayBillCreateBusiRspBO busiRspBO = this.fscPayBillCreateBusiService.dealPayBillCreate(fscPayBillCreateBusiReqBO);
                    log.info("\u521b\u5efa\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)((Object)busiRspBO)));
                    if (!"0000".equals(busiRspBO.getRespCode())) {
                        log.info("\u4ed8\u6b3e\u5355\u521b\u5efa\u5931\u8d25");
                        String failReason = "\u81ea\u52a8\u521b\u5efa\u4ed8\u6b3e\u5355\u5931\u8d25:" + busiRspBO.getRespDesc();
                        this.updateAutoOrderState(item.getFscOrderId(), failReason, 2);
                        continue;
                    }
                    FscSendPaymentOrderAtomReqBO fscSendPaymentOrderAtomReqBO = new FscSendPaymentOrderAtomReqBO();
                    fscSendPaymentOrderAtomReqBO.setFscOrderId(busiRspBO.getFscOrderId());
                    fscSendPaymentOrderAtomReqBO.setIsprofes("1");
                    log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3mq\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)fscSendPaymentOrderAtomReqBO)));
                    ProxyMessage message = new ProxyMessage(this.FSC_FINANCIAL_SHARED_SEND_TOPIC, "*", JSON.toJSONString((Object)((Object)fscSendPaymentOrderAtomReqBO)));
                    log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3mq\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)message));
                    this.fscFinancialSharedSendProducer.send(message);
                    this.updateAutoOrderState(item.getFscOrderId(), "", 1);
                    FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                    fscComOrderListSyncAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
                    this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                    List orderRelationAndOrderList = this.fscOrderMapper.getJSDandInspbyFKDids(Arrays.asList(busiRspBO.getFscOrderId()));
                    log.info("\u4ed8\u6b3e\u5355\u67e5\u7ed3\u7b97\u5173\u8054\u5173\u7cfb\uff1a{}", (Object)JSON.toJSONString((Object)orderRelationAndOrderList));
                    if (CollectionUtils.isEmpty((Collection)orderRelationAndOrderList)) continue;
                    for (FscOrderRelationAndOrderBO fscOrderPOFor : orderRelationAndOrderList) {
                        UocOrderRelUpdateExtReqBo uocOrderRelUpdateReqBo = new UocOrderRelUpdateExtReqBo();
                        uocOrderRelUpdateReqBo.setOrderId(fscOrderPOFor.getOrderId());
                        uocOrderRelUpdateReqBo.setRelId(Convert.toStr((Object)busiRspBO.getFscOrderId(), null));
                        uocOrderRelUpdateReqBo.setRelNo(fscOrderPOFor.getFkdOrderNo());
                        uocOrderRelUpdateReqBo.setRelState(FscConstants.FscRelStatus.COMMITTED);
                        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPOFor.getReceiveType())) {
                            uocOrderRelUpdateReqBo.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
                        } else if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPOFor.getReceiveType())) {
                            uocOrderRelUpdateReqBo.setRelType(FscConstants.FscRelType.PRO_INVOICE);
                        }
                        uocOrderRelUpdateReqBo.setObjId(fscOrderPOFor.getAcceptOrderId());
                        uocOrderRelUpdateReqBo.setObjType(FscConstants.ORDER_OBJ_TYPE.PAY);
                        log.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocOrderRelUpdateReqBo));
                        UocOrderRelUpdateExtRspBo uocOrderRelUpdateRspBo = this.uocOrderRelUpdateExtService.dealRelUpdate(uocOrderRelUpdateReqBo);
                        log.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocOrderRelUpdateRspBo));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info("\u521b\u5efa\u4ed8\u6b3e\u5355\u9519\u8bef:{}", (Object)Long.parseLong(keyList[0]));
                }
            }
        }
    }

    private Boolean validBankAndOrder(FscOrderPO fscOrderPO) {
        if (!FscConstants.FscServiceOrderState.SIGNED_INVOICE.equals(fscOrderPO.getOrderState())) {
            FscAccountPO fscAccountPo = new FscAccountPO();
            fscAccountPo.setOrgId(fscOrderPO.getPurchaserId());
            fscAccountPo.setStatus(FscConstants.AccountStatus.VALID);
            fscAccountPo.setAccountCategory(Integer.valueOf(Integer.parseInt("1")));
            log.info("\u6821\u9a8c\u7ed1\u5b9a\u94f6\u884c\u5361\u5165\u53c2\uff1a{}", (Object)fscAccountPo);
            int checkResult = this.fscAccountMapper.getCheckBy(fscAccountPo);
            log.info("\u6821\u9a8c\u7ed1\u5b9a\u94f6\u884c\u5361\u7ed3\u679c\uff1a{}", (Object)checkResult);
            if (checkResult <= 0) {
                String resultMessage = "\u8d26\u53f7\u6ca1\u6709\u7ed1\u5b9a\u6709\u6548\u7684\u94f6\u884c\u5361\u4fe1\u606f\uff0c\u8bf7\u5b8c\u6210\u5b9e\u4f53\u8d26\u6237\u7ed1\u5b9a\uff0c\u518d\u53d1\u8d77\u4ed8\u6b3e\u3002";
                return false;
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType()) && (FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType()) && "3".equals(fscOrderPO.getOrderSource().toString()) || FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) && "2".equals(fscOrderPO.getOrderSource().toString()))) {
                FscBillInvoiceSignInAbilityReqBO fscBillInvoiceSignInAbilityReqBO = new FscBillInvoiceSignInAbilityReqBO();
                fscBillInvoiceSignInAbilityReqBO.setFscOrderIds(Arrays.asList(fscOrderPO.getFscOrderId()));
                FscBillInvoiceSignInAbilityRspBO fscBillInvoiceSignInAbilityRspBO = this.fscBillInvoiceSignInAbilityService.fscOrderInvoiceSignIn(fscBillInvoiceSignInAbilityReqBO);
                if (!((FscBillInvoiceSignBO)fscBillInvoiceSignInAbilityRspBO.getFscBillInvoiceSignBOList().get(0)).getSignIsSuccess().booleanValue()) {
                    return false;
                }
            }
        }
        return true;
    }

    private void updateAutoOrderState(Long fscOrderId, String failReason, Integer state) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setAutoCreateState(state);
        fscOrderPO.setAutoCreateFailReason(failReason);
        this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
    }
}

