/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.fsc.bill.ability.api.FscStockOrderPrintPreviewAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceProxyAddressMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderMsgLogMapper;
import com.tydic.fsc.dao.FscStockMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscSendTradePayBillOrderAtomService;
import com.tydic.fsc.pay.atom.bo.FscSendTradePayBillOrderAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendTradePayBillOrderAtomRspBO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceProxyAddressPO;
import com.tydic.fsc.po.FscOrderMsgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FileUtils;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.umc.general.ability.api.CrcQryMainUserInfoByPartIdAbilityService;
import com.tydic.umc.general.ability.api.UmcQryOrgAccountCodeByOrgIdAbilityService;
import com.tydic.umc.general.ability.bo.CrcQryMainUserInfoByPartIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryMainUserInfoByPartIdAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityRspBO;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FscSendTradePayBillOrderAtomServiceImpl
implements FscSendTradePayBillOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSendTradePayBillOrderAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private CrcQryMainUserInfoByPartIdAbilityService crcQryMainUserInfoByPartIdAbilityService;
    @Autowired
    private UmcQryOrgAccountCodeByOrgIdAbilityService umcQryOrgAccountCodeByOrgIdAbilityService;
    @Autowired
    private FscOrderMsgLogMapper fscOrderMsgLogMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscStockMapper fscStockMapper;
    @Autowired
    private FscStockOrderPrintPreviewAbilityService fscStockOrderPrintPreviewAbilityService;
    @Autowired
    private FscInvoiceProxyAddressMapper fscInvoiceProxyAddressMapper;
    @Value(value="${ESB_SEND_GOODS_PAY_ORDER_URL}")
    private String ESB_SEND_GOODS_PAY_ORDER_URL;

    @Override
    public FscSendTradePayBillOrderAtomRspBO sendTradePayBillOrder(FscSendTradePayBillOrderAtomReqBO reqBO) {
        FscSendTradePayBillOrderAtomRspBO rspBO = new FscSendTradePayBillOrderAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
        log.info("\u8d22\u52a1\u5171\u4eab\u63a8\u9001\u4ed8\u6b3e\u5355\u5165\u53c2:{}", (Object)fscOrderPO);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtils.isEmpty((Object)fscOrderPO)) {
            throw new BaseBusinessException("8888", "\u63a8\u9001\u4ed8\u6b3e\u5355\u5931\u8d25,\u4ed8\u6b3e\u5355\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (!ObjectUtils.isEmpty((Object)fscOrderPO.getReimburseNo()) && !fscOrderPO.getSyncState().equals(FscConstants.SYNC_STATE_TYPE.REJECT)) {
            return rspBO;
        }
        String sendParams = this.initSendParams(fscOrderPO);
        log.info("\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_SEND_GOODS_PAY_ORDER_URL);
        log.info("\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u53c2\u6570:{}", (Object)sendParams);
        String returnString = SSLClient.doPost((String)this.ESB_SEND_GOODS_PAY_ORDER_URL, (String)sendParams);
        log.info("\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u54cd\u5e94:{}", (Object)returnString);
        FscOrderMsgLogPO fscOrderMsgLogPO = new FscOrderMsgLogPO();
        fscOrderMsgLogPO.setSendUrl(this.ESB_SEND_GOODS_PAY_ORDER_URL);
        fscOrderMsgLogPO.setSendContent(sendParams);
        fscOrderMsgLogPO.setMsgContent(returnString);
        fscOrderMsgLogPO.setObjId(fscOrderPO.getFscOrderId());
        fscOrderMsgLogPO.setPushTime(new Date());
        if (ObjectUtil.isEmpty((Object)returnString)) {
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8c03\u7528ESB\u63a5\u53e3\u5546\u54c1\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            this.writeLog(fscOrderMsgLogPO);
            throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u5546\u54c1\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        this.resolveRsp(returnString, reqBO, fscOrderMsgLogPO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        return rspBO;
    }

    private void val(FscSendTradePayBillOrderAtomReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new BaseBusinessException("8888", "\u4ed8\u6b3e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String initSendParams(FscOrderPO fscOrderPO) {
        CrcQryMainUserInfoByPartIdAbilityReqBO crcQryMainUserInfoByPartIdAbilityReqBO = new CrcQryMainUserInfoByPartIdAbilityReqBO();
        crcQryMainUserInfoByPartIdAbilityReqBO.setMemId(fscOrderPO.getCreateOperId());
        log.info("\u8c03\u7528\u4f1a\u5458\u83b7\u53d6\u4e3b\u8d26\u53f7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityReqBO));
        CrcQryMainUserInfoByPartIdAbilityRspBO crcQryMainUserInfoByPartIdAbilityRspBO = this.crcQryMainUserInfoByPartIdAbilityService.qryMainUserInfoByPartId(crcQryMainUserInfoByPartIdAbilityReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u83b7\u53d6\u4e3b\u8d26\u53f7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityRspBO));
        if (!"0000".equals(crcQryMainUserInfoByPartIdAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u4f1a\u5458\u5f02\u5e38\uff1a" + crcQryMainUserInfoByPartIdAbilityRspBO.getRespDesc());
        }
        String creatorLdap = crcQryMainUserInfoByPartIdAbilityRspBO.getMainMemInformation().getRegAccount();
        UmcQryOrgAccountCodeByOrgIdAbilityReqBO umcQryOrgAccountCodeByOrgIdAbilityReqBO = new UmcQryOrgAccountCodeByOrgIdAbilityReqBO();
        umcQryOrgAccountCodeByOrgIdAbilityReqBO.setOrgId(fscOrderPO.getPayeeId());
        log.info("\u67e5\u8be2\u4f1a\u5458\u6536\u6b3e\u5355\u4f4d\u7f16\u7801\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityReqBO));
        UmcQryOrgAccountCodeByOrgIdAbilityRspBO umcQryOrgAccountCodeByOrgIdAbilityRspBO = this.umcQryOrgAccountCodeByOrgIdAbilityService.qryOrgAccountCodeByOrgId(umcQryOrgAccountCodeByOrgIdAbilityReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458\u6536\u6b3e\u5355\u4f4d\u7f16\u7801\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityRspBO));
        String orgAccountCode = umcQryOrgAccountCodeByOrgIdAbilityRspBO.getCorporationCode();
        JSONObject reqJson = new JSONObject();
        reqJson.put("ouCode", (Object)"SZZB0");
        reqJson.put("sourceNo", (Object)fscOrderPO.getOrderNo());
        reqJson.put("serialNo", (Object)Sequence.getInstance().nextId());
        reqJson.put("vendorCode", (Object)orgAccountCode);
        reqJson.put("vendorName", (Object)fscOrderPO.getPayeeName());
        reqJson.put("vendorBankName", (Object)fscOrderPO.getPayeeBankName());
        reqJson.put("vendorAccountNo", (Object)fscOrderPO.getPayeeBankAccount());
        reqJson.put("vendorAccountName", (Object)fscOrderPO.getPayeeName());
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setOrgId(fscOrderPO.getPayerId());
        fscAccountPO.setStatus(FscConstants.AccountStatus.VALID);
        List fscAccountPOList = this.fscAccountMapper.getList(fscAccountPO);
        if (ObjectUtil.isEmpty((Object)fscAccountPOList)) {
            throw new BaseBusinessException("8888", "\u4ed8\u6b3e\u5355\u4f4d\u94f6\u884c\u8d26\u53f7\u4e3a\u7a7a");
        }
        List distinctList = fscAccountPOList.stream().collect(Collectors.toMap(FscAccountPO::getAccountNo, accountPO -> accountPO, (p1, p2) -> p1)).values().stream().collect(Collectors.toList());
        String payAccountStr = distinctList.stream().distinct().map(r -> r.getAccountNo()).collect(Collectors.joining(","));
        reqJson.put("payAccountNo", (Object)payAccountStr);
        reqJson.put("applyLdapId", (Object)creatorLdap);
        reqJson.put("applyDate", (Object)DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        String summaryStr = "\u4ed8\u6b3e\u5355/" + fscOrderPO.getOrderNo();
        reqJson.put("summary", (Object)summaryStr);
        JSONArray lines = new JSONArray();
        List jsdList = this.fscOrderMapper.getJSDbyFKDid(fscOrderPO.getFscOrderId());
        JSONArray attachmentList = new JSONArray();
        for (FscOrderPO item : jsdList) {
            FscOrderPO fscOrderPO1 = new FscOrderPO();
            fscOrderPO1.setFscOrderId(item.getFscOrderId());
            fscOrderPO1 = this.fscOrderMapper.getModelBy(fscOrderPO1);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("currencyCode", (Object)"CNY");
            jsonObject.put("payAccountNo", (Object)payAccountStr);
            jsonObject.put("payAmount", (Object)String.valueOf(fscOrderPO1.getTotalCharge().setScale(2, RoundingMode.HALF_UP)));
            jsonObject.put("lineSummary", (Object)item.getOrderNo());
            lines.add((Object)jsonObject);
            FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
            fscAttachmentPO.setFscOrderId(item.getFscOrderId());
            fscAttachmentPO.setAttachmentTypeList(Arrays.asList(FscConstants.AttachmentType.FSC_ORDER_PDF, FscConstants.AttachmentType.INVOICE, FscConstants.AttachmentType.OFD, FscConstants.AttachmentType.XML, FscConstants.AttachmentType.INVOICE_FILE));
            log.info("\u83b7\u53d6\u9644\u4ef6\u5165\u53c2:{}", (Object)fscAttachmentPO);
            List fscAttachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
            int num = 1;
            if (ObjectUtil.isEmpty((Object)fscAttachmentPOList)) continue;
            List attachmentTypeList = fscAttachmentPOList.stream().map(FscAttachmentPO::getAttachmentType).collect(Collectors.toList());
            if (!attachmentTypeList.contains(FscConstants.AttachmentType.FSC_ORDER_PDF)) {
                this.writeAttachmentFailLog(fscOrderPO.getFscOrderId(), "\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u5931\u8d25\uff0c\u7f3a\u5c11\u7ed3\u7b97\u5355pdf\u9644\u4ef6");
                throw new FscBusinessException("191000", "\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u5931\u8d25\uff0c\u7f3a\u5c11\u7ed3\u7b97\u5355pdf\u9644\u4ef6");
            }
            if (!attachmentTypeList.contains(FscConstants.AttachmentType.INVOICE)) {
                this.writeAttachmentFailLog(fscOrderPO.getFscOrderId(), "\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u5931\u8d25\uff0c\u7f3a\u5c11\u91c7\u8d2d\u53d1\u7968pdf\u9644\u4ef6");
                throw new FscBusinessException("191000", "\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u5931\u8d25\uff0c\u7f3a\u5c11\u91c7\u8d2d\u53d1\u7968pdf\u9644\u4ef6");
            }
            for (FscAttachmentPO attachmentPOItem : fscAttachmentPOList) {
                String invoiceName = "";
                if (attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE)) {
                    invoiceName = "\u91c7\u8d2d\u53d1\u7968" + fscOrderPO.getOrderNo() + "-00" + num + ".pdf";
                } else if (attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.OFD)) {
                    invoiceName = "\u91c7\u8d2d\u53d1\u7968" + fscOrderPO.getOrderNo() + "-00" + num + ".ofd";
                } else if (attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.XML)) {
                    invoiceName = attachmentPOItem.getAttachmentUrl().indexOf("xml") != -1 ? "\u91c7\u8d2d\u53d1\u7968" + fscOrderPO.getOrderNo() + "-00" + num + ".xml" : "\u91c7\u8d2d\u53d1\u7968" + fscOrderPO.getOrderNo() + "-00" + num + ".zip";
                } else if (attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE_FILE)) {
                    String[] fileUrlList = attachmentPOItem.getAttachmentUrl().split("/");
                    String fileName = fileUrlList[attachmentPOItem.getAttachmentUrl().split("/").length - 1];
                    String fileSuffix = "";
                    if (fileName.indexOf(".") != -1) {
                        fileSuffix = fileName.split("\\.")[1];
                    }
                    invoiceName = "\u91c7\u8d2d\u53d1\u7968" + fscOrderPO.getOrderNo() + "-00" + num + "." + fileSuffix;
                }
                if (attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE) || attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.OFD) || attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.XML) || attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE_FILE)) {
                    ++num;
                }
                JSONObject jsonObject1 = new JSONObject();
                if (attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.FSC_ORDER_PDF)) {
                    jsonObject1.put("attachmentName", (Object)"\u91c7\u8d2d\u7ed3\u7b97\u5355.pdf");
                } else if (attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE)) {
                    jsonObject1.put("attachmentName", (Object)invoiceName);
                } else if (attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.OFD)) {
                    jsonObject1.put("attachmentName", (Object)invoiceName);
                } else if (attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.XML)) {
                    jsonObject1.put("attachmentName", (Object)invoiceName);
                } else if (attachmentPOItem.getAttachmentType().equals(FscConstants.AttachmentType.INVOICE_FILE)) {
                    jsonObject1.put("attachmentName", (Object)invoiceName);
                } else {
                    jsonObject1.put("attachmentName", (Object)attachmentPOItem.getAttachmentName());
                }
                jsonObject1.put("attachmentType", (Object)attachmentPOItem.getAttachmentType());
                String invoiceProxyAddress = this.proxyInvoiceAddress(attachmentPOItem.getAttachmentUrl(), fscOrderPO1.getSupplierId());
                attachmentPOItem.setAttachmentUrl(invoiceProxyAddress);
                String size = FileUtils.getFileLength((String)attachmentPOItem.getAttachmentUrl(), (String)"kb");
                jsonObject1.put("attachmentSize", (Object)size);
                jsonObject1.put("attachmentUrl", (Object)attachmentPOItem.getAttachmentUrl());
                jsonObject1.put("sourceNo", (Object)fscOrderPO.getOrderNo());
                attachmentList.add((Object)jsonObject1);
            }
        }
        reqJson.put("lines", (Object)lines);
        reqJson.put("attachments", (Object)attachmentList);
        log.info("\u63a8\u9001\u51fa\u53c2:{}", (Object)reqJson);
        return reqJson.toJSONString();
    }

    private void resolveRsp(String returnString, FscSendTradePayBillOrderAtomReqBO atomReqBO, FscOrderMsgLogPO fscOrderMsgLogPO) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519:" + e.getMessage());
            this.writeLog(fscOrderMsgLogPO);
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(atomReqBO.getFscOrderId());
        fscOrderPO.setOrderSyncTime(new Date(System.currentTimeMillis()));
        if (null == rspJsonObject.getJSONObject("RESPONSE") || null == rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA")) {
            fscOrderPO.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setOrderSyncFailReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.writeLog(fscOrderMsgLogPO);
            return;
        }
        if (rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"status").equals("SUCCESS")) {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.APPLYING);
            fscOrderPO.setSyncFailReason("");
            fscOrderPO.setSyncTime(new Date());
            fscOrderPO.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.SUCCESS);
            fscOrderPO.setOrderSyncFailReason("");
            fscOrderPO.setOrderSyncTime(new Date());
            fscOrderPO.setReimburseNo(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"claimNo").toString());
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("1");
        } else {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setSyncFailReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            fscOrderPO.setSyncTime(new Date());
            fscOrderPO.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setOrderSyncFailReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            fscOrderPO.setOrderSyncTime(new Date());
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
        }
        this.writeLog(fscOrderMsgLogPO);
    }

    private void writeAttachmentFailLog(Long fscOrderId, String errorMsg) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
        fscOrderPO.setSyncFailReason(errorMsg);
        fscOrderPO.setSyncTime(new Date());
        this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void writeLog(FscOrderMsgLogPO fscOrderMsgLogPO) {
        fscOrderMsgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderMsgLogPO.setMsgType(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_PAYMENT_ORDER);
        fscOrderMsgLogPO.setObjType(FscConstants.FSC_ORDER_OUT_OBJ_TYPE.PAYMENT_FSC_ORDER);
        fscOrderMsgLogPO.setCreateTime(new Date());
        this.fscOrderMsgLogMapper.insert(fscOrderMsgLogPO);
    }

    private String proxyInvoiceAddress(String invoiceUrl, Long supplierId) {
        FscInvoiceProxyAddressPO item;
        FscInvoiceProxyAddressPO fscInvoiceProxyAddressPO = new FscInvoiceProxyAddressPO();
        fscInvoiceProxyAddressPO.setSupplierIds(Arrays.asList(supplierId, 0L));
        List fscInvoiceProxyAddressPOS = this.fscInvoiceProxyAddressMapper.getList(fscInvoiceProxyAddressPO);
        if (ObjectUtil.isEmpty((Object)fscInvoiceProxyAddressPOS)) {
            log.info("\u4f9b\u5e94\u5546:{},\u6620\u5c04\u5730\u5740\u4e0d\u5b58\u5728", (Object)supplierId);
            return invoiceUrl;
        }
        String invoiceProxyAddress = "";
        Iterator iterator = fscInvoiceProxyAddressPOS.iterator();
        while (iterator.hasNext() && (invoiceProxyAddress = invoiceUrl.replace((item = (FscInvoiceProxyAddressPO)iterator.next()).getOrderAddress(), item.getProxyAddress())).equals(invoiceUrl)) {
        }
        return invoiceProxyAddress;
    }
}

