/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.pay.ability.api.FscSyncPayOrderToUocService;
import com.tydic.fsc.pay.ability.bo.FscSyncPayOrderToUocReqBO;
import com.tydic.fsc.pay.ability.bo.FscSyncPayOrderToUocRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscSyncPayOrderToUocService"})
public class FscSyncPayOrderToUocServiceImpl
implements FscSyncPayOrderToUocService {
    private static final Logger log = LoggerFactory.getLogger(FscSyncPayOrderToUocServiceImpl.class);
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;

    @PostMapping(value={"syncPayOrderToUoc"})
    public FscSyncPayOrderToUocRspBO syncPayOrderToUoc(@RequestBody FscSyncPayOrderToUocReqBO reqBO) {
        int pageNum = 1;
        int pageSize = 100;
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAIED);
        fscOrderPO.setOrderBy("create_time desc");
        if (!reqBO.getAllSync().booleanValue()) {
            if (!(reqBO.getAllSync().booleanValue() || ObjectUtil.isEmpty((Object)reqBO.getBeginTime()) || ObjectUtil.isEmpty((Object)reqBO.getBeginTime()))) {
                fscOrderPO.setCreateTimeStart(DateUtil.strToDate((String)reqBO.getBeginTime(), (String)"yyyyMMdd"));
                fscOrderPO.setCreateTimeEnd(DateUtil.strToDate((String)reqBO.getEndTime(), (String)"yyyyMMdd"));
            } else if (!ObjectUtil.isEmpty((Object)reqBO.getFscOrderIds())) {
                fscOrderPO.setFscOrderIds(reqBO.getFscOrderIds());
            } else {
                fscOrderPO.setCreateTimeStart(new Date());
                fscOrderPO.setCreateTimeEnd(new Date());
            }
        }
        while (pageSize >= 100) {
            List fscOrderPOList = new ArrayList();
            Page page = new Page(pageNum, pageSize);
            fscOrderPOList = this.fscOrderMapper.getPayOrdersListPage(fscOrderPO, page);
            if (ObjectUtil.isEmpty(fscOrderPOList)) {
                log.info("\u540c\u6b65\u4ed8\u6b3e\u5355\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a");
                break;
            }
            pageSize = fscOrderPOList.size();
            ++pageNum;
            for (FscOrderPO orderPO : fscOrderPOList) {
                this.syncOrderStatus(orderPO.getFscOrderId());
            }
        }
        return new FscSyncPayOrderToUocRspBO();
    }

    private void syncOrderStatus(Long fscPayOrderId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId);
        Map<Long, FscShouldPayPO> fscShouldPayPOMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getObjectId, FscShouldPayPO2 -> FscShouldPayPO2));
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            return;
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(fscShouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        List orderList = this.fscOrderMapper.getList(fscOrderPo);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(orderList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList()));
        List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
            fscUocProOrderPaymentCallbackAbilityReqBO.setUocPaymentCallbackBOS(fscOrderRelationPOs.stream().map(fscPaySuccessCallBackOrderBO -> {
                FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBO = new FscUocProOrderPaymentCallbackAbilityBO();
                fscUocProOrderPaymentCallbackAbilityBO.setSaleOrderId(fscPaySuccessCallBackOrderBO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayMod(Integer.valueOf(30));
                fscUocProOrderPaymentCallbackAbilityBO.setObjectId(fscPaySuccessCallBackOrderBO.getAcceptOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayerType(FscConstants.FscOrderReceiveType.PURCHASE.equals(((FscOrderPO)orderList.get(0)).getReceiveType()) ? "pur" : "pro");
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(Boolean.valueOf(true));
                fscUocProOrderPaymentCallbackAbilityBO.setShouldPayMoney(fscPaySuccessCallBackOrderBO.getOrderTotalCharge());
                fscUocProOrderPaymentCallbackAbilityBO.setFscShouldPayId(((FscShouldPayPO)fscShouldPayPOMap.get(fscPaySuccessCallBackOrderBO.getFscOrderId())).getShouldPayId());
                return fscUocProOrderPaymentCallbackAbilityBO;
            }).collect(Collectors.toList()));
            log.info("\u540c\u6b65\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscUocProOrderPaymentCallbackAbilityReqBO));
            this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
        }
    }
}

