/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcQryAutoPaymentRuleAbilityService;
import com.tydic.cfc.ability.api.CfcQryFinancialTypeQryParentAbilityService;
import com.tydic.cfc.ability.api.CfcUniteParamQryListPageAbilityService;
import com.tydic.cfc.ability.bo.CfcQryAutoPaymentRuleAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryAutoPaymentRuleAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcQryFinancialTypeQryParentBO;
import com.tydic.cfc.ability.bo.CfcQryFinancialTypeQryParentReqBO;
import com.tydic.cfc.ability.bo.CfcQryFinancialTypeQryParentRspBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityRspBO;
import com.tydic.commodity.common.ability.api.UccbBatchQryCatalogRelListAbilityService;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.service.domainservice.UocOrderExtInspItemPageQryExtService;
import com.tydic.fsc.busibase.external.api.bo.FscUocAcceptOrderCommodityInfoExtBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderMsgLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscSendPayBillOrderToXhSrmAtomService;
import com.tydic.fsc.pay.atom.bo.FscSendPayBillOrderToXhSrmAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendPayBillOrderToXhSrmAtomRspBO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderMsgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.umc.general.ability.api.CrcQryMainUserInfoByPartIdAbilityService;
import com.tydic.umc.general.ability.api.UmcQryOrgAccountCodeByOrgIdAbilityService;
import com.tydic.umc.general.ability.api.UmcQrySupplierInfoAbilityService;
import com.tydic.umc.general.ability.bo.CrcQryMainUserInfoByPartIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryMainUserInfoByPartIdAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQrySupplierInfoAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQrySupplierInfoAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscSendPayBillOrderToXhSrmAtomServiceImpl
implements FscSendPayBillOrderToXhSrmAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSendPayBillOrderToXhSrmAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private CrcQryMainUserInfoByPartIdAbilityService crcQryMainUserInfoByPartIdAbilityService;
    @Autowired
    private UmcQryOrgAccountCodeByOrgIdAbilityService umcQryOrgAccountCodeByOrgIdAbilityService;
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    @Autowired
    private UccbBatchQryCatalogRelListAbilityService uccbBatchQryCatalogRelListAbilityService;
    @Autowired
    private UmcQrySupplierInfoAbilityService umcQrySupplierInfoAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private CfcQryAutoPaymentRuleAbilityService cfcQryAutoPaymentRuleAbilityService;
    @Autowired
    private FscOrderMsgLogMapper fscOrderMsgLogMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Value(value="${opertionWithdrawalOrgId}")
    private Long opertionWithdrawalOrgId;
    @Value(value="${secondOrgId.sn:823263047433240576}")
    private Long SECONDORGID_SN;
    @Value(value="${ESB_SEND_PAY_ORDER_XH_URL}")
    private String ESB_SEND_PAY_ORDER_XH_URL;
    @Value(value="${ESB_SEND_PAY_ORDER_SN_URL}")
    private String ESB_SEND_PAY_ORDER_SN_URL;
    @Autowired
    private CfcQryFinancialTypeQryParentAbilityService cfcQryFinancialTypeQryParentAbilityService;
    @Autowired
    private UocOrderExtInspItemPageQryExtService uocOrderExtInspItemPageQryExtService;
    @Autowired
    private CfcUniteParamQryListPageAbilityService cfcUniteParamQryListPageAbilityService;

    @Override
    public FscSendPayBillOrderToXhSrmAtomRspBO sendPayBillOrderToXhSrm(FscSendPayBillOrderToXhSrmAtomReqBO reqBO) {
        FscSendPayBillOrderToXhSrmAtomRspBO rspBO = new FscSendPayBillOrderToXhSrmAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        String sendParams = null;
        try {
            sendParams = this.initPostStr(reqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4ed8\u6b3e\u5355\u63a8\u9001\u96ea\u82b1SRM\u7cfb\u7edf\u5931\u8d25:{}", (Object)e.getMessage());
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderPO.setSyncTime(new Date(System.currentTimeMillis()));
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setSyncFailReason("\u96ea\u82b1\u4ed8\u6b3e\u5355\u540c\u6b65-\u53c2\u6570\u83b7\u53d6\u9519\u8bef:" + (ObjectUtil.isEmpty((Object)e.getMessage()) ? "\u5931\u8d25" : e.getMessage()));
            fscOrderPO.setSendExtSystemCount(Integer.valueOf(1));
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            return rspBO;
        }
        String sendUrl = this.ESB_SEND_PAY_ORDER_XH_URL;
        if (reqBO.getSecondOrgId().equals(this.SECONDORGID_SN)) {
            sendUrl = this.ESB_SEND_PAY_ORDER_SN_URL;
        }
        log.info("\u96ea\u82b1\u4ed8\u6b3e\u5355\u63a8\u9001SRM\u8bf7\u6c42\u5730\u5740:{}", (Object)sendUrl);
        log.info("\u96ea\u82b1\u4ed8\u6b3e\u5355\u63a8\u9001SRM\u8bf7\u6c42\u53c2\u6570:{}", (Object)sendParams);
        String returnString = SSLClient.doPost((String)sendUrl, (String)sendParams);
        log.info("\u96ea\u82b1\u4ed8\u6b3e\u5355\u63a8\u9001SRM\u8bf7\u6c42\u54cd\u5e94:{}", (Object)returnString);
        FscOrderMsgLogPO fscOrderMsgLogPO = new FscOrderMsgLogPO();
        fscOrderMsgLogPO.setSendUrl(sendUrl);
        fscOrderMsgLogPO.setSendContent(sendParams);
        fscOrderMsgLogPO.setMsgContent(returnString);
        fscOrderMsgLogPO.setObjId(reqBO.getFscOrderId());
        fscOrderMsgLogPO.setPushTime(new Date());
        if (ObjectUtil.isEmpty((Object)returnString)) {
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8c03\u7528ESB\u63a5\u53e3\u96ea\u82b1\u4ed8\u6b3e\u5355\u63a8\u9001SRM\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            this.writeLog(fscOrderMsgLogPO);
            throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u96ea\u82b1\u4ed8\u6b3e\u5355\u63a8\u9001SRM\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        this.resolveRsp(returnString, reqBO, fscOrderMsgLogPO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        return rspBO;
    }

    private void val(FscSendPayBillOrderToXhSrmAtomReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String initPostStr(FscSendPayBillOrderToXhSrmAtomReqBO reqBO) {
        JSONObject postJson = new JSONObject();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO payOrderInfo = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtil.isEmpty((Object)payOrderInfo)) {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        reqBO.setSecondOrgId(payOrderInfo.getSecondOrgId());
        List fscOrderPOList = this.fscOrderMapper.getJSDbyFKDid(reqBO.getFscOrderId());
        if (ObjectUtil.isEmpty((Object)fscOrderPOList)) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        JSONObject reqJson = new JSONObject();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (FscOrderPO item : fscOrderPOList) {
            FscLegalCompanyPO fscLegalCompanyPO;
            UmcQryOrgAccountCodeByOrgIdAbilityRspBO umcQryOrgAccountCodeByOrgIdAbilityRspBO;
            FscOrderItemPO fscOrderItem = new FscOrderItemPO();
            fscOrderItem.setFscOrderId(item.getFscOrderId());
            List fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItem);
            if (ObjectUtil.isEmpty((Object)fscOrderItemList)) {
                throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
            }
            List catalogNameList = fscOrderItemList.stream().map(FscOrderItemPO::getL1CatalogName).collect(Collectors.toList());
            UccbBatchQryCatalogRelListAbilityReqBO relListAbilityReqBO = new UccbBatchQryCatalogRelListAbilityReqBO();
            relListAbilityReqBO.setCatalogNames(catalogNameList);
            log.info("\u63a8\u9001\u7a0e\u63a7-\u67e5\u8be2\u4e1a\u52a1\u5c0f\u7c7b\u5165\u53c2:{}", (Object)relListAbilityReqBO);
            UccbBatchQryCatalogRelListAbilityRspBO rspBO = this.uccbBatchQryCatalogRelListAbilityService.batchQryCatalogRelList(relListAbilityReqBO);
            log.info("\u63a8\u9001\u7a0e\u63a7-\u67e5\u8be2\u4e1a\u52a1\u5c0f\u7c7b\u51fa\u53c2:{}", (Object)rspBO);
            if (ObjectUtil.isEmpty((Object)rspBO.getRows())) {
                throw new FscBusinessException("191000", "\u914d\u7f6e\u9879\u201cZFJS33\u5546\u54c1\u4e00\u7ea7\u7269\u6599\u5206\u7c7b\u4e0e\u62a5\u8d26\u7c7b\u76ee\u5bf9\u5e94\u5173\u7cfb\u201d\u6570\u636e\u4e0d\u5b8c\u6574\u3002");
            }
            if (!ObjectUtil.isEmpty((Object)rspBO.getRows())) {
                Map<String, List<UccbBatchQryCatalogRelListBO>> uccbBatchQryCatalogRelListBOList = rspBO.getRows().stream().collect(Collectors.groupingBy(UccbBatchQryCatalogRelListBO::getCatalogName));
                fscOrderItemList.forEach(orderItemPO -> {
                    if (!ObjectUtil.isEmpty(uccbBatchQryCatalogRelListBOList.get(orderItemPO.getL1CatalogName()))) {
                        orderItemPO.setBussiCatalogCode(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(orderItemPO.getL1CatalogName())).get(0)).getBussiCatalogCode());
                        orderItemPO.setBussiCatalogName(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(orderItemPO.getL1CatalogName())).get(0)).getBussiCatalogName());
                        orderItemPO.setSalesReceiptsStatement(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(orderItemPO.getL1CatalogName())).get(0)).getSalesReceiptsStatement());
                        orderItemPO.setCatalogName(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(orderItemPO.getL1CatalogName())).get(0)).getCatalogName());
                    }
                });
            }
            CfcQryFinancialTypeQryParentReqBO cfcQryFinancialTypeQryParentReqBO = new CfcQryFinancialTypeQryParentReqBO();
            String classofBusiness = "";
            String classofBusinessName = "";
            String subCategoryCode = "";
            String subCategoryName = "";
            if (ObjectUtil.isNotEmpty((Object)item.getFscBusiType())) {
                ArrayList<String> financialIdList = new ArrayList<String>();
                financialIdList.add(item.getFscBusiType());
                cfcQryFinancialTypeQryParentReqBO.setFinancialTypeCode(financialIdList);
                log.info("\u67e5\u8be2\u8d39\u7528\u7c7b\u578b\u4e0a\u7ea7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)cfcQryFinancialTypeQryParentReqBO));
                CfcQryFinancialTypeQryParentRspBO financialTypeQryParentRspBO = this.cfcQryFinancialTypeQryParentAbilityService.qryParentFinancialType(cfcQryFinancialTypeQryParentReqBO);
                log.info("\u67e5\u8be2\u8d39\u7528\u7c7b\u578b\u4e0a\u7ea7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)financialTypeQryParentRspBO));
                if (!"0000".equals(financialTypeQryParentRspBO.getRespCode())) {
                    log.info("\u67e5\u8be2\u8d39\u7528\u7c7b\u578b\u4e0a\u7ea7\u9519\u8bef");
                    throw new ZTBusinessException("\u67e5\u8be2\u8d39\u7528\u7c7b\u578b\u4e0a\u7ea7\u9519\u8bef");
                }
                List financialTypeQryParentBOS = financialTypeQryParentRspBO.getFinancialList();
                if (ObjectUtil.isNotEmpty((Object)financialTypeQryParentBOS)) {
                    classofBusiness = ((CfcQryFinancialTypeQryParentBO)financialTypeQryParentBOS.get(0)).getParentFinancialTypeCode();
                    classofBusinessName = ((CfcQryFinancialTypeQryParentBO)financialTypeQryParentBOS.get(0)).getParentFinancialTypeName();
                    subCategoryCode = ((CfcQryFinancialTypeQryParentBO)financialTypeQryParentBOS.get(0)).getFinancialTypeCode();
                    subCategoryName = ((CfcQryFinancialTypeQryParentBO)financialTypeQryParentBOS.get(0)).getFinancialTypeName();
                }
            }
            BigDecimal totalAmountWithoutTax = fscOrderItemList.stream().map(FscOrderItemPO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalTax = fscOrderItemList.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            reqJson.put("processNo", (Object)Sequence.getInstance().nextId());
            reqJson.put("requestTime", (Object)DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            reqJson.put("purchase_flag", (Object)"0");
            JSONArray statementMain = new JSONArray();
            JSONObject statementInfo = new JSONObject();
            statementInfo.put("statementHeaderId", (Object)item.getFscOrderId());
            statementInfo.put("statementNo", (Object)item.getOrderNo());
            statementInfo.put("payId", (Object)payOrderInfo.getFscOrderId());
            statementInfo.put("payCode", (Object)payOrderInfo.getOrderNo());
            statementInfo.put("statementDate", (Object)DateUtil.dateToStr((Date)payOrderInfo.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            UmcQryOrgAccountCodeByOrgIdAbilityReqBO umcQryOrgAccountCodeByOrgIdAbilityReqBO = new UmcQryOrgAccountCodeByOrgIdAbilityReqBO();
            if (("2".equals(item.getOrderSource().toString()) || "3".equals(item.getOrderSource().toString())) && item.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION) && item.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE)) {
                statementInfo.put("supplierCode", (Object)"S00043612");
                statementInfo.put("supplierName", (Object)"\u534e\u6da6\u5b88\u6b63\u62db\u6807\u6709\u9650\u516c\u53f8");
            } else {
                umcQryOrgAccountCodeByOrgIdAbilityReqBO.setOrgId(item.getSupplierId());
                log.info("\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546mdm\u7f16\u7801\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityReqBO));
                umcQryOrgAccountCodeByOrgIdAbilityRspBO = this.umcQryOrgAccountCodeByOrgIdAbilityService.qryOrgAccountCodeByOrgId(umcQryOrgAccountCodeByOrgIdAbilityReqBO);
                log.info("\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546mdm\u7f16\u7801\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityRspBO));
                String orgAccountSupCode = umcQryOrgAccountCodeByOrgIdAbilityRspBO.getCorporationCode();
                statementInfo.put("supplierCode", (Object)orgAccountSupCode);
                statementInfo.put("supplierName", (Object)item.getSupplierName());
            }
            statementInfo.put("companyName", (Object)item.getPurchaserName());
            umcQryOrgAccountCodeByOrgIdAbilityReqBO.setOrgId(item.getPurchaserId());
            log.info("\u67e5\u8be2\u4f1a\u5458\u91c7\u8d2d\u5355\u4f4d\u7f16\u7801\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityReqBO));
            umcQryOrgAccountCodeByOrgIdAbilityRspBO = this.umcQryOrgAccountCodeByOrgIdAbilityService.qryOrgAccountCodeByOrgId(umcQryOrgAccountCodeByOrgIdAbilityReqBO);
            log.info("\u67e5\u8be2\u4f1a\u5458\u91c7\u8d2d\u5355\u4f4d\u7f16\u7801\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcQryOrgAccountCodeByOrgIdAbilityRspBO));
            String orgAccountPurCode = ObjectUtil.isEmpty((Object)umcQryOrgAccountCodeByOrgIdAbilityRspBO.getOrgAccountCode()) ? "0" : umcQryOrgAccountCodeByOrgIdAbilityRspBO.getOrgAccountCode();
            statementInfo.put("ouCode", (Object)orgAccountPurCode);
            statementInfo.put("ouName", (Object)item.getPurchaserName());
            statementInfo.put("meetingExpenses", (Object)item.getFscBusiTypeItemName());
            if (("2".equals(item.getOrderSource().toString()) || "3".equals(item.getOrderSource().toString())) && item.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION) && item.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE)) {
                fscLegalCompanyPO = this.fscLegalCompanyMapper.getByOrgId(this.opertionWithdrawalOrgId);
                CfcUniteParamQryListPageAbilityReqBO cfcUniteParamQryListPageAbilityReqBO1 = new CfcUniteParamQryListPageAbilityReqBO();
                cfcUniteParamQryListPageAbilityReqBO1.setId(FscConstants.TRADE_MODEL.SALE_ORDER_FEE);
                CfcUniteParamQryListPageAbilityRspBO cfcUniteParamQryListPageAbilityRspBO1 = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(cfcUniteParamQryListPageAbilityReqBO1);
                log.info("\u83b7\u53d6\u8fd0\u8425\u63d0\u73b0\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)cfcUniteParamQryListPageAbilityRspBO1.getRows()));
                FscAccountPO fscAccountPO = new FscAccountPO();
                fscAccountPO.setOrgId(this.opertionWithdrawalOrgId);
                fscAccountPO.setRecvSubLedgerAcctNo(((JSONObject)cfcUniteParamQryListPageAbilityRspBO1.getRows().get(0)).get((Object)"payeeAccountNo").toString());
                fscAccountPO.setStatus(Integer.valueOf(1));
                List accountPOList = this.fscAccountMapper.getList(fscAccountPO);
                statementInfo.put("ratepayingSalerCode", (Object)fscLegalCompanyPO.getOrgCertificateCode());
                statementInfo.put("ratepayingSalerName", (Object)(ObjectUtil.isEmpty((Object)accountPOList) ? "" : ((FscAccountPO)accountPOList.get(0)).getLegalName()));
                statementInfo.put("supplierBankAccount", (Object)(ObjectUtil.isEmpty((Object)accountPOList) ? "" : ((FscAccountPO)accountPOList.get(0)).getRecvSubLedgerAcctNo()));
                statementInfo.put("supplierBankName", (Object)(ObjectUtil.isEmpty((Object)accountPOList) ? "" : ((FscAccountPO)accountPOList.get(0)).getRecvSubLedgerBankName()));
                statementInfo.put("supplierBankAccountName", (Object)(ObjectUtil.isEmpty((Object)accountPOList) ? "" : ((FscAccountPO)accountPOList.get(0)).getRecvSubLedgerAcctName()));
                statementInfo.put("supplierContactName", (Object)(ObjectUtil.isEmpty((Object)accountPOList) ? "" : ((FscAccountPO)accountPOList.get(0)).getTransactorName()));
                statementInfo.put("supplierContactTel", (Object)(ObjectUtil.isEmpty((Object)accountPOList) ? "" : ((FscAccountPO)accountPOList.get(0)).getTransactorPhone()));
                statementInfo.put("supplierContactMail", (Object)"");
            } else {
                fscLegalCompanyPO = this.fscLegalCompanyMapper.getByOrgId(item.getSupplierId());
                FscAccountPO fscAccountPO = new FscAccountPO();
                fscAccountPO.setOrgId(item.getSupplierId());
                fscAccountPO.setStatus(Integer.valueOf(1));
                fscAccountPO.setRecvSubLedgerAcctNo(payOrderInfo.getPayeeBankAccount());
                List accountPOList = this.fscAccountMapper.getList(fscAccountPO);
                statementInfo.put("ratepayingSalerCode", (Object)fscLegalCompanyPO.getOrgCertificateCode());
                statementInfo.put("ratepayingSalerName", (Object)(ObjectUtil.isEmpty((Object)accountPOList) ? "" : ((FscAccountPO)accountPOList.get(0)).getLegalName()));
                statementInfo.put("supplierBankAccount", (Object)(ObjectUtil.isEmpty((Object)accountPOList) ? "" : ((FscAccountPO)accountPOList.get(0)).getRecvSubLedgerAcctNo()));
                statementInfo.put("supplierBankName", (Object)(ObjectUtil.isEmpty((Object)accountPOList) ? "" : ((FscAccountPO)accountPOList.get(0)).getRecvSubLedgerBankName()));
                statementInfo.put("supplierBankAccountName", (Object)(ObjectUtil.isEmpty((Object)accountPOList) ? "" : ((FscAccountPO)accountPOList.get(0)).getRecvSubLedgerAcctName()));
                UmcQrySupplierInfoAbilityReqBO umcQrySupplierInfoAbilityReqBO = new UmcQrySupplierInfoAbilityReqBO();
                umcQrySupplierInfoAbilityReqBO.setSupId(item.getSupplierId());
                log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)umcQrySupplierInfoAbilityReqBO));
                UmcQrySupplierInfoAbilityRspBO umcQrySupplierInfoAbilityRspBO = this.umcQrySupplierInfoAbilityService.qrySupplierInfo(umcQrySupplierInfoAbilityReqBO);
                log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)umcQrySupplierInfoAbilityRspBO));
                if (!"0000".equals(umcQrySupplierInfoAbilityRspBO.getRespCode())) {
                    log.info("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u9519\u8bef");
                    throw new FscBusinessException("191000", "\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u9519\u8bef");
                }
                statementInfo.put("supplierContactName", (Object)(ObjectUtil.isEmpty((Object)umcQrySupplierInfoAbilityRspBO.getUmcCorporationInfoBO().getRemark()) ? "" : umcQrySupplierInfoAbilityRspBO.getUmcCorporationInfoBO().getRemark()));
                statementInfo.put("supplierContactTel", (Object)(ObjectUtil.isEmpty((Object)umcQrySupplierInfoAbilityRspBO.getUmcCorporationInfoBO().getPhone()) ? "" : umcQrySupplierInfoAbilityRspBO.getUmcCorporationInfoBO().getPhone()));
                statementInfo.put("supplierContactMail", (Object)"");
            }
            statementInfo.put("totalAmountWithTax", (Object)String.valueOf(item.getTotalCharge().setScale(2, 4)));
            statementInfo.put("totalAmountWithoutTax", (Object)String.valueOf(totalAmountWithoutTax.setScale(2, 4)));
            statementInfo.put("totalTax", (Object)String.valueOf(totalTax.setScale(2, 4)));
            statementInfo.put("statementStatus", (Object)"CONFIRMED");
            statementInfo.put("source", (Object)"ECP");
            CrcQryMainUserInfoByPartIdAbilityReqBO crcQryMainUserInfoByPartIdAbilityReqBO = new CrcQryMainUserInfoByPartIdAbilityReqBO();
            crcQryMainUserInfoByPartIdAbilityReqBO.setMemId(item.getCreateOperId());
            log.info("\u8c03\u7528\u4f1a\u5458\u83b7\u53d6\u4e3b\u8d26\u53f7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityReqBO));
            CrcQryMainUserInfoByPartIdAbilityRspBO crcQryMainUserInfoByPartIdAbilityRspBO = this.crcQryMainUserInfoByPartIdAbilityService.qryMainUserInfoByPartId(crcQryMainUserInfoByPartIdAbilityReqBO);
            log.info("\u8c03\u7528\u4f1a\u5458\u83b7\u53d6\u4e3b\u8d26\u53f7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityRspBO));
            if (!"0000".equals(crcQryMainUserInfoByPartIdAbilityRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u8c03\u7528\u4f1a\u5458\u5f02\u5e38\uff1a" + crcQryMainUserInfoByPartIdAbilityRspBO.getRespDesc());
            }
            String creatorLdap = crcQryMainUserInfoByPartIdAbilityRspBO.getMainMemInformation().getRegAccount();
            statementInfo.put("createUserId", (Object)creatorLdap);
            CfcQryAutoPaymentRuleAbilityReqBO cfcQryAutoPaymentRuleAbilityReqBO = new CfcQryAutoPaymentRuleAbilityReqBO();
            cfcQryAutoPaymentRuleAbilityReqBO.setCorporationId(item.getPurchaserId());
            cfcQryAutoPaymentRuleAbilityReqBO.setOrgIdWeb(item.getSecondOrgId());
            log.info("\u81ea\u52a8\u751f\u6210\u7ed3\u7b97\u5355\u914d\u7f6e\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)cfcQryAutoPaymentRuleAbilityReqBO));
            CfcQryAutoPaymentRuleAbilityRspBO cfcQryAutoPaymentRuleAbilityRspBO = this.cfcQryAutoPaymentRuleAbilityService.qryAutoPaymentRule(cfcQryAutoPaymentRuleAbilityReqBO);
            log.info("\u81ea\u52a8\u751f\u6210\u7ed3\u7b97\u5355\u914d\u7f6e\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)cfcQryAutoPaymentRuleAbilityRspBO));
            if (!"0000".equals(cfcQryAutoPaymentRuleAbilityRspBO.getRespCode())) {
                log.info("\u81ea\u52a8\u751f\u6210\u7ed3\u7b97\u5355\u914d\u7f6e\u67e5\u8be2\u9519\u8bef:{}", (Object)cfcQryAutoPaymentRuleAbilityRspBO.getRespDesc());
                continue;
            }
            statementInfo.put("createUserName", (Object)cfcQryAutoPaymentRuleAbilityRspBO.getApplicantUserName());
            statementInfo.put("createTime", (Object)DateUtil.dateToStr((Date)item.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            statementInfo.put("supplierLocation", (Object)"");
            statementInfo.put("pushFlag", (Object)1);
            JSONArray statementDetail = new JSONArray();
            Set acceptIds = fscOrderItemList.stream().map(FscOrderItemPO::getAcceptOrderId).collect(Collectors.toSet());
            FscUocInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBO = new FscUocInspectionDetailsListPageQueryReqBO();
            fscUocInspectionDetailsListPageQueryReqBO.setPageSize(Integer.valueOf(1000));
            fscUocInspectionDetailsListPageQueryReqBO.setInspOrderIdList(new ArrayList(acceptIds));
            fscUocInspectionDetailsListPageQueryReqBO.setCanSettleChng(Boolean.valueOf(true));
            log.info("\u96ea\u82b1\u63a8\u9001\u4ed8\u6b3e\u5355-\u83b7\u53d6\u9a8c\u6536\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscUocInspectionDetailsListPageQueryReqBO));
            FscUocInspectionDetailsListPageQueryRspBO fscUocInspectionDetailsListPageQueryRspBO = this.fscUocInspectionDetailsListPageQueryService.getInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBO);
            if (!"0000".equals(fscUocInspectionDetailsListPageQueryRspBO.getRespCode())) {
                log.info("\u96ea\u82b1\u63a8\u9001\u4ed8\u6b3e\u5355-\u83b7\u53d6\u9a8c\u6536\u5355\u5931\u8d25");
                throw new FscBusinessException("198888", "\u83b7\u53d6\u9a8c\u6536\u5355\u9519\u8bef");
            }
            if (ObjectUtil.isEmpty((Object)fscUocInspectionDetailsListPageQueryRspBO.getRows())) {
                log.info("\u96ea\u82b1\u63a8\u9001\u4ed8\u6b3e\u5355-\u83b7\u53d6\u9a8c\u6536\u5355\u6570\u636e\u4e3a\u7a7a");
                throw new FscBusinessException("198888", "\u83b7\u53d6\u9a8c\u6536\u5355\u6570\u636e\u4e3a\u7a7a");
            }
            Map<Long, List<FscUocInspectionDetailsListBO>> acceptListMap = fscUocInspectionDetailsListPageQueryRspBO.getRows().stream().collect(Collectors.groupingBy(o -> o.getAcceptOrderId()));
            Map<Long, List<FscOrderItemPO>> fscOrderItemMapList = fscOrderItemList.stream().collect(Collectors.groupingBy(FscOrderItemPO::getOrderId));
            HashSet<Long> inspOrderItemList = new HashSet<Long>();
            for (FscOrderItemPO fscOrderItemPO : fscOrderItemList) {
                FscUocInspectionDetailsListBO acceptInfo = acceptListMap.get(fscOrderItemPO.getAcceptOrderId()).get(0);
                Map<String, List<FscUocAcceptOrderCommodityInfoExtBO>> acceptOrderCommodityInfoMapList = acceptInfo.getAcceptOrderCommodityInfo().stream().collect(Collectors.groupingBy(FscUocAcceptOrderCommodityInfoExtBO::getSkuId));
                FscUocAcceptOrderCommodityInfoExtBO acceptOrderCommodityInfo = null;
                if (!ObjectUtil.isEmpty(acceptOrderCommodityInfoMapList.get(fscOrderItemPO.getSkuId().toString()))) {
                    List<FscUocAcceptOrderCommodityInfoExtBO> tempList = acceptOrderCommodityInfoMapList.get(fscOrderItemPO.getSkuId().toString());
                    for (FscUocAcceptOrderCommodityInfoExtBO fscUocAcceptOrderCommodityInfoExtBO : tempList) {
                        if (inspOrderItemList.contains(fscUocAcceptOrderCommodityInfoExtBO.getInspOrderItemId())) continue;
                        acceptOrderCommodityInfo = fscUocAcceptOrderCommodityInfoExtBO;
                        inspOrderItemList.add(fscUocAcceptOrderCommodityInfoExtBO.getInspOrderItemId());
                        break;
                    }
                }
                statementInfo.put("contract", (Object)acceptInfo.getEntAgreementCode());
                JSONObject statementDetailInfo = new JSONObject();
                statementDetailInfo.put("poHeaderId", (Object)acceptInfo.getSaleOrderId());
                statementDetailInfo.put("poNum", (Object)acceptInfo.getSaleOrderNo());
                crcQryMainUserInfoByPartIdAbilityReqBO.setMemId(acceptInfo.getOrderCreateOperId());
                crcQryMainUserInfoByPartIdAbilityRspBO = this.crcQryMainUserInfoByPartIdAbilityService.qryMainUserInfoByPartId(crcQryMainUserInfoByPartIdAbilityReqBO);
                log.info("\u83b7\u53d6\u4f1a\u5458\u8d26\u53f7:{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityRspBO));
                statementDetailInfo.put("agentCode", (Object)crcQryMainUserInfoByPartIdAbilityRspBO.getMainMemInformation().getRegAccount());
                statementDetailInfo.put("agentName", (Object)acceptInfo.getOrderCreateOperName());
                statementDetailInfo.put("PoCreateUserId", (Object)crcQryMainUserInfoByPartIdAbilityRspBO.getMainMemInformation().getRegAccount());
                statementDetailInfo.put("confirmedFlag", (Object)1);
                statementDetailInfo.put("currencyCode", (Object)"CNY");
                List<FscOrderItemPO> fscOrderItemPOList1 = fscOrderItemMapList.get(fscOrderItemPO.getOrderId());
                BigDecimal amount = fscOrderItemPOList1.stream().map(FscOrderItemPO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                statementDetailInfo.put("amount", (Object)String.valueOf(acceptInfo.getSaleOrderTotalUntaxAmtAmount()));
                BigDecimal taxIncludedAmount = fscOrderItemPOList1.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                statementDetailInfo.put("taxIncludedAmount", (Object)String.valueOf(acceptInfo.getSaleOrderTotalAmtAmount()));
                statementDetailInfo.put("poHeaderRemark", (Object)"");
                statementDetailInfo.put("paymentCode", (Object)"TRANSFER");
                statementDetailInfo.put("taxRate", (Object)fscOrderItemPO.getTaxRate().multiply(new BigDecimal(100)).setScale(0, 4));
                statementDetailInfo.put("taxAmount", (Object)String.valueOf(fscOrderItemPO.getTaxAmt().setScale(2, 4)));
                statementDetailInfo.put("poLineId", (Object)acceptOrderCommodityInfo.getSaleOrderItemId());
                statementDetailInfo.put("poLineNum", (Object)acceptOrderCommodityInfo.getSkuCode());
                statementDetailInfo.put("itemCode", (Object)"");
                statementDetailInfo.put("itemName", (Object)fscOrderItemPO.getSkuName());
                statementDetailInfo.put("category", (Object)"");
                statementDetailInfo.put("poQuantity", (Object)acceptOrderCommodityInfo.getPurchaseCount());
                statementDetailInfo.put("receiptId", (Object)acceptOrderCommodityInfo.getInspOrderItemId());
                statementDetailInfo.put("quantity", (Object)acceptOrderCommodityInfo.getInspCount().setScale(6, 4));
                statementDetailInfo.put("uom", (Object)fscOrderItemPO.getUnit());
                statementDetailInfo.put("unitPrice", (Object)String.valueOf(fscOrderItemPO.getPrice().setScale(10, RoundingMode.HALF_UP).divide(fscOrderItemPO.getTaxRate().add(new BigDecimal("1")).setScale(10, RoundingMode.HALF_UP), 2, 4)));
                statementDetailInfo.put("enteredTaxIncludedPrice", (Object)String.valueOf(fscOrderItemPO.getPrice().setScale(10, 4)));
                statementDetailInfo.put("lineAmount", (Object)String.valueOf(fscOrderItemPO.getUntaxAmt().setScale(2, 4)));
                statementDetailInfo.put("taxIncludedLineAmount", (Object)String.valueOf(fscOrderItemPO.getAmt().setScale(2, 4)));
                statementDetailInfo.put("model", (Object)(ObjectUtil.isEmpty((Object)fscOrderItemPO.getModel()) ? "" : fscOrderItemPO.getModel()));
                statementDetailInfo.put("specifications", (Object)(ObjectUtil.isEmpty((Object)fscOrderItemPO.getSpec()) ? "" : fscOrderItemPO.getSpec()));
                statementDetailInfo.put("brand", (Object)(ObjectUtil.isEmpty((Object)acceptOrderCommodityInfo.getSkuBrandName()) ? "" : acceptOrderCommodityInfo.getSkuBrandName()));
                statementDetailInfo.put("needDate", (Object)DateUtil.dateToStr((Date)acceptInfo.getAcceptTime(), (String)"yyyy-MM-dd"));
                statementDetailInfo.put("promiseDeliveryDate", (Object)DateUtil.dateToStr((Date)acceptInfo.getAcceptTime(), (String)"yyyy-MM-dd"));
                UmcQryOrgAccountCodeByOrgIdAbilityReqBO deptQryOrgAccountCodeReq = new UmcQryOrgAccountCodeByOrgIdAbilityReqBO();
                deptQryOrgAccountCodeReq.setDeptOrgId(acceptInfo.getPurOrgId());
                log.info("\u9a8c\u6536\u5355\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)acceptInfo));
                log.info("\u67e5\u8be2\u4f1a\u5458\u90e8\u95e8\u7f16\u7801\u5165\u53c2\uff1a" + JSON.toJSONString((Object)deptQryOrgAccountCodeReq));
                UmcQryOrgAccountCodeByOrgIdAbilityRspBO deptQryOrgAccountCodeRsp = this.umcQryOrgAccountCodeByOrgIdAbilityService.qryOrgAccountCodeByOrgId(deptQryOrgAccountCodeReq);
                log.info("\u67e5\u8be2\u4f1a\u5458\u90e8\u95e8\u7f16\u7801\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)deptQryOrgAccountCodeRsp));
                String orgAccountDeptCode = deptQryOrgAccountCodeRsp.getDeptId();
                statementDetailInfo.put("costCenterid", (Object)orgAccountDeptCode);
                statementDetailInfo.put("costCenterName", (Object)acceptInfo.getPurOrgName());
                statementDetailInfo.put("classofBusiness", (Object)classofBusiness);
                statementDetailInfo.put("classofBusinessName", (Object)classofBusinessName);
                statementDetailInfo.put("subCategoryCode", (Object)subCategoryCode);
                statementDetailInfo.put("subCategoryName", (Object)subCategoryName);
                statementDetailInfo.put("productNum", (Object)fscOrderItemPO.getSkuNo());
                statementDetailInfo.put("productName", (Object)fscOrderItemPO.getSkuName());
                statementDetailInfo.put("PolineRemark", (Object)"");
                String receiveAddr = (ObjectUtil.isEmpty((Object)acceptInfo.getOrderLogisticsRela().getContactProvinceName()) ? "" : acceptInfo.getOrderLogisticsRela().getContactProvinceName()) + (ObjectUtil.isEmpty((Object)acceptInfo.getOrderLogisticsRela().getContactCityName()) ? "" : acceptInfo.getOrderLogisticsRela().getContactCityName()) + (ObjectUtil.isEmpty((Object)acceptInfo.getOrderLogisticsRela().getContactCountyName()) ? "" : acceptInfo.getOrderLogisticsRela().getContactCountyName()) + (ObjectUtil.isEmpty((Object)acceptInfo.getOrderLogisticsRela().getContactTown()) ? "" : acceptInfo.getOrderLogisticsRela().getContactTown()) + (ObjectUtil.isEmpty((Object)acceptInfo.getOrderLogisticsRela().getContactAddress()) ? "" : acceptInfo.getOrderLogisticsRela().getContactAddress());
                statementDetailInfo.put("shipToThirdPartyAddress", (Object)receiveAddr);
                statementDetailInfo.put("shipToThirdPartyName", (Object)(ObjectUtil.isEmpty((Object)acceptInfo.getOrderLogisticsRela().getContactName()) ? "" : acceptInfo.getOrderLogisticsRela().getContactName()));
                statementDetailInfo.put("finalAmount", (Object)item.getTotalCharge().setScale(2, 4));
                statementDetail.add((Object)statementDetailInfo);
            }
            statementInfo.put("Statement_Detail", (Object)statementDetail);
            statementMain.add((Object)statementInfo);
            reqJson.put("Statement_Main", (Object)statementMain);
        }
        postJson.put("payload", (Object)JSON.toJSONString((Object)reqJson));
        log.info("\u96ea\u82b1\u63a8\u9001SRM-\u51fa\u53c2:{}", (Object)postJson.toJSONString());
        return postJson.toString();
    }

    private void resolveRsp(String returnString, FscSendPayBillOrderToXhSrmAtomReqBO atomReqBO, FscOrderMsgLogPO fscOrderMsgLogPO) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519:" + e.getMessage());
            this.writeLog(fscOrderMsgLogPO);
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(atomReqBO.getFscOrderId());
        fscOrderPO.setSyncTime(new Date(System.currentTimeMillis()));
        if (null == rspJsonObject.getJSONObject("RESPONSE") || null == rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA")) {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setSyncFailReason("\u96ea\u82b1\u4ed8\u6b3e\u5355\u540c\u6b65:ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            fscOrderPO.setSendExtSystemCount(Integer.valueOf(1));
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u96ea\u82b1\u4ed8\u6b3e\u5355\u540c\u6b65:ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.writeLog(fscOrderMsgLogPO);
            return;
        }
        if (rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"status").equals("SUCC")) {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.APPLYING);
            fscOrderPO.setSyncFailReason("");
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("1");
            this.writeLog(fscOrderMsgLogPO);
        } else {
            String str = "\u5bf9\u8d26\u5355\u91cd\u590d\u63a8\u9001";
            if (rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString().indexOf(str) != -1) {
                fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.APPLYING);
                fscOrderPO.setSyncFailReason("");
                this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
                fscOrderMsgLogPO.setResultString("1");
                this.writeLog(fscOrderMsgLogPO);
            } else {
                fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
                fscOrderPO.setSyncFailReason("\u96ea\u82b1\u4ed8\u6b3e\u5355\u540c\u6b65:" + rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
                fscOrderPO.setSendExtSystemCount(Integer.valueOf(1));
                this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
                fscOrderMsgLogPO.setResultString("0");
                fscOrderMsgLogPO.setFailureReason("\u96ea\u82b1\u4ed8\u6b3e\u5355\u540c\u6b65:" + rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
                this.writeLog(fscOrderMsgLogPO);
            }
        }
    }

    private void writeLog(FscOrderMsgLogPO fscOrderMsgLogPO) {
        fscOrderMsgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderMsgLogPO.setMsgType(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_XH_SRM);
        fscOrderMsgLogPO.setObjType(FscConstants.FSC_ORDER_OUT_OBJ_TYPE.XH_SRM);
        fscOrderMsgLogPO.setCreateTime(new Date());
        this.fscOrderMsgLogMapper.insert(fscOrderMsgLogPO);
    }
}

