/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderMsgLogMapper;
import com.tydic.fsc.pay.atom.api.FscSendPaymentInsertMsgLogService;
import com.tydic.fsc.po.FscOrderMsgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscSendPaymentInsertMsgLogServiceImpl
implements FscSendPaymentInsertMsgLogService {
    private static final Logger log = LoggerFactory.getLogger(FscSendPaymentInsertMsgLogServiceImpl.class);
    @Autowired
    private FscOrderMsgLogMapper fscOrderMsgLogMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @Override
    public void insertMsgLog(FscOrderMsgLogPO fscOrderMsgLogPO) {
        fscOrderMsgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderMsgLogPO.setMsgType(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_FINANCIAL_SHARE);
        fscOrderMsgLogPO.setObjType(FscConstants.FSC_ORDER_OUT_OBJ_TYPE.FSC_ORDER);
        fscOrderMsgLogPO.setCreateTime(new Date());
        this.fscOrderMsgLogMapper.insert(fscOrderMsgLogPO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderMsgLogPO.getObjId());
        fscOrderPO.setSyncTime(new Date(System.currentTimeMillis()));
        fscOrderPO.setSendExtSystemCount(Integer.valueOf(1));
        fscOrderPO.setSyncTime(new Date(System.currentTimeMillis()));
        fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
        fscOrderPO.setSyncFailReason(fscOrderMsgLogPO.getFailureReason());
        this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderMsgLogPO.getObjId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

