/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscBankReceiptFileMapper;
import com.tydic.fsc.pay.ability.api.FscSendSmartAccountPayBillOrderAbilityService;
import com.tydic.fsc.pay.ability.bo.FscSendSmartAccountPayBillOrderAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscSendSmartAccountPayBillOrderAbilityRspBO;
import com.tydic.fsc.pay.atom.api.FscSendFeeServicePayBillOrderAtomService;
import com.tydic.fsc.pay.atom.api.FscSendPayBillOrderAtomService;
import com.tydic.fsc.pay.atom.bo.FscSendFeeServicePayBillOrderAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendPayBillOrderAtomReqBO;
import com.tydic.fsc.po.FscBankReceiptFilePO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscSendSmartAccountPayBillOrderAbilityService"})
public class FscSendSmartAccountPayBillOrderAbilityServiceImpl
implements FscSendSmartAccountPayBillOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscSendSmartAccountPayBillOrderAbilityServiceImpl.class);
    @Autowired
    private FscBankReceiptFileMapper fscBankReceiptFileMapper;
    @Autowired
    private FscSendPayBillOrderAtomService fscSendPayBillOrderAtomService;
    @Autowired
    private FscSendFeeServicePayBillOrderAtomService fscSendFeeServicePayBillOrderAtomService;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Value(value="${opertionWithdrawalOrgId}")
    private Long payeeId;
    @Value(value="${TRADE_SUB_ACCOUNT_NO:30012817000000}")
    private String tradeSubAccountNo;
    @Value(value="${MATCHMAKE_SUB_ACCOUNT_NO:30112817000002}")
    private String matchmakeSubAccountNo;

    @PostMapping(value={"sendSmartAccountPayBillOrder"})
    public FscSendSmartAccountPayBillOrderAbilityRspBO sendSmartAccountPayBillOrder(@RequestBody FscSendSmartAccountPayBillOrderAbilityReqBO reqBO) {
        FscSendSmartAccountPayBillOrderAbilityRspBO rspBO = new FscSendSmartAccountPayBillOrderAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscBankReceiptFilePO fscBankReceiptFilePO = new FscBankReceiptFilePO();
        if (!ObjectUtil.isEmpty((Object)reqBO.getBankReceiptFileDateStar()) && !ObjectUtil.isEmpty((Object)reqBO.getBankReceiptFileDateEnd())) {
            fscBankReceiptFilePO.setTradeDateStart(reqBO.getBankReceiptFileDateStar());
            fscBankReceiptFilePO.setTradeDateEnd(reqBO.getBankReceiptFileDateEnd());
        } else {
            Calendar curDate = Calendar.getInstance();
            curDate.setTime(new Date());
            curDate.add(5, -1);
            fscBankReceiptFilePO.setTradeDateStart(DateUtil.dateToStr((Date)curDate.getTime(), (String)"yyyyMMdd"));
            fscBankReceiptFilePO.setTradeDateEnd(DateUtil.dateToStr((Date)curDate.getTime(), (String)"yyyyMMdd"));
        }
        Date endDate = DateUtil.strToDate((String)fscBankReceiptFilePO.getTradeDateEnd(), (String)"yyyyMMdd");
        fscBankReceiptFilePO.setSyncStatus(Integer.valueOf(0));
        fscBankReceiptFilePO.setAccountNoType("2");
        fscBankReceiptFilePO.setPayeeId(this.payeeId);
        log.info("\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscBankReceiptFilePO));
        List fscBankReceiptFilePOList = this.fscBankReceiptFileMapper.getListBySz(fscBankReceiptFilePO);
        log.info("\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscBankReceiptFilePOList));
        if (!ObjectUtil.isEmpty((Object)fscBankReceiptFilePOList)) {
            HashMap<String, List<Long>> resultMap;
            ArrayList<Long> bankCheckIds = new ArrayList<Long>();
            ArrayList<Long> receiptFileIds = new ArrayList<Long>();
            BigDecimal withdrawalAmount = new BigDecimal(0);
            ArrayList<Long> servicePayBankCheckIds = new ArrayList<Long>();
            ArrayList<Long> servicePayReceiptFileIds = new ArrayList<Long>();
            BigDecimal servicePayWithdrawalAmount = new BigDecimal(0);
            for (FscBankReceiptFilePO bankReceiptFilePO : fscBankReceiptFilePOList) {
                if (this.tradeSubAccountNo.equals(bankReceiptFilePO.getPayeeSubAccountNo())) {
                    bankCheckIds.add(bankReceiptFilePO.getBankCheckId());
                    receiptFileIds.add(bankReceiptFilePO.getBankReceiptId());
                    withdrawalAmount = withdrawalAmount.add(bankReceiptFilePO.getTradeAmt());
                    continue;
                }
                if (!this.matchmakeSubAccountNo.equals(bankReceiptFilePO.getPayeeSubAccountNo())) continue;
                servicePayBankCheckIds.add(bankReceiptFilePO.getBankCheckId());
                servicePayReceiptFileIds.add(bankReceiptFilePO.getBankReceiptId());
                servicePayWithdrawalAmount = servicePayWithdrawalAmount.add(bankReceiptFilePO.getTradeAmt());
            }
            if (ObjectUtil.isNotEmpty(bankCheckIds)) {
                FscSendPayBillOrderAtomReqBO fscSendPayBillOrderAtomReqBO = new FscSendPayBillOrderAtomReqBO();
                fscSendPayBillOrderAtomReqBO.setAuto(true);
                fscSendPayBillOrderAtomReqBO.setWithdrawalAmount(withdrawalAmount);
                resultMap = new HashMap<String, List<Long>>();
                resultMap.put(String.valueOf(Sequence.getInstance().nextId()), bankCheckIds);
                fscSendPayBillOrderAtomReqBO.setResultMap(resultMap);
                fscSendPayBillOrderAtomReqBO.setReceiptFileIds(receiptFileIds);
                fscSendPayBillOrderAtomReqBO.setSummaryStr("\u3010\u7535\u5546\u3011" + DateUtil.dateToStr((Date)endDate, (String)"yyyy") + "\u5e74" + DateUtil.dateToStr((Date)endDate, (String)"MM") + "\u6708" + DateUtil.dateToStr((Date)endDate, (String)"dd") + "\u65e5\u7535\u5546\u4ee3\u7406\u9500\u552e\u6536\u6b3e\u5165\u8d26");
                log.info("\u540c\u6b65\u8d38\u6613\u6536\u5165\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(resultMap));
                this.fscSendPayBillOrderAtomService.sendPayBillOrder(fscSendPayBillOrderAtomReqBO);
            }
            if (ObjectUtil.isNotEmpty(servicePayBankCheckIds)) {
                FscSendFeeServicePayBillOrderAtomReqBO fscSendFeeServicePayBillOrderAtomReqBO = new FscSendFeeServicePayBillOrderAtomReqBO();
                fscSendFeeServicePayBillOrderAtomReqBO.setAuto(true);
                fscSendFeeServicePayBillOrderAtomReqBO.setWithdrawalAmount(servicePayWithdrawalAmount);
                resultMap = new HashMap();
                resultMap.put(String.valueOf(Sequence.getInstance().nextId()), servicePayBankCheckIds);
                fscSendFeeServicePayBillOrderAtomReqBO.setResultMap(resultMap);
                fscSendFeeServicePayBillOrderAtomReqBO.setReceiptFileIds(servicePayReceiptFileIds);
                log.info("\u540c\u6b65\u670d\u52a1\u8d39\u6536\u5165\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(resultMap));
                this.fscSendFeeServicePayBillOrderAtomService.sendFeeServicePayBillOrder(fscSendFeeServicePayBillOrderAtomReqBO);
            }
        }
        return rspBO;
    }
}

