/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscCreditDeductAtomBO;
import com.tydic.fsc.busibase.atom.api.FscCreditDeductAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscPaySuccessCallBackOrderBO;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderShouldPayItemPO;
import com.tydic.fsc.po.FscPayLogPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscDealPaySuccessAtomServiceImpl
implements FscDealPaySuccessAtomService {
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private FscCreditDeductAtomService fscCreditDeductAtomService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    private static final Integer IS_CREDIT = 0;

    @Override
    public FscDealPaySuccessAtomRspBO dealPaySuccess(FscDealPaySuccessAtomReqBO atomReqBO) {
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderIds(atomReqBO.getPayFscOrderId());
        List pos = this.fscOrderPayItemMapper.getListForDealPaySuccess(fscOrderPayItemPO);
        HashSet shouldPayIdSet = new HashSet();
        pos.forEach(fscOrderPayItemPO1 -> {
            shouldPayIdSet.add(fscOrderPayItemPO1.getShouldPayId());
            if (ObjectUtil.isNotNull((Object)atomReqBO.getFscPayCallbackContentBO()) && !StringUtils.isBlank((CharSequence)atomReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(atomReqBO.getFscPayCallbackContentBO().getResultCode())) {
                int n = this.fscShouldPayMapper.updateByPayFail(fscOrderPayItemPO1.getShouldPayId(), fscOrderPayItemPO1.getPayAmount());
            } else {
                int n = this.fscShouldPayMapper.updateByPaySuccess(fscOrderPayItemPO1.getShouldPayId(), fscOrderPayItemPO1.getPayAmount());
            }
        });
        if (!(CollectionUtils.isEmpty(shouldPayIdSet) || ObjectUtil.isNotNull((Object)atomReqBO.getFscPayCallbackContentBO()) && !StringUtils.isBlank((CharSequence)atomReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(atomReqBO.getFscPayCallbackContentBO().getResultCode()))) {
            this.fscShouldPayMapper.updateShouldPayStatusForPartPay(shouldPayIdSet);
            this.fscShouldPayMapper.updateShouldPayStatusForPaied(shouldPayIdSet);
        }
        FscDealPaySuccessAtomRspBO atomRspBO = new FscDealPaySuccessAtomRspBO();
        this.updateFscOrderAndOrder(atomReqBO, atomRspBO);
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u539f\u5b50\u670d\u52a1\u5904\u7406\u6210\u529f");
        return atomRspBO;
    }

    private void updateFscOrderAndOrder(FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO, FscDealPaySuccessAtomRspBO fscDealPaySuccessAtomRspBO) {
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderIds(fscDealPaySuccessAtomReqBO.getPayFscOrderId());
        List pos = this.fscOrderPayItemMapper.getListForDealPaySuccess(fscOrderPayItemPO);
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>();
        HashMap payFscOrderIdMap = new HashMap();
        ArrayList fscCreditDeductAtomBOS = new ArrayList();
        ArrayList fscPayLogPOS = new ArrayList();
        ArrayList<FscPaySuccessCallBackOrderBO> fscPaySuccessCallBackOrderBOList = new ArrayList<FscPaySuccessCallBackOrderBO>();
        Map<Long, FscOrderShouldPayItemPO> fscOrderShouldPayItemPOMap = pos.stream().collect(Collectors.toMap(FscOrderShouldPayItemPO::getFscOrderId, o -> o));
        pos.forEach(fscOrderShouldPayItemPO -> {
            if (FscConstants.ShouldObjectType.PURCHASE_ORDER.equals(fscOrderShouldPayItemPO.getObjectType()) || FscConstants.ShouldObjectType.SALE_ORDER.equals(fscOrderShouldPayItemPO.getObjectType()) || FscConstants.ShouldObjectType.CHECK_ORDER.equals(fscOrderShouldPayItemPO.getObjectType()) || FscConstants.ShouldObjectType.DELIVER_ORDER.equals(fscOrderShouldPayItemPO.getObjectType())) {
                FscPaySuccessCallBackOrderBO fscPaySuccessCallBackOrderBO = new FscPaySuccessCallBackOrderBO();
                fscPaySuccessCallBackOrderBO.setPayMod(Convert.toInt((Object)fscOrderShouldPayItemPO.getPayMethod()));
                fscPaySuccessCallBackOrderBO.setShouldPayId(fscOrderShouldPayItemPO.getShouldPayId());
                fscPaySuccessCallBackOrderBO.setObjectId(fscOrderShouldPayItemPO.getObjectId());
                fscPaySuccessCallBackOrderBO.setShouldPayMoney(fscOrderShouldPayItemPO.getPayAmount());
                fscPaySuccessCallBackOrderBO.setOrderId(fscOrderShouldPayItemPO.getOrderId());
                if (ObjectUtil.isNotNull((Object)fscDealPaySuccessAtomReqBO.getFscPayCallbackContentBO()) && !StringUtils.isBlank((CharSequence)fscDealPaySuccessAtomReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(fscDealPaySuccessAtomReqBO.getFscPayCallbackContentBO().getResultCode())) {
                    fscPaySuccessCallBackOrderBO.setPayResult(Boolean.valueOf(false));
                } else {
                    fscPaySuccessCallBackOrderBO.setPayResult(Boolean.valueOf(true));
                }
                fscPaySuccessCallBackOrderBO.setShouldPayType(fscOrderShouldPayItemPO.getShouldPayType());
                fscPaySuccessCallBackOrderBO.setCallBackOrder(Boolean.valueOf(true));
                fscPaySuccessCallBackOrderBOList.add(fscPaySuccessCallBackOrderBO);
            } else if (FscConstants.ShouldPayStatus.PAYED.equals(fscOrderShouldPayItemPO.getShouldPayStatus())) {
                HashSet<Long> fscOrderId = (HashSet<Long>)payFscOrderIdMap.get(fscOrderShouldPayItemPO.getFscOrderId());
                if (fscOrderId == null) {
                    fscOrderId = new HashSet<Long>();
                    payFscOrderIdMap.put(fscOrderShouldPayItemPO.getFscOrderId(), fscOrderId);
                }
                fscOrderId.add(fscOrderShouldPayItemPO.getObjectId());
            }
            if (fscOrderShouldPayItemPO.getShouldPayType().equals(FscConstants.ShouldPayType.PAYMENT_DAY_PAY)) {
                FscCreditDeductAtomBO bo = new FscCreditDeductAtomBO();
                bo.setAmount(BigDecimal.ZERO.subtract(fscOrderShouldPayItemPO.getPayAmount()));
                bo.setOrderNo(fscOrderShouldPayItemPO.getObjectNo());
                bo.setOrderId(fscOrderShouldPayItemPO.getObjectId());
                if (fscOrderShouldPayItemPO.getObjectType().equals(FscConstants.ShouldObjectType.COMMON_ORDER) || fscOrderShouldPayItemPO.getObjectType().equals(FscConstants.ShouldObjectType.DEAL_ORDER) || fscOrderShouldPayItemPO.getObjectType().equals(FscConstants.ShouldObjectType.USR_ORDER) || fscOrderShouldPayItemPO.getObjectType().equals(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER)) {
                    bo.setOrderType(FscConstants.CreditOrderType.FSC_ORDER);
                } else {
                    bo.setOrderType(FscConstants.CreditOrderType.ORDER);
                }
                fscCreditDeductAtomBOS.add(bo);
            } else {
                FscPayLogPO po = new FscPayLogPO();
                po.setOrgId(fscOrderShouldPayItemPO.getPayerId());
                po.setPayeeId(fscOrderShouldPayItemPO.getPayeeId());
                if (fscOrderShouldPayItemPO.getShouldPayType().equals(FscConstants.ShouldPayType.DEAL_PAY)) {
                    po.setBusiCategory(FscConstants.FscBusiCategory.SERVICE_FEE_PAY);
                } else if (fscOrderShouldPayItemPO.getShouldPayType().equals(FscConstants.ShouldPayType.PALATFORM_USE_PAY)) {
                    po.setBusiCategory(FscConstants.FscBusiCategory.PLATFORM_FEE_PAY);
                } else {
                    po.setBusiCategory(FscConstants.FscBusiCategory.ORDER_PAY);
                }
                po.setBusiAmount(fscOrderShouldPayItemPO.getPayAmount());
                po.setBusiTime(new Date());
                po.setUserName(fscOrderShouldPayItemPO.getPayOrderName());
                po.setBusiOrderNo(fscOrderShouldPayItemPO.getObjectNo());
                if (fscOrderShouldPayItemPO.getObjectType().equals(FscConstants.ShouldObjectType.COMMON_ORDER) || fscOrderShouldPayItemPO.getObjectType().equals(FscConstants.ShouldObjectType.DEAL_ORDER) || fscOrderShouldPayItemPO.getObjectType().equals(FscConstants.ShouldObjectType.USR_ORDER) || fscOrderShouldPayItemPO.getObjectType().equals(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER)) {
                    po.setBusiOrderType(FscConstants.CreditOrderType.FSC_ORDER);
                } else {
                    po.setBusiOrderType(FscConstants.CreditOrderType.ORDER);
                }
                po.setBusiOrderId(fscOrderShouldPayItemPO.getObjectId());
                po.setIsCredit(IS_CREDIT);
                po.setCreateOperId(fscOrderShouldPayItemPO.getPayOrderId());
                po.setShouldPayId(fscOrderShouldPayItemPO.getShouldPayId());
                po.setCreateTime(new Date());
                po.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscPayLogPOS.add(po);
            }
        });
        if (fscPayLogPOS.size() > 0) {
            this.fscPayLogMapper.insertBatch(fscPayLogPOS);
        }
        if (!ObjectUtil.isNotNull((Object)fscDealPaySuccessAtomReqBO.getFscPayCallbackContentBO()) || StringUtils.isBlank((CharSequence)fscDealPaySuccessAtomReqBO.getFscPayCallbackContentBO().getResultCode()) || !"FAIL".equals(fscDealPaySuccessAtomReqBO.getFscPayCallbackContentBO().getResultCode())) {
            Date time = new Date(System.currentTimeMillis());
            if (payFscOrderIdMap.size() > 0) {
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderIds(new ArrayList(payFscOrderIdMap.keySet()));
                List fscOrderPOs = this.fscOrderMapper.getList(fscOrderPO);
                fscOrderPOs.forEach(fscOrderPO1 -> {
                    FscOrderPO set = new FscOrderPO();
                    set.setPayConfirmId(fscOrderPO1.getPayConfirmId());
                    set.setPayConfirmName(fscOrderPO1.getPayConfirmName());
                    set.setPayConfirmTime(fscOrderPO1.getPayConfirmTime());
                    set.setPayTime(new Date());
                    set.setPayOperName(fscOrderPO1.getPayOperName());
                    set.setPayerName(fscOrderPO1.getPayerName());
                    set.setPayerId(fscOrderPO1.getPayerId());
                    set.setPayeeBankName(fscOrderPO1.getPayeeBankName());
                    set.setPayeeBankAccount(fscOrderPO1.getPayeeBankAccount());
                    set.setPayeeAccountName(fscOrderPO1.getPayeeAccountName());
                    set.setPayeeName(fscOrderPO1.getPayeeName());
                    set.setPayeeId(fscOrderPO1.getPayeeId());
                    set.setShouldPayType(fscOrderPO1.getShouldPayType());
                    set.setPayType(fscOrderPO1.getPayType());
                    set.setPayMethod(fscOrderPO1.getPayMethod());
                    set.setPayChannel(fscOrderPO1.getPayChannel());
                    set.setPayOperId(fscOrderPO1.getPayOperId());
                    if (null != fscDealPaySuccessAtomReqBO.getUserId()) {
                        set.setUpdateOperId(fscDealPaySuccessAtomReqBO.getUserId().toString());
                    }
                    set.setUpdateOperName(fscDealPaySuccessAtomReqBO.getName());
                    set.setUpdateTime(time);
                    FscOrderPO where = new FscOrderPO();
                    ArrayList fscOrderIds = new ArrayList((Collection)payFscOrderIdMap.get(fscOrderPO1.getFscOrderId()));
                    where.setFscOrderIds(fscOrderIds);
                    this.fscOrderMapper.updateBy(set, where);
                    if (!FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER.equals(((FscOrderShouldPayItemPO)fscOrderShouldPayItemPOMap.get(fscOrderPO1.getFscOrderId())).getObjectType())) {
                        for (Long fscOrderId : fscOrderIds) {
                            this.invokeFscOrderStatusFlow(fscOrderId, fscDealPaySuccessAtomReqBO.getParamMap(), FscConstants.FscServiceOrderState.TO_PAY);
                            resultFscOrderIds.add(fscOrderId);
                        }
                    }
                });
            }
        }
        fscDealPaySuccessAtomRspBO.setResultFscOrderIds(resultFscOrderIds);
        fscDealPaySuccessAtomRspBO.setFscPaySuccessCallBackOrderBOList(fscPaySuccessCallBackOrderBOList);
        if (!CollectionUtils.isEmpty(fscPaySuccessCallBackOrderBOList)) {
            FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
            fscUocProOrderPaymentCallbackAbilityReqBO.setUocPaymentCallbackBOS(fscPaySuccessCallBackOrderBOList.stream().map(fscPaySuccessCallBackOrderBO -> {
                FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBO = new FscUocProOrderPaymentCallbackAbilityBO();
                fscUocProOrderPaymentCallbackAbilityBO.setOrderId(fscPaySuccessCallBackOrderBO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayMod(fscPaySuccessCallBackOrderBO.getPayMod());
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(fscPaySuccessCallBackOrderBO.getPayResult());
                fscUocProOrderPaymentCallbackAbilityBO.setShouldPayMoney(fscPaySuccessCallBackOrderBO.getShouldPayMoney());
                fscUocProOrderPaymentCallbackAbilityBO.setFscShouldPayId(fscPaySuccessCallBackOrderBO.getShouldPayId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(fscPaySuccessCallBackOrderBO.getPayResult());
                return fscUocProOrderPaymentCallbackAbilityBO;
            }).collect(Collectors.toList()));
            this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
        }
    }

    private void invokeFscOrderStatusFlow(Long fscOrderId, Map<String, Object> paramMap, Integer curStatus) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        fscOrderStatusFlowAtomReqBO.setCurStatus(curStatus);
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }
}

