/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcUniteParamQryListPageAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscBankReceiptFileMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderMsgLogMapper;
import com.tydic.fsc.pay.atom.api.FscSendPayBillOrderAtomService;
import com.tydic.fsc.pay.atom.bo.FscSendPayBillOrderAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscSendPayBillOrderAtomRspBO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscBankReceiptFilePO;
import com.tydic.fsc.po.FscOrderMsgLogPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FileUtils;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.umc.general.ability.api.CrcQryMainUserInfoByPartIdAbilityService;
import com.tydic.umc.general.ability.api.UmcQryOrgAccountCodeByOrgIdAbilityService;
import com.tydic.umc.general.ability.bo.CrcQryMainUserInfoByPartIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryMainUserInfoByPartIdAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryOrgAccountCodeByOrgIdAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FscSendPayBillOrderAtomServiceImpl
implements FscSendPayBillOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSendPayBillOrderAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private CrcQryMainUserInfoByPartIdAbilityService crcQryMainUserInfoByPartIdAbilityService;
    @Autowired
    private UmcQryOrgAccountCodeByOrgIdAbilityService umcQryOrgAccountCodeByOrgIdAbilityService;
    @Autowired
    private FscOrderMsgLogMapper fscOrderMsgLogMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Value(value="${ESB_SEND_RECEIPT_ORDER_URL}")
    private String ESB_SEND_RECEIPT_ORDER_URL;
    @Autowired
    private CfcUniteParamQryListPageAbilityService cfcUniteParamQryListPageAbilityService;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscBankReceiptFileMapper fscBankReceiptFileMapper;

    @Override
    public FscSendPayBillOrderAtomRspBO sendPayBillOrder(FscSendPayBillOrderAtomReqBO reqBO) {
        Map<String, List<Long>> resultMap = reqBO.getResultMap();
        FscSendPayBillOrderAtomRspBO rspBO = new FscSendPayBillOrderAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!ObjectUtil.isEmpty(resultMap)) {
            resultMap.forEach((key, val) -> {
                String sendParams = this.initSendParams((String)key, (List<Long>)val, reqBO);
                log.info("\u6536\u6b3e\u901a\u77e5\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_SEND_RECEIPT_ORDER_URL);
                log.info("\u6536\u6b3e\u901a\u77e5\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u53c2\u6570:{}", (Object)sendParams);
                String returnString = SSLClient.doPost((String)this.ESB_SEND_RECEIPT_ORDER_URL, (String)sendParams);
                log.info("\u6536\u6b3e\u901a\u77e5\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u54cd\u5e94:{}", (Object)returnString);
                FscOrderMsgLogPO fscOrderMsgLogPO = new FscOrderMsgLogPO();
                fscOrderMsgLogPO.setSendUrl(this.ESB_SEND_RECEIPT_ORDER_URL);
                fscOrderMsgLogPO.setSendContent(sendParams);
                fscOrderMsgLogPO.setMsgContent(returnString);
                fscOrderMsgLogPO.setPushTime(new Date());
                if (ObjectUtil.isEmpty((Object)returnString)) {
                    fscOrderMsgLogPO.setResultString("0");
                    fscOrderMsgLogPO.setFailureReason("\u8c03\u7528ESB\u63a5\u53e3\u9500\u552e\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                    this.writeLog(fscOrderMsgLogPO);
                    throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u9500\u552e\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                }
                this.resolveRsp(returnString, (String)key, fscOrderMsgLogPO);
            });
        }
        if (!ObjectUtil.isEmpty(reqBO.getReceiptFileIds())) {
            FscBankReceiptFilePO setPO = new FscBankReceiptFilePO();
            setPO.setSyncStatus(Integer.valueOf(1));
            setPO.setSyncTime(new Date());
            FscBankReceiptFilePO wherePO = new FscBankReceiptFilePO();
            wherePO.setBankReceiptIds(reqBO.getReceiptFileIds());
            this.fscBankReceiptFileMapper.updateBy(setPO, wherePO);
        }
        return rspBO;
    }

    private void val(FscSendPayBillOrderAtomReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new BaseBusinessException("8888", "\u6536\u6b3e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String initSendParams(String frontSeqNo, List<Long> bankCheckIdList, FscSendPayBillOrderAtomReqBO reqBO) {
        CfcUniteParamQryListPageAbilityReqBO cfcUniteParamQryListPageAbilityReqBO = new CfcUniteParamQryListPageAbilityReqBO();
        cfcUniteParamQryListPageAbilityReqBO.setId(FscConstants.TRADE_MODEL.SALE_ORDER_FEE);
        CfcUniteParamQryListPageAbilityRspBO cfcUniteParamQryListPageAbilityRspBO = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(cfcUniteParamQryListPageAbilityReqBO);
        log.info("\u83b7\u53d6\u8fd0\u8425\u63d0\u73b0\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)cfcUniteParamQryListPageAbilityRspBO.getRows()));
        if (ObjectUtil.isEmpty((Object)cfcUniteParamQryListPageAbilityRspBO.getRows())) {
            log.info("YY009\u672a\u914d\u7f6e");
        }
        String payeeBankName = ObjectUtil.isEmpty((Object)cfcUniteParamQryListPageAbilityRspBO.getRows()) ? "" : ((JSONObject)cfcUniteParamQryListPageAbilityRspBO.getRows().get(0)).get((Object)"payeeBankName").toString();
        String payeeAccountNo = ObjectUtil.isEmpty((Object)cfcUniteParamQryListPageAbilityRspBO.getRows()) ? "" : ((JSONObject)cfcUniteParamQryListPageAbilityRspBO.getRows().get(0)).get((Object)"payeeAccountNo").toString();
        String payeeAccountName = ObjectUtil.isEmpty((Object)cfcUniteParamQryListPageAbilityRspBO.getRows()) ? "" : ((JSONObject)cfcUniteParamQryListPageAbilityRspBO.getRows().get(0)).get((Object)"payeeAccountName").toString();
        JSONObject reqJson = new JSONObject();
        reqJson.put("ouCode", (Object)"SZZB0");
        reqJson.put("sourceNo", (Object)frontSeqNo);
        reqJson.put("serialNo", (Object)Sequence.getInstance().nextId());
        reqJson.put("receiptOuCode", (Object)"SZZB0");
        reqJson.put("receiptOuName", (Object)"\u534e\u6da6\u5b88\u6b63\u62db\u6807\u6709\u9650\u516c\u53f8");
        reqJson.put("receiptBankName", (Object)payeeBankName);
        reqJson.put("receiptAccountNo", (Object)"15467777777705");
        reqJson.put("receiptAccountName", (Object)payeeAccountName);
        if (reqBO.getAuto().booleanValue()) {
            reqJson.put("applyLdapId", (Object)"miaolin3");
        } else {
            CrcQryMainUserInfoByPartIdAbilityReqBO crcQryMainUserInfoByPartIdAbilityReqBO = new CrcQryMainUserInfoByPartIdAbilityReqBO();
            crcQryMainUserInfoByPartIdAbilityReqBO.setMemId(reqBO.getUserId());
            log.info("\u8c03\u7528\u4f1a\u5458\u83b7\u53d6\u4e3b\u8d26\u53f7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityReqBO));
            CrcQryMainUserInfoByPartIdAbilityRspBO crcQryMainUserInfoByPartIdAbilityRspBO = this.crcQryMainUserInfoByPartIdAbilityService.qryMainUserInfoByPartId(crcQryMainUserInfoByPartIdAbilityReqBO);
            log.info("\u8c03\u7528\u4f1a\u5458\u83b7\u53d6\u4e3b\u8d26\u53f7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)crcQryMainUserInfoByPartIdAbilityRspBO));
            if (!"0000".equals(crcQryMainUserInfoByPartIdAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u4f1a\u5458\u5f02\u5e38\uff1a" + crcQryMainUserInfoByPartIdAbilityRspBO.getRespDesc());
            }
            String creatorLdap = crcQryMainUserInfoByPartIdAbilityRspBO.getMainMemInformation().getRegAccount();
            reqJson.put("applyLdapId", (Object)creatorLdap);
        }
        reqJson.put("applyDate", (Object)DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSummaryStr())) {
            reqJson.put("summary", (Object)reqBO.getSummaryStr());
        } else {
            String summaryStr = "\u9500\u552e\u6536\u5165\u6536\u6b3e/" + frontSeqNo;
            if (reqBO.getAuto().booleanValue()) {
                reqJson.put("summary", (Object)("\u81ea\u52a8\u63d0\u73b0" + summaryStr));
            } else {
                reqJson.put("summary", (Object)summaryStr);
            }
        }
        JSONArray lines = new JSONArray();
        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPO.setBankCheckIdS(bankCheckIdList);
        List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPO);
        BigDecimal remainingAmount = reqBO.getWithdrawalAmount();
        for (FscBankCheckFileItemPO item : fscBankCheckFileItemPOList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("currencyCode", (Object)"CNY");
            jsonObject.put("receiptAmount", (Object)(remainingAmount.compareTo(item.getTradeAmt()) >= 0 ? String.valueOf(item.getTradeAmt().setScale(2, RoundingMode.HALF_UP)) : String.valueOf(remainingAmount.setScale(2, RoundingMode.HALF_UP))));
            if (remainingAmount.compareTo(item.getTradeAmt()) >= 0) {
                remainingAmount = remainingAmount.subtract(item.getTradeAmt());
            }
            UmcQryOrgAccountCodeByOrgIdAbilityReqBO umcQReqBO = new UmcQryOrgAccountCodeByOrgIdAbilityReqBO();
            umcQReqBO.setOrgId(item.getPayerId());
            log.info("\u67e5\u8be2\u4f1a\u5458\u4ed8\u6b3e\u5355\u4f4d\u7f16\u7801\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQReqBO));
            UmcQryOrgAccountCodeByOrgIdAbilityRspBO umcRspBO = this.umcQryOrgAccountCodeByOrgIdAbilityService.qryOrgAccountCodeByOrgId(umcQReqBO);
            log.info("\u67e5\u8be2\u4f1a\u5458\u6536\u6b3e\u5355\u4f4d\u7f16\u7801\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcRspBO));
            String orgAccountCodePayer = ObjectUtil.isEmpty((Object)umcRspBO.getOrgAccountCode()) ? "0" : umcRspBO.getOrgAccountCode();
            jsonObject.put("vendorCode", (Object)orgAccountCodePayer);
            jsonObject.put("vendorName", (Object)item.getPayerName());
            jsonObject.put("lineSummary", (Object)frontSeqNo);
            lines.add((Object)jsonObject);
        }
        JSONArray attachmentList = new JSONArray();
        FscBankReceiptFilePO fscBankReceiptFilePO = new FscBankReceiptFilePO();
        if (ObjectUtil.isEmpty(reqBO.getReceiptFileIds())) {
            Calendar curDate = Calendar.getInstance();
            curDate.setTime(new Date());
            fscBankReceiptFilePO.setCreateTimeStart(DateUtil.strToDate((String)DateUtil.dateToStr((Date)curDate.getTime(), (String)"yyyy-MM-dd")));
        } else {
            fscBankReceiptFilePO.setBankReceiptIds(reqBO.getReceiptFileIds());
        }
        List fscBankReceiptFilePOList = this.fscBankReceiptFileMapper.getList(fscBankReceiptFilePO);
        if (!ObjectUtils.isEmpty((Object)fscBankReceiptFilePOList)) {
            int i = 1;
            for (FscBankReceiptFilePO bankReceiptFilePO : fscBankReceiptFilePOList) {
                JSONObject jsonObject1 = new JSONObject();
                String attachmentName = (i < 10 ? "\u5e73\u5b89\u94f6\u884c\u6d41\u6c34\u56de\u5355-00" : (10 <= i && i < 100 ? "\u5e73\u5b89\u94f6\u884c\u6d41\u6c34\u56de\u5355-0" : "\u5e73\u5b89\u94f6\u884c\u6d41\u6c34\u56de\u5355-")) + i + ".zip";
                jsonObject1.put("attachmentName", (Object)attachmentName);
                jsonObject1.put("attachmentType", (Object)bankReceiptFilePO.getAttachmentType());
                String size = FileUtils.getFileLength((String)bankReceiptFilePO.getAttachmentUrl(), (String)"kb");
                jsonObject1.put("attachmentSize", (Object)size);
                jsonObject1.put("attachmentUrl", (Object)bankReceiptFilePO.getAttachmentUrl());
                jsonObject1.put("sourceNo", (Object)frontSeqNo);
                attachmentList.add((Object)jsonObject1);
                ++i;
            }
        } else {
            throw new BaseBusinessException("8888", "\u6536\u6b3e\u901a\u77e5\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u5931\u8d25:\u7f3a\u5c11\u94f6\u884c\u56de\u5355pdf\u9644\u4ef6");
        }
        reqJson.put("lines", (Object)lines);
        reqJson.put("attachments", (Object)attachmentList);
        log.info("\u63a8\u9001\u51fa\u53c2:{}", (Object)reqJson);
        return reqJson.toJSONString();
    }

    private void resolveRsp(String returnString, String frontSeqNo, FscOrderMsgLogPO fscOrderMsgLogPO) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519:" + e.getMessage());
            this.writeLog(fscOrderMsgLogPO);
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        if (null == rspJsonObject.getJSONObject("RESPONSE") || null == rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA")) {
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.writeLog(fscOrderMsgLogPO);
            return;
        }
        if (rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"status").equals("SUCCESS")) {
            fscOrderMsgLogPO.setResultString("1");
        } else {
            fscOrderMsgLogPO.setResultString("0");
            try {
                fscOrderMsgLogPO.setFailureReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            }
            catch (Exception e) {
                try {
                    fscOrderMsgLogPO.setFailureReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMessage").toString());
                }
                catch (Exception ex) {
                    fscOrderMsgLogPO.setFailureReason(returnString);
                }
            }
        }
        this.writeLog(fscOrderMsgLogPO);
    }

    private void writeLog(FscOrderMsgLogPO fscOrderMsgLogPO) {
        fscOrderMsgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderMsgLogPO.setMsgType(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_RECEIPT_ORDER);
        fscOrderMsgLogPO.setObjType(FscConstants.FSC_ORDER_OUT_OBJ_TYPE.RECEIPT_FSC_ORDER);
        fscOrderMsgLogPO.setCreateTime(new Date());
        this.fscOrderMsgLogMapper.insert(fscOrderMsgLogPO);
    }
}

