/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.unit;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderMsgLogMapper;
import com.tydic.fsc.pay.atom.bo.FscSendPaymentOrderAtomReqBO;
import com.tydic.fsc.po.FscOrderMsgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendOutUrlThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(SendOutUrlThread.class);
    FscOrderMsgLogPO fscOrderMsgLogPO;
    FscSendPaymentOrderAtomReqBO atomReqBO;
    FscOrderMapper fscOrderMapper;
    FscOrderMsgLogMapper fscOrderMsgLogMapper;

    public SendOutUrlThread(FscOrderMsgLogPO fscOrderMsgLogPO, FscSendPaymentOrderAtomReqBO atomReqBO, FscOrderMapper fscOrderMapper, FscOrderMsgLogMapper fscOrderMsgLogMapper) {
        this.fscOrderMsgLogPO = fscOrderMsgLogPO;
        this.atomReqBO = atomReqBO;
        this.fscOrderMapper = fscOrderMapper;
        this.fscOrderMsgLogMapper = fscOrderMsgLogMapper;
    }

    @Override
    public void run() {
        log.info("\u542f\u52a8\u7ebf\u7a0b\u63a8\u9001\u8d22\u52a1\u5171\u4eab" + this.fscOrderMsgLogPO.getSendUrl());
        String returnString = HttpUtil.post((String)this.fscOrderMsgLogPO.getSendUrl(), (String)this.fscOrderMsgLogPO.getSendContent());
        log.info("\u542f\u52a8\u7ebf\u7a0b\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8fd4\u56de\u53c2\u6570" + returnString);
        this.fscOrderMsgLogPO.setMsgContent(returnString);
        if (ObjectUtil.isEmpty((Object)returnString)) {
            this.fscOrderMsgLogPO.setResultString("0");
            this.fscOrderMsgLogPO.setFailureReason("\u8c03\u7528ESB\u63a5\u53e3\u4ed8\u6b3e\u5355\u63a8\u9001\u81f3\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            this.writeLog(this.fscOrderMsgLogPO);
        }
        this.resolveRsp(returnString, this.atomReqBO, this.fscOrderMsgLogPO);
    }

    public static void main(String[] agrs) {
    }

    private void resolveRsp(String returnString, FscSendPaymentOrderAtomReqBO atomReqBO, FscOrderMsgLogPO fscOrderMsgLogPO) {
        JSONObject rspJsonObject;
        log.info("\u683c\u5f0f\u5316\u53c2\u6570:{}", (Object)returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519:" + e.getMessage());
            this.writeLog(fscOrderMsgLogPO);
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(atomReqBO.getFscOrderId());
        fscOrderPO.setSyncTime(new Date(System.currentTimeMillis()));
        if (null == rspJsonObject.getJSONObject("RESPONSE") || null == rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA")) {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setSyncFailReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.writeLog(fscOrderMsgLogPO);
            return;
        }
        if (rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"status").equals("SUCC")) {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.APPLYING);
            fscOrderPO.setSyncFailReason("");
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("1");
            this.writeLog(fscOrderMsgLogPO);
        } else {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setSyncFailReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            this.writeLog(fscOrderMsgLogPO);
        }
    }

    private void writeLog(FscOrderMsgLogPO fscOrderMsgLogPO) {
        fscOrderMsgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderMsgLogPO.setMsgType(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_FINANCIAL_SHARE);
        fscOrderMsgLogPO.setObjType(FscConstants.FSC_ORDER_OUT_OBJ_TYPE.FSC_ORDER);
        fscOrderMsgLogPO.setCreateTime(new Date());
        this.fscOrderMsgLogMapper.insert(fscOrderMsgLogPO);
    }
}

