/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.fsc.dao.FscGcOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscGcOrderCreateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscGcOrderCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscGcOrderCreateAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscGcOrderItemAbilityBO;
import com.tydic.fsc.pay.busi.api.FscGcOrderCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscGcOrderCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscGcOrderCreateBusiRspBO;
import com.tydic.fsc.po.FscGcOrderPO;
import com.tydic.fsc.util.FscRu;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscGcOrderCreateAbilityService"})
public class FscGcOrderCreateAbilityServiceimpl
implements FscGcOrderCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscGcOrderCreateAbilityServiceimpl.class);
    @Autowired
    private FscGcOrderCreateBusiService fscGcOrderCreateBusiService;
    @Autowired
    private FscGcOrderMapper fscGcOrderMapper;

    @PostMapping(value={"createFscGcOrder"})
    public FscGcOrderCreateAbilityRspBO createFscGcOrder(@RequestBody FscGcOrderCreateAbilityReqBO reqBO) {
        this.validate(reqBO);
        FscGcOrderPO fscGcOrderPo = new FscGcOrderPO();
        fscGcOrderPo.setFscOrderId(reqBO.getFscOrderId());
        List fscGcOrderPOList = this.fscGcOrderMapper.getList(fscGcOrderPo);
        if (ObjectUtil.isNotEmpty((Object)fscGcOrderPOList)) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[fscOrderId]\u5df2\u5b58\u5728");
        }
        FscGcOrderCreateBusiRspBO busiRspBO = this.fscGcOrderCreateBusiService.createFscGcOrder((FscGcOrderCreateBusiReqBO)FscRu.js((Object)reqBO, FscGcOrderCreateBusiReqBO.class));
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("193005", busiRspBO.getRespDesc());
        }
        FscGcOrderCreateAbilityRspBO rspBO = (FscGcOrderCreateAbilityRspBO)FscRu.js((Object)((Object)busiRspBO), FscGcOrderCreateAbilityRspBO.class);
        return rspBO;
    }

    private void validate(FscGcOrderCreateAbilityReqBO reqBo) {
        if (null == reqBo) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFscOrderId())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[fscOrderId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFscOrderNo())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[fscOrderNo]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[userId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getName())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[name]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPayeeId())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[payeeId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPayeeName())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[payeeName]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPayeeAccountNo())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[payeeAccountNo]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPayeeBankName())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[payeeBankName]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTotalCharge())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[totalCharge]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCommodityBos())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos]\u4e3a\u7a7a");
        }
        reqBo.getCommodityBos().forEach(bo -> {
            if (ObjectUtil.isEmpty((Object)bo.getOrderId())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][orderId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getSkuId())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][skuId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getSkuName())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][skuName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getSupplierId())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][supplierId]\u4e3a\u7a7a");
            }
            if (bo.getSupplierId() != ((FscGcOrderItemAbilityBO)reqBo.getCommodityBos().get(0)).getSupplierId()) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][supplierId]\u5fc5\u987b\u76f8\u540c");
            }
            if (ObjectUtil.isEmpty((Object)bo.getSupplierName())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][supplierName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getPrice())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][price]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getAmt())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][amt]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getUntaxAmt())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][untaxAmt]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getPurchaseCount())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][purchaseCount]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getTaxPrice())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][taxPrice]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getTax())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][tax]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getUnit())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][unit]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getTaxId())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][taxId]\u4e3a\u7a7a");
            }
        });
        if (ObjectUtil.isEmpty((Object)reqBo.getInvoiceBos())) {
            throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[invoiceBos]\u4e3a\u7a7a");
        }
        reqBo.getInvoiceBos().forEach(bo -> {
            if (ObjectUtil.isEmpty((Object)bo.getInvoiceType())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][invoiceType]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getBillDate())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][billDate]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getTaxAmt())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][taxAmt]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getAmt())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][amt]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getUntaxAmt())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][untaxAmt]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getInvoiceNo())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][invoiceNo]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bo.getBuyName())) {
                throw new FscBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[commodityBos][uyName]\u4e3a\u7a7a");
            }
        });
    }
}

