/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderMsgLogMapper;
import com.tydic.fsc.pay.ability.api.FscGcSendTradePayBillOrderAtomService;
import com.tydic.fsc.pay.ability.bo.FscGcSendTradePayBillOrderAtomReqBO;
import com.tydic.fsc.pay.ability.bo.FscGcSendTradePayBillOrderAtomRspBO;
import com.tydic.fsc.po.FscOrderMsgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.SSLClient;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FscGcSendTradePayBillOrderAbilityServiceImpl
implements FscGcSendTradePayBillOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscGcSendTradePayBillOrderAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderMsgLogMapper fscOrderMsgLogMapper;
    @Value(value="${ESB_SEND_GOODS_PAY_ORDER_URL}")
    private String ESB_SEND_GOODS_PAY_ORDER_URL;

    public FscGcSendTradePayBillOrderAtomRspBO gcSendTradePayBillOrder(FscGcSendTradePayBillOrderAtomReqBO reqBO) {
        FscGcSendTradePayBillOrderAtomRspBO rspBO = new FscGcSendTradePayBillOrderAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        String sendParams = JSONObject.toJSONString((Object)reqBO);
        log.info("\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u5730\u5740:{}", (Object)this.ESB_SEND_GOODS_PAY_ORDER_URL);
        log.info("\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u53c2\u6570:{}", (Object)sendParams);
        String returnString = SSLClient.doPost((String)this.ESB_SEND_GOODS_PAY_ORDER_URL, (String)sendParams);
        log.info("\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u8bf7\u6c42\u54cd\u5e94:{}", (Object)returnString);
        FscOrderMsgLogPO fscOrderMsgLogPO = new FscOrderMsgLogPO();
        fscOrderMsgLogPO.setSendUrl(this.ESB_SEND_GOODS_PAY_ORDER_URL);
        fscOrderMsgLogPO.setSendContent(sendParams);
        fscOrderMsgLogPO.setMsgContent(returnString);
        fscOrderMsgLogPO.setObjId(reqBO.getFscOrderId());
        fscOrderMsgLogPO.setPushTime(new Date());
        fscOrderMsgLogPO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderMsgLogPO.setSysTenantName(reqBO.getSysTenantName());
        if (ObjectUtil.isEmpty((Object)returnString)) {
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8c03\u7528ESB\u63a5\u53e3\u5546\u54c1\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            this.writeLog(fscOrderMsgLogPO);
            throw new BaseBusinessException("8888", "\u8c03\u7528ESB\u63a5\u53e3\u5546\u54c1\u4ed8\u6b3e\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        this.resolveRsp(returnString, reqBO, fscOrderMsgLogPO);
        return rspBO;
    }

    private void val(FscGcSendTradePayBillOrderAtomReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new BaseBusinessException("8888", "\u4ed8\u6b3e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void resolveRsp(String returnString, FscGcSendTradePayBillOrderAtomReqBO atomReqBO, FscOrderMsgLogPO fscOrderMsgLogPO) {
        JSONObject rspJsonObject;
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519:" + e.getMessage());
            this.writeLog(fscOrderMsgLogPO);
            throw new RuntimeException("\u8f6c\u6362\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e.getMessage());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(atomReqBO.getFscOrderId());
        fscOrderPO.setOrderSyncTime(new Date(System.currentTimeMillis()));
        if (null == rspJsonObject.getJSONObject("RESPONSE") || null == rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA")) {
            fscOrderPO.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setOrderSyncFailReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason("ECSB\u8c03\u7528\u8fd4\u56de\u5f02\u5e38");
            this.writeLog(fscOrderMsgLogPO);
            return;
        }
        if (rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"status").equals("SUCCESS")) {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.APPLYING);
            fscOrderPO.setSyncFailReason("");
            fscOrderPO.setSyncTime(new Date());
            fscOrderPO.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.SUCCESS);
            fscOrderPO.setOrderSyncFailReason("");
            fscOrderPO.setOrderSyncTime(new Date());
            fscOrderPO.setReimburseNo(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"claimNo").toString());
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("1");
        } else {
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setSyncFailReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            fscOrderPO.setSyncTime(new Date());
            fscOrderPO.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setOrderSyncFailReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
            fscOrderPO.setOrderSyncTime(new Date());
            this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            fscOrderMsgLogPO.setResultString("0");
            fscOrderMsgLogPO.setFailureReason(rspJsonObject.getJSONObject("RESPONSE").getJSONObject("RETURN_DATA").get((Object)"errorMsg").toString());
        }
        this.writeLog(fscOrderMsgLogPO);
    }

    private void writeLog(FscOrderMsgLogPO fscOrderMsgLogPO) {
        fscOrderMsgLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderMsgLogPO.setMsgType(FscConstants.FSC_ORDER_OUT_MSG_TYPE.PUSH_PAYMENT_ORDER);
        fscOrderMsgLogPO.setObjType(FscConstants.FSC_ORDER_OUT_OBJ_TYPE.PAYMENT_FSC_ORDER);
        fscOrderMsgLogPO.setCreateTime(new Date());
        this.fscOrderMsgLogMapper.insert(fscOrderMsgLogPO);
    }
}

