/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.pay.ability.api.FscQueryWriteInfoByPayOrderAbilityService;
import com.tydic.fsc.pay.ability.bo.FscQueryWriteInfoByPayOrderAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscQueryWriteInfoByPayOrderAbilityRspBO;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscQueryWriteInfoByPayOrderAbilityService"})
public class FscQueryWriteInfoByPayOrderAbilityServiceImpl
implements FscQueryWriteInfoByPayOrderAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;

    @PostMapping(value={"queryWriteInfoByPayOrder"})
    public FscQueryWriteInfoByPayOrderAbilityRspBO queryWriteInfoByPayOrder(@RequestBody FscQueryWriteInfoByPayOrderAbilityReqBO reqBO) {
        FscQueryWriteInfoByPayOrderAbilityRspBO rspBO = new FscQueryWriteInfoByPayOrderAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setOrderNo(reqBO.getFscOrderNo());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtil.isEmpty((Object)fscOrderPO)) {
            throw new ZTBusinessException("\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728");
        }
        rspBO.setWriteOffStatus(fscOrderPO.getOrderState().equals(FscConstants.FscPayOrderState.PAIED) ? "1" : "0");
        if (reqBO.getSelectType() == 2) {
            return rspBO;
        }
        FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
        fscWriteOffItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List fscWriteOffItemPOList = this.fscWriteOffItemMapper.getList(fscWriteOffItemPO);
        if (ObjectUtil.isEmpty((Object)fscWriteOffItemPOList)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u5173\u8054\u6d41\u6c34\u8bb0\u5f55");
        }
        FscBalancePO fscBalancePO = new FscBalancePO();
        fscBalancePO.setBankCheckIds(fscWriteOffItemPOList.stream().map(FscWriteOffItemPO::getBankCheckId).collect(Collectors.toList()));
        List fscBalancePOList = this.fscBalanceMapper.getList(fscBalancePO);
        if (ObjectUtil.isEmpty((Object)fscBalancePOList)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u5173\u8054\u63d0\u73b0\u8bb0\u5f55");
        }
        Long count = fscBalancePOList.stream().filter(o -> o.getUsedAmount().compareTo(BigDecimal.ZERO) != 0).count();
        rspBO.setBalanceStatus(count > 0L ? "1" : "0");
        return rspBO;
    }
}

