/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPayBillUpdateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillUpdateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillUpdateBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillUpdateBusiServiceImpl
implements FscPayBillUpdateBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;

    @Override
    public FscPayBillUpdateBusiRspBO dealPayBillUpdate(FscPayBillUpdateBusiReqBO busiReqBO) {
        FscOrderPO set = new FscOrderPO();
        if (!CollectionUtils.isEmpty(busiReqBO.getFscOrderPayItemBOS())) {
            BigDecimal totalAmount = this.updateShouldPay(busiReqBO);
            set.setTotalCharge(totalAmount);
        }
        set.setPayMethod(busiReqBO.getPayMethod());
        set.setPayChannel(busiReqBO.getPayChannel());
        set.setUpdateOperId(busiReqBO.getUserName());
        set.setUpdateOperName(busiReqBO.getName());
        set.setUpdateTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(busiReqBO.getFscOrderId());
        where.setOrderState(FscConstants.FscPayOrderState.CANCEL);
        int count = this.fscOrderMapper.updateBy(set, where);
        if (count != 1) {
            throw new FscBusinessException("193204", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u662f\u8349\u7a3f\u72b6\u6001");
        }
        this.invokeFscOrderStatusFlow(busiReqBO);
        FscPayBillUpdateBusiRspBO busiRspBO = new FscPayBillUpdateBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        return busiRspBO;
    }

    private BigDecimal updateShouldPay(FscPayBillUpdateBusiReqBO busiReqBO) {
        BigDecimal totalAmount = new BigDecimal(0);
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        for (FscOrderPayItemBO fscOrderPayItemBO : busiReqBO.getFscOrderPayItemBOS()) {
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            fscShouldPayPO.setPayAmount(fscOrderPayItemBO.getPayAmount());
            int count1 = this.fscShouldPayMapper.updateAmount(fscShouldPayPO);
            if (count1 != 1) {
                throw new FscBusinessException("193204", "\u5df2\u751f\u6210\u4ed8\u6b3e\u5355\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(busiReqBO.getFscOrderId());
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            po.setPayAmount(fscOrderPayItemBO.getPayAmount());
            po.setSysTenantId(busiReqBO.getSysTenantId());
            po.setSysTenantName(busiReqBO.getSysTenantName());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO.getPayAmount());
        }
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(busiReqBO.getFscOrderId());
        this.fscOrderPayItemMapper.deleteBy(fscOrderPayItemPO);
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        return totalAmount;
    }

    private void invokeFscOrderStatusFlow(FscPayBillUpdateBusiReqBO busiReqBO) {
        HashMap<String, Integer> paramMap;
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("fscPayApplyOrder");
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(busiReqBO.getFscOrderId());
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(busiReqBO.getFscOrderId().toString());
        approvalObjBO.setObjName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("193204", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        if (!uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            paramMap = new HashMap<String, Integer>();
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        }
        if (!uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            paramMap = new HashMap();
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        }
        fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.CANCEL);
        fscOrderStatusFlowAtomReqBO.setOrderId(busiReqBO.getFscOrderId());
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193204", atomRspBO.getRespDesc());
        }
    }
}

