/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayBillAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillBusiRspBO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillAbilityService"})
public class FscPayBillAbilityServiceImpl
implements FscPayBillAbilityService {
    @Autowired
    private FscPayBillBusiService fscPayBillBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPayBill"})
    public FscPayBillAbilityRspBO dealPayBill(@RequestBody FscPayBillAbilityReqBO abilityReqBO) {
        this.validParam(abilityReqBO);
        this.verifyPayAuth(abilityReqBO);
        FscPayBillBusiReqBO fscPayBillBusiReqBO = (FscPayBillBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscPayBillBusiReqBO.class));
        FscPayBillBusiRspBO busiRspBO = this.fscPayBillBusiService.dealPayBill(fscPayBillBusiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            if (!CollectionUtils.isEmpty(busiRspBO.getResultFscOrderIds())) {
                abilityReqBO.getFscOrderIds().addAll(busiRspBO.getResultFscOrderIds());
            }
            abilityReqBO.getFscOrderIds().forEach(fscOrderId -> {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
                fscComOrderListSyncAbilityReqBO.setSysTenantId(abilityReqBO.getSysTenantId());
                fscComOrderListSyncAbilityReqBO.setSysTenantName(abilityReqBO.getSysTenantName());
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            });
        }
        FscPayBillAbilityRspBO abilityRspBO = new FscPayBillAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        return abilityRspBO;
    }

    private String getPaymentAuth(FscPayBillAbilityReqBO abilityReqBO, String cfcParamCode) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode(cfcParamCode);
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(String.valueOf(abilityReqBO.getOrgId()));
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191201", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPayApplyPay())) {
            throw new FscBusinessException("191201", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[payApplyPay]\u8fd4\u56de\u4e3a\u7a7a");
        }
        return fscCfcUniteParamQryListDetailExternalRspBO.getPayApplyPay();
    }

    private void verifyPayAuth(FscPayBillAbilityReqBO abilityReqBO) {
        String payApplyPay = this.getPaymentAuth(abilityReqBO, "bill_auth");
        if (!"0".equals(payApplyPay) && !abilityReqBO.getAuthPermission().contains(payApplyPay)) {
            throw new FscBusinessException("191201", "\u65e0\u4ed8\u6b3e\u6743\u9650\uff01");
        }
    }

    private void validParam(FscPayBillAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u4e3b\u5355ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getPayChannel()) {
            throw new FscBusinessException("191000", "\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getPayConfirmFlag()) {
            throw new FscBusinessException("191000", "\u662f\u5426\u9700\u8981\u786e\u8ba4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)abilityReqBO.getDetailName())) {
            throw new FscBusinessException("191000", "\u652f\u4ed8\u8bf7\u6c42\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getFscAttachmentBOS())) {
            abilityReqBO.getFscAttachmentBOS().forEach(attachmentBO -> {
                if (null == attachmentBO.getAttachmentType()) {
                    throw new FscBusinessException("191000", "\u9644\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)attachmentBO.getAttachmentName())) {
                    throw new FscBusinessException("191000", "\u9644\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)attachmentBO.getAttachmentUrl())) {
                    throw new FscBusinessException("191000", "\u9644\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            });
        }
    }
}

