/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.pay.ability.api.FscReSendPayOrderToExtTaskAbilityService;
import com.tydic.fsc.pay.ability.bo.FscReSendPayOrderToExtTaskAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscReSendPayOrderToExtTaskAbilityRspBO;
import com.tydic.fsc.pay.atom.api.FscSendEleInvoiceToXhSrmAtomService;
import com.tydic.fsc.pay.atom.api.FscSendPayBillOrderToXhSrmAtomService;
import com.tydic.fsc.pay.atom.bo.FscSendPaymentOrderAtomReqBO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscReSendPayOrderToExtTaskAbilityService"})
public class FscReSendPayOrderToExtTaskAbilityServiceImpl
implements FscReSendPayOrderToExtTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscReSendPayOrderToExtTaskAbilityServiceImpl.class);
    @Autowired
    private FscSendEleInvoiceToXhSrmAtomService fscSendEleInvoiceToXhSrmAtomService;
    @Autowired
    private FscSendPayBillOrderToXhSrmAtomService fscSendPayBillOrderToXhSrmAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${FSC_FINANCIAL_SHARED_SEND_TOPIC:FSC_FINANCIAL_SHARED_SEND_TOPIC}")
    private String FSC_FINANCIAL_SHARED_SEND_TOPIC;
    @Resource(name="fscFinancialSharedSendProducer")
    private ProxyMessageProducer fscFinancialSharedSendProducer;
    @Value(value="${secondOrgId.xh}")
    private Long SECONDORGID_XH;
    @Value(value="${secondOrgId.notSend.xh:794261675996319744}")
    private String secondOrgIdNotSendXh;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @PostMapping(value={"reSendPayOrderToExtTask"})
    public FscReSendPayOrderToExtTaskAbilityRspBO reSendPayOrderToExtTask(@RequestBody FscReSendPayOrderToExtTaskAbilityReqBO reqBO) {
        if (!ObjectUtil.isEmpty((Object)reqBO.getFscOrderIds())) {
            for (Long fscOrderId : reqBO.getFscOrderIds()) {
                FscSendPaymentOrderAtomReqBO fscSendPaymentOrderAtomReqBO = new FscSendPaymentOrderAtomReqBO();
                fscSendPaymentOrderAtomReqBO.setFscOrderId(fscOrderId);
                fscSendPaymentOrderAtomReqBO.setIsprofes("1");
                log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3mq\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)fscSendPaymentOrderAtomReqBO)));
                fscSendPaymentOrderAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
                fscSendPaymentOrderAtomReqBO.setSysTenantName(reqBO.getSysTenantName());
                ProxyMessage message = new ProxyMessage(this.FSC_FINANCIAL_SHARED_SEND_TOPIC, "*", JSON.toJSONString((Object)((Object)fscSendPaymentOrderAtomReqBO)));
                this.fscFinancialSharedSendProducer.send(message);
                log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3mq\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)message));
            }
        } else {
            FscOrderPO fscOrderPO = new FscOrderPO();
            if (ObjectUtil.isNotEmpty((Object)this.secondOrgIdNotSendXh)) {
                String[] splitArray = this.secondOrgIdNotSendXh.split(",");
                List secondOrgIdList = new ArrayList<String>(Arrays.asList(splitArray)).stream().map(Long::valueOf).collect(Collectors.toList());
                fscOrderPO.setNotSecondOrgIdList(secondOrgIdList);
            }
            fscOrderPO.setSendExtSystemCount(reqBO.getSendExtSystemCount());
            Page page = new Page();
            int pageNo = 1;
            int pageSize = 1000;
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            List fscOrderPOList = this.fscOrderMapper.getReSendOrderByXh(fscOrderPO, page);
            while (!ObjectUtil.isEmpty((Object)fscOrderPOList)) {
                for (FscOrderPO item : fscOrderPOList) {
                    Object fscSendEleInvoiceToXhSrmAtomRspBO = null;
                    Object fscSendPayBillOrderToXhSrmAtomRspBO = null;
                    FscSendPaymentOrderAtomReqBO fscSendPaymentOrderAtomReqBO = new FscSendPaymentOrderAtomReqBO();
                    fscSendPaymentOrderAtomReqBO.setFscOrderId(item.getFscOrderId());
                    fscSendPaymentOrderAtomReqBO.setIsprofes("1");
                    fscSendPaymentOrderAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
                    fscSendPaymentOrderAtomReqBO.setSysTenantName(reqBO.getSysTenantName());
                    log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3mq\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)fscSendPaymentOrderAtomReqBO)));
                    ProxyMessage message = new ProxyMessage(this.FSC_FINANCIAL_SHARED_SEND_TOPIC, "*", JSON.toJSONString((Object)((Object)fscSendPaymentOrderAtomReqBO)));
                    this.fscFinancialSharedSendProducer.send(message);
                    log.info("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3mq\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)message));
                }
                log.info("\u91cd\u63a8\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3mq\u6b21\u6570:{}", (Object)pageNo);
                page.setPageSize(pageSize);
                page.setPageNo(++pageNo);
                fscOrderPOList = new ArrayList();
                fscOrderPOList = this.fscOrderMapper.getReSendOrderByXh(fscOrderPO, page);
            }
        }
        return new FscReSendPayOrderToExtTaskAbilityRspBO();
    }

    private void updateOrderState(Long fscOrderId, String errorMsg, Integer type) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setSyncTime(new Date(System.currentTimeMillis()));
        fscOrderPO.setSendExtSystemCount(Integer.valueOf(1));
        if (type == 1) {
            fscOrderPO.setSyncTime(new Date(System.currentTimeMillis()));
            fscOrderPO.setSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setSyncFailReason(errorMsg);
        } else {
            fscOrderPO.setInvoiceSyncTime(new Date(System.currentTimeMillis()));
            fscOrderPO.setInvoiceSyncState(FscConstants.SYNC_STATE_TYPE.FAIL);
            fscOrderPO.setInvoiceSyncFailReason(errorMsg);
        }
        this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
    }
}

