/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscStockMapper;
import com.tydic.fsc.pay.busi.api.FscPayReverseBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayReverseBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayReverseBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscStockPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class FscPayReverseBusiServiceImpl
implements FscPayReverseBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscStockMapper fscStockMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @Override
    public FscPayReverseBusiRspBO payReverse(FscPayReverseBusiReqBO reqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderNo(reqBO.getSourceNo());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtils.isEmpty((Object)fscOrderPO)) {
            throw new ZTBusinessException("\u83b7\u53d6\u7ed3\u7b97\u4e3a\u7a7a");
        }
        FscPayReverseBusiRspBO rspBO = new FscPayReverseBusiRspBO();
        if (!"WAREHOUSE".equals(reqBO.getSourceType())) {
            FscOrderPO temp = new FscOrderPO();
            temp.setFscOrderId(fscOrderPO.getFscOrderId());
            FscOrderPO modelBy = this.fscOrderMapper.getModelBy(temp);
            if (modelBy == null) {
                rspBO.setStatus("FAIL");
                rspBO.setMessage("\u4ed8\u6b3e\u5355id\uff08" + reqBO.getSourceNo() + "\uff09\u4e0d\u5b58\u5728");
                return rspBO;
            }
            FscOrderPO fscOrderPo = new FscOrderPO();
            fscOrderPo.setFscOrderId(modelBy.getFscOrderId());
            if ("VOID".equals(reqBO.getSourceStatus())) {
                fscOrderPo.setOrderSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.REJECT);
                if ("PAYMENT".equals(reqBO.getSourceType())) {
                    fscOrderPo.setSyncState(FscConstants.SYNC_STATE_TYPE.REJECT);
                    fscOrderPo.setSyncTime(new Date());
                }
            }
            fscOrderPo.setOrderSyncTime(new Date());
            this.fscOrderMapper.updateById(fscOrderPo);
        } else {
            FscStockPO tmp = new FscStockPO();
            tmp.setFscOrderId(fscOrderPO.getFscOrderId());
            List list = this.fscStockMapper.getList(tmp);
            if (CollectionUtils.isEmpty((Collection)list)) {
                rspBO.setStatus("FAIL");
                rspBO.setMessage("\u4ed8\u6b3e\u5355id\uff08" + reqBO.getSourceNo() + "\uff09\u4e0d\u5b58\u5728");
                return rspBO;
            }
            FscStockPO set = new FscStockPO();
            if ("VOID".equals(reqBO.getSourceStatus())) {
                set.setSyncState(FscConstants.FINANCIAL_SYNC_STATE_TYPE.REJECT);
            }
            set.setSyncTime(new Date());
            FscStockPO where = new FscStockPO();
            where.setFscOrderId(fscOrderPO.getFscOrderId());
            this.fscStockMapper.updateBy(set, where);
        }
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscComOrderListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        rspBO.setStatus("SUCCESS");
        rspBO.setMessage("\u6210\u529f");
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

