/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mmc.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.mmc.ability.bo.MmcShopAccessoryBO;
import com.tydic.mmc.ability.bo.MmcShopBO;
import com.tydic.mmc.ability.bo.MmcShopContactsBO;
import com.tydic.mmc.ability.bo.MmcSupplierSalesCategoryBO;
import com.tydic.mmc.busi.api.MmcSaveShopInfoBusiService;
import com.tydic.mmc.busi.bo.MmcSaveShopInfoBusiReqBO;
import com.tydic.mmc.busi.bo.MmcSaveShopInfoBusiRspBO;
import com.tydic.mmc.dao.MmcShopAccessoryMapper;
import com.tydic.mmc.dao.MmcShopContactsMapper;
import com.tydic.mmc.dao.MmcShopMapper;
import com.tydic.mmc.dao.MmcSupplierSalesCategoryMapper;
import com.tydic.mmc.po.MmcShopAccessoryPo;
import com.tydic.mmc.po.MmcShopContactsPo;
import com.tydic.mmc.po.MmcShopPo;
import com.tydic.mmc.po.MmcSupplierSalesCategoryPo;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MmcSaveShopInfoBusiServiceImpl
implements MmcSaveShopInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(MmcSaveShopInfoBusiServiceImpl.class);
    @Autowired
    private MmcShopMapper mmcShopMapper;
    @Autowired
    private MmcShopAccessoryMapper mmcShopAccessoryMapper;
    @Autowired
    private MmcShopContactsMapper mmcShopContactsMapper;
    @Autowired
    private MmcSupplierSalesCategoryMapper mmcSupplierSalesCategoryMapper;

    @Override
    public MmcSaveShopInfoBusiRspBO saveShopInfo(MmcSaveShopInfoBusiReqBO mmcSaveShopInfoBusiReqBO) {
        Long shopId = 0L;
        if (mmcSaveShopInfoBusiReqBO.getShopId() != null) {
            log.info("\u4fee\u6539\u5e97\u94fa\u4fe1\u606f");
            shopId = this.updateInfo(mmcSaveShopInfoBusiReqBO);
        } else if (mmcSaveShopInfoBusiReqBO.getShopId() == null) {
            log.info("\u65b0\u589e\u5e97\u94fa\u4fe1\u606f");
            shopId = this.saveInfo(mmcSaveShopInfoBusiReqBO);
        }
        MmcSaveShopInfoBusiRspBO rspBO = new MmcSaveShopInfoBusiRspBO();
        rspBO.setShopId(shopId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5e97\u94fa\u4e2d\u5fc3\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        return rspBO;
    }

    private Long updateInfo(MmcSaveShopInfoBusiReqBO mmcSaveShopInfoBusiReqBO) {
        this.updateShopInfo(mmcSaveShopInfoBusiReqBO);
        this.addOrUpdateShopAccessory(mmcSaveShopInfoBusiReqBO);
        this.addOrUpdateShopContacts(mmcSaveShopInfoBusiReqBO);
        this.addOrUpdateSupplierSalesCategory(mmcSaveShopInfoBusiReqBO);
        return mmcSaveShopInfoBusiReqBO.getShopId();
    }

    private Long saveInfo(MmcSaveShopInfoBusiReqBO mmcSaveShopInfoBusiReqBO) {
        Long shopId = this.addShopInfo(mmcSaveShopInfoBusiReqBO);
        mmcSaveShopInfoBusiReqBO.setShopId(shopId);
        this.addOrUpdateShopAccessory(mmcSaveShopInfoBusiReqBO);
        this.addOrUpdateShopContacts(mmcSaveShopInfoBusiReqBO);
        this.addOrUpdateSupplierSalesCategory(mmcSaveShopInfoBusiReqBO);
        return shopId;
    }

    private Long addShopInfo(MmcSaveShopInfoBusiReqBO mmcSaveShopInfoBusiReqBO) {
        MmcShopPo mmcShopPo = new MmcShopPo();
        long shopId = Sequence.getInstance().nextId();
        mmcShopPo.setShopId(shopId);
        mmcShopPo.setSupplierId(mmcSaveShopInfoBusiReqBO.getSupplierId());
        mmcShopPo.setSupplierName(mmcSaveShopInfoBusiReqBO.getSupplierName());
        MmcShopBO mmcShopBO = mmcSaveShopInfoBusiReqBO.getMmcShopBO();
        mmcShopPo.setShopName(mmcShopBO.getShopName());
        mmcShopPo.setShopAddress(mmcShopBO.getShopAddress());
        mmcShopPo.setShopDescribe(mmcShopBO.getShopDescribe());
        mmcShopPo.setShopWebsite(mmcShopBO.getShopWebsite());
        mmcShopPo.setShopLogoUrl(mmcShopBO.getShopLogoUrl());
        mmcShopPo.setShipSignUrl(mmcShopBO.getShipSignUrl());
        mmcShopPo.setRemark(mmcShopBO.getRemark());
        mmcShopPo.setStatus("1");
        mmcShopPo.setCreateDeptId(mmcShopBO.getCreateDeptId());
        mmcShopPo.setCreateDeptName(mmcShopBO.getCreateDeptName());
        mmcShopPo.setCreateUserId(mmcShopBO.getCreateUserId());
        mmcShopPo.setCreateUserName(mmcShopBO.getCreateUserName());
        mmcShopPo.setCreateTime(new Date());
        mmcShopPo.setSysTenantId(mmcSaveShopInfoBusiReqBO.getSysTenantId());
        mmcShopPo.setSysTenantName(mmcSaveShopInfoBusiReqBO.getSysTenantName());
        int i = this.mmcShopMapper.insertSelective(mmcShopPo);
        if (i != 1) {
            throw new ZTBusinessException("\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
        }
        return shopId;
    }

    private void updateShopInfo(MmcSaveShopInfoBusiReqBO mmcSaveShopInfoBusiReqBO) {
        Long shopId = mmcSaveShopInfoBusiReqBO.getShopId();
        int i = this.mmcShopMapper.deleteByPrimaryKey(shopId);
        if (i != 1) {
            throw new ZTBusinessException("\u5e97\u94fa\u4fe1\u606f\u5220\u9664\u5931\u8d25");
        }
        MmcShopPo mmcShopPo = new MmcShopPo();
        mmcShopPo.setShopId(shopId);
        mmcShopPo.setSupplierId(mmcSaveShopInfoBusiReqBO.getSupplierId());
        mmcShopPo.setSupplierName(mmcSaveShopInfoBusiReqBO.getSupplierName());
        MmcShopBO mmcShopBO = mmcSaveShopInfoBusiReqBO.getMmcShopBO();
        mmcShopPo.setShopName(mmcShopBO.getShopName());
        mmcShopPo.setShopAddress(mmcShopBO.getShopAddress());
        mmcShopPo.setShopDescribe(mmcShopBO.getShopDescribe());
        mmcShopPo.setShopWebsite(mmcShopBO.getShopWebsite());
        mmcShopBO.setShopLogoUrl(mmcShopBO.getShopLogoUrl());
        mmcShopPo.setShipSignUrl(mmcShopBO.getShipSignUrl());
        mmcShopPo.setRemark(mmcShopBO.getRemark());
        mmcShopPo.setStatus("1");
        mmcShopPo.setSysTenantId(mmcSaveShopInfoBusiReqBO.getSysTenantId());
        mmcShopPo.setSysTenantName(mmcSaveShopInfoBusiReqBO.getSysTenantName());
        mmcShopBO.setUpDate(new Date());
        mmcShopBO.setUpdateUserId(mmcSaveShopInfoBusiReqBO.getOperId());
        mmcShopBO.setUpdateUserName(mmcSaveShopInfoBusiReqBO.getOperName());
        int j = this.mmcShopMapper.insertSelective(mmcShopPo);
        if (j != 1) {
            throw new ZTBusinessException("\u5e97\u94fa\u4fe1\u606f\u4fee\u6539\u5931\u8d25");
        }
    }

    private void addOrUpdateShopAccessory(MmcSaveShopInfoBusiReqBO mmcSaveShopInfoBusiReqBO) {
        List<MmcShopAccessoryBO> mmcShopAccessoryBOs = mmcSaveShopInfoBusiReqBO.getMmcShopAccessoryBOs();
        if (mmcShopAccessoryBOs != null && mmcShopAccessoryBOs.size() > 0) {
            for (MmcShopAccessoryBO mmcShopAccessoryBO : mmcShopAccessoryBOs) {
                int i;
                MmcShopAccessoryPo mmcShopAccessoryPo = new MmcShopAccessoryPo();
                if (mmcShopAccessoryBO.getAccessoryId() != null) {
                    log.info("\u8f6e\u64ad\u56fe\u4fee\u6539");
                    i = this.mmcShopAccessoryMapper.deleteByPrimaryKey(mmcShopAccessoryBO.getAccessoryId());
                    if (i != 1) {
                        throw new ZTBusinessException("\u5e97\u94fa\u8f6e\u64ad\u56fe\u4fee\u6539-\u5220\u9664\u5931\u8d25");
                    }
                    mmcShopAccessoryPo.setAccessoryId(mmcShopAccessoryBO.getAccessoryId());
                } else {
                    log.info("\u8f6e\u64ad\u56fe\u65b0\u589e");
                    mmcShopAccessoryPo.setAccessoryId(Sequence.getInstance().nextId());
                }
                mmcShopAccessoryPo.setShopId(mmcSaveShopInfoBusiReqBO.getShopId());
                mmcShopAccessoryPo.setRelativeId(mmcSaveShopInfoBusiReqBO.getShopId());
                mmcShopAccessoryPo.setRelativeType("1");
                mmcShopAccessoryPo.setAccessoryName(mmcShopAccessoryBO.getAccessoryName());
                mmcShopAccessoryPo.setAccessoryUrl(mmcShopAccessoryBO.getAccessoryUrl());
                mmcShopAccessoryPo.setAccessorySerial(mmcShopAccessoryBO.getAccessorySerial());
                mmcShopAccessoryPo.setSysTenantId(mmcSaveShopInfoBusiReqBO.getSysTenantId());
                mmcShopAccessoryPo.setSysTenantName(mmcSaveShopInfoBusiReqBO.getSysTenantName());
                i = this.mmcShopAccessoryMapper.insertSelective(mmcShopAccessoryPo);
                if (i == 1) continue;
                throw new ZTBusinessException("\u5e97\u94fa\u8f6e\u64ad\u56fe\u65b0\u589e\u5931\u8d25");
            }
        }
    }

    private void addOrUpdateShopContacts(MmcSaveShopInfoBusiReqBO mmcSaveShopInfoBusiReqBO) {
        List<MmcShopContactsBO> mmcShopContactsBOs = mmcSaveShopInfoBusiReqBO.getMmcShopContactsBOs();
        if (mmcShopContactsBOs != null && mmcShopContactsBOs.size() > 0) {
            for (MmcShopContactsBO mmcShopContactsBO : mmcShopContactsBOs) {
                int i;
                MmcShopContactsPo mmcShopContactsPo = new MmcShopContactsPo();
                if (mmcShopContactsBO.getContractId() != null) {
                    log.info("\u5e97\u94fa\u8054\u7cfb\u4eba\u4fee\u6539");
                    i = this.mmcShopContactsMapper.deleteByPrimaryKey(mmcShopContactsBO.getContractId());
                    if (i != 1) {
                        throw new ZTBusinessException("\u5e97\u94fa\u8054\u7cfb\u4eba\u4fee\u6539-\u5220\u9664\u5931\u8d25");
                    }
                    mmcShopContactsPo.setContractId(mmcShopContactsBO.getContractId());
                } else {
                    log.info("\u5e97\u94fa\u8054\u7cfb\u4eba\u65b0\u589e");
                    mmcShopContactsPo.setContractId(Sequence.getInstance().nextId());
                }
                mmcShopContactsPo.setShopId(mmcSaveShopInfoBusiReqBO.getShopId());
                mmcShopContactsPo.setRelativeId(mmcSaveShopInfoBusiReqBO.getShopId());
                mmcShopContactsPo.setRelativeType("1");
                mmcShopContactsPo.setContractName(mmcShopContactsBO.getContractName());
                mmcShopContactsPo.setPosition(mmcShopContactsBO.getPosition());
                mmcShopContactsPo.setContactPhone(mmcShopContactsBO.getContactPhone());
                mmcShopContactsPo.setRemark(mmcShopContactsBO.getRemark());
                mmcShopContactsPo.setSysTenantId(mmcSaveShopInfoBusiReqBO.getSysTenantId());
                mmcShopContactsPo.setSysTenantName(mmcSaveShopInfoBusiReqBO.getSysTenantName());
                i = this.mmcShopContactsMapper.insertSelective(mmcShopContactsPo);
                if (i == 1) continue;
                throw new ZTBusinessException("\u5e97\u94fa\u8054\u7cfb\u4eba\u65b0\u589e-\u5931\u8d25");
            }
        }
    }

    private void addOrUpdateSupplierSalesCategory(MmcSaveShopInfoBusiReqBO mmcSaveShopInfoBusiReqBO) {
        List<MmcSupplierSalesCategoryBO> mmcSupplierSalesCategoryBOs = mmcSaveShopInfoBusiReqBO.getMmcSupplierSalesCategoryBOs();
        if (mmcSupplierSalesCategoryBOs != null && mmcSupplierSalesCategoryBOs.size() > 0) {
            for (MmcSupplierSalesCategoryBO mmcSupplierSalesCategoryBO : mmcSupplierSalesCategoryBOs) {
                int i;
                MmcSupplierSalesCategoryPo mmcSupplierSalesCategoryPo = new MmcSupplierSalesCategoryPo();
                if (mmcSupplierSalesCategoryBO.getSalesCategoryId() != null) {
                    log.info("\u5e97\u94fa\u4f9b\u5e94\u5546\u5546\u54c1\u5206\u7c7b\u4fee\u6539");
                    i = this.mmcSupplierSalesCategoryMapper.deleteByPrimaryKey(mmcSupplierSalesCategoryBO.getSalesCategoryId());
                    if (i != 1) {
                        throw new ZTBusinessException("\u5e97\u94fa\u4f9b\u5e94\u5546\u5546\u54c1\u5206\u7c7b\u4fee\u6539-\u5220\u9664\u5931\u8d25");
                    }
                    mmcSupplierSalesCategoryPo.setSalesCategoryId(mmcSupplierSalesCategoryBO.getSalesCategoryId());
                } else {
                    log.info("\u5e97\u94fa\u4f9b\u5e94\u5546\u5546\u54c1\u5206\u7c7b\u65b0\u589e");
                    mmcSupplierSalesCategoryPo.setSalesCategoryId(Sequence.getInstance().nextId());
                }
                mmcSupplierSalesCategoryPo.setShopId(mmcSaveShopInfoBusiReqBO.getShopId());
                mmcSupplierSalesCategoryPo.setSupplierId(mmcSaveShopInfoBusiReqBO.getSupplierId());
                mmcSupplierSalesCategoryPo.setItemCatId(mmcSupplierSalesCategoryBO.getItemCatId());
                mmcSupplierSalesCategoryPo.setItemCatName(mmcSupplierSalesCategoryBO.getItemCatName());
                mmcSupplierSalesCategoryPo.setSysTenantId(mmcSaveShopInfoBusiReqBO.getSysTenantId());
                mmcSupplierSalesCategoryPo.setSysTenantName(mmcSaveShopInfoBusiReqBO.getSysTenantName());
                i = this.mmcSupplierSalesCategoryMapper.insertSelective(mmcSupplierSalesCategoryPo);
                if (i == 1) continue;
                throw new ZTBusinessException("\u5e97\u94fa\u4f9b\u5e94\u5546\u5546\u54c1\u5206\u7c7b\u65b0\u589e-\u5931\u8d25");
            }
        }
    }
}

