/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.constants.hr;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorInfoChecker {
    private static final Map<String, String> checkMap = new HashMap<String, String>();

    private static void init() {
        checkMap.put("\u5546\u54c1\u4f20\u53c2\u4ef7\u683c\u4e0e\u552e\u5356\u4ef7\u683c\u4e0d\u7b49", "COMMODITY_PRICE_ERROR");
        checkMap.put("\u5546\u54c1\u7684\u4e0b\u5355\u6570\u91cf\u6709\u8bef", "COMMODITY_PRICE_ERROR");
        checkMap.put("\u5546\u54c1\u4ef7\u683c\u6709\u8bef", "COMMODITY_PRICE_ERROR");
        checkMap.put("\u5b57\u6570\u8fc7\u957f", "WORD_COUNT_ERROR");
        checkMap.put("\u8d2d\u4e70\u6570\u91cf\u4e0d\u6ee1\u8db3\u6700\u5c0f\u8d77\u8ba2\u91cf", "MINIMUM_ORDER_ERROR1");
        checkMap.put("\u8d2d\u4e70\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u6700\u5c0f\u8d77\u8ba2\u91cf", "MINIMUM_ORDER_ERROR2");
        checkMap.put("\u91c7\u8d2d\u6570\u91cf\u672a\u8fbe\u5230\u6700\u5c0f\u8d77\u8ba2\u91cf", "MINIMUM_ORDER_ERROR3");
        checkMap.put("\u589e\u5e45\u6700\u5927\u4e3a", "MINIMUM_ORDER_ERROR4");
        checkMap.put("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u65e0\u6cd5\u4e0b\u5355", "INSUFFICIENT_INVENTORY");
        checkMap.put("\u5e93\u5b58\u4e0d\u8db3", "INSUFFICIENT_INVENTORY");
        checkMap.put("\u7684\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3", "INSUFFICIENT_INVENTORY");
        checkMap.put("\u7684\u9644\u4ef6\u5e93\u5b58\u4e0d\u8db3", "INSUFFICIENT_INVENTORY");
        checkMap.put("\u4ea7\u54c1\u5373\u5c06\u4e0b\u67b6", "SUPPLIER_OUT_OF_STOCK");
        checkMap.put("\u5546\u54c1\u4e3a\u5f85\u8be2\u4ef7\u72b6\u6001", "SUPPLIER_OUT_OF_STOCK");
        checkMap.put("\u5df2\u5b58\u5728", "ORDER_EXIT_ERROR");
        checkMap.put("\u5e93\u5b58\u5360\u7528\u5931\u8d25", "OCCUPANCY_FAILURE");
        checkMap.put("\u53d1\u7968\u62ac\u5934\u5ba2\u6237\u540d\u79f0\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f\u672a\u914d\u7f6e", "INVOICE_INFO_ERROR");
        checkMap.put("\u7cfb\u7edf\u5f02\u5e38", "SYSTEM_ERROR");
        checkMap.put("\u843d\u5730\u670d\u52a1\u5f02\u5e38", "SYSTEM_ERROR");
        checkMap.put("\u7cfb\u7edf\u7e41\u5fd9", "SYSTEM_ERROR");
        checkMap.put("\u670d\u52a1\u5f02\u5e38", "SYSTEM_ERROR");
        checkMap.put("\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7", "SYSTEM_ERROR");
        checkMap.put("\u63d2\u4ef6\u6267\u884c\u5f02\u5e38", "SYSTEM_ERROR");
        checkMap.put("\u5b83\u518d\u4e5f\u65e0\u6cd5\u4f7f\u7528", "SYSTEM_ERROR");
        checkMap.put("\u8c03\u7528\u7ec4\u5408\u903b\u8f91\u811a\u672c\u5931\u8d25", "SYSTEM_ERROR");
        checkMap.put("\u60a8\u7684\u4f59\u989d\u4e0d\u8db3", "BALANCE_ERROR");
        checkMap.put("\u6536\u8d27\u4eba\u5730\u5740\u6709\u8bef", "ADDRESS_ERROR");
        checkMap.put("\u6536\u8d27\u5730\u5740\u8054\u7cfb\u4eba\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e", "CONTACT_NAME_ERROR");
        checkMap.put("\u914d\u9001\u4e2d\u5fc3", "DELIVERY_ERROR");
        checkMap.put("\u5931\u8d25", "FAILURE_ERROR");
        checkMap.put("\u533a\u57df", "REGION_ERROR");
        checkMap.put("\u5e73\u53f0\u9274\u6743\u83b7\u53d6\u5931\u8d25", "PLATFORM_AUTHENTICATION_ERROR");
        checkMap.put("\u884c\u4e1a\u4e13\u5c5e\u6807\u7b7e\u4e0e\u5ba2\u6237\u884c\u4e1a\u4e0d\u4e00\u81f4", "PROFESSION_ERROR");
    }

    public static Map<String, String> replace(String errorInfo, Object supName, Map<String, String> saleInfoMap, String saleOrderNo, String buyerName, Map<String, BigDecimal> purCountMap) {
        Map<String, String> resMap = new HashMap<String, String>();
        resMap.put("content", errorInfo);
        resMap.put("title", "\u4e0b\u5355\u5931\u8d25");
        ErrorInfoChecker.init();
        String pattern = "[\u4e00-\u9fa5]+";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(errorInfo);
        boolean isFinish = false;
        block44: while (m.find() && !isFinish) {
            String errorType = checkMap.get(m.group());
            if (null == errorType) continue;
            switch (errorType) {
                case "COMMODITY_PRICE_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.commodityPriceError(errorInfo, saleInfoMap);
                    continue block44;
                }
                case "WORD_COUNT_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.wordCountError(errorInfo);
                    continue block44;
                }
                case "MINIMUM_ORDER_ERROR1": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.minimumOrderError1(errorInfo, saleInfoMap, purCountMap);
                    continue block44;
                }
                case "MINIMUM_ORDER_ERROR2": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.minimumOrderError2(errorInfo, saleInfoMap);
                    continue block44;
                }
                case "MINIMUM_ORDER_ERROR3": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.minimumOrderError3(errorInfo, saleInfoMap, purCountMap);
                    continue block44;
                }
                case "MINIMUM_ORDER_ERROR4": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.minimumOrderError4(errorInfo, saleInfoMap, purCountMap);
                    continue block44;
                }
                case "INSUFFICIENT_INVENTORY": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.insufficientInventory(errorInfo, saleInfoMap, supName);
                    continue block44;
                }
                case "SUPPLIER_OUT_OF_STOCK": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.supplierOutOfStock(errorInfo, saleInfoMap, supName);
                    continue block44;
                }
                case "ORDER_EXIT_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.orderExitError(errorInfo, saleOrderNo);
                    continue block44;
                }
                case "OCCUPANCY_FAILURE": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.occupancyFailure(errorInfo, supName);
                    continue block44;
                }
                case "INVOICE_INFO_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.invoiceInfoError(errorInfo, buyerName);
                    continue block44;
                }
                case "SYSTEM_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.systemError(errorInfo);
                    continue block44;
                }
                case "BALANCE_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.balanceError(errorInfo);
                    continue block44;
                }
                case "ADDRESS_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.addressError(errorInfo);
                    continue block44;
                }
                case "CONTACT_NAME_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.contactNameError(errorInfo);
                    continue block44;
                }
                case "DELIVERY_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.deliveryError(errorInfo);
                    continue block44;
                }
                case "FAILURE_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.failureError(errorInfo, supName);
                    continue block44;
                }
                case "REGION_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.regionError(errorInfo);
                    continue block44;
                }
                case "PLATFORM_AUTHENTICATION_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.platformAuthenticationError(errorInfo);
                    continue block44;
                }
                case "PROFESSION_ERROR": {
                    isFinish = true;
                    resMap = ErrorInfoChecker.professionError(errorInfo, supName);
                    continue block44;
                }
            }
            isFinish = true;
        }
        return resMap;
    }

    private static Map<String, String> professionError(String errorInfo, Object supName) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u884c\u4e1a\u4e13\u5c5e\u6807\u7b7e\u4e0e\u5ba2\u6237\u884c\u4e1a\u4e0d\u4e00\u81f4");
        StringBuilder sb = new StringBuilder("\u5546\u54c1\u7f16\u7801");
        Pattern r = Pattern.compile("\\w+");
        Matcher m1 = r.matcher(errorInfo);
        ArrayList<String> list = new ArrayList<String>();
        while (m1.find()) {
            if (list.size() == 1) {
                sb.append("\u3001");
            }
            if (list.size() == 2) {
                sb.append("\u548c");
            }
            list.add(m1.group());
            if (list.size() < 4) {
                sb.append("\"" + m1.group() + "\"");
            }
            if (list.size() < 4) continue;
            sb.append("\u7b49");
        }
        sb.append("\u884c\u4e1a\u4e13\u5c5e\u6807\u7b7e\u4e0e\u5ba2\u6237\u884c\u4e1a\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\uff0c\u8bf7\u8054\u7cfb\u4f9b\u5e94\u5546\uff1a" + supName + "\u5728\u7ebf\u5ba2\u670d\u5904\u7406\uff1b");
        System.out.println(sb);
        res.put("content", sb.toString());
        return res;
    }

    private static Map<String, String> platformAuthenticationError(String errorInfo) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u5e73\u53f0\u9274\u6743\u83b7\u53d6\u5931\u8d25");
        System.out.println(errorInfo);
        res.put("content", errorInfo);
        return res;
    }

    private static Map<String, String> regionError(String errorInfo) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u533a\u57df\u4e0d\u5b58\u5728");
        System.out.println("\u60a8\u8f93\u5165\u7684\u5730\u5740\u533a\u57df\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u4eac\u4e1c\u5728\u7ebf\u5ba2\u670d\u3002");
        res.put("content", "\u60a8\u8f93\u5165\u7684\u5730\u5740\u533a\u57df\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u4eac\u4e1c\u5728\u7ebf\u5ba2\u670d\u3002");
        return res;
    }

    private static Map<String, String> failureError(String errorInfo, Object supName) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u8ba2\u5355\u5931\u8d25");
        System.out.println("\u8ba2\u5355\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355\u3002");
        res.put("content", supName + "\u8ba2\u5355\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355\u3002");
        return res;
    }

    private static Map<String, String> deliveryError(String errorInfo) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u914d\u9001\u4fe1\u606f\u6709\u8bef");
        System.out.println("\u60a8\u8f93\u5165\u7684\u914d\u9001\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u4eac\u4e1c\u5728\u7ebf\u5ba2\u670d\u3002");
        res.put("content", "\u60a8\u8f93\u5165\u7684\u914d\u9001\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u4eac\u4e1c\u5728\u7ebf\u5ba2\u670d\u3002");
        return res;
    }

    private static Map<String, String> contactNameError(String errorInfo) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u6536\u8d27\u5730\u5740\u8054\u7cfb\u4eba\u540d\u79f0\u8fc7\u957f");
        String pattern = "-?[1-9]\\d*";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(errorInfo);
        while (m.find()) {
            System.out.println(m.group());
            res.put("content", "\u60a8\u597d\uff0c\u6536\u8d27\u5730\u5740\u8054\u7cfb\u4eba\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e" + m.group() + "\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002");
        }
        return res;
    }

    private static Map<String, String> addressError(String errorInfo) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u6536\u8d27\u4eba\u5730\u5740\u6709\u8bef");
        System.out.println("\u60a8\u597d\uff0c\u60a8\u8f93\u5165\u7684\u6536\u8d27\u4eba\u5730\u5740\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u4eac\u4e1c\u5728\u7ebf\u5ba2\u670d\u3002");
        res.put("content", "\u60a8\u597d\uff0c\u60a8\u8f93\u5165\u7684\u6536\u8d27\u4eba\u5730\u5740\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u4eac\u4e1c\u5728\u7ebf\u5ba2\u670d\u3002");
        return res;
    }

    private static Map<String, String> balanceError(String errorInfo) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u4f59\u989d\u4e0d\u8db3");
        System.out.println("\u60a8\u7684\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u4eac\u4e1c\u5728\u7ebf\u5ba2\u670d\u3002");
        res.put("content", "\u60a8\u7684\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u4eac\u4e1c\u5728\u7ebf\u5ba2\u670d\u3002");
        return res;
    }

    private static Map<String, String> systemError(String errorInfo) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u7cfb\u7edf\u7e41\u5fd9");
        System.out.println("\u60a8\u597d\uff0c\u7cfb\u7edf\u7e41\u5fd9\uff0c\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u665a\u518d\u4e0b\u5355\uff0c\u611f\u8c22\u60a8\u7684\u7406\u89e3\u548c\u652f\u6301\u3002");
        res.put("content", "\u60a8\u597d\uff0c\u7cfb\u7edf\u7e41\u5fd9\uff0c\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u665a\u518d\u4e0b\u5355\uff0c\u611f\u8c22\u60a8\u7684\u7406\u89e3\u548c\u652f\u6301\u3002");
        return res;
    }

    private static Map<String, String> invoiceInfoError(String errorInfo, String buyerName) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u53d1\u7968\u4fe1\u606f\u4e0d\u5339\u914d");
        String[] split = errorInfo.split("\uff1a");
        System.out.println(split[1]);
        res.put("content", "\u8ba2\u5355\u53d1\u7968\u62ac\u5934\u4e3a\"" + buyerName + "\";\n\u5bf9\u5e94\u53d1\u7968\u62ac\u5934\u4e3a\"" + split[1] + "\",\u8bf7\u786e\u8ba4\u540e\u518d\u63d0\u4ea4\u3002");
        return res;
    }

    private static Map<String, String> occupancyFailure(String errorInfo, Object supName) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u9884\u5360\u5e93\u5b58\u5931\u8d25");
        res.put("content", supName + "\u5e93\u5b58\u5360\u7528\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355\u3002");
        return res;
    }

    private static Map<String, String> orderExitError(String errorInfo, String saleOrderNo) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u8ba2\u5355\u5df2\u5b58\u5728");
        res.put("content", "\u8ba2\u5355\"" + saleOrderNo + "\"\u5df2\u5b58\u5728\u3002");
        return res;
    }

    private static Map<String, String> supplierOutOfStock(String errorInfo, Map<String, String> saleInfoMap, Object supName) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u4f9b\u5e94\u5546\u65e0\u8d27");
        Pattern r = Pattern.compile("\\w+");
        Matcher m1 = r.matcher(errorInfo);
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        while (m1.find()) {
            if (++i <= 3) {
                sb.append(supName).append("\uff1a\u5546\u54c1").append("\"").append(saleInfoMap.get(m1.group())).append("\"").append("\u65e0\u8d27");
            }
            if (i <= 2) {
                sb.append("\uff1b").append("\n");
            } else if (i == 3) {
                sb.append("\u7b49\u3002");
            }
            System.out.println(saleInfoMap.get(m1.group()));
        }
        String content = sb.toString();
        if (i == 1) {
            content = content.replace("\uff1b", "\u3002");
        }
        res.put("content", content);
        return res;
    }

    private static Map<String, String> insufficientInventory(String errorInfo, Map<String, String> saleInfoMap, Object supName) {
        String[] split;
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u4e0b\u5355");
        if (errorInfo.contains("\uff0c")) {
            split = errorInfo.split("\uff0c");
            errorInfo = split[1];
        }
        if (errorInfo.contains("\uff1a")) {
            split = errorInfo.split("\uff1a");
            errorInfo = split[0];
        }
        String skuId = errorInfo.replace("SkuId", "");
        Pattern r = Pattern.compile("\\w+");
        Matcher m1 = r.matcher(skuId);
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        while (m1.find()) {
            if (++i <= 3) {
                sb.append(supName).append("\uff1a\u5546\u54c1").append("\"").append(saleInfoMap.get(m1.group())).append("\"");
            }
            if (i <= 2) {
                sb.append("\uff1b").append("\n");
                continue;
            }
            if (i != 3) continue;
            sb.append("\u7b49\u3002");
        }
        String content = sb.toString();
        if (i == 1) {
            content = content.replace("\uff1b", "\u3002");
        }
        res.put("content", content);
        return res;
    }

    private static Map<String, String> minimumOrderError(String errorInfo) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u4e0d\u6ee1\u8db3\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf");
        StringBuilder sb = new StringBuilder("\u5546\u54c1");
        Pattern r = Pattern.compile("\\w+");
        Matcher m1 = r.matcher(errorInfo);
        ArrayList<String> list = new ArrayList<String>();
        while (m1.find()) {
            list.add(m1.group());
            sb.append(m1.group()).append("\u3001");
        }
        int i = sb.lastIndexOf("\u3001");
        if (list.size() > 1) {
            sb.replace(i, i + 1, "\u7b49\uff0c");
        } else {
            sb.replace(i, i + 1, "\uff0c");
        }
        sb.append("\u4f9b\u5e94\u5546\u4ef7\u683c\u5df2\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
        System.out.println(sb);
        res.put("content", sb.toString());
        return res;
    }

    private static Map<String, String> minimumOrderError1(String errorInfo, Map<String, String> saleInfoMap, Map<String, BigDecimal> purCountMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u4e0d\u6ee1\u8db3\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf");
        errorInfo = errorInfo.replace("skuIds", "");
        StringBuilder sb = new StringBuilder("\u8d2d\u4e70\u6570\u91cf\u4e0d\u6ee1\u8db3\u6700\u5c0f\u8d77\u8ba2\u91cf\uff0c\u8bf7\u8c03\u6574\u91c7\u8d2d\u91cf\u91cd\u65b0\u4e0b\u5355\u3002\n");
        Pattern r = Pattern.compile("\\w+");
        Matcher m1 = r.matcher(errorInfo);
        ArrayList<String> list = new ArrayList<String>();
        while (m1.find()) {
            list.add(m1.group());
            sb.append("\u5546\u54c1\"").append(saleInfoMap.get(m1.group())).append("\"").append("\u6700\u5c0f\u8d77\u8ba2\u91cf\u4e3a\" \",").append("\u60a8\u7684\u91c7\u8d2d\u6570\u91cf\u4e3a\"").append(purCountMap.get(m1.group()).setScale(2, RoundingMode.HALF_UP)).append("\";\n");
        }
        System.out.println(sb);
        res.put("content", sb.toString());
        return res;
    }

    private static Map<String, String> minimumOrderError2(String errorInfo, Map<String, String> saleInfoMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u4e0d\u6ee1\u8db3\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf");
        StringBuilder sb = new StringBuilder("\u8d2d\u4e70\u6570\u91cf\u4e0d\u6ee1\u8db3\u6700\u5c0f\u8d77\u8ba2\u91cf\uff0c\u8bf7\u8c03\u6574\u91c7\u8d2d\u91cf\u91cd\u65b0\u4e0b\u5355\u3002\n");
        Pattern r = Pattern.compile("\\w+");
        Matcher m1 = r.matcher(errorInfo);
        ArrayList<String> list = new ArrayList<String>();
        while (m1.find()) {
            list.add(m1.group());
            if (list.size() == 1) {
                sb.append("\u5546\u54c1\"").append(saleInfoMap.get(m1.group())).append("\"").append("\u7684\u6700\u5c0f\u8d77\u8ba2\u91cf\u4e3a\"");
            }
            if (list.size() == 2) {
                sb.append(m1.group()).append("\",");
            }
            if (list.size() != 3) continue;
            sb.append("\u60a8\u7684\u91c7\u8d2d\u6570\u91cf\u4e3a\"").append(m1.group()).append("\";");
        }
        System.out.println(sb);
        res.put("content", sb.toString());
        return res;
    }

    private static Map<String, String> minimumOrderError3(String errorInfo, Map<String, String> saleInfoMap, Map<String, BigDecimal> purCountMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u4e0d\u6ee1\u8db3\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf");
        StringBuilder sb = new StringBuilder("\u8d2d\u4e70\u6570\u91cf\u4e0d\u6ee1\u8db3\u6700\u5c0f\u8d77\u8ba2\u91cf\uff0c\u8bf7\u8c03\u6574\u91c7\u8d2d\u91cf\u91cd\u65b0\u4e0b\u5355\u3002\n");
        Pattern r = Pattern.compile("\\w+");
        Matcher m1 = r.matcher(errorInfo);
        ArrayList<String> list = new ArrayList<String>();
        BigDecimal purCont = BigDecimal.ZERO;
        while (m1.find()) {
            list.add(m1.group());
            if (list.size() == 1) {
                sb.append("\u5546\u54c1\"").append(saleInfoMap.get(m1.group())).append("\"").append("\u7684\u6700\u5c0f\u8d77\u8ba2\u91cf\u4e3a\"");
                purCont = purCountMap.get(m1.group());
            }
            if (list.size() != 3) continue;
            sb.append(m1.group()).append("\"");
        }
        sb.append("\u60a8\u7684\u91c7\u8d2d\u6570\u91cf\u4e3a\"").append(purCont.setScale(2, RoundingMode.HALF_UP)).append("\";");
        System.out.println(sb);
        res.put("content", sb.toString());
        return res;
    }

    private static Map<String, String> minimumOrderError4(String errorInfo, Map<String, String> saleInfoMap, Map<String, BigDecimal> purCountMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u4e0d\u6ee1\u8db3\u5546\u54c1\u6700\u5c0f\u8d77\u8ba2\u91cf");
        StringBuilder sb = new StringBuilder("\u8d2d\u4e70\u6570\u91cf\u4e0d\u6ee1\u8db3\u6700\u5c0f\u8d77\u8ba2\u91cf\uff0c\u8bf7\u8c03\u6574\u91c7\u8d2d\u91cf\u91cd\u65b0\u4e0b\u5355\u3002\n");
        Pattern r = Pattern.compile("\\w+");
        Matcher m1 = r.matcher(errorInfo);
        ArrayList<String> list = new ArrayList<String>();
        BigDecimal purCont = BigDecimal.ZERO;
        while (m1.find()) {
            list.add(m1.group());
            if (list.size() % 2 == 0) {
                sb.append("\u7684\u6700\u5c0f\u8d77\u8ba2\u91cf\u4e3a\"").append(m1.group()).append("\"").append("\uff0c");
                sb.append("\u60a8\u7684\u91c7\u8d2d\u6570\u91cf\u4e3a\"").append(purCont.setScale(2, RoundingMode.HALF_UP));
                if (list.size() == 6) {
                    sb.append("\"\u7b49\uff1b");
                    break;
                }
                sb.append("\";\n");
                continue;
            }
            sb.append("\u5546\u54c1\"").append(saleInfoMap.get(m1.group())).append("\"");
            purCont = purCountMap.get(m1.group());
        }
        System.out.println(sb);
        res.put("content", sb.toString());
        return res;
    }

    private static Map<String, String> wordCountError(String errorInfo) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u5b57\u6570\u8fc7\u957f");
        StringBuilder sb = new StringBuilder();
        Pattern r = Pattern.compile("\\w+");
        Matcher m1 = r.matcher(errorInfo);
        ArrayList<String> list = new ArrayList<String>();
        while (m1.find()) {
            if (list.size() == 1) {
                sb.append("\u3001");
            }
            if (list.size() == 2) {
                sb.append("\u548c");
            }
            list.add(m1.group());
            if (list.size() < 4) {
                sb.append("\"" + m1.group() + "\"");
            }
            if (list.size() < 4) continue;
            sb.append("\u7b49");
        }
        sb.append("\u5b57\u6570\u8fc7\u957f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4");
        System.out.println(sb);
        res.put("content", sb.toString());
        return res;
    }

    private static Map<String, String> commodityPriceError(String errorInfo, Map<String, String> saleInfoMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("title", "\u5546\u54c1\u4ef7\u683c\u6709\u8bef");
        StringBuilder sb = new StringBuilder("\u5546\u54c1");
        Pattern r = Pattern.compile("\\w+");
        Matcher m1 = r.matcher(errorInfo);
        ArrayList<String> list = new ArrayList<String>();
        while (m1.find()) {
            if (list.size() == 1) {
                sb.append("\u3001");
            }
            if (list.size() == 2) {
                sb.append("\u548c");
            }
            list.add(m1.group());
            if (list.size() < 4) {
                sb.append("\"" + saleInfoMap.get(m1.group()) + "\"");
            }
            if (list.size() < 4) continue;
            sb.append("\u7b49");
        }
        sb.append("\uff0c\u4f9b\u5e94\u5546\u4ef7\u683c\u5df2\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
        System.out.println(sb);
        res.put("content", sb.toString());
        return res;
    }
}

