/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.exception;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class SearchSortException
extends RuntimeException
implements Serializable {
    public static final ThreadLocal<SearchSortException> MQ_THREAD_EXCEPTION = new ThreadLocal();
    private static final long serialVersionUID = -204127600368323746L;
    private String msgCode;
    private String msgDesc;

    public SearchSortException(String msgCode, String msgDesc, Throwable err) {
        super(err);
        this.msgCode = msgCode;
        if (SearchSortException.class.equals(err.getClass())) {
            SearchSortException tmp = (SearchSortException)err;
            this.msgDesc = tmp.getMsgDesc() + "," + msgDesc;
        } else if (InvocationTargetException.class.equals(err.getClass())) {
            InvocationTargetException tmp = (InvocationTargetException)err;
            try {
                SearchSortException searchSortException = (SearchSortException)tmp.getTargetException();
                this.msgDesc = searchSortException.getMsgDesc() + "," + msgDesc;
            }
            catch (Exception e) {
                tmp.getTargetException().printStackTrace();
                this.msgDesc = tmp.getTargetException().getMessage() + msgDesc;
            }
        } else {
            StackTraceElement stackTraceElement = err.getStackTrace()[0];
            this.msgDesc = stackTraceElement.getFileName() + "||" + stackTraceElement.getMethodName() + "||" + stackTraceElement.getLineNumber() + "  --->  " + err.getMessage() + "," + msgDesc;
        }
    }

    public SearchSortException(Throwable err) {
        super(err);
    }

    public SearchSortException(String msgCode, String msgDesc) {
        this.msgCode = msgCode;
        this.msgDesc = msgDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchSortException)) {
            return false;
        }
        SearchSortException other = (SearchSortException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$msgCode = this.getMsgCode();
        String other$msgCode = other.getMsgCode();
        if (this$msgCode == null ? other$msgCode != null : !this$msgCode.equals(other$msgCode)) {
            return false;
        }
        String this$msgDesc = this.getMsgDesc();
        String other$msgDesc = other.getMsgDesc();
        return !(this$msgDesc == null ? other$msgDesc != null : !this$msgDesc.equals(other$msgDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchSortException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $msgCode = this.getMsgCode();
        result = result * 59 + ($msgCode == null ? 43 : $msgCode.hashCode());
        String $msgDesc = this.getMsgDesc();
        result = result * 59 + ($msgDesc == null ? 43 : $msgDesc.hashCode());
        return result;
    }

    public String getMsgCode() {
        return this.msgCode;
    }

    public String getMsgDesc() {
        return this.msgDesc;
    }

    public void setMsgCode(String msgCode) {
        this.msgCode = msgCode;
    }

    public void setMsgDesc(String msgDesc) {
        this.msgDesc = msgDesc;
    }

    @Override
    public String toString() {
        return "SearchSortException(msgCode=" + this.getMsgCode() + ", msgDesc=" + this.getMsgDesc() + ")";
    }
}

