/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;

public class CompletableFutureExpandUtils {
    public static <T> CompletableFuture<T> orTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit) {
        if (null == unit) {
            throw new RuntimeException("\u65f6\u95f4\u7684\u7ed9\u5b9a\u7c92\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == future) {
            throw new RuntimeException("\u5f02\u6b65\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (future.isDone()) {
            return future;
        }
        return future.whenComplete((BiConsumer)new Canceller(Delayer.delay(new Timeout(future), timeout, unit)));
    }

    static final class Delayer {
        static final ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());

        Delayer() {
        }

        static ScheduledFuture<?> delay(Runnable command, long delay, TimeUnit unit) {
            return delayer.schedule(command, delay, unit);
        }

        static {
            delayer.setRemoveOnCancelPolicy(true);
        }

        static final class DaemonThreadFactory
        implements ThreadFactory {
            DaemonThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("CompletableFutureExpandUtilsDelayScheduler");
                return t;
            }
        }
    }

    static final class Canceller
    implements BiConsumer<Object, Throwable> {
        final Future<?> future;

        Canceller(Future<?> future) {
            this.future = future;
        }

        @Override
        public void accept(Object ignore, Throwable ex) {
            if (null == ex && null != this.future && !this.future.isDone()) {
                this.future.cancel(false);
            }
        }
    }

    static final class Timeout
    implements Runnable {
        final CompletableFuture<?> future;

        Timeout(CompletableFuture<?> future) {
            this.future = future;
        }

        @Override
        public void run() {
            if (null != this.future && !this.future.isDone()) {
                this.future.completeExceptionally(new TimeoutException());
            }
        }
    }
}

