/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.job.bo;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.tydic.se.base.ability.bo.SeShouldBO;
import com.tydic.se.base.ability.bo.SeTermsBO;
import com.tydic.se.search.job.bo.AggregationBO;
import com.tydic.se.search.job.bo.CollapseBO;
import com.tydic.se.search.job.bo.DarticipleQueryReader;
import com.tydic.se.search.job.bo.TermsBO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@JSONType(orders={"from", "size", "query", "sort", "collapse"})
public class DarticipleQueryBO
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JSONField(serialize=false)
    private DarticipleQueryReader darticipleQueryReader;
    private Integer from;
    private Integer size;
    private Query query;
    private List<Map<String, Map<String, String>>> sort;
    private AggregationBO aggs;
    private CollapseBO collapse;

    public void init(DarticipleQueryReader darticipleQueryReader) {
        this.darticipleQueryReader = darticipleQueryReader;
        this.from = this.darticipleQueryReader.getFrom();
        this.size = this.darticipleQueryReader.getSize();
        this.sort = this.darticipleQueryReader.getSort();
        this.query = new Query();
        this.query.init();
        if (darticipleQueryReader.getIsAggregation().booleanValue()) {
            this.aggs = new AggregationBO();
        }
        if (darticipleQueryReader.getIsCollapse().booleanValue()) {
            this.collapse = new CollapseBO();
        }
    }

    public DarticipleQueryReader getDarticipleQueryReader() {
        return this.darticipleQueryReader;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getSize() {
        return this.size;
    }

    public Query getQuery() {
        return this.query;
    }

    public List<Map<String, Map<String, String>>> getSort() {
        return this.sort;
    }

    public AggregationBO getAggs() {
        return this.aggs;
    }

    public CollapseBO getCollapse() {
        return this.collapse;
    }

    public void setDarticipleQueryReader(DarticipleQueryReader darticipleQueryReader) {
        this.darticipleQueryReader = darticipleQueryReader;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setSort(List<Map<String, Map<String, String>>> sort) {
        this.sort = sort;
    }

    public void setAggs(AggregationBO aggs) {
        this.aggs = aggs;
    }

    public void setCollapse(CollapseBO collapse) {
        this.collapse = collapse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DarticipleQueryBO)) {
            return false;
        }
        DarticipleQueryBO other = (DarticipleQueryBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DarticipleQueryReader this$darticipleQueryReader = this.getDarticipleQueryReader();
        DarticipleQueryReader other$darticipleQueryReader = other.getDarticipleQueryReader();
        if (this$darticipleQueryReader == null ? other$darticipleQueryReader != null : !((Object)this$darticipleQueryReader).equals(other$darticipleQueryReader)) {
            return false;
        }
        Integer this$from = this.getFrom();
        Integer other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Query this$query = this.getQuery();
        Query other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        List<Map<String, Map<String, String>>> this$sort = this.getSort();
        List<Map<String, Map<String, String>>> other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        AggregationBO this$aggs = this.getAggs();
        AggregationBO other$aggs = other.getAggs();
        if (this$aggs == null ? other$aggs != null : !((Object)this$aggs).equals(other$aggs)) {
            return false;
        }
        CollapseBO this$collapse = this.getCollapse();
        CollapseBO other$collapse = other.getCollapse();
        return !(this$collapse == null ? other$collapse != null : !((Object)this$collapse).equals(other$collapse));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DarticipleQueryBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DarticipleQueryReader $darticipleQueryReader = this.getDarticipleQueryReader();
        result = result * 59 + ($darticipleQueryReader == null ? 43 : ((Object)$darticipleQueryReader).hashCode());
        Integer $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Query $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        List<Map<String, Map<String, String>>> $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        AggregationBO $aggs = this.getAggs();
        result = result * 59 + ($aggs == null ? 43 : ((Object)$aggs).hashCode());
        CollapseBO $collapse = this.getCollapse();
        result = result * 59 + ($collapse == null ? 43 : ((Object)$collapse).hashCode());
        return result;
    }

    public String toString() {
        return "DarticipleQueryBO(darticipleQueryReader=" + this.getDarticipleQueryReader() + ", from=" + this.getFrom() + ", size=" + this.getSize() + ", query=" + this.getQuery() + ", sort=" + this.getSort() + ", aggs=" + this.getAggs() + ", collapse=" + this.getCollapse() + ")";
    }

    @JSONType(orders={"function_score"})
    public class Query {
        private FunctionScore function_score;

        public void init() {
            this.function_score = new FunctionScore();
            this.function_score.init();
        }

        public FunctionScore getFunction_score() {
            return this.function_score;
        }

        public void setFunction_score(FunctionScore function_score) {
            this.function_score = function_score;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Query)) {
                return false;
            }
            Query other = (Query)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FunctionScore this$function_score = this.getFunction_score();
            FunctionScore other$function_score = other.getFunction_score();
            return !(this$function_score == null ? other$function_score != null : !((Object)this$function_score).equals(other$function_score));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Query;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FunctionScore $function_score = this.getFunction_score();
            result = result * 59 + ($function_score == null ? 43 : ((Object)$function_score).hashCode());
            return result;
        }

        public String toString() {
            return "DarticipleQueryBO.Query(function_score=" + this.getFunction_score() + ")";
        }

        @JSONType(orders={"functions", "score_mode", "boost", "max_boost", "min_score"})
        public class FunctionScore {
            private List<String> functions;
            private String score_mode;
            private InQuery query;
            private Double boost;
            private Double max_boost;
            private Double min_score;

            public void init() {
                this.functions = DarticipleQueryBO.this.darticipleQueryReader.getFunctions();
                this.score_mode = DarticipleQueryBO.this.darticipleQueryReader.getScore_mode();
                this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                this.max_boost = DarticipleQueryBO.this.darticipleQueryReader.getMax_boost();
                this.min_score = DarticipleQueryBO.this.darticipleQueryReader.getMin_score();
                this.query = new InQuery();
                this.query.init();
            }

            public List<String> getFunctions() {
                return this.functions;
            }

            public String getScore_mode() {
                return this.score_mode;
            }

            public InQuery getQuery() {
                return this.query;
            }

            public Double getBoost() {
                return this.boost;
            }

            public Double getMax_boost() {
                return this.max_boost;
            }

            public Double getMin_score() {
                return this.min_score;
            }

            public void setFunctions(List<String> functions) {
                this.functions = functions;
            }

            public void setScore_mode(String score_mode) {
                this.score_mode = score_mode;
            }

            public void setQuery(InQuery query) {
                this.query = query;
            }

            public void setBoost(Double boost) {
                this.boost = boost;
            }

            public void setMax_boost(Double max_boost) {
                this.max_boost = max_boost;
            }

            public void setMin_score(Double min_score) {
                this.min_score = min_score;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FunctionScore)) {
                    return false;
                }
                FunctionScore other = (FunctionScore)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$functions = this.getFunctions();
                List<String> other$functions = other.getFunctions();
                if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
                    return false;
                }
                String this$score_mode = this.getScore_mode();
                String other$score_mode = other.getScore_mode();
                if (this$score_mode == null ? other$score_mode != null : !this$score_mode.equals(other$score_mode)) {
                    return false;
                }
                InQuery this$query = this.getQuery();
                InQuery other$query = other.getQuery();
                if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
                    return false;
                }
                Double this$boost = this.getBoost();
                Double other$boost = other.getBoost();
                if (this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost)) {
                    return false;
                }
                Double this$max_boost = this.getMax_boost();
                Double other$max_boost = other.getMax_boost();
                if (this$max_boost == null ? other$max_boost != null : !((Object)this$max_boost).equals(other$max_boost)) {
                    return false;
                }
                Double this$min_score = this.getMin_score();
                Double other$min_score = other.getMin_score();
                return !(this$min_score == null ? other$min_score != null : !((Object)this$min_score).equals(other$min_score));
            }

            protected boolean canEqual(Object other) {
                return other instanceof FunctionScore;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $functions = this.getFunctions();
                result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
                String $score_mode = this.getScore_mode();
                result = result * 59 + ($score_mode == null ? 43 : $score_mode.hashCode());
                InQuery $query = this.getQuery();
                result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
                Double $boost = this.getBoost();
                result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                Double $max_boost = this.getMax_boost();
                result = result * 59 + ($max_boost == null ? 43 : ((Object)$max_boost).hashCode());
                Double $min_score = this.getMin_score();
                result = result * 59 + ($min_score == null ? 43 : ((Object)$min_score).hashCode());
                return result;
            }

            public String toString() {
                return "DarticipleQueryBO.Query.FunctionScore(functions=" + this.getFunctions() + ", score_mode=" + this.getScore_mode() + ", query=" + this.getQuery() + ", boost=" + this.getBoost() + ", max_boost=" + this.getMax_boost() + ", min_score=" + this.getMin_score() + ")";
            }

            public class InQuery {
                private Bool bool;

                public void init() {
                    this.bool = new Bool();
                    this.bool.init();
                }

                public Bool getBool() {
                    return this.bool;
                }

                public void setBool(Bool bool) {
                    this.bool = bool;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof InQuery)) {
                        return false;
                    }
                    InQuery other = (InQuery)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Bool this$bool = this.getBool();
                    Bool other$bool = other.getBool();
                    return !(this$bool == null ? other$bool != null : !((Object)this$bool).equals(other$bool));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof InQuery;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Bool $bool = this.getBool();
                    result = result * 59 + ($bool == null ? 43 : ((Object)$bool).hashCode());
                    return result;
                }

                public String toString() {
                    return "DarticipleQueryBO.Query.FunctionScore.InQuery(bool=" + this.getBool() + ")";
                }

                public class Bool {
                    private Boolean adjust_pure_negative;
                    private List<Map<String, Object>> must;
                    private List<Map<String, Object>> must_not;
                    private Double boost;

                    public void init() {
                        this.adjust_pure_negative = DarticipleQueryBO.this.darticipleQueryReader.getAdjust_pure_negative();
                        this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                        this.must = new ArrayList<Map<String, Object>>();
                        if (DarticipleQueryBO.this.darticipleQueryReader.getTermsList() != null && DarticipleQueryBO.this.darticipleQueryReader.getTermsList().size() > 0) {
                            for (SeTermsBO seTermsBO : DarticipleQueryBO.this.darticipleQueryReader.getTermsList()) {
                                JSONObject jsonObject;
                                HashMap<String, JSONObject> termsMap = new HashMap<String, JSONObject>();
                                if (Boolean.TRUE.equals(seTermsBO.getIsWildcard()) && seTermsBO.getName().contains(".keyword") && seTermsBO.getValueList().size() == 1 && ((String)seTermsBO.getValueList().get(0)).startsWith("*") && ((String)seTermsBO.getValueList().get(0)).endsWith("*")) {
                                    jsonObject = new JSONObject();
                                    jsonObject.put(seTermsBO.getName(), seTermsBO.getValueList().get(0));
                                    termsMap.put("wildcard", jsonObject);
                                    this.must.add(termsMap);
                                    continue;
                                }
                                jsonObject = new JSONObject();
                                jsonObject.put("boost", (Object)DarticipleQueryBO.this.darticipleQueryReader.getBoost());
                                jsonObject.put(seTermsBO.getName(), (Object)seTermsBO.getValueList());
                                termsMap.put("terms", jsonObject);
                                this.must.add(termsMap);
                            }
                        }
                        if (DarticipleQueryBO.this.darticipleQueryReader.getNotTermsList() != null && DarticipleQueryBO.this.darticipleQueryReader.getNotTermsList().size() > 0) {
                            this.must_not = new ArrayList<Map<String, Object>>();
                            ArrayList must2 = new ArrayList();
                            for (SeTermsBO termsBO : DarticipleQueryBO.this.darticipleQueryReader.getNotTermsList()) {
                                JSONObject jsonObject;
                                HashMap<String, JSONObject> termsMap = new HashMap<String, JSONObject>();
                                if (Boolean.TRUE.equals(termsBO.getIsWildcard()) && termsBO.getName().contains(".keyword") && termsBO.getValueList().size() == 1 && ((String)termsBO.getValueList().get(0)).startsWith("*") && ((String)termsBO.getValueList().get(0)).endsWith("*")) {
                                    jsonObject = new JSONObject();
                                    jsonObject.put(termsBO.getName(), termsBO.getValueList().get(0));
                                    termsMap.put("wildcard", jsonObject);
                                    must2.add(termsMap);
                                } else {
                                    jsonObject = new JSONObject();
                                    jsonObject.put("boost", (Object)DarticipleQueryBO.this.darticipleQueryReader.getBoost());
                                    jsonObject.put(termsBO.getName(), (Object)termsBO.getValueList());
                                    termsMap.put("terms", jsonObject);
                                }
                                if (!termsBO.getNeedMust().booleanValue()) {
                                    this.must_not.add(termsMap);
                                    continue;
                                }
                                must2.add(termsMap);
                            }
                            if (must2 != null && must2.size() > 0) {
                                JSONObject jSONObject = new JSONObject();
                                JSONObject mustList = new JSONObject();
                                mustList.put("must", must2);
                                jSONObject.put("bool", (Object)mustList);
                                this.must_not.add((Map<String, Object>)jSONObject);
                            }
                        }
                        HashMap<String, Object> boolMap = new HashMap<String, Object>();
                        if ("L0".equals(DarticipleQueryBO.this.darticipleQueryReader.getSearchType())) {
                            Must must = new Must();
                            must.init();
                            boolMap.put("bool", must);
                        }
                        if ("L1".equals(DarticipleQueryBO.this.darticipleQueryReader.getSearchType())) {
                            Must must = new Must();
                            must.init();
                            boolMap.put("bool", must);
                        } else if ("L2".equals(DarticipleQueryBO.this.darticipleQueryReader.getSearchType())) {
                            InBool inBool = new InBool();
                            DarticipleQueryBO.this.darticipleQueryReader.setMinimum_should_match("90%");
                            inBool.init();
                            boolMap.put("bool", inBool);
                        } else if ("L3".equals(DarticipleQueryBO.this.darticipleQueryReader.getSearchType())) {
                            InBool inBool = new InBool();
                            inBool.init();
                            boolMap.put("bool", inBool);
                        }
                        if (boolMap != null && boolMap.size() > 0) {
                            this.must.add(boolMap);
                        }
                        if (StringUtils.isNotBlank((CharSequence)DarticipleQueryBO.this.darticipleQueryReader.getProperties())) {
                            HashMap<String, PropertiesBool> hashMap = new HashMap<String, PropertiesBool>();
                            PropertiesBool propertiesBool = new PropertiesBool();
                            propertiesBool.init();
                            hashMap.put("bool", propertiesBool);
                            this.must.add(hashMap);
                        }
                        if (DarticipleQueryBO.this.darticipleQueryReader.getShouldList() != null) {
                            HashMap<String, ShouldBool> hashMap = new HashMap<String, ShouldBool>();
                            ShouldBool shouldBool = new ShouldBool();
                            shouldBool.init();
                            hashMap.put("bool", shouldBool);
                            this.must.add(hashMap);
                        }
                    }

                    private TermsBO parseTerms(SeTermsBO termsBO) {
                        TermsBO terms = new TermsBO();
                        terms.init(DarticipleQueryBO.this.darticipleQueryReader);
                        List<String> values = termsBO.getValueList();
                        if (values != null && values.size() == 1 && values.get(0) instanceof String) {
                            values = Arrays.asList(((String)values.get(0)).split(","));
                        }
                        String lv1CategoryId = "l1_category_id";
                        String lv2CategoryId = "l2_category_id";
                        String lv3CategoryId = "l3_category_id";
                        String lv4CategoryId = "l4mg_category_id";
                        String brandId = "brand_id";
                        String vendorId = "vendor_id";
                        if ("sku_status".equals(termsBO.getName())) {
                            terms.setSku_status(values);
                        } else if ("channel_id".equals(termsBO.getName())) {
                            terms.setChannel_id(values);
                        } else if (vendorId.equals(termsBO.getName())) {
                            terms.setVendor_id(values);
                        } else if (brandId.equals(termsBO.getName())) {
                            terms.setBrand_id(values);
                        } else if (lv1CategoryId.equals(termsBO.getName())) {
                            terms.setL1_category_id(values);
                        } else if (lv2CategoryId.equals(termsBO.getName())) {
                            terms.setL2_category_id(values);
                        } else if (lv3CategoryId.equals(termsBO.getName())) {
                            terms.setL3_category_id(values);
                        } else if (lv4CategoryId.equals(termsBO.getName())) {
                            terms.setL4mg_category_id(values);
                        } else if ("type_id".equals(termsBO.getName())) {
                            terms.setType_id(values);
                        } else if ("type_name".equals(termsBO.getName())) {
                            terms.setType_name(values);
                        } else if ("supplier_shop_id".equals(termsBO.getName())) {
                            terms.setSupplier_shop_id(values);
                        } else if ("supplier_id".equals(termsBO.getName())) {
                            terms.setSupplier_id(values);
                        } else if ("agreement_id".equals(termsBO.getName())) {
                            terms.setAgreement_id(values);
                        } else if ("ext_sku_id".equals(termsBO.getName())) {
                            terms.setExt_sku_id(values);
                        } else if ("upc".equals(termsBO.getName())) {
                            terms.setUpc(values);
                        } else if ("commodity_id".equals(termsBO.getName())) {
                            terms.setCommodity_id(values);
                        } else if ("brand_name".equals(termsBO.getName())) {
                            terms.setBrand_name(values);
                        } else if ("vendor_name".equals(termsBO.getName())) {
                            terms.setVendor_name(values);
                        } else if ("l3_category_name".equals(termsBO.getName())) {
                            terms.setL3_category_name(values);
                        } else if ("properties".equals(termsBO.getName())) {
                            terms.setProperties(values);
                        } else if ("whitelist".equals(termsBO.getName())) {
                            terms.setWhitelist(values);
                        } else if ("commodity_type".equals(termsBO.getName())) {
                            terms.setCommodity_type(values);
                        } else if ("virtual_sku_id".equals(termsBO.getName())) {
                            terms.setVirtual_sku_id(values);
                        } else if ("service_org_name".equals(termsBO.getName())) {
                            terms.setService_org_name(values);
                        } else if ("evaluation_total".equals(termsBO.getName())) {
                            terms.setEvaluation_total(values);
                        } else if ("evaluation_score".equals(termsBO.getName())) {
                            terms.setEvaluation_score(values);
                        } else if ("service_org_path".equals(termsBO.getName())) {
                            terms.setService_org_path(values);
                        } else if ("item_name".equals(termsBO.getName())) {
                            terms.setItem_name(values);
                        } else if ("new_Properties".equals(termsBO.getName())) {
                            terms.setNew_Properties(values);
                        } else if ("agr_type".equals(termsBO.getName())) {
                            terms.setAgr_type(values);
                        } else if ("sku_source".equals(termsBO.getName())) {
                            terms.setSku_source(values);
                        } else {
                            return null;
                        }
                        return terms;
                    }

                    public Boolean getAdjust_pure_negative() {
                        return this.adjust_pure_negative;
                    }

                    public List<Map<String, Object>> getMust() {
                        return this.must;
                    }

                    public List<Map<String, Object>> getMust_not() {
                        return this.must_not;
                    }

                    public Double getBoost() {
                        return this.boost;
                    }

                    public void setAdjust_pure_negative(Boolean adjust_pure_negative) {
                        this.adjust_pure_negative = adjust_pure_negative;
                    }

                    public void setMust(List<Map<String, Object>> must) {
                        this.must = must;
                    }

                    public void setMust_not(List<Map<String, Object>> must_not) {
                        this.must_not = must_not;
                    }

                    public void setBoost(Double boost) {
                        this.boost = boost;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Bool)) {
                            return false;
                        }
                        Bool other = (Bool)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Boolean this$adjust_pure_negative = this.getAdjust_pure_negative();
                        Boolean other$adjust_pure_negative = other.getAdjust_pure_negative();
                        if (this$adjust_pure_negative == null ? other$adjust_pure_negative != null : !((Object)this$adjust_pure_negative).equals(other$adjust_pure_negative)) {
                            return false;
                        }
                        List<Map<String, Object>> this$must = this.getMust();
                        List<Map<String, Object>> other$must = other.getMust();
                        if (this$must == null ? other$must != null : !((Object)this$must).equals(other$must)) {
                            return false;
                        }
                        List<Map<String, Object>> this$must_not = this.getMust_not();
                        List<Map<String, Object>> other$must_not = other.getMust_not();
                        if (this$must_not == null ? other$must_not != null : !((Object)this$must_not).equals(other$must_not)) {
                            return false;
                        }
                        Double this$boost = this.getBoost();
                        Double other$boost = other.getBoost();
                        return !(this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Bool;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Boolean $adjust_pure_negative = this.getAdjust_pure_negative();
                        result = result * 59 + ($adjust_pure_negative == null ? 43 : ((Object)$adjust_pure_negative).hashCode());
                        List<Map<String, Object>> $must = this.getMust();
                        result = result * 59 + ($must == null ? 43 : ((Object)$must).hashCode());
                        List<Map<String, Object>> $must_not = this.getMust_not();
                        result = result * 59 + ($must_not == null ? 43 : ((Object)$must_not).hashCode());
                        Double $boost = this.getBoost();
                        result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                        return result;
                    }

                    public String toString() {
                        return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool(adjust_pure_negative=" + this.getAdjust_pure_negative() + ", must=" + this.getMust() + ", must_not=" + this.getMust_not() + ", boost=" + this.getBoost() + ")";
                    }

                    @JSONType(orders={"should"})
                    public class ShouldBool {
                        private List<Map> should;

                        public void init() {
                            if (DarticipleQueryBO.this.darticipleQueryReader.getShouldList() != null) {
                                this.should = new ArrayList<Map>();
                                for (SeShouldBO shouldBO : DarticipleQueryBO.this.darticipleQueryReader.getShouldList()) {
                                    InBool inBool;
                                    HashMap<String, InBool> inBoolMap;
                                    JSONObject jsonObject;
                                    if (!StringUtils.isNotBlank((CharSequence)shouldBO.getName()) || shouldBO.getValueList() == null) continue;
                                    HashMap<String, JSONObject> termsMap = new HashMap<String, JSONObject>();
                                    if (shouldBO.getIsWildcard().booleanValue()) {
                                        if (shouldBO.getValueList() != null && shouldBO.getValueList().size() > 0) {
                                            jsonObject = new JSONObject();
                                            jsonObject.put(shouldBO.getName(), (Object)("*" + (String)shouldBO.getValueList().get(0) + "*"));
                                            termsMap.put("wildcard", jsonObject);
                                            this.should.add(termsMap);
                                        }
                                    } else {
                                        jsonObject = new JSONObject();
                                        jsonObject.put(shouldBO.getName(), (Object)shouldBO.getValueList());
                                        termsMap.put("terms", jsonObject);
                                        this.should.add(termsMap);
                                    }
                                    if (shouldBO.getExists() == null) continue;
                                    if (shouldBO.getExists().booleanValue()) {
                                        inBoolMap = new HashMap<String, InBool>();
                                        inBool = new InBool();
                                        inBool.initMust(shouldBO.getName());
                                        inBoolMap.put("bool", inBool);
                                        this.should.add(inBoolMap);
                                        continue;
                                    }
                                    if (shouldBO.getExists().booleanValue()) continue;
                                    inBoolMap = new HashMap();
                                    inBool = new InBool();
                                    inBool.initMustNot(shouldBO.getName());
                                    inBoolMap.put("bool", inBool);
                                    this.should.add(inBoolMap);
                                }
                            }
                        }

                        public List<Map> getShould() {
                            return this.should;
                        }

                        public void setShould(List<Map> should) {
                            this.should = should;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof ShouldBool)) {
                                return false;
                            }
                            ShouldBool other = (ShouldBool)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            List<Map> this$should = this.getShould();
                            List<Map> other$should = other.getShould();
                            return !(this$should == null ? other$should != null : !((Object)this$should).equals(other$should));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof ShouldBool;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            List<Map> $should = this.getShould();
                            result = result * 59 + ($should == null ? 43 : ((Object)$should).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.ShouldBool(should=" + this.getShould() + ")";
                        }

                        public class InBool {
                            private List<Map<String, Object>> must_not;
                            private List<Map<String, Object>> must;

                            public void initMustNot(String field) {
                                this.must_not = new ArrayList<Map<String, Object>>();
                                HashMap<String, Field> existsMap = new HashMap<String, Field>();
                                Field fieldBO = new Field();
                                fieldBO.setField(field);
                                existsMap.put("exists", fieldBO);
                                this.must_not.add(existsMap);
                            }

                            public void initMust(String field) {
                                this.must = new ArrayList<Map<String, Object>>();
                                HashMap<String, Field> existsMap = new HashMap<String, Field>();
                                Field fieldBO = new Field();
                                fieldBO.setField(field);
                                existsMap.put("exists", fieldBO);
                                this.must.add(existsMap);
                            }

                            public List<Map<String, Object>> getMust_not() {
                                return this.must_not;
                            }

                            public List<Map<String, Object>> getMust() {
                                return this.must;
                            }

                            public void setMust_not(List<Map<String, Object>> must_not) {
                                this.must_not = must_not;
                            }

                            public void setMust(List<Map<String, Object>> must) {
                                this.must = must;
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof InBool)) {
                                    return false;
                                }
                                InBool other = (InBool)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                List<Map<String, Object>> this$must_not = this.getMust_not();
                                List<Map<String, Object>> other$must_not = other.getMust_not();
                                if (this$must_not == null ? other$must_not != null : !((Object)this$must_not).equals(other$must_not)) {
                                    return false;
                                }
                                List<Map<String, Object>> this$must = this.getMust();
                                List<Map<String, Object>> other$must = other.getMust();
                                return !(this$must == null ? other$must != null : !((Object)this$must).equals(other$must));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof InBool;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                List<Map<String, Object>> $must_not = this.getMust_not();
                                result = result * 59 + ($must_not == null ? 43 : ((Object)$must_not).hashCode());
                                List<Map<String, Object>> $must = this.getMust();
                                result = result * 59 + ($must == null ? 43 : ((Object)$must).hashCode());
                                return result;
                            }

                            public String toString() {
                                return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.ShouldBool.InBool(must_not=" + this.getMust_not() + ", must=" + this.getMust() + ")";
                            }

                            @JSONType(orders={"field"})
                            public class Field {
                                private String field;

                                public String getField() {
                                    return this.field;
                                }

                                public void setField(String field) {
                                    this.field = field;
                                }

                                public boolean equals(Object o) {
                                    if (o == this) {
                                        return true;
                                    }
                                    if (!(o instanceof Field)) {
                                        return false;
                                    }
                                    Field other = (Field)o;
                                    if (!other.canEqual(this)) {
                                        return false;
                                    }
                                    String this$field = this.getField();
                                    String other$field = other.getField();
                                    return !(this$field == null ? other$field != null : !this$field.equals(other$field));
                                }

                                protected boolean canEqual(Object other) {
                                    return other instanceof Field;
                                }

                                public int hashCode() {
                                    int PRIME = 59;
                                    int result = 1;
                                    String $field = this.getField();
                                    result = result * 59 + ($field == null ? 43 : $field.hashCode());
                                    return result;
                                }

                                public String toString() {
                                    return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.ShouldBool.InBool.Field(field=" + this.getField() + ")";
                                }
                            }
                        }
                    }

                    @JSONType(orders={"adjust_pure_negative", "should", "boost"})
                    public class PropertiesBool {
                        private Boolean adjust_pure_negative;
                        private List<Map> should;
                        private Double boost;

                        public void init() {
                            this.adjust_pure_negative = DarticipleQueryBO.this.darticipleQueryReader.getAdjust_pure_negative();
                            this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                            Match match = new Match();
                            match.init();
                            MatchModel matchModel = new MatchModel();
                            matchModel.init();
                            HashMap<String, Object> shouldMap = new HashMap<String, Object>();
                            if (DarticipleQueryBO.this.darticipleQueryReader.getProperties().split("\\*~~").length == 2 && "model".equals(DarticipleQueryBO.this.darticipleQueryReader.getProperties().split("\\*~~")[0])) {
                                shouldMap.put("match", matchModel);
                            } else {
                                shouldMap.put("match", match);
                            }
                            this.should = new ArrayList<Map>();
                            this.should.add(shouldMap);
                        }

                        public Boolean getAdjust_pure_negative() {
                            return this.adjust_pure_negative;
                        }

                        public List<Map> getShould() {
                            return this.should;
                        }

                        public Double getBoost() {
                            return this.boost;
                        }

                        public void setAdjust_pure_negative(Boolean adjust_pure_negative) {
                            this.adjust_pure_negative = adjust_pure_negative;
                        }

                        public void setShould(List<Map> should) {
                            this.should = should;
                        }

                        public void setBoost(Double boost) {
                            this.boost = boost;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof PropertiesBool)) {
                                return false;
                            }
                            PropertiesBool other = (PropertiesBool)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Boolean this$adjust_pure_negative = this.getAdjust_pure_negative();
                            Boolean other$adjust_pure_negative = other.getAdjust_pure_negative();
                            if (this$adjust_pure_negative == null ? other$adjust_pure_negative != null : !((Object)this$adjust_pure_negative).equals(other$adjust_pure_negative)) {
                                return false;
                            }
                            List<Map> this$should = this.getShould();
                            List<Map> other$should = other.getShould();
                            if (this$should == null ? other$should != null : !((Object)this$should).equals(other$should)) {
                                return false;
                            }
                            Double this$boost = this.getBoost();
                            Double other$boost = other.getBoost();
                            return !(this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof PropertiesBool;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Boolean $adjust_pure_negative = this.getAdjust_pure_negative();
                            result = result * 59 + ($adjust_pure_negative == null ? 43 : ((Object)$adjust_pure_negative).hashCode());
                            List<Map> $should = this.getShould();
                            result = result * 59 + ($should == null ? 43 : ((Object)$should).hashCode());
                            Double $boost = this.getBoost();
                            result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.PropertiesBool(adjust_pure_negative=" + this.getAdjust_pure_negative() + ", should=" + this.getShould() + ", boost=" + this.getBoost() + ")";
                        }

                        @JSONType(orders={"model"})
                        public class MatchModel {
                            private String model;

                            public void init() {
                                this.model = DarticipleQueryBO.this.darticipleQueryReader.getModel();
                            }

                            public String getModel() {
                                return this.model;
                            }

                            public void setModel(String model) {
                                this.model = model;
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof MatchModel)) {
                                    return false;
                                }
                                MatchModel other = (MatchModel)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                String this$model = this.getModel();
                                String other$model = other.getModel();
                                return !(this$model == null ? other$model != null : !this$model.equals(other$model));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof MatchModel;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                String $model = this.getModel();
                                result = result * 59 + ($model == null ? 43 : $model.hashCode());
                                return result;
                            }

                            public String toString() {
                                return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.PropertiesBool.MatchModel(model=" + this.getModel() + ")";
                            }
                        }

                        @JSONType(orders={"properties"})
                        public class Match {
                            private String properties;

                            public void init() {
                                this.properties = DarticipleQueryBO.this.darticipleQueryReader.getProperties();
                            }

                            public String getProperties() {
                                return this.properties;
                            }

                            public void setProperties(String properties) {
                                this.properties = properties;
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Match)) {
                                    return false;
                                }
                                Match other = (Match)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                String this$properties = this.getProperties();
                                String other$properties = other.getProperties();
                                return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof Match;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                String $properties = this.getProperties();
                                result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
                                return result;
                            }

                            public String toString() {
                                return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.PropertiesBool.Match(properties=" + this.getProperties() + ")";
                            }
                        }
                    }

                    @JSONType(orders={"adjust_pure_negative", "should", "boost"})
                    public class InBool {
                        private Boolean adjust_pure_negative;
                        private List<Map> should;
                        private Double boost;

                        public void init() {
                            this.adjust_pure_negative = DarticipleQueryBO.this.darticipleQueryReader.getAdjust_pure_negative();
                            this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                            MultiMatch multiMatch = new MultiMatch();
                            multiMatch.init();
                            HashMap<String, MultiMatch> shouldMap = new HashMap<String, MultiMatch>();
                            shouldMap.put("multi_match", multiMatch);
                            this.should = new ArrayList<Map>();
                            this.should.add(shouldMap);
                        }

                        public Boolean getAdjust_pure_negative() {
                            return this.adjust_pure_negative;
                        }

                        public List<Map> getShould() {
                            return this.should;
                        }

                        public Double getBoost() {
                            return this.boost;
                        }

                        public void setAdjust_pure_negative(Boolean adjust_pure_negative) {
                            this.adjust_pure_negative = adjust_pure_negative;
                        }

                        public void setShould(List<Map> should) {
                            this.should = should;
                        }

                        public void setBoost(Double boost) {
                            this.boost = boost;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof InBool)) {
                                return false;
                            }
                            InBool other = (InBool)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Boolean this$adjust_pure_negative = this.getAdjust_pure_negative();
                            Boolean other$adjust_pure_negative = other.getAdjust_pure_negative();
                            if (this$adjust_pure_negative == null ? other$adjust_pure_negative != null : !((Object)this$adjust_pure_negative).equals(other$adjust_pure_negative)) {
                                return false;
                            }
                            List<Map> this$should = this.getShould();
                            List<Map> other$should = other.getShould();
                            if (this$should == null ? other$should != null : !((Object)this$should).equals(other$should)) {
                                return false;
                            }
                            Double this$boost = this.getBoost();
                            Double other$boost = other.getBoost();
                            return !(this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof InBool;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Boolean $adjust_pure_negative = this.getAdjust_pure_negative();
                            result = result * 59 + ($adjust_pure_negative == null ? 43 : ((Object)$adjust_pure_negative).hashCode());
                            List<Map> $should = this.getShould();
                            result = result * 59 + ($should == null ? 43 : ((Object)$should).hashCode());
                            Double $boost = this.getBoost();
                            result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.InBool(adjust_pure_negative=" + this.getAdjust_pure_negative() + ", should=" + this.getShould() + ", boost=" + this.getBoost() + ")";
                        }

                        @JSONType(orders={"auto_generate_synonyms_phrase_query", "query", "minimum_should_match", "fuzzy_transpositions", "type", "operator", "slop", "max_expansions", "analyzer", "zero_terms_query", "boost", "prefix_length", "fields"})
                        public class MultiMatch {
                            private Boolean auto_generate_synonyms_phrase_query;
                            private String query;
                            private String minimum_should_match;
                            private Boolean fuzzy_transpositions;
                            private String type;
                            private String operator;
                            private Integer slop;
                            private Integer max_expansions;
                            private String analyzer;
                            private String zero_terms_query;
                            private Double boost;
                            private Integer prefix_length;
                            private List<String> fields;

                            public void init() {
                                this.auto_generate_synonyms_phrase_query = DarticipleQueryBO.this.darticipleQueryReader.getAdjust_pure_negative();
                                this.query = DarticipleQueryBO.this.darticipleQueryReader.getQuery();
                                this.minimum_should_match = DarticipleQueryBO.this.darticipleQueryReader.getMinimum_should_match();
                                this.type = DarticipleQueryBO.this.darticipleQueryReader.getType();
                                this.operator = DarticipleQueryBO.this.darticipleQueryReader.getOperator();
                                this.slop = DarticipleQueryBO.this.darticipleQueryReader.getSlop();
                                this.max_expansions = DarticipleQueryBO.this.darticipleQueryReader.getMax_expansions();
                                this.analyzer = DarticipleQueryBO.this.darticipleQueryReader.getAnalyzer();
                                this.zero_terms_query = DarticipleQueryBO.this.darticipleQueryReader.getZero_terms_query();
                                this.boost = DarticipleQueryBO.this.darticipleQueryReader.getBoost();
                                this.prefix_length = DarticipleQueryBO.this.darticipleQueryReader.getPrefix_length();
                                this.fields = DarticipleQueryBO.this.darticipleQueryReader.getFields();
                            }

                            public Boolean getAuto_generate_synonyms_phrase_query() {
                                return this.auto_generate_synonyms_phrase_query;
                            }

                            public String getQuery() {
                                return this.query;
                            }

                            public String getMinimum_should_match() {
                                return this.minimum_should_match;
                            }

                            public Boolean getFuzzy_transpositions() {
                                return this.fuzzy_transpositions;
                            }

                            public String getType() {
                                return this.type;
                            }

                            public String getOperator() {
                                return this.operator;
                            }

                            public Integer getSlop() {
                                return this.slop;
                            }

                            public Integer getMax_expansions() {
                                return this.max_expansions;
                            }

                            public String getAnalyzer() {
                                return this.analyzer;
                            }

                            public String getZero_terms_query() {
                                return this.zero_terms_query;
                            }

                            public Double getBoost() {
                                return this.boost;
                            }

                            public Integer getPrefix_length() {
                                return this.prefix_length;
                            }

                            public List<String> getFields() {
                                return this.fields;
                            }

                            public void setAuto_generate_synonyms_phrase_query(Boolean auto_generate_synonyms_phrase_query) {
                                this.auto_generate_synonyms_phrase_query = auto_generate_synonyms_phrase_query;
                            }

                            public void setQuery(String query) {
                                this.query = query;
                            }

                            public void setMinimum_should_match(String minimum_should_match) {
                                this.minimum_should_match = minimum_should_match;
                            }

                            public void setFuzzy_transpositions(Boolean fuzzy_transpositions) {
                                this.fuzzy_transpositions = fuzzy_transpositions;
                            }

                            public void setType(String type) {
                                this.type = type;
                            }

                            public void setOperator(String operator) {
                                this.operator = operator;
                            }

                            public void setSlop(Integer slop) {
                                this.slop = slop;
                            }

                            public void setMax_expansions(Integer max_expansions) {
                                this.max_expansions = max_expansions;
                            }

                            public void setAnalyzer(String analyzer) {
                                this.analyzer = analyzer;
                            }

                            public void setZero_terms_query(String zero_terms_query) {
                                this.zero_terms_query = zero_terms_query;
                            }

                            public void setBoost(Double boost) {
                                this.boost = boost;
                            }

                            public void setPrefix_length(Integer prefix_length) {
                                this.prefix_length = prefix_length;
                            }

                            public void setFields(List<String> fields) {
                                this.fields = fields;
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof MultiMatch)) {
                                    return false;
                                }
                                MultiMatch other = (MultiMatch)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                Boolean this$auto_generate_synonyms_phrase_query = this.getAuto_generate_synonyms_phrase_query();
                                Boolean other$auto_generate_synonyms_phrase_query = other.getAuto_generate_synonyms_phrase_query();
                                if (this$auto_generate_synonyms_phrase_query == null ? other$auto_generate_synonyms_phrase_query != null : !((Object)this$auto_generate_synonyms_phrase_query).equals(other$auto_generate_synonyms_phrase_query)) {
                                    return false;
                                }
                                String this$query = this.getQuery();
                                String other$query = other.getQuery();
                                if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                                    return false;
                                }
                                String this$minimum_should_match = this.getMinimum_should_match();
                                String other$minimum_should_match = other.getMinimum_should_match();
                                if (this$minimum_should_match == null ? other$minimum_should_match != null : !this$minimum_should_match.equals(other$minimum_should_match)) {
                                    return false;
                                }
                                Boolean this$fuzzy_transpositions = this.getFuzzy_transpositions();
                                Boolean other$fuzzy_transpositions = other.getFuzzy_transpositions();
                                if (this$fuzzy_transpositions == null ? other$fuzzy_transpositions != null : !((Object)this$fuzzy_transpositions).equals(other$fuzzy_transpositions)) {
                                    return false;
                                }
                                String this$type = this.getType();
                                String other$type = other.getType();
                                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                                    return false;
                                }
                                String this$operator = this.getOperator();
                                String other$operator = other.getOperator();
                                if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                                    return false;
                                }
                                Integer this$slop = this.getSlop();
                                Integer other$slop = other.getSlop();
                                if (this$slop == null ? other$slop != null : !((Object)this$slop).equals(other$slop)) {
                                    return false;
                                }
                                Integer this$max_expansions = this.getMax_expansions();
                                Integer other$max_expansions = other.getMax_expansions();
                                if (this$max_expansions == null ? other$max_expansions != null : !((Object)this$max_expansions).equals(other$max_expansions)) {
                                    return false;
                                }
                                String this$analyzer = this.getAnalyzer();
                                String other$analyzer = other.getAnalyzer();
                                if (this$analyzer == null ? other$analyzer != null : !this$analyzer.equals(other$analyzer)) {
                                    return false;
                                }
                                String this$zero_terms_query = this.getZero_terms_query();
                                String other$zero_terms_query = other.getZero_terms_query();
                                if (this$zero_terms_query == null ? other$zero_terms_query != null : !this$zero_terms_query.equals(other$zero_terms_query)) {
                                    return false;
                                }
                                Double this$boost = this.getBoost();
                                Double other$boost = other.getBoost();
                                if (this$boost == null ? other$boost != null : !((Object)this$boost).equals(other$boost)) {
                                    return false;
                                }
                                Integer this$prefix_length = this.getPrefix_length();
                                Integer other$prefix_length = other.getPrefix_length();
                                if (this$prefix_length == null ? other$prefix_length != null : !((Object)this$prefix_length).equals(other$prefix_length)) {
                                    return false;
                                }
                                List<String> this$fields = this.getFields();
                                List<String> other$fields = other.getFields();
                                return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof MultiMatch;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                Boolean $auto_generate_synonyms_phrase_query = this.getAuto_generate_synonyms_phrase_query();
                                result = result * 59 + ($auto_generate_synonyms_phrase_query == null ? 43 : ((Object)$auto_generate_synonyms_phrase_query).hashCode());
                                String $query = this.getQuery();
                                result = result * 59 + ($query == null ? 43 : $query.hashCode());
                                String $minimum_should_match = this.getMinimum_should_match();
                                result = result * 59 + ($minimum_should_match == null ? 43 : $minimum_should_match.hashCode());
                                Boolean $fuzzy_transpositions = this.getFuzzy_transpositions();
                                result = result * 59 + ($fuzzy_transpositions == null ? 43 : ((Object)$fuzzy_transpositions).hashCode());
                                String $type = this.getType();
                                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                                String $operator = this.getOperator();
                                result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
                                Integer $slop = this.getSlop();
                                result = result * 59 + ($slop == null ? 43 : ((Object)$slop).hashCode());
                                Integer $max_expansions = this.getMax_expansions();
                                result = result * 59 + ($max_expansions == null ? 43 : ((Object)$max_expansions).hashCode());
                                String $analyzer = this.getAnalyzer();
                                result = result * 59 + ($analyzer == null ? 43 : $analyzer.hashCode());
                                String $zero_terms_query = this.getZero_terms_query();
                                result = result * 59 + ($zero_terms_query == null ? 43 : $zero_terms_query.hashCode());
                                Double $boost = this.getBoost();
                                result = result * 59 + ($boost == null ? 43 : ((Object)$boost).hashCode());
                                Integer $prefix_length = this.getPrefix_length();
                                result = result * 59 + ($prefix_length == null ? 43 : ((Object)$prefix_length).hashCode());
                                List<String> $fields = this.getFields();
                                result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
                                return result;
                            }

                            public String toString() {
                                return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.InBool.MultiMatch(auto_generate_synonyms_phrase_query=" + this.getAuto_generate_synonyms_phrase_query() + ", query=" + this.getQuery() + ", minimum_should_match=" + this.getMinimum_should_match() + ", fuzzy_transpositions=" + this.getFuzzy_transpositions() + ", type=" + this.getType() + ", operator=" + this.getOperator() + ", slop=" + this.getSlop() + ", max_expansions=" + this.getMax_expansions() + ", analyzer=" + this.getAnalyzer() + ", zero_terms_query=" + this.getZero_terms_query() + ", boost=" + this.getBoost() + ", prefix_length=" + this.getPrefix_length() + ", fields=" + this.getFields() + ")";
                            }
                        }
                    }

                    public class Must {
                        private List<Object> should;

                        public void init() {
                            this.should = new ArrayList<Object>();
                            Map<String, String> map = DarticipleQueryBO.this.darticipleQueryReader.getShould();
                            for (String s : map.keySet()) {
                                if (map.get(s) != null && map.get(s).contains("#_#^_^#_#")) {
                                    String[] values;
                                    for (String value : values = map.get(s).split("#_#\\^_\\^#_#")) {
                                        HashMap<String, String> map1 = new HashMap<String, String>();
                                        map1.put(s, "*" + value + "*");
                                        Wild wild = new Wild();
                                        wild.setWildcard(map1);
                                        this.should.add(wild);
                                    }
                                    continue;
                                }
                                HashMap<String, String> map1 = new HashMap<String, String>();
                                map1.put(s, map.get(s));
                                Wild wild = new Wild();
                                wild.setWildcard(map1);
                                this.should.add(wild);
                            }
                            Map<String, String> londShould = DarticipleQueryBO.this.darticipleQueryReader.getLondShould();
                            for (String s : londShould.keySet()) {
                                HashMap<String, String> map1 = new HashMap<String, String>();
                                map1.put(s, londShould.get(s));
                                Match match = new Match();
                                match.setMatch(map1);
                                this.should.add(match);
                            }
                            Query.this.function_score.min_score = 0.0;
                        }

                        public List<Object> getShould() {
                            return this.should;
                        }

                        public void setShould(List<Object> should) {
                            this.should = should;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Must)) {
                                return false;
                            }
                            Must other = (Must)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            List<Object> this$should = this.getShould();
                            List<Object> other$should = other.getShould();
                            return !(this$should == null ? other$should != null : !((Object)this$should).equals(other$should));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Must;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            List<Object> $should = this.getShould();
                            result = result * 59 + ($should == null ? 43 : ((Object)$should).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.Must(should=" + this.getShould() + ")";
                        }

                        @JsonInclude(value=JsonInclude.Include.NON_NULL)
                        public class Match {
                            private Map<String, String> match = new HashMap<String, String>();

                            public Map<String, String> getMatch() {
                                return this.match;
                            }

                            public void setMatch(Map<String, String> match) {
                                this.match = match;
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Match)) {
                                    return false;
                                }
                                Match other = (Match)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                Map<String, String> this$match = this.getMatch();
                                Map<String, String> other$match = other.getMatch();
                                return !(this$match == null ? other$match != null : !((Object)this$match).equals(other$match));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof Match;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                Map<String, String> $match = this.getMatch();
                                result = result * 59 + ($match == null ? 43 : ((Object)$match).hashCode());
                                return result;
                            }

                            public String toString() {
                                return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.Must.Match(match=" + this.getMatch() + ")";
                            }
                        }

                        @JsonInclude(value=JsonInclude.Include.NON_NULL)
                        public class Wild {
                            private Map<String, String> wildcard = new HashMap<String, String>();

                            public Map<String, String> getWildcard() {
                                return this.wildcard;
                            }

                            public void setWildcard(Map<String, String> wildcard) {
                                this.wildcard = wildcard;
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Wild)) {
                                    return false;
                                }
                                Wild other = (Wild)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                Map<String, String> this$wildcard = this.getWildcard();
                                Map<String, String> other$wildcard = other.getWildcard();
                                return !(this$wildcard == null ? other$wildcard != null : !((Object)this$wildcard).equals(other$wildcard));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof Wild;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                Map<String, String> $wildcard = this.getWildcard();
                                result = result * 59 + ($wildcard == null ? 43 : ((Object)$wildcard).hashCode());
                                return result;
                            }

                            public String toString() {
                                return "DarticipleQueryBO.Query.FunctionScore.InQuery.Bool.Must.Wild(wildcard=" + this.getWildcard() + ")";
                            }
                        }
                    }
                }
            }
        }
    }
}

