/*
 * Decompiled with CFR 0.152.
 */
package com.sdb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SignUtil {
    private static final int BUFFSIZE = 8096;
    public static final String ALG_DES = "DesEde/CBC/PKCS5Padding";
    public static final String KS_DES = "DesEde";
    public static final String FILE_TYPE_ENC = "enc";
    private static byte[] DEFAULT_IV = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};

    public static void encrypt(String srcFile, String encFile, byte[] bkey, String algorithm, String keySpec, byte[] bivSpec) throws Exception {
        SecretKeySpec key = new SecretKeySpec(bkey, keySpec);
        Cipher cipher = Cipher.getInstance(algorithm);
        if (bivSpec == null) {
            bivSpec = DEFAULT_IV;
        }
        IvParameterSpec ivSpec = new IvParameterSpec(bivSpec);
        cipher.init(1, (Key)key, ivSpec);
        InputStream ins = null;
        OutputStream outs = null;
        try {
            ins = new BufferedInputStream(new FileInputStream(srcFile));
            outs = new CipherOutputStream(new FileOutputStream(encFile), cipher);
            byte[] buf = new byte[8096];
            int count = -1;
            while ((count = ins.read(buf)) != -1) {
                outs.write(buf, 0, count);
                outs.flush();
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (outs != null) {
                try {
                    outs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void decrypt(String srcFile, String dstFile, byte[] bkey, String algorithm, String keySpec, byte[] bivSpec) throws Exception {
        SecretKeySpec key = new SecretKeySpec(bkey, keySpec);
        Cipher cipher = Cipher.getInstance(algorithm);
        if (bivSpec == null) {
            bivSpec = DEFAULT_IV;
        }
        IvParameterSpec ivSpec = new IvParameterSpec(bivSpec);
        cipher.init(2, (Key)key, ivSpec);
        InputStream ins = null;
        OutputStream outs = null;
        try {
            ins = new CipherInputStream(new BufferedInputStream(new FileInputStream(srcFile)), cipher);
            outs = new BufferedOutputStream(new FileOutputStream(dstFile));
            byte[] buf = new byte[8096];
            int count = -1;
            while ((count = ins.read(buf)) != -1) {
                outs.write(buf, 0, count);
                outs.flush();
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (outs != null) {
                try {
                    outs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void compress(String srcFile, String dstFile) throws Exception {
        InputStream ins = null;
        ZipOutputStream outs = null;
        try {
            outs = new ZipOutputStream(new FileOutputStream(new File(dstFile)));
            ins = new BufferedInputStream(new FileInputStream(srcFile), 8096);
            byte[] buf = new byte[8096];
            ZipEntry entry = new ZipEntry(new File(srcFile).getName());
            outs.putNextEntry(new ZipEntry(entry));
            int count = 0;
            while ((count = ins.read(buf)) != -1) {
                outs.write(buf, 0, count);
                outs.flush();
            }
            outs.closeEntry();
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (outs != null) {
                try {
                    outs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void uncompress(String srcFile, String dstFile) throws Exception {
        ZipFile zfile = null;
        OutputStream outs = null;
        try {
            zfile = new ZipFile(srcFile);
            Enumeration<? extends ZipEntry> e = zfile.entries();
            if (!e.hasMoreElements()) {
                throw new Exception("\u538b\u7f29\u5305\u6761\u76ee\u4e3a\u7a7a");
            }
            ZipEntry entry = e.nextElement();
            if (e.hasMoreElements()) {
                throw new Exception("\u538b\u7f29\u5305\u4e2d\u5305\u542b\u591a\u4e2a\u6587\u4ef6\u6216\u6587\u4ef6\u5939");
            }
            InputStream ins = zfile.getInputStream(entry);
            outs = new BufferedOutputStream(new FileOutputStream(dstFile));
            byte[] buf = new byte[8096];
            int count = -1;
            while ((count = ins.read(buf)) != -1) {
                outs.write(buf, 0, count);
                outs.flush();
            }
            ins.close();
        }
        finally {
            if (zfile != null) {
                try {
                    zfile.close();
                }
                catch (Exception exception) {}
            }
            if (outs != null) {
                try {
                    outs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] generateBytesKey() {
        byte[] bkey = new byte[24];
        SecureRandom random = new SecureRandom();
        ((Random)random).nextBytes(bkey);
        return bkey;
    }
}

