/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.busibase.busi.api.UccApproveTaskSyncBusiService;
import com.tydic.commodity.busibase.busi.bo.ApproveTaskSyncBO;
import com.tydic.commodity.busibase.busi.bo.UccApproveTaskSyncBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccApproveTaskSyncBusiRspBO;
import com.tydic.commodity.busibase.busi.bo.UccSendTodoBusiReqBO;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccApproveTaskSyncBusiServiceImpl
implements UccApproveTaskSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccApproveTaskSyncBusiServiceImpl.class);
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Resource(name="dycUccSendTodoProducer")
    private ProxyMessageProducer dycUccSendTodoProducer;

    @Override
    public UccApproveTaskSyncBusiRspBO ApproveTaskSync(UccApproveTaskSyncBusiReqBO reqBO) {
        UccApproveTaskSyncBusiRspBO rspBO = new UccApproveTaskSyncBusiRspBO();
        UccSendTodoBusiReqBO uccSendTodoBusiReqBO = new UccSendTodoBusiReqBO();
        log.info("\u5ba1\u6279\u4efb\u52a1mq\u540c\u6b65API\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        ArrayList<Long> spuIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(reqBO.getTaskList())) {
            ArrayList<Long> thisTimeTaskIds = new ArrayList<Long>();
            for (ApproveTaskSyncBO each : reqBO.getTaskList()) {
                each.setApproveInstId(reqBO.getProcInstId());
                each.setBusinessId(each.getBusiness().getBusinessId());
                each.setBusinessType(each.getBusiness().getBusinessType());
                each.setTacheCode(each.getStepId());
                each.setTacheName(each.getStepName());
                EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
                eacRuTaskPO.setStatusList(Arrays.asList("ACTIVE", "SUSPEND"));
                eacRuTaskPO.setBusinessId(each.getBusinessId());
                if (each.getBusinessType().equals(ApprovalTypeEnum.uccOnShelfProcessOrder.code())) {
                    eacRuTaskPO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep()));
                    each.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep()));
                } else if (each.getBusinessType().equals(ApprovalTypeEnum.uccOffShelfProcessOrder.code())) {
                    eacRuTaskPO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep()));
                    each.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep()));
                } else if (each.getBusinessType().equals(ApprovalTypeEnum.uccReinstateProcessOrder.code())) {
                    eacRuTaskPO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccReinstateProcessOrder.getStep()));
                    each.setObjType(Integer.parseInt(ApprovalTypeEnum.uccReinstateProcessOrder.getStep()));
                } else if (each.getBusinessType().equals(ApprovalTypeEnum.uccEditProcessOrder.code())) {
                    eacRuTaskPO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccEditProcessOrder.getStep()));
                    each.setObjType(Integer.parseInt(ApprovalTypeEnum.uccEditProcessOrder.getStep()));
                }
                List<EacRuTaskPO> list = this.eacRuTaskMapper.getList(eacRuTaskPO);
                if (!CollectionUtils.isEmpty(list)) {
                    list.removeIf(e -> thisTimeTaskIds.contains(e.getTaskId()));
                }
                if (!CollectionUtils.isEmpty(list)) {
                    log.info("\u53bb\u9664\u8fd9\u6b21\u7684\u4efb\u52a1id\u4e4b\u540e\u7684list\uff1a{}", (Object)JSON.toJSONString(list));
                    Map<String, List<EacRuTaskPO>> collect = list.stream().collect(Collectors.groupingBy(EacRuTaskPO::getTacheCode));
                    if (collect.keySet().size() > 1) {
                        log.error("businessId\u4e3a" + each.getBusinessId() + "\uff0cobjType\u4e3a" + each.getBusinessType() + "\u7684\u5ba1\u6279\u4efb\u52a1\u5728\u4e0d\u540c\u73af\u8282\u4e2d\u6709\u6fc0\u6d3b\u72b6\u6001");
                    }
                    if (list.get(0).getTacheCode().equals(each.getStepId())) {
                        log.info("\u5ba1\u6279\u73af\u8282\u4e00\u81f4");
                        uccSendTodoBusiReqBO.setFlowstatus("\u5904\u7406\u4e2d");
                    } else {
                        log.info("\u5ba1\u6279\u73af\u8282\u4e0d\u4e00\u81f4");
                        uccSendTodoBusiReqBO.setFlowstatus("\u5904\u7406\u4e2d");
                    }
                    EacRuTaskPO eacRuTaskPO1 = new EacRuTaskPO();
                    eacRuTaskPO1.setTaskId(each.getApproveTaskId());
                    EacRuTaskPO modelBy = this.eacRuTaskMapper.getModelBy(eacRuTaskPO1);
                    if (modelBy == null) {
                        EacRuTaskPO temp = new EacRuTaskPO();
                        BeanUtils.copyProperties((Object)each, (Object)temp);
                        temp.setTaskId(each.getApproveTaskId());
                        this.eacRuTaskMapper.insert(temp);
                    }
                } else {
                    log.info("\u8bf4\u660e\u662f\u65b0\u521b\u5efa\u7684\u5ba1\u6279\uff0c\u76f4\u63a5\u5165\u5e93");
                    EacRuTaskPO temp = new EacRuTaskPO();
                    BeanUtils.copyProperties((Object)each, (Object)temp);
                    temp.setTaskId(each.getApproveTaskId());
                    this.eacRuTaskMapper.insert(temp);
                    uccSendTodoBusiReqBO.setFlowcreatetime(new Date(System.currentTimeMillis()));
                    uccSendTodoBusiReqBO.setFlowstatus("\u5904\u7406\u4e2d");
                }
                if (each.getBusinessType().equals(ApprovalTypeEnum.uccEditProcessOrder.getCode())) {
                    spuIds.add(Long.parseLong(each.getBusinessId()));
                } else {
                    List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(Long.parseLong(each.getBusinessId())), null);
                    spuIds.add(uccSkuPoList.get(0).getCommodityId());
                }
                thisTimeTaskIds.add(each.getApproveTaskId());
            }
        }
        if (reqBO.getIsfinish().booleanValue()) {
            log.info(reqBO.getProcInstId() + "\u6d41\u7a0b\u7ed3\u675f");
            EacRuTaskPO temp = new EacRuTaskPO();
            temp.setApproveInstId(reqBO.getProcInstId());
            List<EacRuTaskPO> list = this.eacRuTaskMapper.getList(temp);
            if (!CollectionUtils.isEmpty(list)) {
                for (EacRuTaskPO each : list) {
                    if (each.getObjType() == 2) {
                        spuIds.add(Long.parseLong(each.getBusinessId()));
                        continue;
                    }
                    List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(Long.parseLong(each.getBusinessId())), null);
                    spuIds.add(uccSkuPoList.get(0).getCommodityId());
                }
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getTaskList())) {
            try {
                List<Long> taskIds = reqBO.getTaskList().stream().map(ApproveTaskSyncBO::getApproveTaskId).collect(Collectors.toList());
                uccSendTodoBusiReqBO.setTaskIds(taskIds);
                if (ApprovalTypeEnum.uccEditProcessOrder.code().equals(reqBO.getTaskList().get(0).getBusinessType())) {
                    UccCommodityPo commodityById = this.uccCommodityMapper.getCommodityById(Long.parseLong(reqBO.getTaskList().get(0).getBusinessId()));
                    uccSendTodoBusiReqBO.setSource(commodityById.getCommoditySource());
                } else {
                    List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(Long.parseLong(reqBO.getTaskList().get(0).getBusinessId())), null);
                    uccSendTodoBusiReqBO.setSource(uccSkuPoList.get(0).getSkuSource());
                }
                if (reqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccOnShelfProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep()));
                } else if (reqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccOffShelfProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep()));
                } else if (reqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccReinstateProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccReinstateProcessOrder.getStep()));
                } else if (reqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccEditProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccEditProcessOrder.getStep()));
                }
                uccSendTodoBusiReqBO.setFlowstatus("\u5904\u7406\u4e2d");
                this.dycUccSendTodoProducer.send(new ProxyMessage(PropertiesUtil.getProperty("UCC_SEND_TODO_TOPIC"), "*", JSON.toJSONString((Object)((Object)uccSendTodoBusiReqBO))));
            }
            catch (Exception e2) {
                log.error("\u5ba1\u6279mq\u6d88\u8d39\u8005 \u53d1\u9001\u5f85\u529emq\u5931\u8d25\uff1a" + e2.getMessage());
            }
        }
        rspBO.setSpuIds(spuIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

