/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    public static final String URF8 = "UTF-8";

    public static String getRealPath(HttpServletRequest request) {
        String path = request.getServletContext().getRealPath("/");
        if (!path.endsWith(File.separator)) {
            path = path + "/";
        }
        return path;
    }

    public static String getRealPath(HttpServletRequest request, String relativePath) {
        if (relativePath.startsWith("/") || relativePath.startsWith("\\")) {
            relativePath = relativePath.substring(1);
        }
        return FileUtil.getRealPath(request) + relativePath;
    }

    public static void createFolder(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void delFolders(String folderPath) {
        File file = new File(folderPath);
        if (!file.isDirectory()) {
            file.delete();
            return;
        }
        File[] tempList = file.listFiles();
        if (tempList != null && tempList.length > 0) {
            for (File tmpFile : tempList) {
                if (tmpFile.isDirectory()) {
                    FileUtil.delFolders(tmpFile.getPath());
                    continue;
                }
                if (tmpFile.delete()) continue;
                log.info("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01");
            }
        } else {
            file.delete();
        }
        FileUtil.delFolders(file.getPath());
    }

    public static File writeFile(String content, String writePath, String charCoder) {
        try {
            File file = new File(writePath);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charCoder);
            BufferedWriter reader = new BufferedWriter(osw);
            reader.write(content);
            osw.flush();
            reader.close();
            osw.close();
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readFile(String filePath) {
        String fileContent = "";
        try {
            File f = new File(filePath);
            if (f.isFile() && f.exists()) {
                String line;
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(f), URF8);
                BufferedReader reader = new BufferedReader(read);
                while ((line = reader.readLine()) != null) {
                    fileContent = fileContent + line + "\n";
                }
                reader.close();
                read.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileContent;
    }

    public static Boolean CheckFile(String file) {
        int suffixIndex;
        String[] strArray = file.split("\\.");
        String index = strArray[suffixIndex = strArray.length - 1];
        if ("exe".equals(index) || "EXE".equals(index)) {
            return false;
        }
        return true;
    }

    public static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
    }
}

