/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.busibase.atom.api.UccEbsMaterialRelCallBackAtomService;
import com.tydic.commodity.busibase.atom.bo.UccEbsMaterialRelCallBackAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccEbsMaterialRelCallBackAtomRspBO;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEbsMaterialMapper;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEbsMaterialPO;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import com.tydic.uac.exception.BusinessException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccEbsMaterialRelCallBackAtomServiceImpl
implements UccEbsMaterialRelCallBackAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccEbsMaterialRelCallBackAtomServiceImpl.class);
    @Autowired
    private UccEbsMaterialMapper uccEbsMaterialMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Value(value="${EbsMaterialRelCallBackUrl:${ESB_ACCESS_IP}/OSN/api/esItemCodeSyncEbs/v1}")
    private String EbsMaterialRelCallBackUrl;
    @Value(value="${EbsMaterialRelCallBackUrlXNY:${ESB_ACCESS_IP}/OSN/api/esItemCodeSyncEbs/v1}")
    private String ebsMaterialRelCallBackUrlXNY;
    @Value(value="${EbsMaterialRelCallBackUrl_YB:${ESB_ACCESS_IP}/OSN/api/esItemCodeSyncEbsYB/v1}")
    private String EbsMaterialRelCallBackUrlYB;
    @Value(value="${EbsMaterialRelCallBackUrl_SN:${ESB_ACCESS_IP}/OSN/api/esItemCodeSyncEbsSN/v1}")
    private String EbsMaterialRelCallBackUrlSN;
    @Value(value="${DLXNY_APP_SUB_ID}")
    private String appSubId;

    @Override
    public UccEbsMaterialRelCallBackAtomRspBO ebsMaterialRelCallBack(UccEbsMaterialRelCallBackAtomReqBO reqBO) {
        UccEbsMaterialRelCallBackAtomRspBO rspBO = new UccEbsMaterialRelCallBackAtomRspBO();
        if (reqBO.getEbsMaterialId() == null) {
            throw new BusinessException("8888", "\u5165\u53c2ebsMaterialId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getType())) {
            throw new BusinessException("8888", "\u5165\u53c2type\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            JSONObject reqStr = this.initReqStr(reqBO);
            String subId = reqStr.getString("appSubId");
            reqStr.remove((Object)"appSubId");
            String sendurl = "";
            String sysCode = reqStr.getString("sysCode");
            reqStr.remove((Object)"sysCode");
            if ("CRC_DL".equals(sysCode)) {
                sendurl = this.appSubId.equals(subId) ? this.ebsMaterialRelCallBackUrlXNY : this.EbsMaterialRelCallBackUrl;
            } else if ("CRC_YB".equals(sysCode)) {
                sendurl = this.EbsMaterialRelCallBackUrlYB;
            } else if ("CRC_SN".equals(sysCode)) {
                sendurl = this.EbsMaterialRelCallBackUrlSN;
            } else {
                rspBO.setRespCode("0000");
                return rspBO;
            }
            String reqEsbStr = ESBParamUtil.getEsbReqStr(JSONObject.toJSONString((Object)reqStr), null, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(sendurl), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u7269\u6599\u7f16\u7801\u66f4\u65b0\u540c\u6b65\u81f3EBS\u7cfb\u7edf\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + sendurl + "]");
                throw new RuntimeException("\u7269\u6599\u7f16\u7801\u66f4\u65b0\u540c\u6b65\u81f3EBS\u7cfb\u7edf\u4e1a\u52a1");
            }
            log.info("\u7269\u6599\u7f16\u7801\u66f4\u65b0\u540c\u6b65\u81f3EBS\u7cfb\u7edf\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u7269\u6599\u7f16\u7801\u66f4\u65b0\u540c\u6b65\u81f3EBS\u7cfb\u7edf\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccEbsMaterialRelCallBackAtomRspBO resolveRsp = this.resolveRsp(returnString);
            log.info("\u7269\u6599\u7f16\u7801\u66f4\u65b0\u540c\u6b65\u81f3EBS\u7cfb\u7edf\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + (Object)((Object)resolveRsp));
            return resolveRsp;
        }
        catch (Exception var9) {
            log.error("\u7269\u6599\u7f16\u7801\u66f4\u65b0\u540c\u6b65\u81f3EBS\u7cfb\u7edf\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + var9);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7269\u6599\u7f16\u7801\u66f4\u65b0\u540c\u6b65\u81f3EBS\u7cfb\u7edf\u4e1a\u52a1\u5931\u8d25");
            return rspBO;
        }
    }

    private JSONObject initReqStr(UccEbsMaterialRelCallBackAtomReqBO reqBo) {
        JSONObject jsonObject = new JSONObject();
        UccEbsMaterialPO uccEbsMaterialPO = this.uccEbsMaterialMapper.selectByPrimaryKey(reqBo.getEbsMaterialId());
        if (uccEbsMaterialPO == null) {
            throw new BusinessException("8888", "\u5165\u53c2ebsMaterialId\u4e0d\u5b58\u5728");
        }
        UccEMdmMaterialPO uccEMdmMaterialPO = new UccEMdmMaterialPO();
        if (uccEbsMaterialPO.getMaterialId() != null) {
            uccEMdmMaterialPO = this.uccEMdmMaterialMapper.queryById(uccEbsMaterialPO.getMaterialId());
        }
        jsonObject.put("ebsItemNumber", (Object)uccEbsMaterialPO.getEbsMaterialCode());
        jsonObject.put("appSubId", (Object)uccEbsMaterialPO.getAppSubId());
        jsonObject.put("sysCode", (Object)uccEbsMaterialPO.getSysCode());
        if (uccEMdmMaterialPO != null) {
            jsonObject.put("mallItemNumber", (Object)uccEMdmMaterialPO.getMaterialCode());
            jsonObject.put("mallItemName", (Object)uccEMdmMaterialPO.getMaterialName());
            jsonObject.put("mallItemUom", (Object)uccEMdmMaterialPO.getMeasure());
            jsonObject.put("mallItemSpec", (Object)uccEMdmMaterialPO.getSpec());
            jsonObject.put("mallItemModel", (Object)uccEMdmMaterialPO.getModel());
            jsonObject.put("mallItemBrand", (Object)uccEMdmMaterialPO.getBrandName());
            jsonObject.put("mallItemStatus", (Object)(uccEMdmMaterialPO.getFreezeFlag() != null && uccEMdmMaterialPO.getFreezeFlag() == 0 ? "Y" : "N"));
        }
        jsonObject.put("type", (Object)reqBo.getType());
        return jsonObject;
    }

    private UccEbsMaterialRelCallBackAtomRspBO resolveRsp(String returnString) {
        UccEbsMaterialRelCallBackAtomRspBO rspBo = new UccEbsMaterialRelCallBackAtomRspBO();
        try {
            rspBo = (UccEbsMaterialRelCallBackAtomRspBO)((Object)JSON.parseObject((String)returnString, UccEbsMaterialRelCallBackAtomRspBO.class));
            if ("S".equals(rspBo.getSTATUS())) {
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
            } else {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc(rspBo.getMESSAGE());
            }
            return rspBo;
        }
        catch (Exception var10) {
            log.error("\u7269\u6599\u7f16\u7801\u66f4\u65b0\u540c\u6b65\u81f3EBS\u7cfb\u7edf\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u7269\u6599\u7f16\u7801\u66f4\u65b0\u540c\u6b65\u81f3EBS\u7cfb\u7edf\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

