/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSendMessageAtomService;
import com.tydic.commodity.busibase.atom.bo.SendMessageBO;
import com.tydic.commodity.busibase.atom.bo.SendMessageReceiverBO;
import com.tydic.commodity.busibase.atom.bo.UccSendMessageAtomReqBO;
import com.tydic.commodity.busibase.comb.api.DycDemandCheckMqCombService;
import com.tydic.commodity.busibase.comb.bo.DycDemandCheckMqCombReqBO;
import com.tydic.commodity.busibase.comb.bo.DycDemandCheckMqCombRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirLogMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.ppc.ability.api.PpcDemandInfoQryByAgrSkuAbilityService;
import com.tydic.ppc.ability.bo.PpcDemandInfoQryByAgrSkuAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcDemandInfoQryByAgrSkuAbilityRspBO;
import com.tydic.ppc.ability.bo.PpcDemandInfoQryByAgrSkuBO;
import com.tydic.umc.general.ability.api.UmcSendTodoAbilityService;
import com.tydic.umc.general.ability.bo.UmcSendTodoAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcSendTodoAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcTodoBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycDemandCheckMqCombServiceImpl
implements DycDemandCheckMqCombService {
    private static final Logger log = LoggerFactory.getLogger(DycDemandCheckMqCombServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSkuPutCirLogMapper uccSkuPutCirLogMapper;
    @Autowired
    private UccSendMessageAtomService uccSendMessageAtomService;
    @Autowired
    private UmcSendTodoAbilityService umcSendTodoAbilityService;
    @Value(value="${DEMAND_HERF_LINK:http://10.200.199.100/#/index/purchaseDemandList?tabKey=all&purchaseDemandNo=}")
    private String demanherf;
    @Autowired
    private PpcDemandInfoQryByAgrSkuAbilityService ppcDemandInfoQryByAgrSkuAbilityService;

    @Override
    public DycDemandCheckMqCombRspBO checkDemand(DycDemandCheckMqCombReqBO reqBO) {
        DycDemandCheckMqCombRspBO combRspBO = new DycDemandCheckMqCombRspBO();
        combRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBO.getSkus())) {
            return combRspBO;
        }
        List<UccSkuPo> skuPoList = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkus());
        if (CollectionUtils.isEmpty(skuPoList)) {
            log.error("\u6821\u9a8c\u9700\u6c42\u5355\u5546\u54c1\u67e5\u8be2\u4e3a\u7a7a \uff1a " + reqBO.getSkus().toString());
            return combRspBO;
        }
        if (CollectionUtils.isEmpty(skuPoList = skuPoList.stream().filter(a -> a.getAgreementDetailsId() != null).collect(Collectors.toList()))) {
            return combRspBO;
        }
        Calendar todayStart = Calendar.getInstance();
        todayStart.add(12, -10);
        skuPoList = skuPoList.stream().filter(a -> a.getOnShelveTime() == null || a.getOnShelveTime() != null && a.getOnShelveTime().compareTo(todayStart.getTime()) > 0).collect(Collectors.toList());
        List<Long> agrSku = skuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List<Long> checkSku = this.uccSkuPutCirLogMapper.checkSku(agrSku);
        if (CollectionUtils.isEmpty(checkSku)) {
            agrSku.removeAll(checkSku);
        }
        if (!CollectionUtils.isEmpty(agrSku)) {
            List agrSkus = skuPoList.stream().filter(a -> agrSku.contains(a.getSkuId())).map(UccSkuPo::getAgreementDetailsId).collect(Collectors.toList());
            Map<Long, UccSkuPo> mapAgrSku = skuPoList.stream().filter(a -> agrSku.contains(a.getSkuId())).collect(Collectors.toMap(UccSkuPo::getAgreementDetailsId, Function.identity(), (oldValue, newValue) -> oldValue));
            PpcDemandInfoQryByAgrSkuAbilityReqBO agrSkuAbilityReqBO = new PpcDemandInfoQryByAgrSkuAbilityReqBO();
            agrSkuAbilityReqBO.setAgrSku(agrSkus);
            PpcDemandInfoQryByAgrSkuAbilityRspBO abilityRspBO = this.ppcDemandInfoQryByAgrSkuAbilityService.qryDemandInfoByAgrSku(agrSkuAbilityReqBO);
            if ("0000".equals(abilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                for (PpcDemandInfoQryByAgrSkuBO each : abilityRspBO.getRows()) {
                    this.sendMessage(each, mapAgrSku);
                    this.sendTodo(each, mapAgrSku.get(each.getAgreementSkuId()));
                }
            }
        }
        return combRspBO;
    }

    private void sendTodo(PpcDemandInfoQryByAgrSkuBO agrSkuBOS, UccSkuPo skuPo) {
        UmcTodoBO umcTodoBO = new UmcTodoBO();
        UmcSendTodoAbilityReqBO umcSendTodoAbilityReqBO = new UmcSendTodoAbilityReqBO();
        umcTodoBO.setBusiId(DateUtils.DateToStryyyyMMdd((Date)new Date()) + "-" + agrSkuBOS.getPurchaseDemandId().toString());
        umcTodoBO.setBusinessUnid(umcTodoBO.getBusiId());
        StringBuilder todoName = new StringBuilder("\u3010\u534e\u6da6e\u8d2d\u3011").append(agrSkuBOS.getPurchaseDemandSkuName()).append("\u91c7\u8d2d\u9700\u6c42\u5b9a\u4ef7\u5546\u54c1").append(skuPo.getExtSkuId()).append("\u5df2\u4e0a\u67b6");
        umcTodoBO.setTodoName(todoName.toString());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        umcTodoBO.setFlowcreatetime(simpleDateFormat.format(new Date()));
        umcTodoBO.setTodoItemCode("DMAND_MATCH_SKU_NOTICE");
        umcTodoBO.setUrlSuffix("?tabKey=all&purchaseDemandNo=" + agrSkuBOS.getPurchaseDemandNo() + "&businessUnid=" + umcTodoBO.getBusinessUnid());
        umcTodoBO.setTodoUrl("purchaseDemandList");
        umcTodoBO.setCreateOperId("1");
        umcTodoBO.setCreateOperName("admin");
        umcTodoBO.setCandidateOperId(agrSkuBOS.getDemandInitiateUserId().toString());
        umcTodoBO.setCandidateOperName(agrSkuBOS.getDemandInitiateUserName());
        umcTodoBO.setCurnode("\u9700\u6c42\u5355\u5546\u54c1\u5df2\u4e0a\u67b6\u901a\u77e5");
        umcTodoBO.setFlowstatus("\u8d77\u8349");
        umcSendTodoAbilityReqBO.setTodoList(Arrays.asList(umcTodoBO));
        umcSendTodoAbilityReqBO.setType("unread");
        try {
            log.info("\u53d1\u9001\u5f85\u529e\u5165\u53c2umcSendTodoAbilityReqBO:{}", (Object)JSON.toJSONString((Object)umcSendTodoAbilityReqBO));
            UmcSendTodoAbilityRspBO umcSendTodoAbilityRspBO = this.umcSendTodoAbilityService.sendTodo(umcSendTodoAbilityReqBO);
            log.info("\u53d1\u9001\u5f85\u529e\u51fa\u53c2umcSendTodoAbilityRspBO:{}", (Object)JSON.toJSONString((Object)umcSendTodoAbilityRspBO));
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u53d1\u9001\u5f85\u529e\u62a5\u9519:" + e.getMessage());
        }
    }

    private void sendMessage(PpcDemandInfoQryByAgrSkuBO agrSkuBOS, Map<Long, UccSkuPo> mapAgrSku) {
        UccSendMessageAtomReqBO fscSendMessageAtomReqBO = new UccSendMessageAtomReqBO();
        SendMessageBO sendMessageBO = new SendMessageBO();
        sendMessageBO.setTaskCode("NEGOTIATION_SKU_ONSHELF_NOTICE");
        sendMessageBO.setSendId("1");
        sendMessageBO.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        String email = "";
        String phone = "";
        ArrayList<SendMessageReceiverBO> sendMessageReceiverBOList = new ArrayList<SendMessageReceiverBO>();
        SendMessageReceiverBO sendMessageReceiverBO = new SendMessageReceiverBO();
        sendMessageReceiverBO.setReceiverId(agrSkuBOS.getDemandInitiateUserId().toString());
        sendMessageReceiverBO.setReceiverName(agrSkuBOS.getDemandInitiateUserName());
        sendMessageReceiverBO.setEMail(email);
        sendMessageReceiverBO.setMobileNumber(phone);
        sendMessageReceiverBOList.add(sendMessageReceiverBO);
        sendMessageBO.setReceiverBOList(sendMessageReceiverBOList);
        String paramsObject = this.initReqStr(sendMessageBO, agrSkuBOS, mapAgrSku);
        fscSendMessageAtomReqBO.setParamsObject(paramsObject);
        log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)fscSendMessageAtomReqBO)));
        this.uccSendMessageAtomService.sendMessageAtomService(fscSendMessageAtomReqBO);
    }

    private String initReqStr(SendMessageBO sendMessageBO, PpcDemandInfoQryByAgrSkuBO agrSkuBOS, Map<Long, UccSkuPo> mapAgrSku) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("taskCode", (Object)sendMessageBO.getTaskCode());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder("\u3010\u534e\u6da6e\u8d2d\u3011\u5c0a\u656c\u7684");
        sb.append(agrSkuBOS.getDemandInitiateUserName());
        sb.append("\uff0c\u60a8\u63d0\u4ea4\u7684\u91c7\u8d2d\u9700\u6c42\u5bf9\u5e94\u7684\u5b9a\u4ef7\u5546\u54c1\u5df2\u4e0a\u67b6\uff1a");
        int count = 1;
        sb.append("<br>");
        sb.append(count);
        sb.append("\u3001\u9700\u6c42\u63cf\u8ff0\uff1a");
        sb.append(agrSkuBOS.getPurchaseDemandSkuName());
        sb.append("\uff0c\u91c7\u8d2d\u8ba1\u5212\uff1a");
        sb.append(agrSkuBOS.getPlanNo());
        sb.append("\uff0ce\u8d2d\u91c7\u8d2d\u9700\u6c42\u7f16\u53f7\uff1a");
        sb.append("<a data-mce-href=").append(agrSkuBOS.getPurchaseDemandNo());
        sb.append(" href=").append(this.demanherf).append(agrSkuBOS.getPurchaseDemandNo()).append(">");
        sb.append(agrSkuBOS.getPurchaseDemandNo());
        sb.append("</a>");
        sb.append("\uff0ce\u8d2d\u5546\u54c1\u540d\u79f0\uff1a");
        sb.append(mapAgrSku.get(agrSkuBOS.getAgreementSkuId()).getSkuName());
        sb.append("\uff0c\u4f9b\u5e94\u5546SKU\uff1a");
        sb.append(mapAgrSku.get(agrSkuBOS.getAgreementSkuId()).getExtSkuId());
        JSONObject data = new JSONObject();
        data.put("paramsText", (Object)sb.toString());
        data.put("planNo", (Object)agrSkuBOS.getPlanNo());
        data.put("demandInitiateUserId", (Object)agrSkuBOS.getDemandInitiateUserName());
        data.put("purchaseDemandSkuName", (Object)agrSkuBOS.getPurchaseDemandSkuName());
        data.put("purchaseDemandNo", (Object)agrSkuBOS.getPurchaseDemandNo());
        data.put("skuName", (Object)mapAgrSku.get(agrSkuBOS.getAgreementSkuId()).getSkuName());
        data.put("extSkuId", (Object)mapAgrSku.get(agrSkuBOS.getAgreementSkuId()).getExtSkuId());
        reqJson.put("data", (Object)data.toJSONString());
        reqJson.put("sendId", (Object)sendMessageBO.getSendId());
        reqJson.put("sendName", (Object)sendMessageBO.getSendName());
        JSONArray receivers = new JSONArray();
        for (SendMessageReceiverBO each : sendMessageBO.getReceiverBOList()) {
            JSONObject receiver = new JSONObject();
            receiver.put("receiverId", (Object)each.getReceiverId());
            receiver.put("receiverName", (Object)each.getReceiverName());
            if (!ObjectUtil.isEmpty((Object)each.getMobileNumber())) {
                receiver.put("mobileNumber", (Object)each.getMobileNumber());
            }
            receiver.put("eMail", (Object)each.getEMail());
            receivers.add((Object)receiver);
        }
        reqJson.put("receivers", (Object)receivers);
        return reqJson.toString();
    }
}

