/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.bo.Candidate;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspInfoBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccApproveCreationAtomServiceImpl
implements UccApproveCreationAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccApproveCreationAtomServiceImpl.class);
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccApproveCreationAtomRspBO createApprove(UccApproveCreationAtomReqBO reqBO) {
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO;
        UccApproveCreationAtomRspBO rspBO = new UccApproveCreationAtomRspBO();
        if (CollectionUtils.isEmpty(reqBO.getObjId())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8bf7\u4f20\u5165\u5ba1\u6279\u5bf9\u8c61\u96c6\u5408");
        }
        if (reqBO.getObjType() == null) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8bf7\u4f20\u5165\u5ba1\u6279\u7c7b\u578b");
        }
        if (StringUtils.isEmpty((Object)reqBO.getMenuId())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u8bf7\u4f20\u5165\u6d41\u7a0b\u5b9a\u4e49KEY(menuId)");
        }
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
        eacStartProjectAbilityReqBO.setSysCode("CRC");
        eacStartProjectAbilityReqBO.setProcDefKey(reqBO.getMenuId());
        List businessIdList = JSON.parseArray((String)JSON.toJSONString(reqBO.getObjId()), String.class);
        eacStartProjectAbilityReqBO.setBusinessIdList(businessIdList);
        if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccOnShelfProcessOrder.code());
        } else if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccOffShelfProcessOrder.code());
        } else if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccReinstateProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccReinstateProcessOrder.code());
        } else if (reqBO.getObjType().toString().equals(ApprovalTypeEnum.uccEditProcessOrder.getStep())) {
            eacStartProjectAbilityReqBO.setBusinessType(ApprovalTypeEnum.uccEditProcessOrder.code());
        }
        eacStartProjectAbilityReqBO.setOrgId(reqBO.getOrgId().toString());
        eacStartProjectAbilityReqBO.setOrgName(reqBO.getOrgName());
        eacStartProjectAbilityReqBO.setUserId(reqBO.getUserId().toString());
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        eacStartProjectAbilityReqBO.setStationCode(null);
        eacStartProjectAbilityReqBO.setStationName(null);
        eacStartProjectAbilityReqBO.setRoleId(null);
        eacStartProjectAbilityReqBO.setRoleName(null);
        if (!StringUtils.isEmpty((Object)reqBO.getAgreementCreateUserId())) {
            HashMap<String, String> variables = new HashMap<String, String>();
            ArrayList<Candidate> NEXT_CANDIDATES = new ArrayList<Candidate>();
            Candidate candidate = new Candidate();
            candidate.setName(reqBO.getAgreementCreateUserName());
            candidate.setValue(reqBO.getAgreementCreateUserId());
            NEXT_CANDIDATES.add(candidate);
            variables.put("NEXT_CANDIDATES", JSON.toJSONString(NEXT_CANDIDATES));
            eacStartProjectAbilityReqBO.setVariables(variables);
        }
        try {
            log.info("\u521b\u5efa\u5ba1\u6279\u5355\u5165\u53c2eacStartProjectAbilityReqBO:" + JSON.toJSON((Object)eacStartProjectAbilityReqBO));
            eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
            log.info("\u521b\u5efa\u5ba1\u6279\u5355\u51fa\u53c2eacStartProjectAbilityRspBO:" + JSON.toJSON((Object)eacStartProjectAbilityRspBO));
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        if (ApprovalTypeEnum.uccOffShelfProcessOrder.code().equals(reqBO.getObjType().toString())) {
            for (Long objId : reqBO.getObjId()) {
                UccSkuExpandPo uccSkuExpandPo = new UccSkuExpandPo();
                uccSkuExpandPo.setSkuId(objId);
                List<UccSkuExpandPo> uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand(uccSkuExpandPo);
                uccSkuExpandPo.setExpand15(reqBO.getFileAnnex());
                uccSkuExpandPo.setExpand16(reqBO.getAuditAdvice());
                if (!CollectionUtils.isEmpty(uccSkuExpandPos)) {
                    this.uccSkuExpandMapper.updateSkuExpand(uccSkuExpandPo);
                    continue;
                }
                List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(objId), null);
                uccSkuExpandPo.setCommodityId(uccSkuPoList.get(0).getCommodityId());
                uccSkuExpandPo.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
                this.uccSkuExpandMapper.insertSkuExpand(uccSkuExpandPo);
            }
        }
        rspBO.setStepId(((EacStartProjectAbilityRspInfoBO)eacStartProjectAbilityRspBO.getData().get(0)).getTacheCode());
        rspBO.setFinish(((EacStartProjectAbilityRspInfoBO)eacStartProjectAbilityRspBO.getData().get(0)).getIsFinish());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

