/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.busibase.busi.api.UccSyncDataFailBusiService;
import com.tydic.commodity.busibase.busi.bo.UccSyncDataFailBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSyncDataFailBusiRspBO;
import com.tydic.commodity.dao.UccSyncDataFailMapper;
import com.tydic.commodity.po.UccSyncDataFailPO;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccSyncDataFailBusiServiceImpl
implements UccSyncDataFailBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncDataFailBusiServiceImpl.class);
    @Autowired
    private UccSyncDataFailMapper uccSyncDataFailMapper;
    private Sequence sequenceUtil = Sequence.getInstance();

    @Override
    public UccSyncDataFailBusiRspBO addRecords(UccSyncDataFailBusiReqBO reqBO) {
        UccSyncDataFailBusiRspBO busiRspBO = new UccSyncDataFailBusiRspBO();
        busiRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBO.getSource()) || reqBO.getType() == null) {
            return busiRspBO;
        }
        ArrayList<UccSyncDataFailPO> list = new ArrayList<UccSyncDataFailPO>();
        UccSyncDataFailPO dataFailPO = null;
        for (Long each : reqBO.getSource()) {
            dataFailPO = new UccSyncDataFailPO();
            dataFailPO.setId(this.sequenceUtil.nextId());
            dataFailPO.setSource(each);
            dataFailPO.setStatus(0);
            dataFailPO.setSerialNo(reqBO.getSerialNo());
            dataFailPO.setType(reqBO.getType());
            dataFailPO.setUpdateTime(new Date());
            list.add(dataFailPO);
        }
        try {
            this.uccSyncDataFailMapper.insertBatch(list);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u540c\u6b65\u5931\u8d25\u65e5\u5fd7\u5931\u8d25\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u8bb0\u5f55\u540c\u6b65\u5931\u8d25\u65e5\u5fd7\u5931\u8d25\uff1a" + e.getMessage());
        }
        return busiRspBO;
    }

    @Override
    public UccSyncDataFailBusiRspBO deleteRecords(UccSyncDataFailBusiReqBO reqBO) {
        UccSyncDataFailBusiRspBO rspBO = new UccSyncDataFailBusiRspBO();
        rspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBO.getId())) {
            rspBO.setRespCode("0000");
            return rspBO;
        }
        try {
            this.uccSyncDataFailMapper.barchDeleteById(reqBO.getId());
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6570\u636e\u5931\u8d25\uff1a " + e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
        }
        return rspBO;
    }
}

