/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteAreaBusiService;
import com.tydic.commodity.busibase.busi.bo.UccAreaSkuWhitelistRestrictionBO;
import com.tydic.commodity.busibase.busi.bo.UccOrgAgrWhiteAreaBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccOrgAgrWhiteAreaBusiRspBO;
import com.tydic.commodity.dao.UccAreaSkuWhitelistRestrictionMapper;
import com.tydic.commodity.po.UccAreaSkuWhitelistRestrictionPO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccOrgAgrWhiteAreaBusiServiceImpl
implements UccOrgAgrWhiteAreaBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccOrgAgrWhiteAreaBusiServiceImpl.class);
    @Autowired
    private UccAreaSkuWhitelistRestrictionMapper uccAreaSkuWhitelistRestrictionMapper;

    @Override
    public UccOrgAgrWhiteAreaBusiRspBO dealWhite(UccOrgAgrWhiteAreaBusiReqBO reqBo) {
        UccOrgAgrWhiteAreaBusiRspBO rspBo = new UccOrgAgrWhiteAreaBusiRspBO();
        if (CollectionUtils.isEmpty(reqBo.getWhites()) && !CollectionUtils.isEmpty(reqBo.getAgreementId())) {
            this.uccAreaSkuWhitelistRestrictionMapper.deleteListByAgr(reqBo.getAgreementId(), null);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        if (null != reqBo.getWhites()) {
            reqBo.getWhites().removeIf(e -> "0".equals(e.getProvinceCode()));
        }
        HashSet<Long> agrQuery = new HashSet<Long>();
        HashSet<Long> commdIds = new HashSet<Long>();
        for (UccAreaSkuWhitelistRestrictionBO each : reqBo.getWhites()) {
            agrQuery.add(each.getAgreementId());
            commdIds.add(each.getCommodityId());
        }
        this.uccAreaSkuWhitelistRestrictionMapper.deleteListByAgr(reqBo.getAgreementId(), null);
        if (!CollectionUtils.isEmpty(reqBo.getWhites())) {
            List<UccAreaSkuWhitelistRestrictionPO> poList = this.uccAreaSkuWhitelistRestrictionMapper.batchQueryOrgWhiteWithAgr(new ArrayList<Long>(agrQuery), 1);
            if (!CollectionUtils.isEmpty(poList)) {
                boolean exist = false;
                ArrayList<UccAreaSkuWhitelistRestrictionBO> canInsert = new ArrayList<UccAreaSkuWhitelistRestrictionBO>();
                for (UccAreaSkuWhitelistRestrictionBO org : reqBo.getWhites()) {
                    exist = false;
                    for (UccAreaSkuWhitelistRestrictionPO each : poList) {
                        if (!each.getCityCode().equals(org.getCityCode()) || !org.getAgreementId().equals(each.getAgreementId())) continue;
                        exist = true;
                    }
                    if (exist) continue;
                    canInsert.add(org);
                }
                if (CollectionUtils.isEmpty(canInsert)) {
                    rspBo.setRespCode("0000");
                    rspBo.setRespDesc("\u6210\u529f");
                    return rspBo;
                }
                reqBo.setWhites(canInsert);
            }
            List<UccAreaSkuWhitelistRestrictionPO> skuWhiteAreaPos = new ArrayList();
            skuWhiteAreaPos = JSONObject.parseArray((String)JSONObject.toJSONString(reqBo.getWhites()), UccAreaSkuWhitelistRestrictionPO.class);
            try {
                skuWhiteAreaPos.forEach(item -> {
                    item.setSysTenantId(reqBo.getSysTenantId());
                    item.setSysTenantName(reqBo.getSysTenantName());
                });
                this.uccAreaSkuWhitelistRestrictionMapper.insertBatch(skuWhiteAreaPos);
            }
            catch (Exception e2) {
                log.error("\u5546\u54c1\u5e94\u7528\u8303\u56f4\u63d2\u5165\u5931\u8d25\uff1a" + e2.getMessage());
                throw new ZTBusinessException("\u5546\u54c1\u5e94\u7528\u8303\u56f4\u63d2\u5165\u5931\u8d25\uff1a" + e2.getMessage());
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

